/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.pagingControl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.BitSet;
import javax.swing.JViewport;
import javax.swing.UIManager;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.managers.Styleable;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.dataView.managers.ViewStyleCallback;
import oracle.dss.pagingControl.PageItem;
import oracle.dss.pagingControl.PageItemModel;
import oracle.dss.pagingControl.PagingControl;
import oracle.dss.pagingControl.PagingControlController;
import oracle.dss.pagingControl.PagingControlDefaultValues;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerOutOfRangeException;

public class PagingComponent
extends oracle.bali.ewt.pivot.PagingComponent
implements PropertyChangeListener,
ViewComponent,
ViewStyleCallback,
Styleable {
    protected PagingControl m_pc;
    protected ViewStyle m_viewStyle;
    protected int m_zoomFactor;
    private Model _model;
    private DataAccess _dataAccess;
    private ErrorHandler _errorHandler;
    private boolean _pageSelected;
    private boolean _updatingCurrentPage;
    private boolean _prefSizeSet;
    private int _numRows;
    private int _maxNumColsPerRow;
    private int _numCols;
    private int _maxNumRowsPerCol;
    private int _maxPageItemWidth;
    private int _maxPageItemHeight;
    private static final int _alpha = 60;

    private void $init$() {
        this.m_pc = null;
        this.m_viewStyle = null;
        this.m_zoomFactor = 100;
        this._pageSelected = false;
        this._updatingCurrentPage = false;
        this._numRows = -1;
        this._maxNumColsPerRow = -1;
        this._numCols = -1;
        this._maxNumRowsPerCol = -1;
        this._maxPageItemWidth = 0;
        this._maxPageItemHeight = 0;
    }

    public PagingComponent(PagingControl pagingControl) {
        this.$init$();
        this.m_pc = pagingControl;
        this.getAccessibleContext().setAccessibleName(this.m_pc.getLabelText());
        this.setName("PagingControl_PagingComponent");
        this._errorHandler = this.m_pc.getErrorHandler();
        this.setDefaultViewStyle();
        this.setSelectionTransparent(true);
        this.newPageItems();
    }

    public void newPageItems() {
        this._model = this.m_pc.getModel();
        if (this._model == null) {
            return;
        }
        this.removeAll();
        this._dataAccess = this._model.getDataAccess();
        if (this._dataAccess == null) {
            return;
        }
        String dimensionName = null;
        PageItemModel pageItemModel = null;
        int[] contextSlice = null;
        PageItem pi = null;
        try {
            contextSlice = this._dataAccess.getEdgeCurrentHPos(2);
        }
        catch (EdgeOutOfRangeException e) {
            this._errorHandler.error((Throwable)e, this.getClass().getName(), "newPageItems()");
        }
        int layerCount = -1;
        if (contextSlice != null) {
            layerCount = contextSlice.length;
        }
        int dim = 0;
        while (dim < layerCount) {
            dimensionName = null;
            pageItemModel = null;
            try {
                Object dimName = null;
                if (this.m_pc.isPageItemLabelVisible()) {
                    String layerLabelType = this.m_pc.getLayerMetadataLabelType(2);
                    if (this.m_pc.isLayerMetadataLabelTypeSupported(layerLabelType)) {
                        dimName = this._dataAccess.getLayerMetadata(2, dim, layerLabelType);
                    }
                    dimensionName = dimName == null ? "" : dimName.toString();
                } else {
                    dimensionName = "";
                }
                pageItemModel = new PageItemModel(this.m_pc, contextSlice, dim);
                pi = new PageItem(dimensionName, pageItemModel, this.m_pc);
                this.add((Component)((Object)pi));
                if (pi.getPreferredSize().width > this._maxPageItemWidth) {
                    this._maxPageItemWidth = pi.getPreferredSize().width;
                }
                if (pi.getPreferredSize().height > this._maxPageItemHeight) {
                    this._maxPageItemHeight = pi.getPreferredSize().height;
                }
                if (contextSlice[dim] != -1) {
                    pi.setSelectedIndex(contextSlice[dim]);
                }
                pi.addPropertyChangeListener(this);
            }
            catch (LayerOutOfRangeException e) {
                this._errorHandler.error((Throwable)e, this.getClass().getName(), "newPageItems()");
            }
            catch (EdgeOutOfRangeException ex2) {
                this._errorHandler.error((Throwable)ex2, this.getClass().getName(), "newPageItems()");
            }
            ++dim;
        }
        this.setEnabled(this.isEnabled());
    }

    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        this._prefSizeSet = true;
    }

    public Dimension getPreferredSize() {
        Font f;
        if (this._prefSizeSet || !this.isShowing()) {
            return super.getPreferredSize();
        }
        int width = 5;
        int height = 0;
        int orientation = this.m_pc.getOrientation();
        if (orientation == 0) {
            width += this._maxNumColsPerRow * this._maxPageItemWidth;
            height += this._numRows * this._maxPageItemHeight;
        } else if (this.m_pc.getOrientation() == 1) {
            width += this._numCols * this._maxPageItemWidth;
            height += this._maxNumRowsPerCol * this._maxPageItemHeight;
        }
        if (height == 0 && (f = this.getFont()) != null) {
            height = this.getFontMetrics(f).getHeight() + 10;
        }
        ImmInsets insets = this.getBorderInsets();
        Dimension d = new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        if (this.m_zoomFactor != 100) {
            d.height = DataviewUtils.scaleByZoom(d.height, this.m_zoomFactor);
        }
        return d;
    }

    public void doLayout() {
        block12: {
            int orientation;
            int pageItemWidth;
            int y;
            int x;
            int originY;
            int count;
            Component[] comps;
            int height;
            block13: {
                ImmInsets insets = this.getBorderInsets();
                height = this.getSize().height - (insets.top + insets.bottom);
                int width = this.getSize().width - (insets.left + insets.right);
                comps = this.getComponents();
                count = comps == null ? 0 : comps.length;
                int originX = insets.left;
                originY = insets.top;
                x = insets.left;
                y = insets.top;
                pageItemWidth = 0;
                int pageItemHeight = 0;
                orientation = this.m_pc.getOrientation();
                if (count == 0) break block12;
                if (orientation != 0) break block13;
                this._numRows = 1;
                int _numColsPerRow = 0;
                this._maxNumColsPerRow = 0;
                int i = 0;
                while (i < count) {
                    Component c = comps[i];
                    Dimension pageItemSize = c.getPreferredSize();
                    pageItemHeight = Math.max(pageItemSize.height, this._maxPageItemHeight);
                    if (pageItemSize.width < width - x) {
                        c.setBounds(x, y, pageItemSize.width, pageItemHeight);
                        x += pageItemSize.width;
                        if (++_numColsPerRow > this._maxNumColsPerRow) {
                            this._maxNumColsPerRow = _numColsPerRow;
                        }
                        if (i < count - 1) {
                            boolean createNextRow = false;
                            int widthNextPI = comps[i + 1].getPreferredSize().width;
                            if (width - x < widthNextPI) {
                                createNextRow = true;
                            }
                            if (createNextRow) {
                                _numColsPerRow = 0;
                                x = originX;
                                ++this._numRows;
                                y = (this._numRows - 1) * pageItemHeight;
                            }
                        }
                    }
                    ++i;
                }
                break block12;
            }
            if (orientation != 1) break block12;
            this._numCols = 1;
            int _numRowsPerCol = 0;
            this._maxNumRowsPerCol = 0;
            int i = 0;
            while (i < count) {
                Component c = comps[i];
                Dimension pageItemSize = c.getPreferredSize();
                pageItemWidth = Math.max(pageItemSize.width, this._maxPageItemWidth);
                if (pageItemSize.height < height - y) {
                    c.setBounds(x, y, pageItemWidth, pageItemSize.height);
                    y += pageItemSize.height;
                    if (++_numRowsPerCol > this._maxNumRowsPerCol) {
                        this._maxNumRowsPerCol = _numRowsPerCol;
                    }
                    if (i < count - 1) {
                        boolean createNextCol = false;
                        int heightNextPI = comps[i + 1].getPreferredSize().height;
                        if (height - y < heightNextPI) {
                            createNextCol = true;
                        }
                        if (createNextCol) {
                            _numRowsPerCol = 0;
                            y = originY;
                            ++this._numCols;
                            x = (this._numCols - 1) * pageItemWidth;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Font f;
        if (!this.isShowing()) {
            return this.getPreferredSize();
        }
        int width = 5;
        int height = 0;
        int orientation = this.m_pc.getOrientation();
        if (orientation == 0) {
            if (this._numRows > PagingControlDefaultValues.getNumRowsPageItems()) {
                width += this._maxNumColsPerRow * this._maxPageItemWidth;
                height += PagingControlDefaultValues.getNumRowsPageItems() * this._maxPageItemHeight;
            } else {
                width = this.getPreferredSize().width;
                height = this.getPreferredSize().height;
            }
        } else if (this.m_pc.getOrientation() == 1) {
            if (this._numCols > PagingControlDefaultValues.getNumColsPageItems()) {
                width += PagingControlDefaultValues.getNumColsPageItems() * this._maxPageItemWidth;
                height += this._maxNumColsPerRow * this._maxPageItemHeight;
            } else {
                width = this.getPreferredSize().width;
                height = this.getPreferredSize().height;
            }
        }
        if (height == 0 && (f = this.getFont()) != null) {
            height = this.getFontMetrics(f).getHeight() + 10;
        }
        ImmInsets insets = this.getBorderInsets();
        Dimension d = new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        if (this.m_zoomFactor != 100) {
            d.height = DataviewUtils.scaleByZoom(d.height, this.m_zoomFactor);
        }
        return d;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unit = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        if (unit == 0 && direction >= 0) {
            if (orientation == 0) {
                ImmInsets borderInsets = this.getBorderInsets();
                visibleRect.x += borderInsets.left;
                Component c = this.getComponentAt(visibleRect.x, this.getHeight() / 2);
                if (c == null || c == this) {
                    return unit;
                }
                Component[] comps = this.getComponents();
                unit = c.equals(comps[comps.length - 1]) ? this.getWidth() - (visibleRect.x + visibleRect.width) : c.getLocation().x + c.getSize().width - (visibleRect.x + visibleRect.width);
            } else if (orientation == 1) {
                ImmInsets borderInsets = this.getBorderInsets();
                visibleRect.y += borderInsets.top;
                Component c = this.getComponentAt(visibleRect.y, this.getWidth() / 2);
                if (c == null || c == this) {
                    return unit;
                }
                Component[] comps = this.getComponents();
                unit = c.equals(comps[comps.length - 1]) ? this.getHeight() - (visibleRect.y + visibleRect.height) : c.getLocation().y + c.getSize().height - (visibleRect.y + visibleRect.height);
            }
        }
        return unit;
    }

    public boolean getScrollableTracksViewportHeight() {
        int parentHeight;
        int preferredHeight = this.getPreferredSize().height;
        if (this.getParent() instanceof JViewport) {
            JViewport vp = (JViewport)this.getParent();
            parentHeight = vp.getExtentSize().height;
        } else {
            parentHeight = preferredHeight;
        }
        return parentHeight > preferredHeight;
    }

    public void scrollRectToVisible(Rectangle aRect) {
        Rectangle v = this.getVisibleRect();
        if (aRect.width > v.width) {
            Component[] comps;
            aRect.x += aRect.width - v.width;
            aRect.width = v.width;
            Component c = this.getComponentAt(aRect.x, this.getHeight() / 2);
            if (c != null && c.equals((comps = this.getComponents())[comps.length - 1])) {
                aRect.x = this.getWidth() - v.width;
            }
        }
        super.scrollRectToVisible(aRect);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (this._updatingCurrentPage) {
            return;
        }
        if (pce.getPropertyName() == "selectedIndex") {
            PageItem nv = (PageItem)pce.getSource();
            int dimension = this.getIndex(nv);
            int dimValue = nv.getSelectedIndex();
            this.setPageItemSelected(true);
            this._model = this.m_pc.getModel();
            this._dataAccess = this._model.getDataAccess();
            PagingControlController pcController = this.m_pc.getPagingControlController();
            try {
                try {
                    int[] hPos = this._dataAccess.getEdgeCurrentHPos(2);
                    hPos[dimension] = dimValue;
                    pcController.setCursor(WindowUtils.getWindow((Component)((Object)this)), pcController.getCursorType(2));
                    if (!this._model.pageChangeHappened(this.m_pc, hPos, dimension)) {
                        // empty if block
                    }
                }
                catch (DataException e) {
                    this._errorHandler.error((Throwable)e, this.getClass().getName(), "propertyChange");
                }
            }
            finally {
                pcController.setCursor(WindowUtils.getWindow((Component)((Object)this)), pcController.getCursorType(0));
            }
        }
    }

    public void setPageItemSelected(boolean flag) {
        this._pageSelected = flag;
    }

    public boolean isPageItemSelected() {
        return this._pageSelected;
    }

    public int getID() {
        return 3;
    }

    public String getComponentName() {
        return "PageHeader";
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    public int getEdge() {
        return 2;
    }

    public void updateCurrentPage() {
        this._updatingCurrentPage = true;
        this._model = this.m_pc.getModel();
        this._dataAccess = this._model.getDataAccess();
        if (this._dataAccess == null) {
            return;
        }
        try {
            int[] context = this._dataAccess.getEdgeCurrentHPos(2);
            int layerCount = -1;
            if (context != null) {
                layerCount = context.length;
            }
            int layer = 0;
            while (layer < layerCount) {
                oracle.bali.ewt.pivot.PageItem pi = this.getItem(layer);
                if (pi != null && context[layer] != -1) {
                    pi.setSelectedIndex(context[layer]);
                }
                ++layer;
            }
        }
        catch (EdgeOutOfRangeException eoore) {
            this._errorHandler.error((Throwable)eoore, this.getClass().getName(), "updateCurrentPage()");
        }
        this._updatingCurrentPage = false;
    }

    public void setViewStyle(ViewStyle vs) {
        ViewStyle oldVal = this.m_viewStyle;
        this.m_viewStyle = (ViewStyle)vs.clone();
        this.m_viewStyle.setView(this.m_pc.getFormatProvider());
        this.m_viewStyle.setViewStyleCallback(this);
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(oldVal, this.m_viewStyle));
    }

    public ViewStyle getViewStyle() {
        return this.m_viewStyle;
    }

    public void styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(attributeId));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._model == null || this._dataAccess == null) {
            return;
        }
        try {
            int i = 0;
            while (i < this._dataAccess.getLayerCount(2)) {
                oracle.bali.ewt.pivot.PageItem pi = this.getItem(i);
                if (pi != null) {
                    this.getItem(i).setEnabled(enabled);
                    this.getItem(i).setEditable(enabled);
                } else {
                    this._errorHandler.log("null PageItem", this.getClass().getName(), "setEnabled");
                }
                ++i;
            }
        }
        catch (EdgeOutOfRangeException eoore) {
            this._errorHandler.error((Throwable)eoore, this.getClass().getName(), "setEnabled");
        }
    }

    protected void setZoomFactor(int zoom) {
        this.m_zoomFactor = zoom;
    }

    protected void resetToDefault(int reset) {
        this.m_viewStyle.resetToDefault(reset);
        this.m_pc.updatePageItemStyles();
    }

    protected void updateForPropSet(BitSet bs) {
        this.m_pc.updatePageItemStyles();
    }

    Color getSelectionColor() {
        PageItem pi = (PageItem)this.getItem(0);
        Color selectionbgColor = pi.getAppearance().getSelectBackground();
        if (this.isSelectionTransparent()) {
            Color bgColor = pi.getAppearance().getBackground();
            Color color = ColorUtils.getTransparentColor((Color)bgColor, (Color)selectionbgColor, (int)60);
            return color;
        }
        return selectionbgColor;
    }

    private Appearance getDefaultAppearance() {
        Appearance app = ((Appearance)UIManager.get("PageItem.DefaultAppearance")).copy();
        app.setForeground(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        app.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        return app;
    }

    private void setDefaultViewStyle() {
        this.m_viewStyle = new ViewStyle((DataviewCommon)this.m_pc, this.getDefaultAppearance());
        this.m_viewStyle.setViewStyleCallback(this);
    }
}

