/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.presutil;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.xml.BaseNode;

public class XMLWriter {
    protected Writer m_writer;
    protected ErrorHandler m_eh;
    private String m_characterEncoding;
    protected ArrayList m_elems;
    private boolean m_bStartTagOpen;
    private boolean m_bEncodingScriptTag;
    private boolean m_bAutomaticNewlines;
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private static final int HEX_COLOR_LENGTH = 7;
    protected static final String LINE_SEP = System.getProperty("line.separator");

    public XMLWriter(OutputStream os, ErrorHandler eh, String charEnc) {
        block2: {
            this.$init$();
            this.m_eh = eh;
            this._setCharacterEncoding(charEnc);
            try {
                this.m_writer = new OutputStreamWriter(os, this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                this.m_writer = new OutputStreamWriter(os);
                if (this.m_eh == null) break block2;
                this.m_eh.log("UnsupportedEncodingException", this.getClass().getName(), "public XMLWriter(OutputStream os, ErrorHandler eh, String charEnc)");
            }
        }
    }

    public XMLWriter(OutputStream os, ErrorHandler eh) {
        this(os, eh, null);
    }

    public XMLWriter(Writer writer, ErrorHandler eh, String charEnc) {
        this.$init$();
        this.m_eh = eh;
        this._setCharacterEncoding(charEnc);
        this.m_writer = writer;
    }

    public XMLWriter(Writer writer, ErrorHandler eh) {
        this(writer, eh, null);
    }

    public void setEncodingScriptTag(boolean bEncode) {
        this.m_bEncodingScriptTag = bEncode;
    }

    public boolean isEncodingScriptTag() {
        return this.m_bEncodingScriptTag;
    }

    protected void setAutomaticNewlines(boolean b) {
        this.m_bAutomaticNewlines = b;
    }

    protected boolean isAutomaticNewlines() {
        return this.m_bAutomaticNewlines;
    }

    public void close() throws IOException, Exception {
        int unclosedElementCount = this.m_elems.size();
        int i = 0;
        while (i < unclosedElementCount) {
            this.endElement();
            ++i;
        }
        this.m_writer.flush();
    }

    public void flush() throws IOException, Exception {
        this.m_writer.flush();
    }

    private void _setCharacterEncoding(String charEnc) {
        this.m_characterEncoding = charEnc == null ? DEFAULT_CHARACTER_ENCODING : charEnc;
    }

    public String getCharacterEncoding() {
        return this.m_characterEncoding;
    }

    public void startElement(String name) throws IOException, Exception {
        this.checkPrevStartTag();
        this.print('<');
        this.print(name);
        this.m_bStartTagOpen = true;
        this.m_elems.add(name);
    }

    public void endElement() throws IOException, Exception {
        if (this.m_elems.size() > 0) {
            String name = (String)this.m_elems.remove(this.m_elems.size() - 1);
            this.endElement(name);
        }
    }

    protected void endElement(String name) throws IOException, Exception {
        if (this.m_bStartTagOpen) {
            this.println("/>");
            this.m_bStartTagOpen = false;
        } else {
            this.print("</");
            this.print(name);
            this.println('>');
        }
    }

    public void writeAttribute(String name, String value) throws IOException, Exception {
        if (name != null && value != null) {
            this.print(' ');
            this.print(name);
            this.print("=\"");
            this.print(XMLWriter.escape(value));
            this.print('\"');
        } else if (this.m_eh != null) {
            this.m_eh.log("name and/or value null", this.getClass().getName(), "public void writeAttribute(String name, String value)");
        }
    }

    public void writeAttribute(String name, double d) throws IOException, Exception {
        this.writeAttribute(name, new Double(d).toString());
    }

    public void writeAttribute(String name, int i) throws IOException, Exception {
        this.writeAttribute(name, i, null);
    }

    public void writeAttribute(String name, int i, String units) throws IOException, Exception {
        String value = new Integer(i).toString();
        if (units != null) {
            value = value + units;
        }
        this.writeAttribute(name, value);
    }

    public void writeAttribute(String name, Color color) throws IOException, Exception {
        String s = XMLWriter.colorToHex(color);
        if (s != null) {
            this.writeAttribute(name, s);
        } else if (this.m_eh != null) {
            this.m_eh.log("null hex string", this.getClass().getName(), "public void writeAttribute(String name, Color color)");
        }
    }

    public void writeAttribute(String name, boolean b) throws IOException, Exception {
        this.writeAttribute(name, String.valueOf(b));
    }

    public void writeText(String s) throws IOException, Exception {
        this.checkPrevStartTag(false);
        if (s != null) {
            this.print(XMLWriter.escape(s));
        }
    }

    public void write(String s) throws IOException, Exception {
        if (s != null) {
            this.print(s);
        } else if (this.m_eh != null) {
            this.m_eh.log("null string", this.getClass().getName(), "public void write(String s)");
        }
    }

    public void startCData() throws IOException, Exception {
        this.checkPrevStartTag();
        this.print("<![CDATA[");
    }

    public void endCData() throws IOException, Exception {
        this.print(this.isEncodingScriptTag() ? "]]&gt;" : "]]>");
    }

    public static String escape(String orig) {
        return BaseNode.createEscapes((String)orig);
    }

    public static String colorToHex(Color color) {
        String s = null;
        if (color != null) {
            StringBuilder hex = new StringBuilder(PresUtils.toHexString(color.getRGB()));
            if (hex.length() < 7) {
                int diff = 7 - hex.length();
                int i = 0;
                while (i < diff) {
                    hex.insert(1, '0');
                    ++i;
                }
            }
            s = hex.toString();
        }
        return s;
    }

    public static String colorToHexWithAlpha(Color color) {
        String s = null;
        if (color != null) {
            StringBuilder hex = new StringBuilder(PresUtils.toHexStringWithAlpha(color.getRGB()));
            if (hex.length() < 7) {
                int diff = 7 - hex.length();
                int i = 0;
                while (i < diff) {
                    hex.insert(1, '0');
                    ++i;
                }
            }
            s = hex.toString();
        }
        return s;
    }

    public void writeXMLHeader(String version, String standAlone) throws IOException, Exception {
        this.print("<?xml");
        String ver = version;
        if (ver == null) {
            ver = "1.0";
        }
        this.print(" version=\"");
        this.print(ver);
        this.print('\"');
        this.print(" encoding=\"");
        this.print(this.getCharacterEncoding());
        this.print('\"');
        if (standAlone != null) {
            this.print(" standalone=\"");
            this.print(standAlone);
            this.print('\"');
        }
        this.println("?>");
    }

    public void closeStartTag() throws IOException, Exception {
        this.checkPrevStartTag(true);
    }

    protected void checkPrevStartTag() throws IOException, Exception {
        this.checkPrevStartTag(true);
    }

    protected void checkPrevStartTag(boolean bNewline) throws IOException, Exception {
        if (this.m_bStartTagOpen) {
            if (bNewline) {
                this.println('>');
            } else {
                this.print('>');
            }
            this.m_bStartTagOpen = false;
        }
    }

    protected void print(String s) throws IOException, Exception {
        this.m_writer.write(s);
    }

    protected void print(char c) throws IOException, Exception {
        this.m_writer.write(c);
    }

    protected void println(String s) throws IOException, Exception {
        this.m_writer.write(s);
        if (this.isAutomaticNewlines()) {
            this.m_writer.write(LINE_SEP);
        }
    }

    protected void println(char c) throws IOException, Exception {
        this.m_writer.write(c);
        if (this.isAutomaticNewlines()) {
            this.m_writer.write(LINE_SEP);
        }
    }

    protected void println() throws IOException, Exception {
        if (this.isAutomaticNewlines()) {
            this.m_writer.write(LINE_SEP);
        }
    }

    protected static Color getBrighter(Color c) {
        double COLOR_FACTOR = 1.25;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(0.25 / COLOR_FACTOR);
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        r = (int)((double)r * COLOR_FACTOR);
        g = (int)((double)g * COLOR_FACTOR);
        b = (int)((double)b * COLOR_FACTOR);
        if (r >= 255 && g >= 255 && b >= 255) {
            return c;
        }
        return new Color(Math.min(r, 255), Math.min(g, 255), Math.min(b, 255), c.getAlpha());
    }

    protected String convertShapeToPath(Shape shape) {
        String pathString = null;
        if (shape != null) {
            PathIterator pi = shape.getPathIterator(null);
            if (pi != null) {
                StringBuilder sb = new StringBuilder();
                boolean bFirst = true;
                double prevX = -1.0;
                double prevY = -1.0;
                double x = -1.0;
                double y = -1.0;
                while (!pi.isDone()) {
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
                        sb.append(' ');
                    }
                    double[] coords = new double[6];
                    int type = pi.currentSegment(coords);
                    switch (type) {
                        case 0: {
                            x = this._roundDouble(coords[0]);
                            y = this._roundDouble(coords[1]);
                            if (prevX == x && prevY == y) break;
                            sb.append('M');
                            sb.append(x);
                            sb.append(',');
                            sb.append(y);
                            break;
                        }
                        case 1: {
                            x = this._roundDouble(coords[0]);
                            y = this._roundDouble(coords[1]);
                            if (prevX == x && prevY == y) break;
                            if (bFirst) {
                                sb.append('M');
                            } else {
                                sb.append('L');
                            }
                            sb.append(x);
                            sb.append(',');
                            sb.append(y);
                            break;
                        }
                        case 2: {
                            double x1 = this._roundDouble(coords[0]);
                            double y1 = this._roundDouble(coords[1]);
                            x = this._roundDouble(coords[2]);
                            y = this._roundDouble(coords[3]);
                            if (prevX == x && prevY == y) break;
                            if (bFirst) {
                                sb.append('M');
                            } else {
                                sb.append('Q');
                            }
                            if (x1 == prevX) {
                                x1 += 0.001;
                            } else if (y1 == prevY) {
                                y1 += 0.001;
                            }
                            sb.append(x1);
                            sb.append(',');
                            sb.append(y1);
                            sb.append(' ');
                            sb.append(x);
                            sb.append(',');
                            sb.append(y);
                            break;
                        }
                        case 3: {
                            double x1 = this._roundDouble(coords[0]);
                            double y1 = this._roundDouble(coords[1]);
                            double x2 = this._roundDouble(coords[2]);
                            double y2 = this._roundDouble(coords[3]);
                            x = this._roundDouble(coords[4]);
                            y = this._roundDouble(coords[5]);
                            if (prevX == x && prevY == y) break;
                            if (bFirst) {
                                sb.append('M');
                            } else {
                                sb.append('C');
                            }
                            if (x1 == prevX) {
                                x1 += 0.001;
                            } else if (y1 == prevY) {
                                y1 += 0.001;
                            }
                            sb.append(x1);
                            sb.append(',');
                            sb.append(y1);
                            sb.append(' ');
                            sb.append(x2);
                            sb.append(',');
                            sb.append(y2);
                            sb.append(' ');
                            sb.append(x);
                            sb.append(',');
                            sb.append(y);
                            break;
                        }
                        case 4: {
                            sb.append('Z');
                            break;
                        }
                    }
                    prevX = x;
                    prevY = y;
                    bFirst = false;
                    pi.next();
                }
                if (sb.length() > 0) {
                    pathString = sb.toString();
                }
            } else if (this.m_eh != null) {
                this.m_eh.log("null PathIterator", this.getClass().getName(), "protected String convertShapeToPath(Shape shape)");
            }
        }
        return pathString;
    }

    private double _roundDouble(double d) {
        return (double)((int)(d * 100.0 + 0.5)) / 100.0;
    }

    private void $init$() {
        this.m_writer = null;
        this.m_eh = null;
        this.m_characterEncoding = DEFAULT_CHARACTER_ENCODING;
        this.m_elems = new ArrayList();
        this.m_bStartTagOpen = false;
        this.m_bEncodingScriptTag = false;
        this.m_bAutomaticNewlines = true;
    }
}

