/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.io.Serializable;
import oracle.dss.table.HeaderData;
import oracle.dss.table.Table;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;

public class ColHeaderData
extends HeaderData
implements Serializable {
    private int[] m_cacheCanPivot;
    private static final int NOT_CACHED = -1;
    private static final String m_method_getCanPivot = "protected int getCanPivot(int index)";

    ColHeaderData(Table t) {
        super(t);
        this.$init$();
        this.addItems(0, this.getColumnCount());
    }

    protected boolean isRowHeader() {
        return false;
    }

    public int getColumnCount() {
        try {
            int n = this.dataAccess.getEdgeExtent(0);
            return n;
        }
        catch (EdgeOutOfRangeException e) {
            int n = 0;
            return n;
        }
    }

    public int getRowCount() {
        return 0;
    }

    protected Object calculateCell(int index) {
        return this.calculateCell(index, 0);
    }

    protected int getCanPivot(int index) {
        if (this.m_cacheCanPivot == null) {
            this.m_cacheCanPivot = new int[this.getColumnCount()];
            int i = 0;
            while (i < this.m_cacheCanPivot.length) {
                this.m_cacheCanPivot[i] = -1;
                ++i;
            }
        }
        if (this.m_cacheCanPivot[index] != -1) {
            return this.m_cacheCanPivot[index];
        }
        int iPivotSupported = 1;
        if (this.table.isLayerMetaCanPivotSupported()) {
            try {
                Object oPivotSupported = this.table.getModel().getDataAccess().getLayerMetadata(0, index, "dimCanPivot");
                if (oPivotSupported != null && oPivotSupported instanceof Integer) {
                    iPivotSupported = (Integer)oPivotSupported;
                }
            }
            catch (EdgeOutOfRangeException eoore) {
                this.table.getErrorHandler().log("edge out of range when getting LAYER_METADATA_CANPIVOT", this.getClass().getName(), m_method_getCanPivot);
            }
            catch (LayerOutOfRangeException loore) {
                this.table.getErrorHandler().log("layer out of range when getting LAYER_METADATA_CANPIVOT", this.getClass().getName(), m_method_getCanPivot);
            }
        }
        this.m_cacheCanPivot[index] = iPivotSupported;
        return iPivotSupported;
    }

    private void $init$() {
        this.m_cacheCanPivot = null;
    }
}

