/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageFilter;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import oracle.bali.ewt.elaf.oracle.OracleUIUtils;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.OneDModel;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.table.BlackFilter;
import oracle.dss.table.RowHeaderData;
import oracle.dss.table.TableHeader;

public class RowHeader
extends TableHeader {
    protected ViewStyle incrementalFetchRowStyle;
    protected Image incrementalFetchArrow;

    public RowHeader(RowHeaderData model) {
        super((OneDModel)model, 1);
        this.$init$();
        this.setCanMoveItems(false);
    }

    public int getID() {
        return 11;
    }

    public String getComponentName() {
        return "RowHeader";
    }

    protected int getEdge() {
        return 1;
    }

    protected int getDepth(int column, int row) {
        return row;
    }

    protected int getIndex(int column, int row) {
        return column;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this.getItemCount();
    }

    protected Image getGraphicImage(int index) {
        if (this.table.getTable() != null && this.table.isIncrementalFetchEnabled() && this.table.getTable().isIncrementalFetchRowVisible() && index >= this.table.getTableModel().getTableDataSource().getRowCount() - 1) {
            if (this.incrementalFetchArrow == null) {
                this.incrementalFetchArrow = this.createIncrementalFetchImage();
            }
            return this.incrementalFetchArrow;
        }
        return super.getGraphicImage(index);
    }

    ViewStyle getStyle(int index) {
        ViewStyle style = null;
        if (this.table.getTable() != null && this.table.isIncrementalFetchEnabled() && this.table.getTable().isIncrementalFetchRowVisible() && index >= this.table.getTableModel().getTableDataSource().getRowCount() - 1) {
            Color bg;
            if (this.incrementalFetchRowStyle == null) {
                this.incrementalFetchRowStyle = this.createIncrementalFetchStyle();
            }
            style = this.incrementalFetchRowStyle;
            if (this.defaultViewStyle.getFont() != null && (bg = this.defaultViewStyle.getBackground()) != null) {
                style.setBackground(bg);
            }
        }
        if (style != null) {
            style.setView(this.table);
            if (this.table.getZoomFactor() != 100) {
                style = style.scaleStyle(style.getFont());
                style.setView(this.table);
            }
            return style;
        }
        this.info.setRowCol(index, 0);
        return super.getStyle(index);
    }

    private ViewStyle createIncrementalFetchStyle() {
        Color bg;
        Appearance tempApp = (Appearance)UIManager.get("Header.DefaultAppearance");
        Font font = this.defaultViewStyle.getFont();
        if (font == null && (font = tempApp.getFont()) == null) {
            font = this.table.getFontList().getFont("Serif", 2, 12);
        }
        if (!font.isItalic()) {
            font = this.table.getFontList().getFont(font.getName(), 2, font.getSize());
        }
        if ((bg = this.defaultViewStyle.getBackground()) == null && (bg = tempApp.getBackground()) == null) {
            bg = new ColorUIResource(204, 204, 204);
        }
        ViewStyle tempStyle = new ViewStyle(bg, Color.black, font, 0, 0, false, false, false, false, Color.gray, 0, 7, 7, 7, 7, bg, Color.black);
        tempStyle.setView(this.table);
        return tempStyle;
    }

    private Image createIncrementalFetchImage() {
        Image tempImage = OracleUIUtils.getImage((String)"drilledTriangle.gif");
        tempImage = ImageUtils.createFilteredImage((Image)tempImage, (ImageFilter)new BlackFilter());
        return tempImage;
    }

    private void $init$() {
        this.incrementalFetchRowStyle = null;
        this.incrementalFetchArrow = null;
    }
}

