/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.InputStream;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.BigCellTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.FixedImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterTiler;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.text.WrappedText;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.EdgeRangeComponentHandle;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.RolloverTextManager;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.UIBundle;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.CustomAnnotationCallback;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDatabody;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.gridView.GridViewExcelHTMLExport;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.gridView.GridViewFormatUtils;
import oracle.dss.gridView.GridViewHeader;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.GridViewSelectionManager;
import oracle.dss.gridView.GridViewTable;
import oracle.dss.gridView.UIFormat;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.rules.discriminator.StringValueDiscriminator;
import oracle.dss.table.TableAttributes;
import oracle.dss.table.TableCommon;
import oracle.dss.table.TableController;
import oracle.dss.table.TableControllerAdapter;
import oracle.dss.table.TableDataListener;
import oracle.dss.table.TableDatabody;
import oracle.dss.table.TableDatabodyInputHandler;
import oracle.dss.table.TableDefaultValues;
import oracle.dss.table.TableEdgeComponentHandle;
import oracle.dss.table.TableEdgeComponentInfo;
import oracle.dss.table.TableEdgeRangeComponentHandle;
import oracle.dss.table.TableEdit;
import oracle.dss.table.TableExcelHTMLExport;
import oracle.dss.table.TableFormatUtil;
import oracle.dss.table.TableHeader;
import oracle.dss.table.TableHeaderCell;
import oracle.dss.table.TableModel;
import oracle.dss.table.TableModelAdapter;
import oracle.dss.table.TableSizingManager;
import oracle.dss.table.TableSpreadTable;
import oracle.dss.table.TableUtils;
import oracle.dss.table.TableXML;
import oracle.dss.table.UITable;
import oracle.dss.table.managers.TableRuleSizing;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.Range;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.WaitData;
import oracle.dss.util.WaitDataAvailableEvent;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.XMLObjectReader;

public class Table
extends GridView
implements GridViewAttribute,
TableCommon,
TableAttributes,
UITable {
    public static final int TABLE = 21;
    private static final boolean DEBUG = false;
    public static final String TABLE_NAME = "Table";
    protected TableModel tableModel;
    protected TableController tableController;
    protected transient TableSpreadTable table;
    protected boolean canResizeHeights;
    protected boolean canResizeWidths;
    protected boolean m_bAutoFitting;
    protected int m_iFirstPrintedRow;
    protected boolean m_dataGroupsortSupported;
    protected boolean m_dataNameSupported;
    protected boolean m_bLayerMetadataCanPivotSupported;
    protected boolean m_colHeaderVisible;
    protected boolean m_rowHeaderVisible;
    private ResourceBundle localStrings;
    private static final String m_method_setcolumnheaderrowheight = "setColumnHeaderRowHeight (int height)";
    private static final String m_method_setcolumnvisible = "setColumnVisible (int column, boolean visible)";
    private static final String m_method_iscolumnvisible = "isColumnVisible (int column)";
    private static final String m_method_setcolumnwidth = "setColumnWidth (int index, int width)";
    private static final String m_method_setcornercomponentcolor = "setCornerComponentColor (Component c)";
    private static final String m_method_setfetchincrement = "setFetchIncrement (int i)";
    private static final String m_method_setrowheadercolumnwidth = "setRowHeaderColumnWidth (int width)";
    private static final String m_method_setrowheight = "setRowHeight (int index, int height)";
    private static final String m_method_setrowvisible = "setRowVisible (int row, boolean visible)";
    private static final String m_method_isrowvisible = "isRowVisible (int row)";
    private static final String m_method_setstartcolumn = "setStartColumn (int c)";
    private static final String m_method_setstartrow = "setStartRow (int r)";
    private static final String m_method_setzoomfactor = "setZoomFactor (int f)";
    private static final String m_method_resizerowheight = "protected int resizeRowHeight(int row, int startCol, int endCol)";
    private static final String m_method_selectobject = "selectObject (ComponentHandle ID)";
    private static final String m_method_autoFit = "autoFit()";
    private static final String m_method_sizeRowHeights = "sizeRowHeights(int firstRow, int lastRow)";
    private static final String m_method_updateResourceBundle = "updateResourceBundle()";
    private static final String m_method_cloneForPrint = "cloneForPrint()";
    private static final String m_method_getComponentViewStyle = "getComponentViewStyle(ComponentHandle componentHandle)";
    private static final String m_method_updateRowHeaderWidths = "protected void updateRowHeaderWidths()";
    private static final String m_method_updateColumnWidth = "public void updateColumnWidth()";
    private static final String m_method_updateColumnHeaderRowHeights = "public void updateColumnHeaderRowHeights()";
    private static final String m_method_sizecolumnwidths = "protected void sizeColumnWidths(int firstCol, int lastCol)";
    private static final String m_method_resizeColumnWidth = "protected int resizeColumnWidth(int col, int startRow, int endRow)";
    private TableXML _tableXML;

    public Table() {
        this.$init$();
        this.updateResourceBundle();
        this.setTableModel(new TableModelAdapter(this));
        this.setDataSource(null);
        this.table = new TableSpreadTable(this.getTableModel().getTableDataSource(), this.getTableModel().getColumnDataSource(), this.getTableModel().getRowDataSource());
        this.table.init(this);
        this.table.setAlwaysDrawFocusCellHighlite(true);
        this.addSubcomponent(this.table.getTableDatabody());
        this.addSubcomponent(this.table.getTableColumnHeader());
        this.addSubcomponent(this.table.getTableRowHeader());
        this.setSwapAllowed(TableDefaultValues.isSwapAllowed());
        this.setCornerComponentColor(new Color(TableDefaultValues.getCornerComponentColor()));
        this.setCornerComponentColorUsed(false);
        this.scrollBox = new 1((Component)((Object)this.table), 20, 30);
        this.setTableController(new TableControllerAdapter(this));
        this.m_bResizeForDrillImages = false;
        this._setDrillImage(2, this.getTableColumnHeader().getDrilledImage());
        this._setDrillImage(1, this.getTableColumnHeader().getDrillImage());
        this.m_bResizeForDrillImages = true;
        this.setTableSizingManager(new TableRuleSizing(this));
        this.setManualColumnSizingEnabled(TableDefaultValues.isManualColumnSizingEnabled());
        this.setManualRowSizingEnabled(TableDefaultValues.isManualRowSizingEnabled());
        this.table.setFirstRowOnScreen(TableDefaultValues.getStartRow());
        this.table.setFirstColumnOnScreen(TableDefaultValues.getStartColumn());
        this.editListener = new TableEdit(this);
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        } else {
            this.doSizing();
        }
        this.add((Component)this.scrollBox, "Center");
        this._tableXML = new TableXML(this);
        this.setUserOverrideMode(true);
        this.setStyleOverrideMode(true);
    }

    protected void updateResourceBundle() {
        try {
            this.localStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.table.resource.TableBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.table.resource.TableBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("Missing Table Resource exception", this.getClass().getName(), m_method_updateResourceBundle);
            this.localStrings = null;
        }
    }

    public void modelDataAvailable(DataAvailableEvent e) {
        this.freezeRepaints();
        super.modelDataAvailable(e);
        this.unfreezeRepaints();
    }

    public void setTableModel(TableModel m) {
        super.setGridViewModel(m);
        TableModel oldModel = this.tableModel;
        this.tableModel = m;
        this.firePropertyChange(this, "TableModel", oldModel, this.tableModel);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableController(TableController c) {
        super.setGridViewController(c);
        TableController oldController = this.tableController;
        if (oldController != null) {
            oldController.cleanUp();
        }
        this.tableController = c;
        this.firePropertyChange(this, "TableController", oldController, this.tableController);
    }

    public TableController getTableController() {
        return this.tableController;
    }

    public void setGridViewSelectionManager(GridViewSelectionManager m) {
        if (this.tableController != null) {
            GridViewSelectionManager oldSel = this.tableController.getGridViewSelectionManager();
            this.tableController.setGridViewSelectionManager(m);
            this.firePropertyChange(this, "GridViewSelectionManager", oldSel, m);
        }
    }

    public GridViewSelectionManager getGridViewSelectionManager() {
        if (this.tableController != null) {
            return this.tableController.getGridViewSelectionManager();
        }
        return null;
    }

    public void setLocale(Locale loc) {
        GridViewFormatManager rf;
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle();
        if (this.getViewFormat() != null) {
            this.getViewFormat().setLocale(loc);
        }
        if (this.getTableModel() != null && this.getTableModel().getViewFormat() != null) {
            this.getTableModel().getViewFormat().setLocale(loc);
        }
        if ((rf = this.getGridViewFormatManager()) != null) {
            rf.valueFormatChanged();
        }
        this.dataFormatChanged();
        this.repaint();
    }

    public void setTableSizingManager(TableSizingManager m) {
        if (this.tableController != null) {
            TableSizingManager oldSel = this.tableController.getTableSizingManager();
            this.tableController.setTableSizingManager(m);
            this.firePropertyChange(this, "TableSizingManager", oldSel, m);
        }
    }

    public TableSizingManager getTableSizingManager() {
        if (this.tableController != null) {
            return this.tableController.getTableSizingManager();
        }
        return null;
    }

    public boolean selectObject(ComponentHandle id) {
        if (id == null) {
            return this.tableController.setSelectedObject(null, true);
        }
        int ID = id.getID();
        switch (ID) {
            case 20: {
                RowRangeComponentHandle rrID;
                try {
                    rrID = (RowRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                RowComponentInfo[] rowRangeInfo = rrID.getLocationList();
                TableUtils.selectRows(rowRangeInfo, this.getTableDatabody(), this);
                return this.tableController.setSelectedObject(new RowRangeComponentHandle(ID, this.getNameFromID(ID), this.getTableDatabody(), rowRangeInfo), true);
            }
            case 15: {
                RowComponentHandle rowID;
                try {
                    rowID = (RowComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                RowComponentInfo rowinfo = new RowComponentInfo(rowID.getRow());
                TableUtils.selectRow(rowinfo, this.getTableDatabody(), this);
                return this.tableController.setSelectedObject(new RowComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), rowinfo.getRow()), true);
            }
            case 19: {
                ColumnRangeComponentHandle crID;
                try {
                    crID = (ColumnRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                ColumnComponentInfo[] columnRangeInfo = crID.getLocationList();
                TableUtils.selectColumns(columnRangeInfo, this.getTableDatabody(), this);
                return this.tableController.setSelectedObject(new ColumnRangeComponentHandle(ID, this.getNameFromID(ID), this.getTableDatabody(), columnRangeInfo), true);
            }
            case 14: {
                ColumnComponentHandle colID;
                try {
                    colID = (ColumnComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                ColumnComponentInfo columninfo = new ColumnComponentInfo(colID.getColumn());
                TableUtils.selectColumn(columninfo, this.getTableDatabody(), this);
                return this.tableController.setSelectedObject(new ColumnComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), columninfo.getColumn()), true);
            }
            case 18: {
                TableEdgeRangeComponentHandle terID;
                try {
                    terID = (TableEdgeRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                EdgeComponentInfo[] rowRangeInfo2 = (TableEdgeComponentInfo[])terID.getLocationList();
                TableUtils.selectCells(rowRangeInfo2, this.getTableRowHeader().getEdge(), this.getTableRowHeader(), this);
                return this.tableController.setSelectedObject(new TableEdgeRangeComponentHandle(ID, this.getNameFromID(ID), (Object)this.getTableDatabody(), (TableEdgeComponentInfo[])rowRangeInfo2), true);
            }
            case 11: {
                EdgeComponentHandle edgeID;
                try {
                    edgeID = (EdgeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                TableEdgeComponentInfo edgeinfo = new TableEdgeComponentInfo(edgeID.getEdge(), edgeID.getDepth());
                TableUtils.selectCell(edgeinfo, this.getTableRowHeader().getEdge(), this.getTableRowHeader(), this);
                return this.tableController.setSelectedObject(new TableEdgeComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), edgeinfo), true);
            }
            case 17: {
                TableEdgeRangeComponentHandle terID2;
                try {
                    terID2 = (TableEdgeRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                EdgeComponentInfo[] colRangeInfo = (TableEdgeComponentInfo[])terID2.getLocationList();
                TableUtils.selectCells(colRangeInfo, this.getTableColumnHeader().getEdge(), this.getTableColumnHeader(), this);
                return this.tableController.setSelectedObject(new TableEdgeRangeComponentHandle(ID, this.getNameFromID(ID), (Object)this.getTableDatabody(), (TableEdgeComponentInfo[])colRangeInfo), true);
            }
            case 10: {
                EdgeComponentHandle edgeID2;
                try {
                    edgeID2 = (EdgeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                TableEdgeComponentInfo edgeinfo2 = new TableEdgeComponentInfo(edgeID2.getEdge(), edgeID2.getDepth());
                TableUtils.selectCell(edgeinfo2, this.getTableColumnHeader().getEdge(), this.getTableColumnHeader(), this);
                return this.tableController.setSelectedObject(new TableEdgeComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), edgeinfo2), true);
            }
            case 16: {
                DataRangeComponentHandle drID;
                try {
                    drID = (DataRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                DataComponentInfo[] dataRangeInfo = drID.getLocationList();
                TableUtils.selectCells(dataRangeInfo, this.getTableDatabody(), this);
                return this.tableController.setSelectedObject(new DataRangeComponentHandle(ID, this.getNameFromID(ID), this.getTableDatabody(), dataRangeInfo), true);
            }
            case 12: {
                DataComponentHandle dataID;
                try {
                    dataID = (DataComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                DataComponentInfo datainfo = new DataComponentInfo(dataID.getRow(), dataID.getColumn());
                Cell cell = new Cell(datainfo.getColumn(), datainfo.getRow());
                DataComponentInfo[] cellinfo = new DataComponentInfo[]{datainfo};
                TableUtils.selectCells(cellinfo, this.getTableDatabody(), this);
                return this.tableController.setSelectedObject(new DataComponentHandle(ID, this.getNameFromID(ID), cell, datainfo), true);
            }
            case 0: 
            case 1: 
            case 2: 
            case 9: 
            case 13: 
            case 21: {
                if (ID == 13) {
                    TableUtils.selectAllCells(true, this.getTableDatabody(), this);
                }
                return this.tableController.setSelectedObject(new NonDataComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID)), false);
            }
            case 4: {
                PageItemComponentHandle pageItemID;
                try {
                    pageItemID = (PageItemComponentHandle)id;
                }
                catch (ClassCastException e) {
                    boolean bl = false;
                    return bl;
                }
                int pageItem = pageItemID.getPageItem();
                return this.tableController.setSelectedObject(new PageItemComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), pageItem), false);
            }
        }
        this.getErrorHandler().log("invalid component ID", this.getClass().getName(), m_method_selectobject);
        return false;
    }

    public void setStartRow(int r) {
        if (this.isLoadingViewFromPersistence()) {
            this.m_tmpStartRow = r;
        }
        if (r < 0 || r >= this.table.getGrid().getModel().getRowCount()) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setstartrow);
            return;
        }
        int oldRow = this.getStartRow();
        this.setDesiredStartRow(r);
        if (oldRow != r) {
            this.table.setFirstRowOnScreen(r);
            this.firePropertyChange(this, "StartRow", new Integer(oldRow), new Integer(r));
        }
    }

    public int getStartRow() {
        return this.table.getFirstRowOnScreen();
    }

    public void setStartColumn(int c) {
        if (this.isLoadingViewFromPersistence()) {
            this.m_tmpStartColumn = c;
        }
        if (c < 0 || c >= this.table.getGrid().getModel().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setstartcolumn);
            return;
        }
        int oldCol = this.getStartColumn();
        this.setDesiredStartColumn(c);
        if (oldCol != c) {
            this.table.setFirstColumnOnScreen(c);
            this.firePropertyChange(this, "StartColumn", new Integer(oldCol), new Integer(c));
        }
    }

    public int getStartColumn() {
        return this.table.getFirstColumnOnScreen();
    }

    public void setHGridVisible(boolean b) {
        boolean oldValue = this.isHGridVisible();
        this.table.setHorizontalSeparatorsVisible(b);
        this.firePropertyChange(this, "HGridVisible", new Boolean(oldValue), new Boolean(b));
    }

    public boolean isHGridVisible() {
        return this.table.getHorizontalSeparatorsVisible();
    }

    public void setVGridVisible(boolean b) {
        boolean oldValue = this.isVGridVisible();
        this.table.setVerticalSeparatorsVisible(b);
        this.firePropertyChange(this, "VGridVisible", new Boolean(oldValue), new Boolean(b));
    }

    public boolean isVGridVisible() {
        return this.table.getVerticalSeparatorsVisible();
    }

    public void setIncrementalFetchEnabled(boolean b) {
        if (this.tableModel != null) {
            boolean oldValue = this.tableModel.isIncrementalFetchEnabled();
            this.tableModel.setIncrementalFetchEnabled(b);
            this.firePropertyChange(this, "IncrementalFetchEnabled", new Boolean(oldValue), new Boolean(b));
        }
    }

    public boolean isIncrementalFetchEnabled() {
        if (this.tableModel != null) {
            return this.tableModel.isIncrementalFetchEnabled();
        }
        return false;
    }

    public boolean isIncrementalFetchRowVisible() {
        return this.getTable().isIncrementalFetchRowVisible();
    }

    public void setFetchMessage(String s) {
        if (this.tableModel != null) {
            String oldValue = this.tableModel.getFetchMessage();
            this.tableModel.setFetchMessage(s);
            this.firePropertyChange(this, "FetchMessage", new String(oldValue), new String(s));
        }
    }

    public String getFetchMessage() {
        if (this.tableModel != null) {
            return this.tableModel.getFetchMessage();
        }
        return new String("");
    }

    public void setFetchIncrement(int i) {
        if (i < 0) {
            this.getErrorHandler().log("invalid number of rows to fetch", this.getClass().getName(), m_method_setfetchincrement);
            return;
        }
        if (this.tableModel != null) {
            int oldValue = this.tableModel.getFetchIncrement();
            this.tableModel.setFetchIncrement(i);
            this.firePropertyChange(this, "FetchIncrement", new Integer(oldValue), new Integer(i));
        }
    }

    public int getFetchIncrement() {
        if (this.tableModel != null) {
            return this.tableModel.getFetchIncrement();
        }
        return -1;
    }

    public void setCellEditingAllowed(boolean b) {
        Grid grid = this.table.getGrid();
        boolean oldValue = this.isCellEditingAllowed();
        this.cellEditingAllowed = b;
        if (b != oldValue) {
            if (b) {
                this.table.addEditListener(this.editListener);
                grid.setDefaultInputHandler((CellInputHandler)this.editListener);
            } else {
                this.table.removeEditListener(this.editListener);
                grid.setDefaultInputHandler((CellInputHandler)new TableDatabodyInputHandler(this));
            }
            this.getTableDatabody().setCellEditingAllowed(b);
            this.firePropertyChange(this, "CellEditingAllowed", new Boolean(oldValue), new Boolean(b));
        }
    }

    public void updateColumnWidth() {
        if (this.table == null || this.m_bAutoFitting) {
            return;
        }
        this.getTable().clearColumnWidthsCache();
        this.getTable().checkResizeColumnWidths();
    }

    public void updateRowHeights() {
        if (this.table == null || this.m_bAutoFitting || this.getTable().m_bCheckingColWidths) {
            return;
        }
        this.getTable().clearRowHeightsCache();
        this.getTable().checkResizeRowHeights();
    }

    protected void updateRowHeaderWidths() {
        if (this.table == null || !this.table.isRowHeaderVisible() || (this.getAutoFitScope() & 8) < 1) {
            return;
        }
        Range range = this.getAutoFitRowRange();
        int endRow = range.end;
        int startRow = range.begin;
        if (endRow < startRow) {
            this.getErrorHandler().log("invalid row range", this.getClass().getName(), m_method_updateRowHeaderWidths);
            return;
        }
        int width = this.calcAutoFitRowHeaderWidth(startRow, endRow);
        if (this.getAutoFitRowRangeCallback() != null) {
            this.getAutoFitRowRangeCallback().endAutoFit();
        }
        this.getTableSizingManager().setCalculatedRowHeaderColumnWidth(width);
        this.sizeRowHeaderColumnWidths();
    }

    protected void refreshData() {
        TableDatabody databody;
        TableHeader rowHeader;
        this.freezeRepaints();
        if (this.getTable() != null && this.getTable().isIncrementalFetchRowVisible()) {
            this.getTable().setIncrementalFetchRowVisible(false);
        }
        this.clearWaitDataForAllRows();
        this.tableModel.newDataSource();
        this.tableModel.newRowDataSource();
        this.tableModel.newColDataSource();
        if (this.table != null) {
            this.table.setModels(this.tableModel.getTableDataSource(), (OneDModel)this.tableModel.getColumnDataSource(), (OneDModel)this.tableModel.getRowDataSource());
            this.table.clearRowHeightsCache();
            this.table.clearColumnWidthsCache();
        }
        if (this.getTableDatabody() != null) {
            this.getTableDatabody().clearCache();
        }
        if (this.getTableRowHeader() != null) {
            this.getTableRowHeader().clearCache();
        }
        if (this.getTableColumnHeader() != null) {
            this.getTableColumnHeader().clearCache();
        }
        this.getGridViewDatabodyStyleManager().dataStyleChanged();
        this.getGridViewHeaderStyleManager().metadataStyleChanged();
        this.updatePagingControlStyles();
        this.getGridViewFormatManager().valueFormatChanged();
        this.getGridViewFormatManager().metadataFormatChanged();
        if (this.getTableSizingManager() != null) {
            this.getTableSizingManager().dataChanged();
        }
        this.dataFormatChanged();
        if (this.getTableController() != null) {
            this.getTableController().setSelectedObject(null, false);
        }
        if (this.tableModel.isIncrementalFetchEnabled()) {
            int colCount = this.table.getGrid().getModel().getColumnCount();
            int rowCount = this.table.getGrid().getModel().getRowCount();
            if (this.getTable() != null && rowCount > 0 && colCount > 0) {
                this.getTable().setIncrementalFetchRowVisible(this.getTable().addIncrementalFetchRow());
                if (!this.getTable().isIncrementalFetchRowVisible()) {
                    this.getTable().removeIncrementalFetchRow();
                }
            }
        }
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        } else {
            this.doSizing();
        }
        if (this.isLoadingViewFromPersistence() && this.isLoadingDataSourceFromPersistence()) {
            if (this.m_tmpStartColumn > -1 && this.m_tmpStartColumn < this.getGridViewModel().getGridViewDataSource().getColumnCount()) {
                this.setDesiredStartColumn(this.m_tmpStartColumn);
                this.setMustReScroll(true);
            }
            if (this.m_tmpStartRow > -1 && this.m_tmpStartRow < this.getGridViewModel().getGridViewDataSource().getRowCount()) {
                this.setDesiredStartRow(this.m_tmpStartRow);
                this.setMustReScroll(true);
            }
        }
        this.setLoadingViewFromPersistence(false);
        this.setLoadingDataSourceFromPersistence(false);
        this.m_tmpStartColumn = -1;
        this.m_tmpStartRow = -1;
        this.unfreezeRepaints();
        this.repaint();
        int pageIndex = this.getPagingControl().getPreviousPageItemIndex();
        if (pageIndex != -1 && this.getPagingControl().getPagingComponent().isPageItemSelected()) {
            this.getPagingControl().getPagingComponent().getItem(pageIndex).requestFocus();
            this.getPagingControl().getPagingComponent().setPageItemSelected(false);
        }
        if ((rowHeader = this.getTableRowHeader()) != null && rowHeader.getIncFetchFocusCell() != null) {
            rowHeader.setCellFocus(rowHeader.getIncFetchFocusCell());
            rowHeader.setIncFetchFocusCell(null);
        }
        if ((databody = this.getTableDatabody()) != null && databody.getIncFetchFocusCell() != null) {
            databody.setCellFocus(databody.getIncFetchFocusCell());
            databody.setIncFetchFocusCell(null);
        }
    }

    protected TableDatabody getTableDatabody() {
        return this.table != null ? this.table.getTableDatabody() : null;
    }

    public GridViewDatabody getDatabody() {
        return this.table != null ? this.table.getTableDatabody() : null;
    }

    public GridViewTable getGridViewTable() {
        return this.table;
    }

    protected TableHeader getTableColumnHeader() {
        return this.table != null ? this.table.getTableColumnHeader() : null;
    }

    protected TableHeader getTableRowHeader() {
        return this.table != null ? this.table.getTableRowHeader() : null;
    }

    public GridViewHeader getColumnHeader() {
        return this.table != null ? (GridViewHeader)this.table.getTableColumnHeader() : null;
    }

    public GridViewHeader getRowHeader() {
        return this.table != null ? (GridViewHeader)this.table.getTableRowHeader() : null;
    }

    public void setColumnHeaderVisible(boolean visible) {
        boolean oldVisible = this.m_colHeaderVisible;
        this.m_colHeaderVisible = visible;
        this.getTable().setColumnHeaderVisible(visible);
        if (visible && !oldVisible) {
            this.updateColumnWidth();
            this.updateColumnHeaderRowHeights();
            this.updateRowHeights();
        }
    }

    public boolean isColumnHeaderVisible() {
        return this.m_colHeaderVisible;
    }

    public void setRowHeaderVisible(boolean visible) {
        boolean oldVisible = this.m_rowHeaderVisible;
        this.m_rowHeaderVisible = visible;
        this.getTable().setRowHeaderVisible(visible);
        if (visible && !oldVisible) {
            this.updateRowHeaderWidths();
            this.updateRowHeights();
        }
    }

    public boolean isRowHeaderVisible() {
        return this.m_rowHeaderVisible;
    }

    public TableSpreadTable getTable() {
        return this.table;
    }

    public void setZoomFactor(int f) {
        if (f <= 0) {
            this.getErrorHandler().log("invalid zoom factor", this.getClass().getName(), m_method_setzoomfactor);
            return;
        }
        int oldValue = this.getZoomFactor();
        if (oldValue != f) {
            this.zoomFactor = f;
            this.scaleImages();
            this.getTableRowHeader().setZoomFactor(f);
            this.getTableColumnHeader().setZoomFactor(f);
            ((Title)this.getDataviewTitle()).setZoomFactor(f);
            ((Subtitle)this.getDataviewSubtitle()).setZoomFactor(f);
            ((Footnote)this.getDataviewFootnote()).setZoomFactor(f);
            this.getPagingControl().setZoomFactor(f);
            this.doSizing();
            this.invalidate();
            this.repaint();
            this.firePropertyChange(this, "ZoomFactor", new Integer(oldValue), new Integer(f));
        }
    }

    public void setBackgroundImage(Image image) {
        this.setBackgroundImage(image, false);
    }

    protected void setBackgroundImage(Image image, boolean bSetFromPath) {
        super.setBackgroundImage(image, bSetFromPath);
        if (this.getBackgroundImage() != null) {
            this.getTableDatabody().setFill((Painter)new PainterTiler((Painter)new FixedImagePainter(this.getBackgroundImage(), 0)));
        } else {
            this.getTableDatabody().setFill(null);
        }
    }

    protected Image getDefaultDrillImage() {
        return this.getTableColumnHeader().getDrillImage();
    }

    protected Image getDefaultDrilledImage() {
        return this.getTableColumnHeader().getDrilledImage();
    }

    protected void drillImageChanged() {
        this.getTableColumnHeader().clearUnscaledBlankImage();
        this.getTableColumnHeader().clearScaledBlankImage();
        this.getTableRowHeader().clearUnscaledBlankImage();
        this.getTableRowHeader().clearScaledBlankImage();
        super.drillImageChanged();
    }

    public void setCornerComponentColor(Color c) {
        if (c == null) {
            this.getErrorHandler().log("invalid color", this.getClass().getName(), m_method_setcornercomponentcolor);
            return;
        }
        Color oldColor = this.getCornerComponentColor();
        this.getTable().getCornerComponent("UPPER_LEFT_CORNER").setBackground(c);
        this.setCornerComponentColorUsed(true);
        this.firePropertyChange(this, "CornerComponentColor", oldColor, c);
    }

    public Color getCornerComponentColor() {
        return this.getTable().getCornerComponent("UPPER_LEFT_CORNER").getBackground();
    }

    public void setDefaultCornerComponentColor(Color c) {
        if (c == null) {
            this.getErrorHandler().log("invalid color", this.getClass().getName(), "public void setDefaultCornerComponentColor(Color c)");
            return;
        }
        this._tableXML.setDefaultCornerComponentColor(c);
        if (!this.isCornerComponentColorUsed()) {
            this.setCornerComponentColor(c);
            this.setCornerComponentColorUsed(false);
        }
    }

    public void setColumnWidth(int index, int width) {
        if (index < 0 || index > this.table.getGrid().getModel().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setcolumnwidth);
        } else if (width < 0) {
            this.getErrorHandler().log("invalid column width", this.getClass().getName(), m_method_setcolumnwidth);
        } else {
            int old = this.getColumnWidth(index);
            this.getTableSizingManager().setPreferredColumnWidth(index, width);
            this.firePropertyChange(this, "ColumnWidth", new Integer(old), new Integer(width));
        }
    }

    public void setRowHeaderColumnWidth(int width) {
        if (width < 0) {
            this.getErrorHandler().log("invalid width", this.getClass().getName(), m_method_setrowheadercolumnwidth);
            return;
        }
        int old = this.getRowHeaderColumnWidth();
        this.getTableSizingManager().setPreferredRowHeaderColumnWidth(width);
        this.firePropertyChange(this, "RowHeaderColumnWidth", new Integer(old), new Integer(width));
    }

    public int getRowHeaderColumnWidth() {
        return this.getTableSizingManager().getRowHeaderColumnWidth();
    }

    public void setRowHeight(int index, int height) {
        if (index < 0 || index > this.table.getGrid().getModel().getRowCount()) {
            this.getErrorHandler().log("invalid index", this.getClass().getName(), m_method_setrowheight);
        } else if (height < 0) {
            this.getErrorHandler().log("invalid row height", this.getClass().getName(), m_method_setrowheight);
        } else {
            int old = this.getRowHeight(index);
            this.getTableSizingManager().setPreferredRowHeight(index, height);
            this.firePropertyChange(this, "RowHeight", new Integer(old), new Integer(height));
        }
    }

    public void setColumnHeaderRowHeight(int height) {
        if (height < 0) {
            this.getErrorHandler().log("invalid height", this.getClass().getName(), m_method_setcolumnheaderrowheight);
            return;
        }
        int old = this.getColumnHeaderRowHeight();
        this.getTableSizingManager().setPreferredColumnHeaderRowHeight(height);
        this.firePropertyChange(this, "ColumnHeaderRowHeight", new Integer(old), new Integer(height));
    }

    public int getColumnHeaderRowHeight() {
        return this.getTableSizingManager().getColumnHeaderRowHeight();
    }

    protected int resizeRowHeight(int row, int startCol, int endCol) {
        if (row < 0 || row >= this.getTableModel().getTableDataSource().getRowCount()) {
            this.getErrorHandler().log("invalid row", this.getClass().getName(), m_method_resizerowheight);
            return -1;
        }
        if (this.getTable().m_calculatedRowHeights[row] != -1) {
            return this.getTable().m_calculatedRowHeights[row];
        }
        int[] heights = this.calcAutoFitRowHeights(startCol, endCol, row, row);
        return heights[0];
    }

    protected int resizeColumnWidth(int col, int startRow, int endRow) {
        if (col < 0 || col >= this.getTableModel().getTableDataSource().getColumnCount()) {
            this.getErrorHandler().log("invalid column", this.getClass().getName(), m_method_resizeColumnWidth);
            return -1;
        }
        if (this.getTable().m_calculatedColWidths[col] != -1) {
            return this.getTable().m_calculatedColWidths[col];
        }
        int[] widths = this.calcAutoFitColumnWidths(col, col, startRow, endRow);
        return widths[0];
    }

    protected Range getAutoFitColumnRange() {
        return super.getAutoFitColumnRange();
    }

    protected Range getAutoFitColumnRange(int firstCol) {
        return super.getAutoFitColumnRange(firstCol);
    }

    protected Range getAutoFitRowRange() {
        return super.getAutoFitRowRange();
    }

    protected Range getAutoFitRowRange(int firstRow) {
        return super.getAutoFitRowRange(firstRow);
    }

    public void updateColumnHeaderRowHeights() {
        if (this.table == null || this.m_bAutoFitting || this.getTable().m_bCheckingColWidths || !this.table.isColumnHeaderVisible()) {
            return;
        }
        if ((this.getAutoFitScope() & 4) < 1) {
            return;
        }
        Range range = this.getAutoFitColumnRange();
        int endCol = range.end;
        int startCol = range.begin;
        if (endCol < startCol) {
            this.getErrorHandler().log("invalid column range", this.getClass().getName(), m_method_updateColumnHeaderRowHeights);
            return;
        }
        int height = -1;
        height = this.calcAutoFitColHeaderHeight(startCol, endCol);
        if (this.getAutoFitColumnRangeCallback() != null) {
            this.getAutoFitColumnRangeCallback().endAutoFit();
        }
        this.getTableSizingManager().setCalculatedColumnHeaderRowHeight(height);
        this.sizeColumnHeaderRowHeights();
    }

    public void autoFit() {
        int width;
        boolean calcRowHeaderColWidth;
        TableSizingManager tsm = this.getTableSizingManager();
        if (tsm == null) {
            return;
        }
        boolean calcRowHeights = (this.getAutoFitScope() & 1) > 0;
        boolean calcColWidths = (this.getAutoFitScope() & 2) > 0;
        boolean calcColHeaderRowHeight = (this.getAutoFitScope() & 4) > 0;
        boolean bl = calcRowHeaderColWidth = (this.getAutoFitScope() & 8) > 0;
        if (!(calcRowHeights || calcColWidths || calcColHeaderRowHeight || calcRowHeaderColWidth)) {
            return;
        }
        boolean bValidColRange = true;
        boolean bValidRowRange = true;
        int startCol = 0;
        int endCol = 0;
        if (calcRowHeights || calcColWidths || calcColHeaderRowHeight) {
            Range range = this.getAutoFitColumnRange();
            endCol = range.end;
            startCol = range.begin;
            if (endCol < startCol) {
                this.getErrorHandler().log("invalid column range", this.getClass().getName(), m_method_autoFit);
                bValidColRange = false;
            }
        }
        int startRow = 0;
        int endRow = 0;
        if (calcRowHeights || calcColWidths || calcRowHeaderColWidth) {
            Range range = this.getAutoFitRowRange();
            endRow = range.end;
            startRow = range.begin;
            if (endRow < startRow) {
                this.getErrorHandler().log("invalid row range", this.getClass().getName(), m_method_autoFit);
                bValidRowRange = false;
            }
        }
        this.canResizeHeights = false;
        this.canResizeWidths = false;
        this.m_bAutoFitting = true;
        int colCount = endCol - startCol + 1;
        int rowCount = endRow - startRow + 1;
        if (calcRowHeaderColWidth && this.table.isRowHeaderVisible() && bValidRowRange && (width = this.calcAutoFitRowHeaderWidth(startRow, endRow)) != -1) {
            this.getTableSizingManager().setCalculatedRowHeaderColumnWidth(width);
        }
        if (calcColWidths && bValidColRange) {
            int[] widths = this.calcAutoFitColumnWidths(startCol, endCol, startRow, endRow);
            int totalWidth = 0;
            int width2 = 0;
            if (widths != null) {
                int col = startCol;
                while (col <= endCol) {
                    width2 = widths[col - startCol];
                    totalWidth += width2;
                    this.getTableSizingManager().setCalculatedColumnWidth(col, widths[col - startCol]);
                    ++col;
                }
                if (colCount > 0) {
                    int defWidth = totalWidth / colCount;
                    this.getTable().m_calculatedColCount += colCount;
                    this.getTable().m_accumulatedCalculatedColWidth += totalWidth;
                    this.getTableSizingManager().setDefaultColumnWidth(defWidth);
                }
            }
        }
        if (calcColHeaderRowHeight && this.table.isColumnHeaderVisible() && bValidColRange) {
            int height = -1;
            if (endCol >= 0) {
                height = this.calcAutoFitColHeaderHeight(startCol, endCol);
            }
            this.getTableSizingManager().setCalculatedColumnHeaderRowHeight(height);
        }
        if (calcRowHeights && bValidRowRange) {
            int[] heights = this.calcAutoFitRowHeights(startCol, endCol, startRow, endRow);
            int totalHeight = 0;
            int height = 0;
            int row = startRow;
            while (row <= endRow) {
                height = heights[row - startRow];
                totalHeight += height;
                this.getTableSizingManager().setCalculatedRowHeight(row, heights[row - startRow]);
                ++row;
            }
            if (rowCount > 0) {
                int defHeight = totalHeight / rowCount;
                this.getTable().m_calculatedRowCount += rowCount;
                this.getTable().m_accumulatedCalculatedRowHeight += totalHeight;
                this.getTableSizingManager().setDefaultRowHeight(defHeight);
            }
        }
        if ((calcRowHeights || calcColWidths || calcColHeaderRowHeight) && this.getAutoFitColumnRangeCallback() != null) {
            this.getAutoFitColumnRangeCallback().endAutoFit();
        }
        if ((calcRowHeights || calcColWidths || calcRowHeaderColWidth) && this.getAutoFitRowRangeCallback() != null) {
            this.getAutoFitRowRangeCallback().endAutoFit();
        }
        this.canResizeHeights = true;
        this.canResizeWidths = true;
        this.m_bAutoFitting = false;
        this.doSizing();
        this.tableController.fireComponentSized(this, new NonDataComponentHandle(21, TABLE_NAME, this));
    }

    public int autoFitColumnWidth(int column) {
        int width = this.calcAutoFitColumnWidth(column);
        if (width != -1) {
            this.getGridViewSizingManager().setCalculatedColumnWidth(column, width);
            if (this.getGridViewSizingManager().getPreferredColumnWidth(column) != -1) {
                this.getGridViewSizingManager().setPreferredColumnWidth(column, -1);
            } else {
                this.updateSizes(1);
            }
        }
        return width;
    }

    public Table cloneForPrint() {
        Table ct = new Table();
        ct.setVisible(this.isVisible());
        ct.setEnabled(this.isEnabled());
        try {
            ct.setTableModel((TableModel)this.getTableModel().clone());
        }
        catch (CloneNotSupportedException e) {
            this.getErrorHandler().log("clone not supported", this.getClass().getName(), m_method_cloneForPrint);
        }
        ct.setTableController((TableController)this.getTableController().cloneForNewView(ct));
        ct.setDataSource(this.getDataSource());
        try {
            ct.setGridViewFormatManager((GridViewFormatManager)this.getGridViewFormatManager().clone());
            ct.setGridViewHeaderStyleManager((GridViewHeaderStyleManager)this.getGridViewHeaderStyleManager().clone());
            ct.setGridViewDatabodyStyleManager((GridViewDatabodyStyleManager)this.getGridViewDatabodyStyleManager().clone());
            ct.setTableSizingManager((TableSizingManager)this.getTableSizingManager().clone());
            ct.setGridViewSelectionManager((GridViewSelectionManager)this.getGridViewSelectionManager().clone());
            ct.setRolloverTextManager((RolloverTextManager)this.getRolloverTextManager().clone());
        }
        catch (CloneNotSupportedException e) {
            this.getErrorHandler().log("clone not supported", this.getClass().getName(), m_method_cloneForPrint);
        }
        ct.setHGridVisible(this.isHGridVisible());
        ct.setVGridVisible(this.isVGridVisible());
        ct.setCellMaxHeight(this.getCellMaxHeight());
        ct.setCellMinHeight(this.getCellMinHeight());
        ct.setCellMaxWidth(this.getCellMaxWidth());
        ct.setCellMinWidth(this.getCellMinWidth());
        int index = 1;
        while (index < this.getDrillImageCount()) {
            ct.setDrillImage(index, this.getDrillImage(index));
            ++index;
        }
        ct.getTableDatabody().getViewStyle().setEditBackground(this.getTableDatabody().getViewStyle().getEditBackground());
        ct.getTableDatabody().getViewStyle().setEditForeground(this.getTableDatabody().getViewStyle().getEditForeground());
        ct.setZoomFactor(this.getZoomFactor());
        this.copyTableSpreadTable(ct.getTable(), this.getTable());
        return ct;
    }

    public void sizeColumnHeaderRowHeights() {
        if (this.m_bAutoFitting) {
            return;
        }
        TableSizingManager csm = this.getTableSizingManager();
        if (csm == null) {
            return;
        }
        int size = csm.getColumnHeaderRowHeight();
        if (size != -1) {
            int minCellHeight = DataviewUtils.scaleByZoom(this.cellMinHeight, this.zoomFactor);
            int maxCellHeight = DataviewUtils.scaleByZoom(this.cellMaxHeight, this.zoomFactor);
            int scaledSize = DataviewUtils.scaleByZoom(size, this.zoomFactor);
            if (scaledSize < minCellHeight) {
                scaledSize = minCellHeight;
            }
            if (scaledSize > maxCellHeight) {
                scaledSize = maxCellHeight;
            }
            this.getTable().setColumnHeaderHeight(scaledSize);
        }
    }

    public void sizeRowHeaderColumnWidths() {
        if (this.m_bAutoFitting) {
            return;
        }
        TableSizingManager csm = this.getTableSizingManager();
        if (csm == null) {
            return;
        }
        TableHeader rh = this.getTableRowHeader();
        int size = csm.getRowHeaderColumnWidth();
        if (size != -1) {
            int minCellWidth = DataviewUtils.scaleByZoom(this.cellMinWidth, this.zoomFactor);
            int maxCellWidth = DataviewUtils.scaleByZoom(this.cellMaxWidth, this.zoomFactor);
            int scaledSize = DataviewUtils.scaleByZoom(size, this.zoomFactor);
            if (scaledSize < minCellWidth) {
                scaledSize = minCellWidth;
            }
            if (scaledSize > maxCellWidth) {
                scaledSize = maxCellWidth;
            }
            this.getTable().setRowHeaderWidth(scaledSize);
        }
    }

    public void sizeRowHeights() {
        if (this.m_bAutoFitting) {
            return;
        }
        TableSizingManager tsm = this.getTableSizingManager();
        if (tsm == null) {
            return;
        }
        if (this.getTableModel().getTableDataSource().getRowCount() < 1) {
            return;
        }
        int minCellHeight = DataviewUtils.scaleByZoom(this.cellMinHeight, this.zoomFactor);
        int maxCellHeight = DataviewUtils.scaleByZoom(this.cellMaxHeight, this.zoomFactor);
        int size = tsm.getDefaultRowHeight();
        if (size != -1) {
            int scaledSize = DataviewUtils.scaleByZoom(size, this.zoomFactor);
            if (scaledSize < minCellHeight) {
                scaledSize = minCellHeight;
            }
            if (scaledSize > maxCellHeight) {
                scaledSize = maxCellHeight;
            }
            if (this.getTable().getDefaultRowHeight() != scaledSize) {
                this.getTable().setDefaultRowHeight(scaledSize);
            }
        }
        if (!this.getTable().m_bCheckingRowHeights) {
            int endRow;
            this.getTable().clearSizedRowFlags();
            int startRow = this.getTable().getFirstRowOnScreen();
            if (startRow < 0) {
                startRow = 0;
            }
            if ((endRow = this.getTable().getOnScreenRowCount() + startRow - 1) < startRow) {
                endRow = startRow;
            }
            this.sizeRowHeights(startRow, endRow);
            boolean done = false;
            while (!done) {
                boolean bNewEndRow;
                int oldStartRow = startRow;
                int oldEndRow = endRow;
                startRow = this.getTable().getFirstRowOnScreen();
                if (startRow < 0) {
                    startRow = 0;
                }
                if ((endRow = this.getTable().getOnScreenRowCount() + startRow - 1) < startRow) {
                    endRow = startRow;
                }
                boolean bNewStartRow = startRow < oldStartRow;
                boolean bl = bNewEndRow = endRow > oldEndRow;
                if (!bNewStartRow && !bNewEndRow) {
                    done = true;
                    continue;
                }
                if (bNewStartRow) {
                    this.sizeRowHeights(startRow, oldStartRow - 1);
                }
                if (!bNewEndRow) continue;
                this.sizeRowHeights(oldEndRow + 1, endRow);
            }
        }
    }

    protected void sizeRowHeights(int firstRow, int lastRow) {
        if (this.m_bAutoFitting) {
            return;
        }
        if (firstRow < 0 || lastRow < 0) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_sizeRowHeights);
            return;
        }
        TableSizingManager csm = this.getTableSizingManager();
        if (csm == null) {
            return;
        }
        int size = 0;
        int minCellHeight = DataviewUtils.scaleByZoom(this.cellMinHeight, this.zoomFactor);
        int maxCellHeight = DataviewUtils.scaleByZoom(this.cellMaxHeight, this.zoomFactor);
        int row = firstRow;
        while (row <= lastRow) {
            size = csm.getRowHeight(row);
            if (size != -1) {
                int scaledSize = DataviewUtils.scaleByZoom(size, this.zoomFactor);
                if (scaledSize < minCellHeight) {
                    scaledSize = minCellHeight;
                }
                if (scaledSize > maxCellHeight) {
                    scaledSize = maxCellHeight;
                }
                this.getTable().m_sizedRowFlags[row] = true;
                this.getTable().setRowHeight(row, scaledSize);
            }
            ++row;
        }
    }

    public void sizeColumnWidths() {
        if (this.m_bAutoFitting) {
            return;
        }
        TableSizingManager tsm = this.getTableSizingManager();
        if (tsm == null) {
            return;
        }
        int minCellWidth = DataviewUtils.scaleByZoom(this.cellMinWidth, this.zoomFactor);
        int maxCellWidth = DataviewUtils.scaleByZoom(this.cellMaxWidth, this.zoomFactor);
        int size = tsm.getDefaultColumnWidth();
        if (size != -1) {
            int scaledSize = DataviewUtils.scaleByZoom(size, this.zoomFactor);
            if (scaledSize < minCellWidth) {
                scaledSize = minCellWidth;
            }
            if (scaledSize > maxCellWidth) {
                scaledSize = maxCellWidth;
            }
            if (this.getTable().getDefaultColumnWidth() != scaledSize) {
                this.getTable().setDefaultColumnWidth(scaledSize);
            }
        }
        if (!this.getTable().m_bCheckingColWidths) {
            int endCol;
            this.getTable().clearSizedColumnFlags();
            int startCol = this.getTable().getFirstColumnOnScreen();
            if (startCol < 0) {
                startCol = 0;
            }
            if ((endCol = this.getTable().getOnScreenColumnCount() + startCol - 1) < startCol) {
                endCol = startCol;
            }
            this.sizeColumnWidths(startCol, endCol);
            boolean done = false;
            while (!done) {
                boolean bNewEndCol;
                int oldStartCol = startCol;
                int oldEndCol = endCol;
                startCol = this.getTable().getFirstColumnOnScreen();
                if (startCol < 0) {
                    startCol = 0;
                }
                if ((endCol = this.getTable().getOnScreenColumnCount() + startCol - 1) < startCol) {
                    endCol = startCol;
                }
                boolean bNewStartCol = startCol < oldStartCol;
                boolean bl = bNewEndCol = endCol > oldEndCol;
                if (!bNewStartCol && !bNewEndCol) {
                    done = true;
                    continue;
                }
                if (bNewStartCol) {
                    this.sizeColumnWidths(startCol, oldStartCol - 1);
                }
                if (!bNewEndCol) continue;
                this.sizeColumnWidths(oldEndCol + 1, endCol);
            }
        }
    }

    protected void sizeColumnWidths(int firstCol, int lastCol) {
        if (this.m_bAutoFitting) {
            return;
        }
        if (firstCol < 0 || lastCol < 0) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_sizecolumnwidths);
            return;
        }
        TableSizingManager tsm = this.getTableSizingManager();
        if (tsm == null) {
            return;
        }
        if (this.getTableModel().getTableDataSource().getColumnCount() < 1) {
            return;
        }
        int minCellWidth = DataviewUtils.scaleByZoom(this.cellMinWidth, this.zoomFactor);
        int maxCellWidth = DataviewUtils.scaleByZoom(this.cellMaxWidth, this.zoomFactor);
        int size = 0;
        int col = firstCol;
        while (col <= lastCol) {
            size = tsm.getColumnWidth(col);
            if (size != -1) {
                int scaledSize = DataviewUtils.scaleByZoom(size, this.zoomFactor);
                if (scaledSize < minCellWidth) {
                    scaledSize = minCellWidth;
                }
                if (scaledSize > maxCellWidth) {
                    scaledSize = maxCellWidth;
                }
                this.getTable().m_sizedColFlags[col] = true;
                this.getTable().setColumnWidth(col, scaledSize);
            }
            ++col;
        }
    }

    public void doSizing() {
        if (this.xmlMode) {
            return;
        }
        if (!this.canResizeHeights || !this.canResizeWidths) {
            return;
        }
        if (this.m_bAutoFitting) {
            return;
        }
        if (this.getTableSizingManager() == null) {
            return;
        }
        this.canResizeHeights = false;
        this.canResizeWidths = false;
        this.sizeColumnHeaderRowHeights();
        this.sizeRowHeaderColumnWidths();
        this.sizeRowHeights();
        this.sizeColumnWidths();
        this.canResizeHeights = true;
        this.canResizeWidths = true;
    }

    public void setColumnVisible(int column, boolean visible) {
        if (column < 0 || column > this.table.getGrid().getModel().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setcolumnvisible);
        } else {
            int i = this.invisibleColumn.size();
            int j = 0;
            boolean nodeExit = false;
            boolean search = true;
            while (j < i && !nodeExit && search) {
                if ((Integer)this.invisibleColumn.elementAt(j) == column) {
                    nodeExit = true;
                }
                if ((Integer)this.invisibleColumn.elementAt(j) > column) {
                    search = false;
                    --j;
                }
                ++j;
            }
            if (!nodeExit && !visible) {
                this.invisibleColumn.insertElementAt(new Integer(column), j);
            }
            if (nodeExit && visible) {
                this.invisibleColumn.removeElementAt(j - 1);
            }
            this.getTable().setColumnVisible(column, visible);
        }
    }

    public boolean isColumnVisible(int column) {
        if (column < 0 || column > this.table.getGrid().getModel().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_iscolumnvisible);
            return false;
        }
        return this.getTable().isColumnVisible(column);
    }

    public void setRowVisible(int row, boolean visible) {
        if (row < 0 || row > this.table.getGrid().getModel().getRowCount()) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setrowvisible);
        } else {
            int i = this.invisibleRow.size();
            int j = 0;
            boolean nodeExit = false;
            boolean search = true;
            while (j < i && !nodeExit && search) {
                if ((Integer)this.invisibleRow.elementAt(j) == row) {
                    nodeExit = true;
                }
                if ((Integer)this.invisibleRow.elementAt(j) > row) {
                    search = false;
                    --j;
                }
                ++j;
            }
            if (!nodeExit && !visible) {
                this.invisibleRow.insertElementAt(new Integer(row), j);
            }
            if (nodeExit && visible) {
                this.invisibleRow.removeElementAt(j - 1);
            }
            this.getTable().setRowVisible(row, visible);
        }
    }

    public boolean isRowVisible(int row) {
        if (row < 0 || row > this.table.getGrid().getModel().getRowCount()) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_isrowvisible);
            return false;
        }
        return this.getTable().isRowVisible(row);
    }

    public void addTableDataListener(TableDataListener l) {
        if (this.tableModel != null) {
            this.tableModel.addTableDataListener(l);
        }
    }

    public void removeTableDataListener(TableDataListener l) {
        if (this.tableModel != null) {
            this.tableModel.removeTableDataListener(l);
        }
    }

    protected String getIntlTableString(String key) {
        return this.getIntlString(key, this.localStrings);
    }

    public void setManualRowSizingEnabled(boolean bEnabled) {
        boolean oldVal = this.m_bManualRowSizingEnabled;
        this.m_bManualRowSizingEnabled = bEnabled;
        ((TableHeader)this.getRowHeader()).setCanResizeItems(bEnabled);
        this.firePropertyChange(this, "ManualRowSizingEnabled", new Boolean(oldVal), new Boolean(bEnabled));
    }

    public void setManualColumnSizingEnabled(boolean bEnabled) {
        boolean oldVal = this.m_bManualColumnSizingEnabled;
        this.m_bManualColumnSizingEnabled = bEnabled;
        ((TableHeader)this.getColumnHeader()).setCanResizeItems(bEnabled);
        this.firePropertyChange(this, "ManualColumnSizingEnabled", new Boolean(oldVal), new Boolean(bEnabled));
    }

    public void setCustomAnnotationCallback(CustomAnnotationCallback callback) {
        this.getTableDatabody().getTableData().clearAnnotationCache();
        super.setCustomAnnotationCallback(callback);
    }

    private void copyTableSpreadTable(TableSpreadTable to, TableSpreadTable from) {
        to.setColumnHeaderVisible(from.isColumnHeaderVisible());
        int column = 0;
        while (column < from.getGrid().getModel().getColumnCount()) {
            to.setColumnWidth(column, from.getColumnWidth(column));
            ++column;
        }
        to.setRowHeaderVisible(from.isRowHeaderVisible());
        int row = 0;
        while (row < from.getGrid().getModel().getRowCount()) {
            to.setRowHeight(row, from.getRowHeight(row));
            ++row;
        }
        this.copyGrid(to.getTableDatabody(), from.getTableDatabody());
        this.copyHeader(to.getTableColumnHeader(), from.getTableColumnHeader());
        this.copyHeader(to.getTableRowHeader(), from.getTableRowHeader());
    }

    private void copyHeader(TableHeader to, TableHeader from) {
        int column = 0;
        while (column < from.getModel().getItemCount()) {
            ++column;
        }
        int row = 0;
        while (row < from.getModel().getItemCount()) {
            ++row;
        }
        DataviewUtils.copyStyleProperties(to, from);
    }

    private void copyGrid(TableDatabody to, TableDatabody from) {
        super.copyGrid(to, from);
    }

    public Object getComponentFromID(int ID) {
        Object comp = super.getComponentFromID(ID);
        if (comp != null) {
            return comp;
        }
        switch (ID) {
            case 21: {
                return this;
            }
        }
        return null;
    }

    protected String getNameFromID(int ID) {
        String name = super.getNameFromID(ID);
        if (name != null) {
            return name;
        }
        switch (ID) {
            case 21: {
                return TABLE_NAME;
            }
        }
        return null;
    }

    protected int[] calcAutoFitColumnWidths(int startCol, int endCol, int startRow, int endRow) {
        TableHeader header = this.getTableColumnHeader();
        header.refreshHeaderStyle(startCol, endCol);
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        int minCellWidth = this.cellMinWidth;
        int maxCellWidth = this.cellMaxWidth;
        int colCount = endCol - startCol + 1;
        GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getTableDatabody().getAppearanceManager();
        TableDatabody g = this.getTableDatabody();
        BigCellTwoDModel bcm = (BigCellTwoDModel)this.table.getGrid().getModel();
        OneDModel ds = header.getModel();
        int offset = 0;
        int[] widths = new int[colCount];
        int column = startCol;
        while (column <= endCol) {
            Image img;
            ImmInsets appInsets;
            ImmInsets insets;
            FontMetrics fm;
            ViewStyle style;
            PaintContext pc;
            int width = 0;
            if (this.table.isColumnHeaderVisible()) {
                pc = header.getItemPaintContext(column);
                style = header.getStyle(column);
                fm = pc.getFontMetrics(style.getFont());
                String data = (String)((TableHeaderCell)ds.getData(column)).getData();
                if (data == null) {
                    data = "";
                }
                insets = style.getBorderPainter().getInsets(pc);
                appInsets = style.getInsets();
                ImmInsets borderInsets = header.getHeaderItemBorderPainter().getInsets(pc);
                offset = insets.left + insets.right + appInsets.left + appInsets.right + borderInsets.left + borderInsets.right;
                offset += 2;
                int drillImageWidth = 0;
                if (this.isDrillingEnabled() && !this.isPrintOrPreviewMode() && header.isDrilledOrDrillable(column)) {
                    drillImageWidth = header.getBlankImage().getWidth(null);
                }
                int graphicImageWidth = 0;
                img = header.getGraphicImage(column, false);
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(pc.getImageObserver());
                    ++graphicImageWidth;
                }
                width = fm.stringWidth(data) + drillImageWidth + graphicImageWidth + offset;
            }
            int cellWidth = 0;
            int row = startRow;
            while (row <= endRow) {
                style = appMgr.getCellAppearance(column, row);
                pc = g.getCellPaintContext(column, row);
                fm = pc.getFontMetrics(style.getFont());
                insets = style.getBorderPainter().getInsets(pc);
                appInsets = style.getInsets();
                img = ((TableDatabody)this.getDatabody()).getGraphicImage(column, row, false);
                int stringWidth = 0;
                if (!this.isIncrementalFetchEnabled() || !this.getTable().isIncrementalFetchRowVisible() || row < this.getTableModel().getTableDataSource().getRowCount() - 1) {
                    stringWidth = fm.stringWidth(bcm.getData(column, row).toString());
                }
                int graphicImageWidth = 0;
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(pc.getImageObserver());
                    ++graphicImageWidth;
                }
                int annotationWidth = 0;
                if (this.isAnnotationIconVisible() && (!this.isPrintOrPreviewMode() || this.isAnnotationIconPrinted()) && this.getGridViewModel().getGridViewDataSource().getAnnotation(column, row) != null) {
                    annotationWidth = this.getAnnotationImage().getWidth(pc.getImageObserver());
                    ++annotationWidth;
                }
                int hOffset = insets.left + insets.right + appInsets.left + appInsets.right;
                int dataWidth = graphicImageWidth + stringWidth + annotationWidth + (hOffset += 2);
                cellWidth = Math.max(dataWidth, cellWidth);
                ++row;
            }
            if (width < cellWidth) {
                width = cellWidth;
            }
            if (width < minCellWidth) {
                width = minCellWidth;
            }
            if (width > maxCellWidth) {
                width = maxCellWidth;
            }
            this.table.m_calculatedColWidths[column] = width;
            widths[column - startCol] = width;
            ++column;
        }
        this.zoomFactor = currZoomf;
        if (this.getZoomFactor() != 100) {
            int c = startCol;
            while (c <= endCol) {
                header.clearAppliedStyleFlag(c);
                ++c;
            }
        }
        return widths;
    }

    protected int calcAutoFitColHeaderHeight(int startCol, int endCol) {
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        TableHeader colHeader = this.getTableColumnHeader();
        colHeader.refreshHeaderStyle(startCol, endCol);
        int minCellHeight = DataviewUtils.scaleByZoom(this.cellMinHeight, this.zoomFactor);
        int maxCellHeight = DataviewUtils.scaleByZoom(this.cellMaxHeight, this.zoomFactor);
        int enhFontHeight = 0;
        int offset = 0;
        int height = 0;
        OneDModel cds = this.getTableColumnHeader().getModel();
        int horzOffset = 0;
        int oldRowHeight = 0;
        int col = startCol;
        while (col <= endCol) {
            int imageHt;
            PaintContext context = colHeader.getItemPaintContext(col);
            ViewStyle colStyle = colHeader.getStyle(col);
            ImmInsets insets = colStyle.getBorderPainter().getInsets(context);
            ImmInsets appInsets = colStyle.getInsets();
            ImmInsets borderInsets = colHeader.getHeaderItemBorderPainter().getInsets(context);
            enhFontHeight = DataviewUtils.adjustForEnhancedFont(0, colStyle.isUnderline(), colStyle.isDoubleUnderline());
            offset = insets.top + insets.bottom + appInsets.top + appInsets.bottom + borderInsets.top + borderInsets.bottom + enhFontHeight;
            int drillImageWidth = 0;
            int drillImageHeight = 0;
            if (this.isDrillingEnabled() && !this.isPrintOrPreviewMode() && colHeader.isDrilledOrDrillable(col)) {
                drillImageWidth = colHeader.getBlankImage().getWidth(null);
                drillImageHeight = colHeader.getBlankImage().getHeight(null);
            }
            int graphicImageWidth = 0;
            Image img = colHeader.getGraphicImage(col, false);
            if (img != null && !this.isPrintOrPreviewMode()) {
                graphicImageWidth = img.getWidth(context.getImageObserver());
                ++graphicImageWidth;
            }
            horzOffset = insets.left + insets.right + appInsets.left + appInsets.right + borderInsets.left + borderInsets.right + drillImageWidth + graphicImageWidth;
            horzOffset += 2;
            if (colStyle.isWordWrapEnabled()) {
                Font font = colStyle.getFont();
                FontMetrics metrics = context.getFontMetrics(font);
                String text = (String)((TableHeaderCell)cds.getData(col)).getData();
                WrappedText wrappedText = new WrappedText(text, WordWrapper.getTextWrapper(), this.getColumnWidth(col) - horzOffset, metrics, context.getPaintLocale(), false);
                int numLines = wrappedText.getLineCount();
                height = numLines * metrics.getHeight() - metrics.getLeading();
            } else {
                FontMetrics fm = context.getFontMetrics(colStyle.getFont());
                height = fm.getHeight();
            }
            if (img != null && (imageHt = img.getHeight(context.getImageObserver())) > height) {
                height = imageHt;
            }
            if (drillImageHeight > height) {
                height = drillImageHeight;
            }
            if ((height += offset) > oldRowHeight) {
                oldRowHeight = height;
            }
            ++col;
        }
        if (oldRowHeight < minCellHeight) {
            oldRowHeight = minCellHeight;
        }
        if (oldRowHeight > maxCellHeight) {
            oldRowHeight = maxCellHeight;
        }
        this.zoomFactor = currZoomf;
        if (this.getZoomFactor() != 100) {
            int c = startCol;
            while (c <= endCol) {
                colHeader.clearAppliedStyleFlag(c);
                ++c;
            }
        }
        return oldRowHeight;
    }

    protected int[] calcAutoFitRowHeights(int startCol, int endCol, int startRow, int endRow) {
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        TableHeader header = this.getTableRowHeader();
        header.refreshHeaderStyle(startRow, endRow);
        int minCellHeight = DataviewUtils.scaleByZoom(this.cellMinHeight, this.zoomFactor);
        int maxCellHeight = DataviewUtils.scaleByZoom(this.cellMaxHeight, this.zoomFactor);
        int rowCount = endRow - startRow + 1;
        boolean fontHeight = false;
        int enhFontHeight = 0;
        int offset = 0;
        int height = 0;
        int horzOffset = 0;
        boolean rowHeaderCols = true;
        TableDatabody g = this.getTableDatabody();
        GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getTableDatabody().getAppearanceManager();
        TableHeader rowHeader = this.getTableRowHeader();
        OneDModel rds = this.getTableRowHeader().getModel();
        TwoDModel tds = this.getTableDatabody().getModel();
        int[] heights = new int[rowCount];
        int row = startRow;
        while (row <= endRow) {
            FontMetrics fm;
            ImmInsets insets;
            int oldHeight = 0;
            int currRowHeight = this.getRowHeight(row);
            int col = startCol;
            while (col <= endCol) {
                int annotationHeight;
                int imageHt;
                PaintContext context = g.getCellPaintContext(col, row);
                ViewStyle style = appMgr.getCellAppearance(col, row);
                insets = style.getBorderPainter().getInsets(context);
                ImmInsets appInsets = style.getInsets();
                enhFontHeight = DataviewUtils.adjustForEnhancedFont(0, style.isUnderline(), style.isDoubleUnderline());
                offset = insets.top + insets.bottom + appInsets.top + appInsets.bottom + enhFontHeight;
                offset += 2;
                int graphicImageWidth = 0;
                Image img = ((TableDatabody)this.getDatabody()).getGraphicImage(col, row, false);
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(context.getImageObserver());
                    ++graphicImageWidth;
                }
                boolean bAnnotation = this.isAnnotationIconVisible() && (!this.isPrintOrPreviewMode() || this.isAnnotationIconPrinted()) && this.getGridViewModel().getGridViewDataSource().getAnnotation(col, row) != null;
                int annotationWidth = 0;
                if (bAnnotation) {
                    annotationWidth = this.getAnnotationImage().getWidth(context.getImageObserver());
                    ++annotationWidth;
                }
                horzOffset = insets.left + insets.right + graphicImageWidth + appInsets.left + appInsets.right + annotationWidth;
                horzOffset += 2;
                if (style.isWordWrapEnabled()) {
                    Font font = style.getFont();
                    FontMetrics metrics = context.getFontMetrics(font);
                    String text = (String)tds.getData(col, row);
                    WrappedText wrappedText = new WrappedText(text, WordWrapper.getTextWrapper(), this.getColumnWidth(col) - horzOffset, metrics, context.getPaintLocale(), false);
                    int numLines = wrappedText.getLineCount();
                    height = numLines * metrics.getHeight() - metrics.getLeading();
                } else {
                    fm = context.getFontMetrics(style.getFont());
                    height = fm.getHeight();
                }
                if (img != null && (imageHt = img.getHeight(context.getImageObserver())) > height) {
                    height = imageHt;
                }
                if (bAnnotation && (annotationHeight = this.getAnnotationImage().getHeight(context.getImageObserver())) > height) {
                    height = annotationHeight;
                }
                if ((height += offset) > oldHeight) {
                    oldHeight = height;
                }
                ++col;
            }
            if (this.table.isRowHeaderVisible()) {
                int imageHt;
                PaintContext context = rowHeader.getItemPaintContext(row);
                ViewStyle rowStyle = rowHeader.getStyle(row);
                insets = rowStyle.getBorderPainter().getInsets(context);
                ImmInsets appInsets = rowStyle.getInsets();
                ImmInsets borderInsets = rowHeader.getHeaderItemBorderPainter().getInsets(context);
                enhFontHeight = DataviewUtils.adjustForEnhancedFont(0, rowStyle.isUnderline(), rowStyle.isDoubleUnderline());
                offset = insets.top + insets.bottom + appInsets.top + appInsets.bottom + borderInsets.top + borderInsets.bottom + enhFontHeight;
                int drillImageWidth = 0;
                int drillImageHeight = 0;
                if (this.isDrillingEnabled() && !this.isPrintOrPreviewMode() && rowHeader.isDrilledOrDrillable(row)) {
                    drillImageWidth = rowHeader.getBlankImage().getWidth(null);
                    drillImageHeight = rowHeader.getBlankImage().getHeight(null);
                }
                int graphicImageWidth = 0;
                Image img = rowHeader.getGraphicImage(row, false);
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(context.getImageObserver());
                    ++graphicImageWidth;
                }
                horzOffset = insets.left + insets.right + appInsets.left + appInsets.right + borderInsets.left + borderInsets.right + drillImageWidth + graphicImageWidth;
                if (rowStyle.isWordWrapEnabled()) {
                    Font font = rowStyle.getFont();
                    FontMetrics metrics = context.getFontMetrics(font);
                    String text = (String)((TableHeaderCell)rds.getData(row)).getData();
                    WrappedText wrappedText = new WrappedText(text, WordWrapper.getTextWrapper(), this.getRowHeaderColumnWidth() - horzOffset, metrics, context.getPaintLocale(), false);
                    int numLines = wrappedText.getLineCount();
                    height = numLines * metrics.getHeight() - metrics.getLeading();
                } else {
                    fm = context.getFontMetrics(rowStyle.getFont());
                    height = fm.getHeight();
                }
                if (img != null && (imageHt = img.getHeight(context.getImageObserver())) > height) {
                    height = imageHt;
                }
                if (drillImageHeight > height) {
                    height = drillImageHeight;
                }
                if ((height += offset) > oldHeight) {
                    oldHeight = height;
                }
            }
            if (oldHeight < minCellHeight) {
                oldHeight = minCellHeight;
            }
            if (oldHeight > maxCellHeight) {
                oldHeight = maxCellHeight;
            }
            this.table.m_calculatedRowHeights[row] = oldHeight;
            heights[row - startRow] = oldHeight;
            ++row;
        }
        this.zoomFactor = currZoomf;
        if (this.getZoomFactor() != 100) {
            int r = startRow;
            while (r <= endRow) {
                header.clearAppliedStyleFlag(r);
                ++r;
            }
        }
        return heights;
    }

    protected int calcAutoFitRowHeaderWidth(int startRow, int endRow) {
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        TableHeader header = this.getTableRowHeader();
        header.refreshHeaderStyle(startRow, endRow);
        int minCellWidth = this.cellMinWidth;
        int maxCellWidth = this.cellMaxWidth;
        int width = 0;
        String data = null;
        int offset = 0;
        OneDModel ds = this.getTableRowHeader().getModel();
        boolean bRowNums = true;
        int row = startRow;
        while (row <= endRow) {
            data = (String)((TableHeaderCell)ds.getData(row)).getData();
            if (data != null && data.length() > 0) {
                try {
                    int rowNumber = Integer.parseInt(data);
                }
                catch (NumberFormatException nfe) {
                    bRowNums = false;
                    break;
                }
            }
            ++row;
        }
        if (bRowNums) {
            int rowCount = ds.getItemCount();
            String maxExpectedLabel = Integer.toString(rowCount);
            data = "";
            int n = 0;
            while (n < maxExpectedLabel.length()) {
                data = data + "0";
                ++n;
            }
        }
        row = startRow;
        while (row <= endRow) {
            PaintContext pc = header.getItemPaintContext(row);
            ViewStyle viewStyle = header.getStyle(row);
            FontMetrics fm = pc.getFontMetrics(viewStyle.getFont());
            if (!bRowNums) {
                data = (String)((TableHeaderCell)ds.getData(row)).getData();
            }
            ImmInsets insets = viewStyle.getBorderPainter().getInsets(pc);
            ImmInsets appInsets = viewStyle.getInsets();
            ImmInsets borderInsets = header.getHeaderItemBorderPainter().getInsets(pc);
            offset = insets.left + insets.right + appInsets.left + appInsets.right + borderInsets.left + borderInsets.right;
            offset += 2;
            int drillImageWidth = 0;
            if (this.isDrillingEnabled() && !this.isPrintOrPreviewMode() && header.isDrilledOrDrillable(row)) {
                drillImageWidth = header.getBlankImage().getWidth(null);
            }
            int graphicImageWidth = 0;
            Image img = header.getGraphicImage(row, false);
            if (img != null && !this.isPrintOrPreviewMode()) {
                graphicImageWidth = img.getWidth(pc.getImageObserver());
                ++graphicImageWidth;
            }
            int tempWidth = drillImageWidth + graphicImageWidth + offset;
            if (data != null) {
                tempWidth += fm.stringWidth(data);
            }
            width = Math.max(tempWidth, width);
            ++row;
        }
        if (width < minCellWidth) {
            width = minCellWidth;
        }
        if (width > maxCellWidth) {
            width = maxCellWidth;
        }
        this.zoomFactor = currZoomf;
        if (this.getZoomFactor() != 100) {
            int r = startRow;
            while (r <= endRow) {
                header.clearAppliedStyleFlag(r);
                ++r;
            }
        }
        return width;
    }

    protected void firePropertyChange(Object obj, String propName, Object oldValue, Object newValue) {
        super.firePropertyChange(obj, propName, oldValue, newValue);
    }

    protected void firePrintBegin(Object source) {
        super.firePrintBegin(source);
    }

    protected void firePrintEnd(Object source) {
        super.firePrintEnd(source);
    }

    protected void setFirstPrintedRow(int row) {
        this.m_iFirstPrintedRow = row;
    }

    protected int getFirstPrintedRow() {
        return this.m_iFirstPrintedRow;
    }

    public void modelWaitDataAvailable(WaitDataAvailableEvent e) {
        WaitData[] waitDataForRows = this.getWaitData();
        if (waitDataForRows != null) {
            int i = 0;
            while (i < waitDataForRows.length) {
                if (waitDataForRows[i] != null) {
                    this.getTable().m_calculatedRowHeights[i] = -1;
                    this.getTable().m_sizedRowFlags[i] = false;
                }
                ++i;
            }
        }
        super.modelWaitDataAvailable(e);
    }

    public int getViewType() {
        return 2;
    }

    public boolean setXML(String xmlString, boolean reset) throws BIIOException, BISAXException, BIParseException {
        int resetFlag = 0;
        if (reset) {
            resetFlag = 2;
        }
        return this.setXML(xmlString, resetFlag);
    }

    public boolean setXML(String xmlString, int reset) throws BIIOException, BISAXException, BIParseException {
        XMLObjectReader reader = new XMLObjectReader(xmlString);
        if (this.isXMLValidated()) {
            reader.setValidationMode(true);
            try {
                reader.setDTD("/oracle/dss/table/Table.dtd", TABLE_NAME);
            }
            catch (BIParseException bipe) {
                System.out.println("Syntax error in DTD in line number " + bipe.getLineNumber());
            }
        }
        ObjectNode node = reader.readObjectNode();
        int newReset = reset;
        if (newReset < 0 || newReset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), "setXML(String xmlString, int reset)");
            newReset = 0;
        }
        if (newReset != 0) {
            this.resetToDefault(newReset);
        }
        this.setXML(node, newReset);
        return true;
    }

    public boolean readXML(InputStream stream, boolean reset) throws BIIOException, BISAXException, BIParseException {
        int resetFlag = 0;
        if (reset) {
            resetFlag = 2;
        }
        return this.readXML(stream, resetFlag);
    }

    public boolean readXML(InputStream stream, int reset) throws BIIOException, BISAXException, BIParseException {
        XMLObjectReader reader = new XMLObjectReader(stream);
        if (this.isXMLValidated()) {
            reader.setValidationMode(true);
            try {
                reader.setDTD("/oracle/dss/table/Table.dtd", TABLE_NAME);
            }
            catch (BIParseException bipe) {
                System.out.println("Syntax error in DTD in line number " + bipe.getLineNumber());
            }
        }
        ObjectNode node = reader.readObjectNode();
        int newReset = reset;
        if (newReset < 0 || newReset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), "readXML(InputStream stream, int reset)");
            newReset = 0;
        }
        if (newReset != 0) {
            this.resetToDefault(newReset);
        }
        this.setXML(node, newReset);
        return true;
    }

    public void resetToDefault(int reset, String version) {
        if (reset < 0 || reset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), "resetToDefault(int reset)");
            return;
        }
        if (reset == 0) {
            this.getErrorHandler().log("attempt to reset to default with argument of RESET_NONE", this.getClass().getName(), "resetToDefault(int reset)");
            return;
        }
        this._tableXML.resetTableXML(reset);
        super.resetToDefault(reset, version);
        if (reset == 4 || reset == 2) {
            this.setTableModel(new TableModelAdapter(this));
            this.removeErrorHandler();
            this.setDataSource(null);
            this.setTableController(new TableControllerAdapter(this));
        } else if (reset == 3 || reset == 1) {
            this.getTableController().setSelectedObject(null, false);
        }
        this.m_bResizeForDrillImages = false;
        this.setDrillImage(2, this.getTableColumnHeader().getDrilledImage());
        this.setDrillImage(1, this.getTableColumnHeader().getDrillImage());
        this.m_bResizeForDrillImages = true;
        this.getTableDatabody().resetToDefault(reset);
        this.getTableRowHeader().resetToDefault(reset);
        this.getTableColumnHeader().resetToDefault(reset);
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        } else {
            this.doSizing();
        }
    }

    protected ObjectNode getObjectNode(boolean allProperties) {
        return this._tableXML.getObjectNode(allProperties);
    }

    protected void setXML(ObjectNode node, int reset) {
        this.xmlMode = true;
        this._tableXML.setXML(node, reset);
        this.xmlMode = false;
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        } else {
            this.doSizing();
        }
    }

    protected void setContext() {
        this._tableXML.setContext(this.m_context);
        super.setContext();
        ((TableRuleSizing)this.getTableSizingManager()).setContext(this.m_context);
    }

    protected DataviewXML getViewXML() {
        return this._tableXML;
    }

    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        try {
            this.setLoadingViewFromPersistence(true);
            this.m_tmpStartColumn = -1;
            this.m_tmpStartRow = -1;
            boolean bl = this.setXML(xml, 0);
            return bl;
        }
        catch (Exception e) {
            this.setLoadingViewFromPersistence(false);
            throw new BIPersistenceException(e.getMessage(), e);
        }
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        PersistableAttributes result = null;
        result = this.m_attrs == null ? new PersistableAttributes() : (PersistableAttributes)this.m_attrs.clone();
        if (oldAttrs != null) {
            result.merge(oldAttrs);
        }
        result.setObjectType(TABLE_NAME);
        result.setTitle(((Title)this.getDataviewTitle()).getText());
        result.setObjectTypeVersion(1);
        return result;
    }

    public ViewFormat getComponentViewFormat(ComponentHandle componentHandle) {
        return Table._getComponentViewFormat(this, this.getGridViewFormatManager(), componentHandle);
    }

    public static ViewFormat _getComponentViewFormat(GridViewCommon gridView, GridViewFormatManager ruleFormatter, ComponentHandle componentHandle) {
        if (componentHandle == null) {
            return null;
        }
        ViewFormat viewFormat = null;
        if (componentHandle instanceof DataComponentHandle) {
            int row = ((DataComponentHandle)componentHandle).getRow();
            int column = ((DataComponentHandle)componentHandle).getColumn();
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, row, column);
        } else if (componentHandle instanceof DataRangeComponentHandle) {
            DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
            int row = ci[0].getRow();
            int column = ci[0].getColumn();
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, row, column);
        } else if (componentHandle instanceof ColumnComponentHandle) {
            int column = ((ColumnComponentHandle)componentHandle).getColumn();
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, 0, column);
        } else if (componentHandle.getID() == 13) {
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, 0, 0);
        }
        return viewFormat;
    }

    public ViewStyle getComponentViewStyle(ComponentHandle componentHandle) {
        if (componentHandle == null) {
            return null;
        }
        ViewStyle viewStyle = null;
        try {
            GridViewHeaderStyleManager headerRuleStyles = this.getGridViewHeaderStyleManager();
            GridViewDatabodyStyleManager databodyRuleStyles = this.getGridViewDatabodyStyleManager();
            if (componentHandle instanceof EdgeComponentHandle) {
                int edge = ((EdgeComponentHandle)componentHandle).getEdge();
                int depth = ((EdgeComponentHandle)componentHandle).getDepth();
                int index = ((EdgeComponentHandle)componentHandle).getIndex();
                ViewStyle _style = null;
                if (edge == 0) {
                    _style = this.getTableColumnHeader().getViewStyle();
                } else if (edge == 1) {
                    _style = this.getTableRowHeader().getViewStyle();
                } else if (edge == 2) {
                    _style = this.getTableDatabody().getViewStyle();
                }
                viewStyle = headerRuleStyles.getMetadataStyle(this, new String(""), _style, edge, depth, 0);
            } else if (componentHandle instanceof EdgeRangeComponentHandle) {
                EdgeComponentInfo edgeInfo = (EdgeComponentInfo)((EdgeRangeComponentHandle)componentHandle).getComponentInfo();
                int edge = edgeInfo.getEdge();
                int depth = edgeInfo.getDepth();
                int index = edgeInfo.getIndex();
                ViewStyle _style = null;
                if (edge == 0) {
                    _style = this.getTableColumnHeader().getViewStyle();
                } else if (edge == 1) {
                    _style = this.getTableRowHeader().getViewStyle();
                } else if (edge == 2) {
                    _style = this.getTableDatabody().getViewStyle();
                }
                viewStyle = headerRuleStyles.getMetadataStyle(this, new String(""), _style, edge, depth, 0);
            } else if (componentHandle instanceof ColumnComponentHandle) {
                int column = ((ColumnComponentHandle)componentHandle).getColumn();
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(column, 0), this.getTableDatabody().getViewStyle(), 0, column, this.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
            } else if (componentHandle instanceof ColumnRangeComponentHandle) {
                int column = ((ColumnRangeComponentHandle)componentHandle).getLocationList()[0].getColumn();
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(column, 0), this.getTableDatabody().getViewStyle(), 0, column, this.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
            } else if (componentHandle instanceof RowComponentHandle) {
                int row = ((RowComponentHandle)componentHandle).getRow();
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(0, row), this.getTableDatabody().getViewStyle(), row, 0, this.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
            } else if (componentHandle instanceof RowRangeComponentHandle) {
                int row = ((RowRangeComponentHandle)componentHandle).getLocationList()[0].getRow();
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(0, row), this.getTableDatabody().getViewStyle(), row, 0, this.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
            } else if (componentHandle instanceof DataComponentHandle) {
                int row = ((DataComponentHandle)componentHandle).getRow();
                int column = ((DataComponentHandle)componentHandle).getColumn();
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(column, row), this.getTableDatabody().getViewStyle(), row, column, this.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
            } else if (componentHandle instanceof DataRangeComponentHandle) {
                DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
                int row = ci[0].getRow();
                int column = ci[0].getColumn();
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(column, row), this.getTableDatabody().getViewStyle(), row, column, this.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
            } else if (componentHandle instanceof PageItemComponentHandle) {
                viewStyle = headerRuleStyles.getMetadataStyle(this, null, new ViewStyle((DataviewCommon)this, this.getPagingControl().getViewStyle()), 2, ((PageItemComponentHandle)componentHandle).getPageItem(), 0);
            } else if (componentHandle.getID() == 13) {
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(0, 0), this.getTableDatabody().getViewStyle(), 0, 0, this.getTableModel().getDataAccess().getEdgeCurrentHPos(2));
            }
        }
        catch (Exception e) {
            this.getErrorHandler().log("can't get component view style", this.getClass().getName(), m_method_getComponentViewStyle);
        }
        return viewStyle;
    }

    public boolean compareComponentViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
        int endRow;
        int startRow;
        int endCol;
        if (componentHandle == null) {
            return false;
        }
        int startCol = this.getTable().getFirstColumnOnScreen();
        if (startCol < 0) {
            startCol = 0;
        }
        if ((endCol = this.getTable().getOnScreenColumnCount() + startCol) < startCol) {
            endCol = startCol;
        }
        if ((startRow = this.getTable().getFirstRowOnScreen()) < 0) {
            startRow = 0;
        }
        if ((endRow = this.getTable().getOnScreenRowCount() + startRow) < startRow) {
            endRow = startRow;
        }
        if (componentHandle instanceof DataRangeComponentHandle) {
            DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
            int i = 0;
            while (i < ci.length) {
                DataComponentHandle dd = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), ci[i]);
                ViewStyle style = this.getComponentViewStyle(dd);
                if (!style.contains(viewStyle)) {
                    return false;
                }
                ++i;
            }
        } else if (componentHandle instanceof RowComponentHandle) {
            int row = ((RowComponentHandle)componentHandle).getRow();
            int i = startCol;
            while (i < endCol) {
                DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), row, i);
                ViewStyle style = this.getComponentViewStyle(d);
                if (!style.contains(viewStyle)) {
                    return false;
                }
                ++i;
            }
        } else if (componentHandle instanceof RowRangeComponentHandle) {
            RowComponentInfo[] ci = ((RowRangeComponentHandle)componentHandle).getLocationList();
            int j = 0;
            while (j < ci.length) {
                int i = startCol;
                while (i < endCol) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), ci[j].getRow(), i);
                    ViewStyle style = this.getComponentViewStyle(d);
                    if (!style.contains(viewStyle)) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
        } else if (componentHandle instanceof ColumnComponentHandle) {
            int column = ((ColumnComponentHandle)componentHandle).getColumn();
            int i = startRow;
            while (i < endRow) {
                DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, column);
                ViewStyle style = this.getComponentViewStyle(d);
                if (!style.contains(viewStyle)) {
                    return false;
                }
                ++i;
            }
        } else if (componentHandle instanceof ColumnRangeComponentHandle) {
            ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)componentHandle).getLocationList();
            int j = 0;
            while (j < ci.length) {
                int i = startRow;
                while (i < endRow) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, ci[j].getColumn());
                    ViewStyle style = this.getComponentViewStyle(d);
                    if (!style.contains(viewStyle)) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
        } else if (componentHandle.getID() == 13) {
            int j = startCol;
            while (j < endCol) {
                int i = startRow;
                while (i < endRow) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, j);
                    ViewStyle style = this.getComponentViewStyle(d);
                    if (!style.contains(viewStyle)) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
        } else {
            ViewStyle style = this.getComponentViewStyle(componentHandle);
            if (!style.contains(viewStyle)) {
                return false;
            }
        }
        return true;
    }

    public boolean compareComponentViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
        int endRow;
        int startRow;
        int endCol;
        if (componentHandle == null) {
            return false;
        }
        int startCol = this.getTable().getFirstColumnOnScreen();
        if (startCol < 0) {
            startCol = 0;
        }
        if ((endCol = this.getTable().getOnScreenColumnCount() + startCol) < startCol) {
            endCol = startCol;
        }
        if ((startRow = this.getTable().getFirstRowOnScreen()) < 0) {
            startRow = 0;
        }
        if ((endRow = this.getTable().getOnScreenRowCount() + startRow) < startRow) {
            endRow = startRow;
        }
        if (componentHandle instanceof DataRangeComponentHandle) {
            DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
            int i = 0;
            while (i < ci.length) {
                DataComponentHandle dd = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), ci[i]);
                ViewFormat format = this.getComponentViewFormat(dd);
                if (!format.contains(viewFormat)) {
                    return false;
                }
                ++i;
            }
        } else if (componentHandle instanceof RowComponentHandle) {
            int row = ((RowComponentHandle)componentHandle).getRow();
            int i = startCol;
            while (i < endCol) {
                DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), row, i);
                ViewFormat format = this.getComponentViewFormat(d);
                if (!format.contains(viewFormat)) {
                    return false;
                }
                ++i;
            }
        } else if (componentHandle instanceof RowRangeComponentHandle) {
            RowComponentInfo[] ci = ((RowRangeComponentHandle)componentHandle).getLocationList();
            int j = 0;
            while (j < ci.length) {
                int i = startCol;
                while (i < endCol) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), ci[j].getRow(), i);
                    ViewFormat format = this.getComponentViewFormat(d);
                    if (!format.contains(viewFormat)) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
        } else if (componentHandle instanceof ColumnComponentHandle) {
            int column = ((ColumnComponentHandle)componentHandle).getColumn();
            int i = startRow;
            while (i < endRow) {
                DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, column);
                ViewFormat format = this.getComponentViewFormat(d);
                if (!format.contains(viewFormat)) {
                    return false;
                }
                ++i;
            }
        } else if (componentHandle instanceof ColumnRangeComponentHandle) {
            ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)componentHandle).getLocationList();
            int j = 0;
            while (j < ci.length) {
                int i = startRow;
                while (i < endRow) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, ci[j].getColumn());
                    ViewFormat format = this.getComponentViewFormat(d);
                    if (!format.contains(viewFormat)) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
        } else if (componentHandle.getID() == 13) {
            int j = startCol;
            while (j < endCol) {
                int i = startRow;
                while (i < endRow) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, j);
                    ViewFormat format = this.getComponentViewFormat(d);
                    if (!format.contains(viewFormat)) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
        } else {
            ViewFormat format = this.getComponentViewFormat(componentHandle);
            if (!format.contains(viewFormat)) {
                return false;
            }
        }
        return true;
    }

    public void applyViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
        if (this.getUIFormats() == null) {
            this.setUIFormats(new Vector());
        }
        int size = this.getUIFormats().size();
        if (viewFormat != null) {
            Table._applyFormatting(this, this.getGridViewFormatManager(), componentHandle, (Mergeable)viewFormat, this.getUIFormats());
        }
        if (this.getUIFormats().size() > size) {
            this.setToolbarUIFormatCount(this.getToolbarUIFormatCount() + 1);
            ((UIFormat)this.getUIFormats().lastElement()).setName(MessageFormat.format(this.localStrings.getString("toolbarformat"), String.valueOf(this.getToolbarUIFormatCount())));
            int isSelectionNumberOrDate = this.isSelectionNumberOrDate(componentHandle);
            if (viewFormat.getNumberType() == 1) {
                if (isSelectionNumberOrDate == 0) {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(48);
                } else if (isSelectionNumberOrDate == 2) {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(63);
                } else {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(32);
                }
            } else if (viewFormat.getNumberType() == 2) {
                if (isSelectionNumberOrDate == 0) {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(64);
                } else if (isSelectionNumberOrDate == 2) {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(79);
                } else {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(32);
                }
            } else if (isSelectionNumberOrDate == 0) {
                ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(32);
            } else if (isSelectionNumberOrDate == 2) {
                ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(47);
            } else {
                ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(32);
            }
            this.firePropertyChange(this, "ToolbarFormat", null, (UIFormat)this.getUIFormats().lastElement());
        }
    }

    public void applyViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
        if (viewStyle != null) {
            if (this.getUIFormats() == null) {
                this.setUIFormats(new Vector());
            }
            int size = this.getUIFormats().size();
            if (componentHandle instanceof EdgeComponentHandle || componentHandle instanceof EdgeRangeComponentHandle || componentHandle instanceof PageItemComponentHandle) {
                Table._applyFormatting(this, this.getGridViewHeaderStyleManager(), componentHandle, (Mergeable)viewStyle, this.getUIFormats());
                if (this.getUIFormats().size() > size) {
                    ((UIFormat)this.getUIFormats().lastElement()).setMergeableType(0);
                    ((UIFormat)this.getUIFormats().lastElement()).setGroup(1);
                }
            } else {
                Table._applyFormatting(this, this.getGridViewDatabodyStyleManager(), componentHandle, (Mergeable)viewStyle, this.getUIFormats());
            }
            if (this.getUIFormats().size() > size) {
                this.setToolbarUIFormatCount(this.getToolbarUIFormatCount() + 1);
                ((UIFormat)this.getUIFormats().lastElement()).setName(MessageFormat.format(this.localStrings.getString("toolbarformat"), String.valueOf(this.getToolbarUIFormatCount())));
                this.firePropertyChange(this, "ToolbarFormat", null, (UIFormat)this.getUIFormats().lastElement());
            }
            if (this.getUIFormats().size() > 0) {
                int isSelectionNumberOrDate = this.isSelectionNumberOrDate(componentHandle);
                if (isSelectionNumberOrDate == 0) {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(32);
                } else if (isSelectionNumberOrDate == 1) {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(240);
                } else {
                    ((UIFormat)this.getUIFormats().lastElement()).setNumberOrDateCategory(47);
                }
            }
        }
    }

    protected void applyFormatting(UIBundle manager, ComponentHandle componentHandle, Mergeable mergeable) {
        Table._applyFormatting(this, manager, componentHandle, mergeable);
    }

    public static void _applyFormatting(GridViewCommon gridView, UIBundle manager, ComponentHandle componentHandle, Mergeable mergeable) {
        Table._applyFormatting(gridView, manager, componentHandle, mergeable, null);
    }

    protected static void _applyFormatting(GridViewCommon gridView, UIBundle manager, ComponentHandle componentHandle, Mergeable mergeable, Vector formats) {
        DataAccess dataAccess = gridView.getModel().getDataAccess();
        Object rule = null;
        TableFormatUtil util = null;
        try {
            util = new TableFormatUtil(gridView, componentHandle);
        }
        catch (Exception e) {
            return;
        }
        GridViewFormatUtils.applyFormat(gridView, manager, util.getDiscriminator(), mergeable);
    }

    private static CompositeDiscriminator _getCellCompositeDiscriminator(DataAccess p_dataAccess, int p_row, int p_column) {
        DataAccess dataAccess = p_dataAccess;
        int row = p_row;
        int column = p_column;
        QDRDiscriminator qdrDiscriminator = null;
        Object value = null;
        try {
            QDR layerQDR = dataAccess.getLayerQDR(0, column, 0);
            qdrDiscriminator = new QDRDiscriminator(layerQDR, 4);
            value = dataAccess.getValue(row, column, "dataValue");
        }
        catch (Exception dataComponentException) {
            CompositeDiscriminator compositeDiscriminator = null;
            return compositeDiscriminator;
        }
        CompositeDiscriminator compositeDiscriminator = null;
        if (value instanceof String) {
            compositeDiscriminator = new CompositeDiscriminator((Discriminator)new StringValueDiscriminator((String)value, 0), (Discriminator)qdrDiscriminator, 0);
        } else if (value instanceof Number) {
            compositeDiscriminator = new CompositeDiscriminator((Discriminator)new NumberValueDiscriminator(((Number)value).doubleValue(), 0), (Discriminator)qdrDiscriminator, 0);
        } else if (value instanceof Date) {
            compositeDiscriminator = new CompositeDiscriminator((Discriminator)new DateValueDiscriminator((Date)value, 0), (Discriminator)qdrDiscriminator, 0);
        } else {
            return null;
        }
        return compositeDiscriminator;
    }

    protected Rule createQDRRule(QDR qdr, Mergeable mergeable, int type) {
        return Table._createQDRRule(qdr, mergeable, type);
    }

    public static Rule _createQDRRule(QDR qdr, Mergeable mergeable, int type) {
        QDRDiscriminator discriminator = new QDRDiscriminator(qdr, type);
        DiscriminatorRule rule = new DiscriminatorRule((Discriminator)discriminator, mergeable);
        return rule;
    }

    protected void setDataGroupsortSupported(boolean supported) {
        this.m_dataGroupsortSupported = supported;
    }

    public boolean isDataGroupsortSupported() {
        return this.m_dataGroupsortSupported;
    }

    protected void setDataNameSupported(boolean supported) {
        this.m_dataNameSupported = supported;
    }

    protected boolean isDataNameSupported() {
        return this.m_dataNameSupported;
    }

    protected void setLayerMetaCanPivotSupported(boolean supported) {
        this.m_bLayerMetadataCanPivotSupported = supported;
    }

    protected boolean isLayerMetaCanPivotSupported() {
        return this.m_bLayerMetadataCanPivotSupported;
    }

    protected boolean isDataAnnotationSupported() {
        return super.isDataAnnotationSupported();
    }

    protected boolean isFocusRequestedForCell() {
        return this.m_bFocusRequestedForCell;
    }

    public GridViewExcelHTMLExport getGridViewExcelHTMLExport() {
        return new TableExcelHTMLExport(this);
    }

    protected boolean saveExportState(GridView.GridViewExportState state) {
        boolean bResult = super.saveExportState(state);
        state.setFirstRowOnScreen(this.getTable().getFirstRowOnScreen());
        state.setFirstColOnScreen(this.getTable().getFirstColumnOnScreen());
        return bResult;
    }

    protected void resizeViewAfterExport(int firstColOnScreen, int firstRowOnScreen) {
        this.autoFit();
        if (firstRowOnScreen >= 0 && firstRowOnScreen < this.getTable().getGrid().getModel().getRowCount()) {
            this.getTable().setFirstRowOnScreen(firstRowOnScreen);
        }
        if (firstColOnScreen >= 0 && firstColOnScreen < this.getTable().getGrid().getModel().getColumnCount()) {
            this.getTable().setFirstColumnOnScreen(firstColOnScreen);
        }
    }

    protected void freezeRepaints() {
        super.freezeRepaints();
        if (this.getTable() != null) {
            this.getTable().freezeSpreadTableRepaints();
        }
    }

    protected void unfreezeRepaints() {
        super.unfreezeRepaints();
        if (this.getTable() != null) {
            this.getTable().unfreezeSpreadTableRepaints();
        }
    }

    public String getVersion() {
        return "3.2.0.21";
    }

    private void $init$() {
        this.tableModel = null;
        this.tableController = null;
        this.table = null;
        this.canResizeHeights = true;
        this.canResizeWidths = true;
        this.m_bAutoFitting = false;
        this.m_iFirstPrintedRow = -1;
        this.m_dataGroupsortSupported = false;
        this.m_dataNameSupported = false;
        this.m_bLayerMetadataCanPivotSupported = false;
        this.m_colHeaderVisible = TableDefaultValues.isColumnHeaderVisible();
        this.m_rowHeaderVisible = TableDefaultValues.isRowHeaderVisible();
        this.localStrings = null;
    }

    final class 1
    extends JScrollPane {
        public JScrollBar createHorizontalScrollBar() {
            JScrollBar scrollBar = super.createHorizontalScrollBar();
            scrollBar.setModel(new ScrollBarModel(true));
            return scrollBar;
        }

        public JScrollBar createVerticalScrollBar() {
            JScrollBar scrollBar = super.createVerticalScrollBar();
            scrollBar.setModel(new ScrollBarModel(false));
            return scrollBar;
        }

        public 1(Component component, int n, int n2) {
            super(component, n, n2);
        }

        class ScrollBarModel
        extends DefaultBoundedRangeModel {
            private boolean m_bHoriz;

            ScrollBarModel(boolean bHoriz) {
                super(0, 10, 0, 100);
                this.$init$();
                this.m_bHoriz = bHoriz;
            }

            protected void fireStateChanged() {
                if (Table.this != null) {
                    Table.this.setDuringScroll(true);
                }
                super.fireStateChanged();
                if (Table.this != null) {
                    Table.this.setDuringScroll(false);
                    if (this.m_bHoriz) {
                        Table.this.getTableColumnHeader().repaint();
                    } else {
                        Table.this.getTableRowHeader().repaint();
                    }
                }
            }

            private void $init$() {
                this.m_bHoriz = true;
            }
        }
    }
}

