/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.table.Table;
import oracle.dss.table.TableDatabody;

public class TableAppearanceMgr
extends GridViewAppearanceMgr {
    protected Table table;
    protected TableDatabody tableDatabody;
    protected ViewStyle incrementalFetchRowStyle;

    public TableAppearanceMgr(Table t, TableDatabody tdb) {
        super(t, tdb);
        this.$init$();
        this.table = t;
        this.tableDatabody = tdb;
    }

    public Appearance getCellPaintingAppearance(int column, int row) {
        int _col = this.gridView.getGridViewModel().getDataFromTableCol(column);
        int _row = this.gridView.getGridViewModel().getDataFromTableRow(row);
        ViewStyle style = null;
        if (this.table.getTable() != null && this.table.isIncrementalFetchEnabled() && this.table.getTable().isIncrementalFetchRowVisible() && _row >= this.table.getTableModel().getTableDataSource().getRowCount() - 1) {
            Font font;
            if (this.incrementalFetchRowStyle == null) {
                this.incrementalFetchRowStyle = this.createIncrementalFetchStyle();
            }
            style = this.incrementalFetchRowStyle;
            if (this.tableDatabody.getViewStyle().getFont() != null && (font = this.tableDatabody.getViewStyle().getFont()) != null) {
                if (!font.isItalic()) {
                    font = new Font(font.getName(), 2, font.getSize());
                }
                style.setFont(font);
                style.setSelectFont(font);
            }
        }
        if (style != null) {
            ViewStyle newStyle = style;
            style.setView(this.gridView);
            if (this.gridView.getZoomFactor() != 100) {
                newStyle = style.scaleStyle(style.getFont());
                newStyle.setView(this.gridView);
            }
            return newStyle;
        }
        return super.getCellPaintingAppearance(column, row);
    }

    private ViewStyle createIncrementalFetchStyle() {
        Appearance tempApp;
        Font font = this.tableDatabody.getViewStyle().getFont();
        if (font == null && (font = (tempApp = (Appearance)UIManager.get("Grid.DefaultAppearance")).getFont()) == null) {
            font = this.table.getFontList().getFont("Serif", 2, 12);
        }
        if (!font.isItalic()) {
            font = this.table.getFontList().getFont(font.getName(), 2, font.getSize());
        }
        ViewStyle tempStyle = new ViewStyle(Color.white, Color.black, font, 2, 0, false, false, false, false, Color.white, 0, 7, 7, 7, 7, Color.white, Color.black);
        tempStyle.setEditBackground(Color.white);
        tempStyle.setEditBackground(Color.black);
        tempStyle.setView(this.table);
        tempStyle.setSelectFont(tempStyle.getFont());
        return tempStyle;
    }

    private void $init$() {
        this.table = null;
        this.tableDatabody = null;
        this.incrementalFetchRowStyle = null;
    }
}

