/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.io.Serializable;
import java.util.Hashtable;
import oracle.bali.ewt.grid.bigCell.BigCellTwoDModel;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.gridView.GridViewData;
import oracle.dss.table.Table;
import oracle.dss.table.TableModel;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.WaitData;

public class TableData
extends BigCellTwoDModel
implements GridViewData,
Serializable {
    protected DataAccess dataAccess;
    private TableModel tableModel;
    protected transient Hashtable valueCache;
    protected transient Hashtable m_annotationsCache;
    protected transient DataComponentInfo info;
    protected Table table;
    private static final String m_method_setdata = "setData(int columnIndex, int rowIndex, Object data)";
    private static final String m_method_getdata = "getData(int columnIndex, int rowIndex)";
    private static final String m_method_getrawdata = "getRawData(int columnIndex, int rowIndex)";
    private static final String m_method_getAnnotation = "getAnnotation(int column, int row)";

    public TableData(TableModel tm, Table t) throws EdgeOutOfRangeException {
        super(tm.getTableFromDataColumnCount(tm.getDataAccess().getEdgeExtent(0)), tm.getTableFromDataRowCount(tm.getDataAccess().getEdgeExtent(1)));
        this.$init$();
        this.valueCache = new Hashtable();
        this.m_annotationsCache = new Hashtable();
        this.table = t;
        this.tableModel = tm;
        this.dataAccess = this.tableModel.getDataAccess();
    }

    public int getColumnCount() {
        try {
            int n = this.tableModel.getTableFromDataColumnCount(this.dataAccess.getEdgeExtent(0));
            return n;
        }
        catch (EdgeOutOfRangeException e) {
            int n = 0;
            return n;
        }
    }

    public int getRowCount() {
        try {
            int rowCount = this.tableModel.getTableFromDataRowCount(this.dataAccess.getEdgeExtent(1));
            if (this.table != null && this.table.getTable() != null && this.table.isIncrementalFetchEnabled() && this.table.getTable().isIncrementalFetchRowVisible()) {
                ++rowCount;
            }
            int n = rowCount;
            return n;
        }
        catch (EdgeOutOfRangeException e) {
            int n = 0;
            return n;
        }
    }

    public Object getData(int columnIndex, int rowIndex) {
        if (columnIndex < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getdata);
            return null;
        }
        if (rowIndex < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getdata);
            return null;
        }
        try {
            Object object;
            int col = this.tableModel.getDataFromTableCol(columnIndex);
            int row = this.tableModel.getDataFromTableRow(rowIndex);
            this.info.setRowCol(row, col);
            if (this.table.isIncrementalFetchEnabled() && (this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getRowCount() - 1 || !this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getRowCount())) {
                Object object2 = super.getData(columnIndex, rowIndex);
                return object2;
            }
            int groupSortData = this.getGroupSortData(col, row);
            Object dataValue = null;
            if (this.table.isPrintOrPreviewMode() && this.table.getFirstPrintedRow() == rowIndex && (groupSortData == 2 || groupSortData == 3)) {
                this.table.getTable().m_calculatedRowHeights[rowIndex] = -1;
                if (this.table.isDataFormattedSupported() && (dataValue = this.table.getValueFromDataAccess(col, row, "dataFormattedValue", this.dataAccess)) != null) {
                    String string = dataValue.toString();
                    return string;
                }
                if (this.table.isDataUnformattedSupported()) {
                    dataValue = this.table.getValueFromDataAccess(col, row, "dataValue", this.dataAccess);
                }
                if (dataValue == null) {
                    dataValue = new String("");
                }
                Object object3 = this.tableModel.getGridViewFormatManager().formatDataValue(this.table, dataValue, col, row, this.dataAccess.getEdgeCurrentHPos(2), this.tableModel.getViewFormat());
                String prevVal = null;
                prevVal = object3 != null ? object3.toString() : "";
                String string = prevVal;
                return string;
            }
            String prevVal = null;
            prevVal = (String)this.valueCache.get(this.info);
            if (prevVal != null) {
                String string = prevVal;
                return string;
            }
            WaitData waitData = null;
            if (this.table.getWaitDataForRow(row) != null) {
                waitData = this.table.getWaitDataForRow(row);
                String string = waitData.getCellMessage();
                return string;
            }
            boolean bFormatted = false;
            if (this.table.isDataFormattedSupported() && (dataValue = this.dataAccess.getValue(row, col, "dataFormattedValue")) != null) {
                bFormatted = true;
            }
            if (!bFormatted && this.table.isDataUnformattedSupported()) {
                dataValue = this.dataAccess.getValue(row, col, "dataValue");
            }
            if (dataValue instanceof WaitData) {
                waitData = (WaitData)dataValue;
                this.table.setWaitDataForRow(row, waitData);
                String string = waitData.getCellMessage();
                return string;
            }
            if (groupSortData == 2 || groupSortData == 3) {
                dataValue = null;
            }
            if (dataValue == null) {
                dataValue = new String("");
            }
            prevVal = bFormatted ? dataValue.toString() : ((object = this.tableModel.getGridViewFormatManager().formatDataValue(this.table, dataValue, col, row, this.dataAccess.getEdgeCurrentHPos(2), this.tableModel.getViewFormat())) != null ? object.toString() : "");
            this.valueCache.put(this.info.clone(), prevVal);
            String string = prevVal;
            return string;
        }
        catch (DataException e) {
            this.tableModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getData");
            Object var21_21 = null;
            return var21_21;
        }
    }

    public Object getRawData(int columnIndex, int rowIndex) {
        if (columnIndex < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getrawdata);
            return null;
        }
        if (rowIndex < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getrawdata);
            return null;
        }
        try {
            int col = this.tableModel.getDataFromTableCol(columnIndex);
            int row = this.tableModel.getDataFromTableRow(rowIndex);
            if (this.table.isIncrementalFetchEnabled() && this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getRowCount() - 1) {
                Object object = super.getRealData(columnIndex, rowIndex);
                return object;
            }
            Object dataValue = null;
            WaitData waitData = null;
            if (this.table.getWaitDataForRow(rowIndex) != null) {
                WaitData waitData2 = waitData = this.table.getWaitDataForRow(rowIndex);
                return waitData2;
            }
            if (this.table.isDataUnformattedSupported() && (dataValue = this.table.getValueFromDataAccess(col, row, "dataValue", this.dataAccess)) instanceof WaitData) {
                waitData = (WaitData)dataValue;
                this.table.setWaitDataForRow(rowIndex, waitData);
                WaitData waitData3 = waitData;
                return waitData3;
            }
            if (dataValue == null) {
                dataValue = "";
            }
            String string = dataValue;
            return string;
        }
        catch (DataException e) {
            this.tableModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getRawData");
            Object var12_12 = null;
            return var12_12;
        }
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        if (columnIndex < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setdata);
            return;
        }
        if (rowIndex < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setdata);
            return;
        }
        try {
            this.clearCache();
            this.tableModel.getGridViewFormatManager().valueFormatChanged();
            this.tableModel.getGridViewDatabodyStyleManager().dataStyleChanged();
            this.dataAccess.setValue(data, this.tableModel.getDataFromTableRow(rowIndex), this.tableModel.getDataFromTableCol(columnIndex), "dataValue");
        }
        catch (DataException e) {
            this.tableModel.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setData");
        }
    }

    public void clearCache() {
        if (this.valueCache != null) {
            this.valueCache.clear();
        }
        if (this.m_annotationsCache != null) {
            this.m_annotationsCache.clear();
        }
    }

    public Object getAnnotation(int column, int row) {
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getAnnotation);
            return null;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getAnnotation);
            return null;
        }
        try {
            int iCol = this.tableModel.getDataFromTableCol(column);
            int iRow = this.tableModel.getDataFromTableRow(row);
            this.info.setRowCol(iRow, iCol);
            if (this.table.isIncrementalFetchEnabled() && (this.table.getTable().isIncrementalFetchRowVisible() && iRow >= this.getRowCount() - 1 || !this.table.getTable().isIncrementalFetchRowVisible() && iRow >= this.getRowCount())) {
                Object var13_5 = null;
                return var13_5;
            }
            int groupSortData = this.getGroupSortData(iCol, iRow);
            Object dataValue = null;
            if (this.table.isPrintOrPreviewMode()) {
                Object var14_8 = null;
                return var14_8;
            }
            String[] prevVal = null;
            prevVal = (String[])this.m_annotationsCache.get(this.info);
            if (prevVal != null) {
                String[] stringArray = prevVal;
                return stringArray;
            }
            WaitData waitData = null;
            if (this.table.getWaitDataForRow(iRow) != null) {
                Object var16_12 = null;
                return var16_12;
            }
            if (this.table.isDataAnnotationSupported()) {
                dataValue = this.dataAccess.getValue(iRow, iCol, "dataAnnotation");
            }
            if (dataValue instanceof WaitData) {
                waitData = (WaitData)dataValue;
                this.table.setWaitDataForRow(iRow, waitData);
                Object var17_13 = null;
                return var17_13;
            }
            if (groupSortData == 2 || groupSortData == 3) {
                dataValue = null;
            }
            if (dataValue != null && this.table.getCustomAnnotationCallback() != null) {
                DataComponentHandle componentHandle = new DataComponentHandle(12, this.table.getNameFromID(12), (Object)this.table, row, column);
                dataValue = this.table.getCustomAnnotationCallback().getAnnotation(dataValue, componentHandle);
            }
            if (dataValue != null) {
                if (dataValue instanceof String[]) {
                    boolean bNonNull = false;
                    prevVal = (String[])dataValue;
                    int i = 0;
                    while (i < prevVal.length) {
                        if (prevVal[i] != null) {
                            bNonNull = true;
                            break;
                        }
                        ++i;
                    }
                    if (!bNonNull) {
                        prevVal = null;
                        this.tableModel.getErrorHandler().log("all lines in annotation null", this.getClass().getName(), m_method_getAnnotation);
                    }
                } else {
                    if (!(dataValue instanceof String)) {
                        this.tableModel.getErrorHandler().log("annotation not String or String[]", this.getClass().getName(), m_method_getAnnotation);
                    }
                    prevVal = new String[]{dataValue.toString()};
                }
            }
            if (prevVal != null) {
                this.m_annotationsCache.put(this.info.clone(), prevVal);
            }
            String[] stringArray = prevVal;
            return stringArray;
        }
        catch (DataException e) {
            this.tableModel.getErrorHandler().log("could not get annotation from data source", this.getClass().getName(), m_method_getAnnotation);
            Object var19_19 = null;
            return var19_19;
        }
    }

    protected int getGroupSortData(int column, int row) {
        Object groupSort = null;
        if (this.table.getWaitDataForRow(row) != null) {
            return 0;
        }
        if (this.table.isDataGroupsortSupported()) {
            try {
                groupSort = this.table.getValueFromDataAccess(column, row, "dataGroupSort", this.dataAccess);
            }
            catch (DataException e) {
                this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getGroupSortData");
                int n = 0;
                return n;
            }
        } else {
            return 0;
        }
        if (groupSort == null) {
            this.table.getErrorHandler().log("DataMap.DATA_GROUPSORT value null", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        if (groupSort instanceof WaitData) {
            this.table.setWaitDataForRow(row, (WaitData)groupSort);
            return 0;
        }
        if (!(groupSort instanceof Integer)) {
            this.table.getErrorHandler().log("non-Integer DataMap.DATA_GROUPSORT value", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        int groupSortVal = (Integer)groupSort;
        if (groupSortVal < 0 || groupSortVal > 3) {
            this.table.getErrorHandler().log("DataMap.DATA_GROUPSORT value out of range", this.getClass().getName(), "getGroupSortData");
            return 0;
        }
        return groupSortVal;
    }

    protected void clearAnnotationCache() {
        if (this.m_annotationsCache != null) {
            this.m_annotationsCache.clear();
        }
    }

    void invalidateData() {
        this.fireModelEvent(2007, 0, this.getColumnCount(), 0, this.getRowCount());
    }

    void invalidateRows() {
        this.fireModelEvent(2006, 0, this.getRowCount());
    }

    void invalidateColumns() {
        this.fireModelEvent(2003, 0, this.getColumnCount());
    }

    private void $init$() {
        this.dataAccess = null;
        this.valueCache = null;
        this.m_annotationsCache = null;
        this.info = new DataComponentInfo(0, 0);
        this.table = null;
    }
}

