/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.util.ArrayList;
import java.util.List;
import oracle.dss.dataView.DimensionMetadata;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class TableDimensionMetadata
extends DimensionMetadata {
    protected String m_datatype;
    protected static final int STOPLIGHT_ITEMS_EDGE = -1;
    protected static final String MEASURE_ID = "MEASURE";
    protected static final String MEASURE_LABEL = "Item";

    public static List createTableDimensionMemberList(GridViewCommon gridView) {
        ArrayList<TableDimensionMetadata> dimensionList = new ArrayList<TableDimensionMetadata>();
        DataAccess dataAccess = gridView.getModel().getDataAccess();
        try {
            int dimIndex = 0;
            int edge = 0;
            while (edge < dataAccess.getEdgeCount()) {
                if (edge != 1) {
                    String datatype = null;
                    int layerCount = dataAccess.getLayerCount(edge);
                    int layer = 0;
                    while (layer < layerCount) {
                        String dimID = null;
                        Object dimObj = dataAccess.getLayerMetadata(edge, layer, "dimName");
                        if (dimObj != null) {
                            dimID = dimObj.toString();
                        }
                        TableDimensionMetadata dimData = new TableDimensionMetadata(gridView, dimID, dimIndex++, edge, layer);
                        dimObj = dataAccess.getMemberMetadata(edge, layer, 0, "dataType");
                        if (dimObj != null) {
                            dimData.setLayerDatatype(dimObj.toString());
                            datatype = dimData.getLayerDatatype();
                        }
                        if ("Double".equals(datatype)) {
                            dimData.setMeasure(true);
                        }
                        dimensionList.add(dimData);
                        ++layer;
                    }
                }
                ++edge;
            }
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException e) {
        }
        catch (SliceOutOfRangeException e) {
            // empty catch block
        }
        return dimensionList;
    }

    public static TableDimensionMetadata getSpecialDimensionMetadata(GridViewCommon gridView) {
        TableDimensionMetadata stoplightItems = null;
        List dimList = gridView.getFormatModel().getDimensionList();
        if (dimList != null) {
            List itemList = null;
            int i = 0;
            while (i < dimList.size()) {
                TableDimensionMetadata dimData;
                if (dimList.get(i) instanceof TableDimensionMetadata && (dimData = (TableDimensionMetadata)dimList.get(i)).isMeasure()) {
                    if (stoplightItems == null) {
                        stoplightItems = new TableDimensionMetadata(gridView, MEASURE_ID, 0, -1, 0);
                        stoplightItems.setMeasure(true);
                        itemList = stoplightItems.getMemberList();
                    }
                    if (itemList != null) {
                        itemList.add(new Object[]{dimData.getDimID(), dimData.getDimLabel(), dimData.getLayerDatatype()});
                    }
                }
                ++i;
            }
        }
        return stoplightItems;
    }

    public static List getTableDimensionMemberList(GridViewCommon gridView, String dimID, int edge, int layer) {
        if (edge == 1) {
            return null;
        }
        if (edge == 0) {
            return TableDimensionMetadata.getDimensionMemberList(gridView, dimID, edge, layer);
        }
        return DimensionMetadata.getDimensionMemberList(gridView, dimID, edge, layer);
    }

    public TableDimensionMetadata(GridViewCommon gridView, String dimID, int dimIndex, int edge, int layer) {
        super(gridView, dimID, dimIndex, edge, layer);
        if (MEASURE_ID.equals(dimID)) {
            this.m_dimLabel = MEASURE_LABEL;
        } else {
            this.getDimLabel();
        }
    }

    public List getMemberList() {
        if (this.m_memberList == null && this.m_edge != 1) {
            this.m_memberList = new ArrayList();
        }
        return this.m_memberList;
    }

    public String getMemberID(int index) {
        if (this.m_edge == 1) {
            return null;
        }
        return super.getMemberID(index);
    }

    public String getMemberID(String label) {
        if (this.m_edge == 1) {
            return null;
        }
        return super.getMemberID(label);
    }

    public int getMemberCount() {
        if (this.m_edge == 1) {
            return 0;
        }
        return super.getMemberCount();
    }

    public int getMemberIndex(String memberID) {
        if (this.m_edge == 1) {
            return -1;
        }
        return super.getMemberIndex(memberID);
    }

    public String getMemberLabel(int index) {
        if (this.m_edge == 1) {
            return null;
        }
        return super.getMemberLabel(index);
    }

    public String getMemberLabel(String memberID) {
        if (this.m_edge == 1) {
            return null;
        }
        return super.getMemberLabel(memberID);
    }

    public int getMemberLabelIndex(String memberLabel) {
        if (this.m_edge == 1) {
            return -1;
        }
        return super.getMemberLabelIndex(memberLabel);
    }

    public List getMemberLabels() {
        if (this.m_edge == 1) {
            return null;
        }
        return super.getMemberLabels();
    }

    public String getMemberDatatype(int index) {
        if (this.m_datatype != null) {
            return this.toSimpleDatatype(this.m_datatype);
        }
        return super.getMemberDatatype(index);
    }

    protected String getLayerDatatype() {
        return this.m_datatype;
    }

    protected void setLayerDatatype(String datatype) {
        this.m_datatype = this.toSimpleDatatype(datatype);
    }
}

