/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.event.MouseEvent;
import oracle.bali.ewt.grid.Grid;
import oracle.dss.gridView.GridViewEdit;
import oracle.dss.table.Table;

public class TableEdit
extends GridViewEdit {
    protected Table m_table;
    private static final String m_method_mouseclicked = "mouseClicked(MouseEvent mouseEvent, Grid grid, int column, int row)";
    private static final String m_method_mousepressed = "mousePressed(MouseEvent mouseEvent, Grid grid, int column, int row)";

    protected TableEdit(Table t) {
        super(t);
        this.$init$();
        this.m_table = t;
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int column, int row) {
        if (row < 0) {
            this.m_table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_mousepressed);
            return;
        }
        if (column < 0) {
            this.m_table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_mousepressed);
            return;
        }
        boolean bIncrementalFetch = false;
        if (this.m_table.getTable() != null && this.m_table.isIncrementalFetchEnabled() && this.m_table.getTable().isIncrementalFetchRowVisible() && row >= this.m_table.getTableModel().getTableDataSource().getRowCount() - 1) {
            bIncrementalFetch = true;
            mouseEvent.consume();
            this.m_table.getTableModel().getTableControllerActions().incrementalFetchGestureHappened(grid, this.m_table.getTableModel().getTableDataSource().getRowCount() - 1, this.m_table.getFetchIncrement());
        }
        if (!bIncrementalFetch) {
            super.mousePressed(mouseEvent, grid, column, row);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, Grid grid, int column, int row) {
        if (row < 0) {
            this.m_table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_mouseclicked);
            return;
        }
        if (column < 0) {
            this.m_table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_mouseclicked);
            return;
        }
        boolean bIncrementalFetch = false;
        if (this.m_table.getTable() != null && this.m_table.isIncrementalFetchEnabled() && this.m_table.getTable().isIncrementalFetchRowVisible() && row >= this.m_table.getTableModel().getTableDataSource().getRowCount() - 1) {
            bIncrementalFetch = true;
            mouseEvent.consume();
        }
        if (!bIncrementalFetch) {
            super.mouseClicked(mouseEvent, grid, column, row);
        }
    }

    private void $init$() {
        this.m_table = null;
    }
}

