/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.util.Vector;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.PageItemComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class TableFormatUtil {
    private QDRDiscriminator m_qdrDisc;
    private CompositeDiscriminator m_compDisc;
    private GridViewCommon m_table;
    private DataAccess dataAccess;
    private MemberListAccess memberAccess;
    private ComponentHandle componentHandle;
    private QDR m_qdr;
    private static final String dimNameType = "dimName";
    private static final String memberNameType = "value";
    private static final String memberLabelType = "shortName";
    private static final String VALUE = "DefaultTableValue";

    public TableFormatUtil(GridViewCommon gridview, ComponentHandle component) throws DataException {
        this.m_table = gridview;
        this.dataAccess = gridview.getModel().getDataAccess();
        this.componentHandle = component;
        this.initFromSelection();
    }

    public Discriminator getDiscriminator() {
        if (this.m_compDisc != null) {
            return this.m_compDisc;
        }
        return this.m_qdrDisc;
    }

    private boolean initFromSelection() throws EdgeOutOfRangeException, LayerOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException, SliceOutOfRangeException {
        if (this.componentHandle == null) {
            return false;
        }
        if (this.componentHandle.getID() == 13) {
            this.m_qdrDisc = new QDRDiscriminator(new QDR(), 4);
        } else if (this.componentHandle instanceof DataComponentHandle) {
            ComponentInfo ci = this.componentHandle.getComponentInfo();
            int row = ((DataComponentInfo)ci).getRow();
            int col = ((DataComponentInfo)ci).getColumn();
            this.m_qdr = ci.getQDR(this.dataAccess, 0);
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else if (this.componentHandle instanceof DataRangeComponentHandle) {
            DataComponentInfo[] ci = ((DataRangeComponentHandle)this.componentHandle).getLocationList();
            int col = this.dataAccess.getEdgeExtent(0);
            Vector[] cols = new Vector[col];
            Vector<Integer> rows = new Vector<Integer>();
            int column = -1;
            if (ci.length == this.dataAccess.getEdgeExtent(1)) {
                column = ci[0].getColumn();
            }
            boolean[] colSelected = new boolean[col];
            int i = 0;
            while (i < ci.length) {
                int row = ci[i].getRow();
                if (column != -1 && ci[i].getColumn() != column) {
                    column = -1;
                }
                if (i == 0 || row != (Integer)rows.lastElement()) {
                    rows.addElement(new Integer(row));
                }
                colSelected[ci[i].getColumn()] = true;
                ++i;
            }
            int i2 = 0;
            while (i2 < rows.size()) {
                int row = (Integer)rows.elementAt(i2);
                int j = 0;
                while (j < col) {
                    Object val = this.dataAccess.getValue(row, j, "dataValue");
                    if (cols[j] != null) {
                        Object oldval = cols[j].lastElement();
                        if (!val.equals(oldval)) {
                            cols[j].addElement(val);
                        }
                    } else {
                        cols[j] = new Vector();
                        cols[j].addElement(val);
                    }
                    ++j;
                }
                ++i2;
            }
            if (column != -1) {
                this.m_qdr = this.dataAccess.getSliceQDR(0, column, 0);
                this.m_qdr.setTarget(new QDRMember(this.dataAccess.getLayerMetadata(0, column, dimNameType).toString()));
                this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
            } else if (rows.size() > 1) {
                Vector data = new Vector();
                int i3 = 0;
                while (i3 < ci.length) {
                    if (this.m_qdrDisc == null) {
                        this.m_qdrDisc = new QDRDiscriminator(ci[i3].getQDR(this.dataAccess, 0), 4);
                    } else {
                        QDRDiscriminator disc = new QDRDiscriminator(ci[i3].getQDR(this.dataAccess, 0), 4);
                        this.m_compDisc = this.m_compDisc == null ? new CompositeDiscriminator((Discriminator)this.m_qdrDisc, (Discriminator)disc, 1) : new CompositeDiscriminator((Discriminator)this.m_compDisc, (Discriminator)disc, 1);
                    }
                    ++i3;
                }
            } else {
                this.m_qdr = this.dataAccess.getSliceQDR(1, ci[0].getRow(), 0);
                Vector<String> data = new Vector<String>();
                int i4 = 0;
                while (i4 < ci.length) {
                    data.addElement(this.dataAccess.getLayerMetadata(0, ci[i4].getColumn(), dimNameType).toString());
                    ++i4;
                }
                if (data.size() > 1) {
                    this.m_qdr.setTarget(new QDRMember(3, data));
                } else {
                    this.m_qdr.setTarget(new QDRMember(0, data.elementAt(0)));
                }
                this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
            }
        } else if (this.componentHandle instanceof ColumnComponentHandle) {
            ColumnComponentInfo ci = (ColumnComponentInfo)this.componentHandle.getComponentInfo();
            int cols = this.dataAccess.getEdgeExtent(0);
            int col = ci.getColumn();
            this.m_qdr = ci.getQDR(this.dataAccess, 0);
            this.m_qdr.setTarget(new QDRMember(this.dataAccess.getLayerMetadata(0, col, dimNameType).toString()));
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else if (this.componentHandle instanceof ColumnRangeComponentHandle) {
            ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)this.componentHandle).getLocationList();
            int col = this.dataAccess.getEdgeExtent(0);
            boolean[] cols = new boolean[col];
            int i = 0;
            while (i < ci.length) {
                cols[ci[i].getColumn()] = true;
                ++i;
            }
            Vector<String> data = new Vector<String>();
            int i5 = 0;
            while (i5 < col) {
                String dim = this.dataAccess.getLayerMetadata(0, i5, dimNameType).toString();
                if (cols[i5]) {
                    data.addElement(dim);
                }
                ++i5;
            }
            this.m_qdr = new QDR();
            if (data instanceof Vector) {
                this.m_qdr.setTarget(new QDRMember(3, data));
            } else {
                this.m_qdr.setTarget(new QDRMember(0, data));
            }
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else if (this.componentHandle instanceof RowComponentHandle) {
            ComponentInfo ci = this.componentHandle.getComponentInfo();
            int col = this.dataAccess.getEdgeExtent(0);
            int row = ((RowComponentInfo)ci).getRow();
            Vector<String> data = new Vector<String>();
            int i = 0;
            while (i < col) {
                String dimension = this.dataAccess.getLayerMetadata(0, i, dimNameType).toString();
                data.addElement(dimension);
                ++i;
            }
            this.m_qdr = ci.getQDR(this.dataAccess, 0);
            if (data.size() > 1) {
                this.m_qdr.setTarget(new QDRMember(3, data));
            } else {
                this.m_qdr.setTarget(new QDRMember(0, data.elementAt(0)));
            }
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else if (this.componentHandle instanceof RowRangeComponentHandle) {
            RowComponentInfo[] ci = ((RowRangeComponentHandle)this.componentHandle).getLocationList();
            int col = this.dataAccess.getEdgeExtent(0);
            Vector[] cols = new Vector[col];
            Vector<String> data = new Vector<String>();
            int i = 0;
            while (i < ci.length) {
                int row = ci[i].getRow();
                int j = 0;
                while (j < col) {
                    Object val = this.dataAccess.getValue(row, j, "dataValue");
                    if (cols[j] != null) {
                        Object oldval = cols[j].lastElement();
                        if (!val.equals(oldval)) {
                            cols[j].addElement(val);
                        }
                    } else {
                        cols[j] = new Vector();
                        cols[j].addElement(val);
                    }
                    ++j;
                }
                ++i;
            }
            int i6 = 0;
            while (i6 < col) {
                String dimension = this.dataAccess.getLayerMetadata(0, i6, dimNameType).toString();
                data.addElement(dimension);
                ++i6;
            }
            int i7 = 0;
            while (i7 < ci.length) {
                if (this.m_qdrDisc == null) {
                    this.m_qdr = ci[i7].getQDR(this.dataAccess, 0);
                    if (data.size() > 1) {
                        this.m_qdr.setTarget(new QDRMember(3, data));
                    } else {
                        this.m_qdr.setTarget(new QDRMember(0, data.elementAt(0)));
                    }
                    this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                } else {
                    this.m_qdr = ci[i7].getQDR(this.dataAccess, 0);
                    if (data.size() > 1) {
                        this.m_qdr.setTarget(new QDRMember(3, data));
                    } else {
                        this.m_qdr.setTarget(new QDRMember(0, data.elementAt(0)));
                    }
                    QDRDiscriminator disc = new QDRDiscriminator(this.m_qdr, 4);
                    this.m_compDisc = this.m_compDisc == null ? new CompositeDiscriminator((Discriminator)this.m_qdrDisc, (Discriminator)disc, 1) : new CompositeDiscriminator((Discriminator)this.m_compDisc, (Discriminator)disc, 1);
                }
                ++i7;
            }
        } else if (this.componentHandle instanceof PageItemComponentHandle) {
            PageItemComponentInfo ci = (PageItemComponentInfo)this.componentHandle.getComponentInfo();
            String dimension = this.dataAccess.getLayerMetadata(2, ci.getPageItem(), dimNameType).toString();
            this.m_qdr = ci.getQDR(this.dataAccess, 0);
            this.m_qdr.setTarget(new QDRMember(dimension));
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else {
            return false;
        }
        return true;
    }

    private Vector getDimValues(int col) {
        try {
            Vector<Object> members = new Vector<Object>();
            Object[] values = null;
            if (this.memberAccess != null) {
                values = this.memberAccess.getAllMembers(0, col, "dataValue");
            }
            int i = 0;
            while (i < this.dataAccess.getEdgeExtent(1)) {
                Object member = values == null || values.length < i ? this.dataAccess.getValue(i, col, "dataValue") : values[i];
                if (members.indexOf(member) == -1) {
                    members.addElement(member);
                }
                ++i;
            }
            Vector<Object> vector = members;
            return vector;
        }
        catch (RowOutOfRangeException e) {
            Vector vector = null;
            return vector;
        }
        catch (ColumnOutOfRangeException e) {
            Vector vector = null;
            return vector;
        }
        catch (EdgeOutOfRangeException e) {
            Vector vector = null;
            return vector;
        }
        catch (LayerOutOfRangeException e) {
            Vector vector = null;
            return vector;
        }
    }

    private Vector getDimValues(String dimension, String type) {
        if (dimension == null) {
            return null;
        }
        try {
            Vector<Object> members = new Vector<Object>();
            int m_dimEdge = -1;
            int m_dimDepth = -1;
            int i = 0;
            while (i < this.dataAccess.getEdgeCount()) {
                int layerCount = this.dataAccess.getLayerCount(i);
                int j = 0;
                while (j < layerCount) {
                    String dim = this.dataAccess.getLayerMetadata(i, j, dimNameType).toString();
                    if (dim != null && dimension.equals(dim)) {
                        if (i == 2) {
                            int memberCount = this.dataAccess.getMemberExtent(i, j, 0);
                            int k = 0;
                            while (k < memberCount) {
                                members.addElement(this.dataAccess.getMemberMetadata(i, j, k, memberNameType));
                                ++k;
                            }
                            Vector<Object> vector = members;
                            return vector;
                        }
                        if (i == 0) {
                            Vector vector = this.getDimValues(j);
                            return vector;
                        }
                        members.addElement(this.dataAccess.getMemberMetadata(i, j, 0, memberNameType));
                        Vector<Object> vector = members;
                        return vector;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException e) {
        }
        catch (SliceOutOfRangeException e) {
            // empty catch block
        }
        return null;
    }
}

