/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.gridView.GridViewTips;
import oracle.dss.table.Table;
import oracle.dss.table.TableControllerAdapter;
import oracle.dss.table.TableEdgeComponentHandle;

class TableTips
extends GridViewTips {
    protected Table table;
    protected TableControllerAdapter controller;

    public TableTips(Table t, TableControllerAdapter tca, int id) {
        super(t, tca, id);
        this.table = t;
        this.controller = tca;
    }

    public String getCellToolTipValue(Grid grid, int column, int row) {
        DataComponentHandle loc;
        switch (this.compId) {
            case 12: {
                loc = new DataComponentHandle(this.compId, this.table.getNameFromID(12), (Object)grid, row, column);
                break;
            }
            default: {
                return null;
            }
        }
        if (this.compId == 12) {
            GridViewAppearanceMgr appMgr;
            ViewStyle vs;
            if (this.table.getTableDatabody().isAnnotation(column, row, this.controller.getMouseEvent().getX() - this.table.getTableDatabody().getColumnPosition(column), this.controller.getMouseEvent().getY() - this.table.getTableDatabody().getRowPosition(row))) {
                Object annotation = this.table.getGridViewModel().getGridViewDataSource().getAnnotation(column, row);
                if (annotation != null && annotation instanceof String[]) {
                    String[] strings = (String[])annotation;
                    StringBuffer result = new StringBuffer("");
                    if (strings.length > 0) {
                        result.append(strings[0]);
                    }
                    int i = 1;
                    while (i < strings.length) {
                        result.append("\n");
                        if (strings[i] == null) {
                            result.append("");
                        } else {
                            result.append(strings[i]);
                        }
                        ++i;
                    }
                    return result.toString();
                }
                return null;
            }
            if (this.table.getTableDatabody().isDrillOut(column, row, this.controller.getMouseEvent().getX() - this.table.getTableDatabody().getColumnPosition(column), this.controller.getMouseEvent().getY() - this.table.getTableDatabody().getRowPosition(row)) && (vs = (appMgr = (GridViewAppearanceMgr)this.table.getTableDatabody().getAppearanceManager()).getCellAppearance(column, row)) != null) {
                return vs.getGraphicImageTooltip();
            }
        }
        String displayText = this.table.getRolloverTextManager().getRolloverText(this.table, loc, this.controller.getMouseEvent().getX(), this.controller.getMouseEvent().getY(), this.controller.getMouseEvent().getModifiers());
        return displayText;
    }

    public String getItemToolTipValue(Header header, int depth) {
        ViewStyle vs;
        TableEdgeComponentHandle loc;
        switch (this.compId) {
            case 11: {
                loc = new TableEdgeComponentHandle(this.compId, this.table.getNameFromID(11), header, 1, depth);
                break;
            }
            case 10: {
                loc = new TableEdgeComponentHandle(this.compId, this.table.getNameFromID(10), header, 0, depth);
                break;
            }
            default: {
                return null;
            }
        }
        if (this.compId == 10) {
            ViewStyle vs2;
            if (this.table.getTableColumnHeader().isDrillOut(depth, this.controller.getMouseEvent().getX() - this.table.getTableColumnHeader().getItemPosition(depth), this.controller.getMouseEvent().getY()) && (vs2 = this.table.getTableColumnHeader().getStyle(depth)) != null) {
                return vs2.getGraphicImageTooltip();
            }
        } else if (this.compId == 11 && this.table.getTableRowHeader().isDrillOut(depth, this.controller.getMouseEvent().getX(), this.controller.getMouseEvent().getY() - this.table.getTableRowHeader().getItemPosition(depth)) && (vs = this.table.getTableRowHeader().getStyle(depth)) != null) {
            return vs.getGraphicImageTooltip();
        }
        String displayText = this.table.getRolloverTextManager().getRolloverText(this.table, loc, this.controller.getMouseEvent().getX(), this.controller.getMouseEvent().getY(), this.controller.getMouseEvent().getModifiers());
        return displayText;
    }
}

