/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.beans.PropertyVetoException;
import java.util.Vector;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.collection.Range;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.gridView.GridViewUtils;
import oracle.dss.table.Table;
import oracle.dss.table.TableEdgeComponentHandle;
import oracle.dss.table.TableEdgeComponentInfo;
import oracle.dss.table.TableEdgeRangeComponentHandle;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.RowComponentInfo;

class TableUtils
extends GridViewUtils {
    static ComponentHandle createDataComponent(Table t, int type, String name, Object source, int row, int column, CellRange[] cellList, boolean useSel) {
        return GridViewUtils.createDataComponent(t, type, name, source, row, column, cellList, useSel);
    }

    static void selectAllCells(boolean select, Grid grid, Table table) {
        table.getTableController().setSelectingCells(true);
        try {
            if (select) {
                table.getTable().selectAll();
            } else {
                table.getTable().deselectAll();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        table.getTableController().setSelectingCells(false);
    }

    static void selectRow(RowComponentInfo row, Grid grid, Table table) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        table.getTableController().setSelectingCells(true);
        try {
            table.getTable().deselectAll();
            gs.addSelection(new TwoDSelection(row.getRow(), true));
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        table.getTableController().setSelectingCells(false);
    }

    static void selectRows(RowComponentInfo[] row, Grid grid, Table table) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        table.getTableController().setSelectingCells(true);
        try {
            OneDSelection ods = new OneDSelection();
            int i = 0;
            while (i < row.length) {
                ods = ods.add(row[i].getRow());
                ++i;
            }
            table.getTable().deselectAll();
            grid.setSelection(new TwoDSelection(null, ods));
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        table.getTableController().setSelectingCells(false);
    }

    static void selectColumn(ColumnComponentInfo col, Grid grid, Table table) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        table.getTableController().setSelectingCells(true);
        try {
            table.getTable().deselectAll();
            gs.addSelection(new TwoDSelection(col.getColumn(), false));
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        table.getTableController().setSelectingCells(false);
    }

    static void selectColumns(ColumnComponentInfo[] col, Grid grid, Table table) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        table.getTableController().setSelectingCells(true);
        try {
            OneDSelection ods = new OneDSelection();
            int i = 0;
            while (i < col.length) {
                ods = ods.add(col[i].getColumn());
                ++i;
            }
            table.getTable().deselectAll();
            grid.setSelection(new TwoDSelection(ods, null));
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        table.getTableController().setSelectingCells(false);
    }

    static void selectCells(DataComponentInfo[] cells, Grid grid, Table table) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        table.getTableController().setSelectingCells(true);
        try {
            CellRange[] ranges = TableUtils.convertCellsToRanges(cells);
            TwoDSelection tds = new TwoDSelection(null, null, ranges);
            table.getTable().deselectAll();
            grid.setSelection(tds);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        table.getTableController().setSelectingCells(false);
    }

    static void selectCell(EdgeComponentInfo info, int headerEdge, Header header, Table table) {
        HeaderSelectionManager hs = header.getHeaderSelectionManager();
        if (hs == null) {
            return;
        }
        table.getTableController().setSelectingCells(true);
        try {
            table.getTable().deselectAll();
            int edge = info.getEdge();
            if (headerEdge == edge) {
                hs.addSelection(new OneDSelection(info.getDepth()));
            }
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        table.getTableController().setSelectingCells(false);
    }

    static void selectCells(EdgeComponentInfo[] info, int headerEdge, Header header, Table table) {
        HeaderSelectionManager hs = header.getHeaderSelectionManager();
        if (hs == null) {
            return;
        }
        table.getTableController().setSelectingCells(true);
        try {
            OneDSelection ods = new OneDSelection();
            int i = 0;
            while (i < info.length) {
                int edge = info[i].getEdge();
                if (headerEdge == edge) {
                    ods = ods.add(info[i].getDepth());
                }
                ++i;
            }
            table.getTable().deselectAll();
            header.setSelection(ods);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        table.getTableController().setSelectingCells(false);
    }

    protected static ComponentHandle createRangeComponent(Table gv, int type, String name, Object source, int index, Range[] cellList, boolean useSel) {
        if (type == 10) {
            if (!TableUtils.oneCellOnly(cellList) && useSel) {
                return new TableEdgeRangeComponentHandle(17, gv.getNameFromID(17), source, TableUtils.convertColEdgeRangesToCells(cellList));
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new TableEdgeComponentHandle(type, name, source, 0, gv.getGridViewModel().getDataFromTableCol(cellList[0].getLowerLimit()));
            }
            return new TableEdgeComponentHandle(type, name, source, 0, gv.getGridViewModel().getDataFromTableCol(index));
        }
        if (type == 11) {
            if (!TableUtils.oneCellOnly(cellList) && useSel) {
                return new TableEdgeRangeComponentHandle(18, gv.getNameFromID(18), source, TableUtils.convertRowEdgeRangesToCells(cellList));
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new TableEdgeComponentHandle(type, name, source, 1, gv.getGridViewModel().getDataFromTableRow(cellList[0].getLowerLimit()));
            }
            return new TableEdgeComponentHandle(type, name, source, 1, gv.getGridViewModel().getDataFromTableRow(index));
        }
        if (type == 14) {
            if (!TableUtils.oneCellOnly(cellList) && useSel) {
                return new ColumnRangeComponentHandle(19, gv.getNameFromID(19), source, TableUtils.convertDataColRangesToCells(cellList));
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new ColumnComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableCol(cellList[0].getLowerLimit()));
            }
            return new ColumnComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableCol(index));
        }
        if (type == 15) {
            if (!TableUtils.oneCellOnly(cellList) && useSel) {
                return new RowRangeComponentHandle(20, gv.getNameFromID(20), source, TableUtils.convertDataRowRangesToCells(cellList));
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new RowComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableRow(cellList[0].getLowerLimit()));
            }
            return new RowComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableRow(index));
        }
        return null;
    }

    protected static TableEdgeComponentInfo[] convertRowEdgeRangesToCells(Range[] range) {
        Vector<TableEdgeComponentInfo> tempteci = new Vector<TableEdgeComponentInfo>();
        int r = 0;
        while (r < range.length) {
            int ll = range[r].getLowerLimit();
            int ul = range[r].getUpperLimit();
            int row = ll;
            while (row <= ul) {
                tempteci.addElement(new TableEdgeComponentInfo(1, row));
                ++row;
            }
            ++r;
        }
        TableEdgeComponentInfo[] teci = new TableEdgeComponentInfo[tempteci.size()];
        r = 0;
        while (r < teci.length) {
            teci[r] = (TableEdgeComponentInfo)((Object)tempteci.elementAt(r));
            ++r;
        }
        return teci;
    }

    protected static TableEdgeComponentInfo[] convertColEdgeRangesToCells(Range[] range) {
        Vector<TableEdgeComponentInfo> tempteci = new Vector<TableEdgeComponentInfo>();
        int r = 0;
        while (r < range.length) {
            int ll = range[r].getLowerLimit();
            int ul = range[r].getUpperLimit();
            int col = ll;
            while (col <= ul) {
                tempteci.addElement(new TableEdgeComponentInfo(0, col));
                ++col;
            }
            ++r;
        }
        TableEdgeComponentInfo[] teci = new TableEdgeComponentInfo[tempteci.size()];
        r = 0;
        while (r < teci.length) {
            teci[r] = (TableEdgeComponentInfo)((Object)tempteci.elementAt(r));
            ++r;
        }
        return teci;
    }

    TableUtils() {
    }
}

