/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table.gui;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.RulesPanel;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccess2;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.help.HelpContext;

public class TableRulesPanel
extends RulesPanel
implements HelpContext {
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;

    public TableRulesPanel() {
    }

    public TableRulesPanel(UIGridView gridView, String header, boolean isDefault) {
        this(gridView, header);
    }

    public TableRulesPanel(UIGridView gridView, String header) {
        this(gridView, header != null);
    }

    public TableRulesPanel(UIGridView gridView, boolean header) {
        super(gridView, header);
        this.m_isTable = true;
        this._init();
    }

    public TableRulesPanel(UIGridView gridView, Discriminator disc, Vector data, boolean[] selected, String header, boolean isDefault) {
        this(gridView, disc, header);
    }

    public TableRulesPanel(UIGridView gridView, Discriminator disc, String header) {
        this(gridView, disc, header != null);
    }

    public TableRulesPanel(UIGridView gridView, Discriminator disc, boolean header) {
        super(gridView, disc, null, header);
        this.m_isTable = true;
        this._init();
    }

    public void setDataAccess(DataAccess access) {
        super.setDataAccess(access);
        this.m_conditions = null;
        this.setDefaultConditions();
        if (this.conditionList != null) {
            this.conditionList.setListData(this.m_conditions);
            this.conditionList.setSelectedIndex(0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_editButton) {
            int idx = this.conditionList.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            String dimension = this.conditionList.getDimension(idx);
            Object memberData = this.conditionList.getMemberData(idx);
            Vector members = new Vector();
            if (memberData == null) {
                members = null;
            } else if (memberData instanceof Vector) {
                members = (Vector)memberData;
            } else {
                members.addElement(memberData);
            }
            if (dimension != null) {
                RulesPanel.DimensionDialog dialog = this.createDimensionDialog(this.rBundle.getString("Select Members"), dimension, members, idx, true, true);
                dialog.show();
            }
        }
    }

    public Discriminator getDiscriminator() {
        Vector target = new Vector();
        Vector pairs = new Vector();
        if (this.m_qdrDisc == null) {
            this.m_qdrDisc = new QDRDiscriminator();
        }
        if (this.m_isHeaderFormat) {
            this.m_qdrDisc = this.m_memberPanel.getDiscriminator();
            return this.m_qdrDisc;
        }
        int i = 0;
        while (i < this.conditionList.getListSize()) {
            String dimension = this.conditionList.getDimension(i);
            QDRMember member = this.m_qdrDisc.getQDR().getDimMember(dimension);
            if (this.conditionList.isChanged(i)) {
                Object data = this.conditionList.getMemberData(i);
                if (data != null) {
                    member = data instanceof Vector ? new QDRMember(3, data) : new QDRMember(0, data);
                    this.m_qdrDisc.getQDR().addDimMemberPair(dimension, member);
                } else {
                    this.m_qdrDisc.getQDR().removeDimMemberPair(dimension);
                }
            }
            ++i;
        }
        if (this.m_entireRowButton.isSelected()) {
            this.m_qdrDisc.getQDR().setTarget(null);
        } else {
            Object[] selectedItems = this.m_selectedCellsList.getSelectedValues();
            try {
                int i2 = 0;
                while (i2 < this.dataAccess.getEdgeCount()) {
                    int layerCount = this.dataAccess.getLayerCount(i2);
                    int j = 0;
                    while (j < layerCount) {
                        Object dimObj = this.dataAccess.getLayerMetadata(i2, j, this.dimLabelType);
                        int k = 0;
                        while (k < selectedItems.length) {
                            if (dimObj.equals(selectedItems[k])) {
                                selectedItems[k] = this.dataAccess.getLayerMetadata(i2, j, "dimName");
                                break;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            catch (EdgeOutOfRangeException e) {
            }
            catch (LayerOutOfRangeException e) {
                // empty catch block
            }
            if (selectedItems.length > 0) {
                if (selectedItems.length == 1) {
                    this.m_qdrDisc.getQDR().setTarget(new QDRMember(selectedItems[0].toString()));
                } else {
                    Vector<Object> data = new Vector<Object>();
                    int i3 = 0;
                    while (i3 < selectedItems.length) {
                        data.addElement(selectedItems[i3]);
                        ++i3;
                    }
                    this.m_qdrDisc.getQDR().setTarget(new QDRMember(3, data));
                }
            } else {
                this.m_qdrDisc.getQDR().setTarget(null);
            }
        }
        return this.m_qdrDisc;
    }

    public String getHelpContextID() {
        if (this.m_isHeaderFormat) {
            return this.getClass().getName() + "_" + "Header";
        }
        return this.getClass().getName() + "_" + "Databody";
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    protected boolean initHeader() {
        this.m_conditions = new Vector();
        int[] edges = new int[]{0, 2};
        Object m_qdr = null;
        try {
            int i = 0;
            while (i < edges.length) {
                int layerCount = this.dataAccess.getLayerCount(edges[i]);
                int j = 0;
                while (j < layerCount) {
                    String dimension = this.dataAccess.getLayerMetadata(edges[i], j, "dimName").toString();
                    String member = this.dataAccess.getMemberMetadata(edges[i], j, 0, this.memberLabelType).toString();
                    this.m_conditions.addElement(new ConditionElement(dimension, member));
                    ++j;
                }
                ++i;
            }
        }
        catch (DataException e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected void setDefaultConditions() {
        this.m_conditions = new Vector();
        int[] edges = new int[]{0, 2};
        try {
            int i = 0;
            while (i < edges.length) {
                int layerCount = this.dataAccess.getLayerCount(edges[i]);
                int j = 0;
                while (j < layerCount) {
                    String dimension = this.dataAccess.getLayerMetadata(edges[i], j, "dimName").toString();
                    this.m_conditions.addElement(new ConditionElement(dimension, (String)null));
                    ++j;
                }
                ++i;
            }
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException e) {
            // empty catch block
        }
        QDR m_qdr = new QDR();
        this.m_qdrDisc = new QDRDiscriminator(m_qdr, 4);
    }

    protected void initFromDisc(Discriminator disc, ConditionElement valueCondition) {
        this.m_qdrDisc = (QDRDiscriminator)disc;
        this.m_conditions = new Vector();
        int[] edges = new int[]{0, 2};
        QDR m_qdr = this.m_qdrDisc.getQDR();
        try {
            int i = 0;
            while (i < edges.length) {
                int layerCount = this.dataAccess.getLayerCount(edges[i]);
                int j = 0;
                while (j < layerCount) {
                    QDRMember member;
                    Object dimObj = this.dataAccess.getLayerMetadata(edges[i], j, "dimName");
                    String dimension = null;
                    if (dimObj != null) {
                        dimension = dimObj.toString();
                    }
                    if ((member = m_qdr.getDimMember(dimension)) == null) {
                        this.m_conditions.addElement(new ConditionElement(dimension, (Object)null));
                    } else {
                        this.m_conditions.addElement(new ConditionElement(dimension, member.getData()));
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected String printCondition(ConditionElement element) {
        String condition = null;
        String dimension = element.getDimension();
        if (element.getType() == 0) {
            condition = element.getData() == null ? this.getLayerLabel(dimension) + ": " + this.rBundle.getString("Any") : this.getLayerLabel(dimension) + ": " + this.getMemberLabel(dimension, element.getData().toString());
        } else if (element.getType() == 1) {
            condition = this.getLayerLabel(dimension) + ": ";
            Vector data = (Vector)element.getData();
            if (data != null) {
                int i = 0;
                while (i < data.size()) {
                    if (i != 0) {
                        condition = condition + ", ";
                    }
                    condition = condition + this.getMemberLabel(dimension, data.elementAt(i).toString());
                    ++i;
                }
            }
        }
        return condition;
    }

    protected String getMemberLabel(String dimension, String member) {
        if (dimension == null || member == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < this.dataAccess.getEdgeCount()) {
                if (i != 1) {
                    int layerCount = this.dataAccess.getLayerCount(i);
                    int endslice = this.dataAccess.getEdgeExtent(i);
                    int j = 0;
                    while (j < layerCount) {
                        Object dimObj = this.dataAccess.getLayerMetadata(i, j, "dimName");
                        String dim = null;
                        if (dimObj != null) {
                            dim = dimObj.toString();
                        }
                        if (dimension.equals(dim)) {
                            if (i == 2) {
                                if (this.dataAccess instanceof DataAccess2) {
                                    List list = ((DataAccess2)this.dataAccess).getCorrespondingMemberMetadata(i, j, new String[]{member}, new String[]{this.memberLabelType}, true);
                                    if (list != null && list.size() > 0 && list.get(0) != null && ((Object[])list.get(0)).length > 0) {
                                        String string = (String)((Object[])list.get(0))[0];
                                        return string;
                                    }
                                    String string = member;
                                    return string;
                                }
                                int startslice = 0;
                                while (startslice != endslice) {
                                    if (this.dataAccess.getMemberStartLayer(i, j, startslice) == j) {
                                        Object objValue = this.dataAccess.getMemberMetadata(i, j, startslice, "value");
                                        String value = null;
                                        if (objValue != null) {
                                            value = objValue.toString();
                                        }
                                        if (value != null && value.equals(member)) {
                                            objValue = this.dataAccess.getMemberMetadata(i, j, startslice, this.memberLabelType);
                                            if (objValue != null) {
                                                value = objValue.toString();
                                            }
                                            if (value == null) {
                                                String string = member;
                                                return string;
                                            }
                                            String string = value;
                                            return string;
                                        }
                                    }
                                    startslice += this.dataAccess.getMemberExtent(i, j, startslice);
                                }
                            } else if (i == 0) {
                                int k = 0;
                                while (k < this.dataAccess.getEdgeExtent(1)) {
                                    Object val = this.dataAccess.getValue(k, j, "value");
                                    if (val != null && val.toString().equals(member)) {
                                        String string = this.dataAccess.getValue(k, j, "dataValue").toString();
                                        return string;
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return member;
    }
}

