/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.graph;

import java.util.ArrayList;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.jbo.uicli.graph.JUGraphBinding;

public class BIBeanDataAccessAdapter
extends DataAccessAdapter
implements RelationalDataDirector,
CubeDataDirector {
    private static final String mEmptyString = "";
    private int pageCount;
    private int currentPage;
    protected DataDirectorListener mListener;
    JUGraphBinding mOwner;
    ArrayList listeners;

    private void $init$() {
        this.mListener = null;
        this.listeners = new ArrayList(5);
    }

    public BIBeanDataAccessAdapter(JUGraphBinding owner) {
        this.$init$();
        this.mOwner = owner;
        this.currentPage = 0;
    }

    public boolean pivot(int fromEdge, int toEdge, int fromLayer, int toLayer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, DataDirectorException {
        return false;
    }

    public boolean drill(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        return true;
    }

    public int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        switch (edge) {
            case 0: {
                return this.mOwner.getColumnCount();
            }
            case 1: {
                return (int)this.mOwner.getRowCount();
            }
        }
        return this.pageCount;
    }

    public int getEdgeCount() {
        return 3;
    }

    public Object getValue(int aRow, int aColumn, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        return this.mOwner.getValue(aRow, aColumn);
    }

    public boolean setValue(Object aValue, int aRow, int aColumn, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        return false;
    }

    public Object getSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        switch (edge) {
            case 0: {
                return this.mOwner.getColumnLabel(slice);
            }
            case 1: {
                return this.mOwner.getRowLabel(slice);
            }
        }
        if (slice < 0 || slice >= this.pageCount) {
            throw new SliceOutOfRangeException(slice, this.pageCount);
        }
        return mEmptyString;
    }

    public int getEdgeCurrentSlice(int edge) throws EdgeOutOfRangeException {
        return this.currentPage;
    }

    public boolean changeEdgeCurrentSlice(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        if (slice < 0 || slice >= this.pageCount) {
            return false;
        }
        this.currentPage = slice;
        return true;
    }

    public int getLayerCount(int edge) throws EdgeOutOfRangeException {
        if (edge == 2) {
            return 0;
        }
        return 1;
    }

    public int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge == 2) {
            return 0;
        }
        return 1;
    }

    public Object getMemberMetadata(int edge, int layer, int slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("drillState")) {
            switch (slice) {
                case 0: {
                    return new Integer(1);
                }
                case 1: {
                    return new Integer(2);
                }
            }
            return new Integer(0);
        }
        if (type.equals("hierLevel")) {
            return new Integer(slice);
        }
        String obj = null;
        switch (edge) {
            case 0: {
                obj = this.mOwner.getColumnLabel(slice);
                break;
            }
            case 1: {
                obj = this.mOwner.getRowLabel(slice);
                break;
            }
            case 2: {
                obj = mEmptyString;
                break;
            }
        }
        return obj;
    }

    public int getMemberExtent(int edge, int depth, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public int getMemberStartLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return layer;
    }

    public void addDataDirectorListener(DataDirectorListener l) {
        if (l != null) {
            this.listeners.add(l);
            l.viewDataAvailable(new DataAvailableEvent((Object)this, (DataAccess)this));
        }
    }

    public void removeDataDirectorListener(DataDirectorListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public boolean refresh() throws DataDirectorException {
        DataChangedEvent event = new DataChangedEvent((Object)this, (DataAccess)this, true, true, true, true);
        int i = 0;
        while (i < this.listeners.size()) {
            DataDirectorListener l = (DataDirectorListener)this.listeners.get(i);
            l.viewDataChanged(event);
            ++i;
        }
        return true;
    }

    public DataMap getSupportedDataMap() {
        String[] supported = new String[]{"dataValue", "dataFormattedValue"};
        return new DataMap(supported);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] supported = new String[]{"longName", "mediumName", "shortName"};
        return new MetadataMap(supported);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] supported = new String[]{"dimLongName", "dimMediumName", "dimShortName"};
        return new LayerMetadataMap(supported);
    }

    void releaseReferences() {
        this.mOwner = null;
        this.listeners.clear();
    }
}

