/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.graph;

import oracle.adf.model.binding.DCIteratorBinding;
import oracle.dss.graph.Graph;
import oracle.jbo.RowSetIterator;
import oracle.jbo.domain.Number;
import oracle.jbo.uicli.binding.JUCtrlRangeBinding;

public class GraphDataFromCol
extends JUCtrlRangeBinding {
    protected int mNumberOfColumnValuesPerMarker;
    protected String mSeriesLabel;
    private int mLabelColumnIndex;
    private final String emptyString;

    private void $init$() {
        this.mLabelColumnIndex = -1;
        this.emptyString = "";
    }

    public GraphDataFromCol(Graph control, DCIteratorBinding iterBinding, String[] dataValueAttrNames, int numberOfColumnValuesPerMarker, String seriesLabel) {
        super((Object)control, iterBinding, dataValueAttrNames);
        this.$init$();
        this.init(control, numberOfColumnValuesPerMarker, dataValueAttrNames.length - 1, seriesLabel);
    }

    private void init(Graph control, int numberOfColumnValuesPerMarker, int labelColumnIndex, String seriesLabel) {
        this.mNumberOfColumnValuesPerMarker = numberOfColumnValuesPerMarker;
        this.mLabelColumnIndex = labelColumnIndex;
        this.mSeriesLabel = seriesLabel;
    }

    protected String getSeriesLabel() {
        return this.mSeriesLabel;
    }

    protected String getColumnLabel(int i) {
        if (this.isFindMode()) {
            return "";
        }
        int rowNumber = i / this.mNumberOfColumnValuesPerMarker;
        int rangeIndex = this.rowIndexToRangeIndex(rowNumber);
        Object val = this.getAttributeFromRow(rangeIndex, this.mLabelColumnIndex);
        return val == null ? "" : val.toString();
    }

    protected int getColumnCount() {
        int rc = this.mNumberOfColumnValuesPerMarker * (int)this.getEstimatedRowCount();
        return rc;
    }

    protected Object getColumnValue(int col) {
        if (this.isFindMode()) {
            return "";
        }
        int modifiedRowNumber = col / this.mNumberOfColumnValuesPerMarker;
        int modifiedColNumber = col % this.mNumberOfColumnValuesPerMarker;
        int rangeIndex = this.rowIndexToRangeIndex(modifiedRowNumber);
        Object val = this.getAttributeValueFromRow(rangeIndex, modifiedColNumber);
        if (val == null) {
            val = "";
        }
        if (val instanceof Number) {
            val = ((Number)val).getData();
        }
        return val;
    }

    protected int rowIndexToRangeIndex(int rowIndex) {
        RowSetIterator iter = (RowSetIterator)this.getRowIterator();
        if (iter != null) {
            int rangeStart = iter.getRangeStart();
            if (rangeStart <= 0) {
                return rowIndex;
            }
            return rowIndex - rangeStart;
        }
        return rowIndex;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addControlToPanel(Object panel, Object layoutObject, Object layoutCons) {
    }

    boolean isFindMode() {
        return this.getFormBinding().isFindMode();
    }
}

