/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.graph;

import oracle.adf.model.binding.DCIteratorBinding;
import oracle.dss.graph.Graph;
import oracle.jbo.AttributeDef;
import oracle.jbo.LocaleContext;
import oracle.jbo.Row;
import oracle.jbo.domain.Number;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.graph.JUGraphBinding;

public class GraphDataFromRow
extends JUGraphBinding {
    private int mSeriesLabelColumnIndex;
    private int numberOfColumnValuesPerMarker;
    private String[] colLabels;

    private void $init$() {
        this.mSeriesLabelColumnIndex = -1;
        this.numberOfColumnValuesPerMarker = 1;
    }

    public GraphDataFromRow(Graph control, DCIteratorBinding iterBinding, String[] dataValueAttrNames, String[] colLabels) {
        super(control, iterBinding, dataValueAttrNames);
        this.$init$();
        this.mSeriesLabelColumnIndex = dataValueAttrNames.length - 1;
        iterBinding.setRangeSize(-1);
        this.setColumnLabels(colLabels);
    }

    public void setColumnLabels(String[] labels) {
        this.colLabels = labels;
    }

    public String[] getColumnLabels() {
        return this.colLabels;
    }

    protected String getColumnLabel(int i) {
        Object label = null;
        if (this.colLabels != null) {
            return this.colLabels[i];
        }
        return super.getAttributeNames()[i];
    }

    protected int getColumnCount() {
        String[] s = super.getAttributeNames();
        return s.length - 1;
    }

    protected String getRowLabel(int i) {
        if (this.isFindMode()) {
            return "";
        }
        int rangeIndex = this.rowIndexToRangeIndex(i);
        Object val = this.getAttributeFromRow(rangeIndex, this.mSeriesLabelColumnIndex);
        if (val == null) {
            val = "";
        }
        return val.toString();
    }

    protected long getRowCount() {
        long rc = this.getEstimatedRowCount();
        return rc == (long)-1 ? 0L : rc;
    }

    protected Object getValue(int row, int col) {
        if (this.isFindMode()) {
            return "";
        }
        int rangeIndex = this.rowIndexToRangeIndex(row);
        Object val = this.getAttributeValueFromRow(rangeIndex, col);
        if (val == null) {
            val = "";
        }
        if (val instanceof Number) {
            val = ((Number)val).getData();
        }
        return val;
    }

    public void updateValuesFromRows(Row[] rows, boolean clear) {
        super.updateValuesFromRows(rows, clear);
        if (this.colLabels == null) {
            this.colLabels = this.getHintsForColumnLabels();
        }
    }

    private String[] getHintsForColumnLabels() {
        String[] attrNames = super.getAttributeNames();
        JUIteratorBinding iter = super.getIteratorBinding();
        String[] hints = new String[attrNames.length];
        AttributeDef[] defs = iter.getAttributeDefs(attrNames);
        LocaleContext ctx = iter.getDataControl().getLocaleContext();
        int i = 0;
        while (i < attrNames.length) {
            hints[i] = defs[i].getUIHelper().getLabel(ctx);
            if (hints[i] == null) {
                hints[i] = attrNames[i];
            }
            ++i;
        }
        return hints;
    }

    protected void notifyView() {
    }

    boolean isFindMode() {
        return this.getFormBinding().isFindMode();
    }
}

