/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.graph;

import java.io.InputStream;
import java.util.HashMap;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.dss.graph.Graph;
import oracle.jbo.common.JBOClass;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.uicli.binding.JUCtrlRangeDef;
import oracle.jbo.uicli.graph.JUGraphBinding;
import oracle.jbo.uicli.graph.JUMasterDetailGraphBinding;
import oracle.jbo.uicli.graph.JUSingleTableGraphBinding;

public class JUSingleTableGraphDef
extends JUCtrlRangeDef {
    public static final String PNAME_ColumnLabels = "ColumnLabels";
    public static final String PNAME_SeriesLabelName = "SeriesLabel";
    public static final String PNAME_GroupLabelName = "GroupLabel";
    public static final String PNAME_GraphPropertiesFileName = "GraphPropertiesFileName";
    public static final String PNAME_ChildAccessorName = "ChildAccessorName";
    public static final String PNAME_SeriesType = "SeriesType";
    public static final String SINGLE_SERIES = "SINGLE_SERIES";
    public static final String MASTER_DETAIL = "MASTER_DETAIL";
    public static final String PNAME_Graph = "DCGraph";
    private String mSeriesType;
    private String[] mColumnLabels;
    private String mSeriesLabelAttrName;
    private String mGroupLabelAttrName;
    private String mGraphPropertiesFileName;
    private String mChildAccessorName;

    private void $init$() {
        this.mSeriesType = SINGLE_SERIES;
        this.mColumnLabels = null;
    }

    public JUSingleTableGraphDef() {
        this.$init$();
        this.setControlBindingClassName(JUSingleTableGraphBinding.class.getName());
    }

    public JUSingleTableGraphDef(String name, String controlClassName, String controlBindingClassName, String iterBindingName, String seriesLabelAttrName, String[] attrNames, String[] colLabels, String graphPropertiesFileName) {
        super(name, controlClassName, controlBindingClassName != null ? controlBindingClassName : JUSingleTableGraphBinding.class.getName(), iterBindingName, attrNames);
        this.$init$();
        this.mColumnLabels = colLabels;
        this.mSeriesLabelAttrName = seriesLabelAttrName;
        this.mGraphPropertiesFileName = graphPropertiesFileName;
    }

    public String[] getColumnLabels() {
        return this.mColumnLabels;
    }

    public String getSeriesLabelAttrName() {
        return this.mSeriesLabelAttrName;
    }

    public String getGroupLabelAttrName() {
        return this.mGroupLabelAttrName;
    }

    public String getGraphPropertiesFileName() {
        return this.mGraphPropertiesFileName;
    }

    public String getChildAccessorName() {
        return this.mChildAccessorName;
    }

    public String getSeriesType() {
        return this.mSeriesType;
    }

    public void init(HashMap initValues) {
        super.init(initValues);
        Object val = initValues.get(PNAME_ColumnLabels);
        if (val != null) {
            this.mColumnLabels = (String[])val;
        }
        if ((val = initValues.get(PNAME_SeriesLabelName)) != null) {
            this.mSeriesLabelAttrName = (String)val;
        }
        if ((val = initValues.get(PNAME_GraphPropertiesFileName)) != null) {
            this.mGraphPropertiesFileName = (String)val;
        }
        if ((val = initValues.get(PNAME_ChildAccessorName)) != null) {
            this.mChildAccessorName = (String)val;
        }
        if ((val = initValues.get(PNAME_SeriesType)) != null) {
            this.mSeriesType = (String)val;
        }
        if ((val = initValues.get(PNAME_GroupLabelName)) != null) {
            this.mGroupLabelAttrName = (String)val;
        }
    }

    protected DCControlBinding createControlBindingInstance(Object control, DCBindingContainer formBnd) {
        if (this.getSeriesType().equals(SINGLE_SERIES)) {
            return this.createSingleTableGraphBinding(control, formBnd);
        }
        return this.createMasterDetailGraphBinding(control, formBnd);
    }

    private DCControlBinding createSingleTableGraphBinding(Object control, DCBindingContainer formBnd) {
        Graph graph = (Graph)control;
        JUSingleTableGraphBinding graphBinding = null;
        graphBinding = this.getGraphPropertiesFileName() == null ? (JUSingleTableGraphBinding)this.createSingleTableGraphBinding((Graph)control, this.getIterBinding(formBnd), this.getAttrNames(), this.getSeriesLabelAttrName(), null) : (JUSingleTableGraphBinding)this.createSingleTableGraphBinding((Graph)control, this.getIterBinding(formBnd), this.getAttrNames(), this.getSeriesLabelAttrName(), null, this.decorateGraphPropertiesFileName(this.getGraphPropertiesFileName()));
        return graphBinding;
    }

    protected Object createSingleTableGraphBinding(Graph control, DCIteratorBinding iterBinding, String[] dataValueAttrNames, String seriesLabelAttrName, String[] colLabels) {
        return new JUSingleTableGraphBinding(control, iterBinding, dataValueAttrNames, seriesLabelAttrName, colLabels);
    }

    protected Object createSingleTableGraphBinding(Graph control, DCIteratorBinding iterBinding, String[] dataValueAttrNames, String seriesLabelAttrName, String[] colLabels, String graphDefFileName) {
        return new JUSingleTableGraphBinding(control, iterBinding, dataValueAttrNames, seriesLabelAttrName, colLabels, graphDefFileName);
    }

    private DCControlBinding createMasterDetailGraphBinding(Object control, DCBindingContainer formBnd) {
        Graph graph = (Graph)control;
        JUMasterDetailGraphBinding graphBinding = null;
        String groupLabel = this.getGroupLabelAttrName();
        if (groupLabel == null) {
            groupLabel = this.getFirstAttrName();
        }
        String[] modifiedAttrList = JUGraphBinding.buildAttributeListWithLabel(this.getAttrNames(), groupLabel);
        if (this.getGraphPropertiesFileName() == null) {
            graphBinding = (JUMasterDetailGraphBinding)this.createMasterDetailGraphBinding((Graph)control, this.getIterBinding(formBnd), this.getSeriesLabelAttrName(), this.getChildAccessorName(), modifiedAttrList, 1);
        } else {
            String decoratedGraphPropertiesFileName = this.decorateGraphPropertiesFileName(this.getGraphPropertiesFileName());
            int graphType = this.getGraphType((Graph)control, decoratedGraphPropertiesFileName);
            int numColumnsPerMarker = JUGraphBinding.getNumberOfColumnPerMarker(graphType);
            graphBinding = (JUMasterDetailGraphBinding)this.createMasterDetailGraphBinding((Graph)control, this.getIterBinding(formBnd), this.getSeriesLabelAttrName(), this.getChildAccessorName(), modifiedAttrList, numColumnsPerMarker, decoratedGraphPropertiesFileName);
        }
        graphBinding.setName(this.getName());
        return graphBinding;
    }

    protected Object createMasterDetailGraphBinding(Graph control, DCIteratorBinding iterBinding, String seriesLabelAttrName, String childAccessorName, String[] dataValueAttrNames, int numberOfColumnValuesPerMarker) {
        return new JUMasterDetailGraphBinding(control, iterBinding, seriesLabelAttrName, childAccessorName, dataValueAttrNames, numberOfColumnValuesPerMarker);
    }

    protected Object createMasterDetailGraphBinding(Graph control, DCIteratorBinding seriesBinding, String seriesLabelAttrName, String childAccessorName, String[] dataValueAttrNames, int numberOfColumnValuesPerMarker, String graphPropertiesFileName) {
        return new JUMasterDetailGraphBinding(control, seriesBinding, seriesLabelAttrName, childAccessorName, dataValueAttrNames, numberOfColumnValuesPerMarker, graphPropertiesFileName);
    }

    private String decorateGraphPropertiesFileName(String s) {
        StringBuffer sbuf = new StringBuffer(s.replace('.', '/'));
        sbuf.append(".xml");
        return sbuf.toString();
    }

    protected void loadChildrenFromXML(DefElement xmlElement) {
        super.loadChildrenFromXML(xmlElement);
        HashMap valueTab = new HashMap(2);
        JUSingleTableGraphDef.readXMLStringArray((DefElement)xmlElement, (String)PNAME_ColumnLabels, valueTab);
        Object val = valueTab.get(PNAME_ColumnLabels);
        if (val != null) {
            this.mColumnLabels = (String[])val;
        }
    }

    protected void retrieveFromXML(DefElement xmlElement, HashMap valueTab) {
        super.retrieveFromXML(xmlElement, valueTab);
        JUSingleTableGraphDef.readXMLString((DefElement)xmlElement, (String)PNAME_SeriesLabelName, (HashMap)valueTab);
        JUSingleTableGraphDef.readXMLString((DefElement)xmlElement, (String)PNAME_GroupLabelName, (HashMap)valueTab);
        JUSingleTableGraphDef.readXMLString((DefElement)xmlElement, (String)PNAME_GraphPropertiesFileName, (HashMap)valueTab);
        JUSingleTableGraphDef.readXMLString((DefElement)xmlElement, (String)PNAME_ChildAccessorName, (HashMap)valueTab);
        JUSingleTableGraphDef.readXMLString((DefElement)xmlElement, (String)PNAME_SeriesType, (HashMap)valueTab);
        Object val = valueTab.get(PNAME_SeriesLabelName);
        if (val != null) {
            this.mSeriesLabelAttrName = (String)val;
        }
        if ((val = valueTab.get(PNAME_GroupLabelName)) != null) {
            this.mGroupLabelAttrName = (String)val;
        }
        if ((val = valueTab.get(PNAME_GraphPropertiesFileName)) != null) {
            this.mGraphPropertiesFileName = (String)val;
        }
        if ((val = valueTab.get(PNAME_ChildAccessorName)) != null) {
            this.mChildAccessorName = (String)val;
        }
        if ((val = valueTab.get(PNAME_SeriesType)) != null) {
            this.mSeriesType = (String)val;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getGraphType(Graph control, String graphDefFileName) {
        Graph gr = control;
        if (gr == null) {
            gr = new Graph();
        }
        InputStream is = JBOClass.getResourceAsStream((String)graphDefFileName);
        try {
            gr.readXML(is, 0);
            int n = gr.getGraphType();
            return n;
        }
        catch (Exception exc) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        try {
            is.close();
            return 17;
        }
        catch (Exception e) {
            // empty catch block
        }
        return 17;
    }

    protected void initSubType() {
        this.setSubType(PNAME_Graph);
    }

    protected void initializeControlBinding(DCBindingContainer formBnd, DCControlBinding controlBnd) {
        super.initializeControlBinding(formBnd, controlBnd);
        JUSingleTableGraphBinding bnd = (JUSingleTableGraphBinding)controlBnd;
        if (bnd instanceof JUSingleTableGraphBinding) {
            bnd.setAttributeNames(JUGraphBinding.buildAttributeListWithLabel(this.getAttrNames(), this.getSeriesLabelAttrName()));
        }
    }
}

