/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import java.sql.Connection;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBEntity;
import oracle.xdb.dom.XDBNamedNodeMap;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.dom.XDBNotation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;

public class XDBDocumentType
extends XDBNode
implements DocumentType {
    private synchronized native long getNotationsNative(long var1, long var3);

    private synchronized native long getEntitiesNative(long var1, long var3);

    private synchronized native String getNameNative(long var1, long var3);

    private synchronized native String getPublicIdNative(long var1, long var3);

    private synchronized native String getSystemIdNative(long var1, long var3);

    XDBDocumentType(XDBDocument owner_doc, long xob) {
        super(owner_doc, xob, (short)10);
    }

    XDBDocumentType(Connection conn, XDBDocument owner_doc, long xob) {
        super(owner_doc, xob, (short)10);
        this.m_conn = conn;
    }

    public NamedNodeMap getNotations() {
        if (this.isClosed()) {
            return null;
        }
        long mapcs = this.getNotationsNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (mapcs == 0L) {
            return null;
        }
        return new XDBNamedNodeMap((XDBDocument)this.getOwnerDocument(), mapcs);
    }

    public String getName() {
        if (this.isClosed()) {
            return null;
        }
        return this.getNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    public NamedNodeMap getEntities() {
        if (this.isClosed()) {
            return null;
        }
        long mapcs = this.getEntitiesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (mapcs == 0L) {
            return null;
        }
        return new XDBNamedNodeMap((XDBDocument)this.getOwnerDocument(), mapcs);
    }

    public String getInternalSubset() {
        return null;
    }

    public String getPublicId() {
        if (this.isClosed()) {
            return null;
        }
        return this.getPublicIdNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    public String getSystemId() {
        if (this.isClosed()) {
            return null;
        }
        return this.getSystemIdNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    public XDBEntity findEntity(String name) {
        if (this.isClosed()) {
            return null;
        }
        NamedNodeMap entityMap = this.getEntities();
        return (XDBEntity)entityMap.getNamedItem(name);
    }

    public XDBNotation findNotation(String name) {
        if (this.isClosed()) {
            return null;
        }
        NamedNodeMap notationMap = this.getNotations();
        return (XDBNotation)notationMap.getNamedItem(name);
    }
}

