/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBDOMException;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XDBNamedNodeMap
implements NamedNodeMap {
    private XDBDocument m_owner;
    private long m_mapcstate;

    private native long getNumNodesNative(long var1, long var3);

    private native long getNodeNative(long var1, long var3, String var5, String var6);

    private native long setNodeNative(long var1, long var3, long var5);

    private native long removeNodeNative(long var1, long var3, String var5, String var6);

    private native long getNodeItemAtNative(long var1, long var3, long var5);

    XDBNamedNodeMap(XDBDocument owner, long map) {
        this.m_owner = owner;
        this.m_mapcstate = map;
    }

    public int getLength() {
        return (int)this.getNumNodesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate);
    }

    public Node getNamedItem(String name) {
        long xobcstate = this.getNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, null, name);
        if (xobcstate != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, xobcstate);
        }
        return null;
    }

    public Node setNamedItem(Node node) {
        if (node.getNodeType() != 2 && node.getNodeType() != 12 && node.getNodeType() != 6) {
            throw new XDBDOMException(3, "Only attribute, notation and entity nodes can be inserted here");
        }
        long cstate = 0L;
        try {
            cstate = this.setNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, ((XDBNode)node).toCState());
        }
        catch (DOMException ex) {
            switch (ex.code) {
                case 32124: {
                    throw new DOMException(10, "Attribute in use");
                }
            }
            throw ex;
        }
        if (cstate == 0L) {
            return null;
        }
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    public Node removeNamedItem(String name) {
        long xobcstate = this.removeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, null, name);
        if (xobcstate != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, xobcstate);
        }
        throw new DOMException(8, "Item " + name + " not found");
    }

    public Node getNamedItemNS(String nsURI, String name) {
        long xobcstate = this.getNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, nsURI, name);
        if (xobcstate != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, xobcstate);
        }
        return null;
    }

    public Node setNamedItemNS(Node node) {
        if (node.getNodeType() != 2 && node.getNodeType() != 12 && node.getNodeType() != 6) {
            throw new XDBDOMException(3, "Only attribute, notation and entity nodes can be inserted here");
        }
        long cstate = 0L;
        try {
            cstate = this.setNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, ((XDBNode)node).toCState());
        }
        catch (DOMException ex) {
            switch (ex.code) {
                case 32124: {
                    throw new DOMException(10, "Attribute in use");
                }
            }
            throw ex;
        }
        if (cstate == 0L) {
            return null;
        }
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    public Node removeNamedItemNS(String nsURI, String name) {
        long xobcstate = this.removeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, nsURI, name);
        if (xobcstate != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, xobcstate);
        }
        throw new DOMException(8, "Item " + name + " not found in " + nsURI);
    }

    public Node item(int index) {
        long xobcstate = this.getNodeItemAtNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, index);
        if (xobcstate != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, xobcstate);
        }
        return null;
    }
}

