/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.ConnectionPanel;
import oracle.dbtools.migration.workbench.plugin.ConvertedModelPanel;
import oracle.dbtools.migration.workbench.plugin.MSAccessPostMigration;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class AccessChangeMdbDialog {
    private JPanel m_oPanel;
    private JPanel m_tpPanel;
    private JPanel m_convPanel;
    private JCheckBox m_removeLocalCheck;
    private JEWTDialog m_dlg;
    private JTextField dsnField;

    public AccessChangeMdbDialog() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.m_tpPanel = new ConnectionPanel("Access Connection", false);
        GridBagConstraints tpConstraints = new GridBagConstraints();
        tpConstraints.fill = 1;
        tpConstraints.weighty = 1.0;
        tpConstraints.weightx = 1.0;
        tpConstraints.gridy = 0;
        tpConstraints.gridx = 0;
        panel.add((Component)this.m_tpPanel, tpConstraints);
        this.m_oPanel = new ConnectionPanel("Oracle Connection", true);
        GridBagConstraints oracleConConstraints = new GridBagConstraints();
        oracleConConstraints.fill = 1;
        oracleConConstraints.anchor = 18;
        oracleConConstraints.weighty = 1.0;
        oracleConConstraints.weightx = 1.0;
        oracleConConstraints.gridy = 1;
        oracleConConstraints.gridx = 0;
        panel.add((Component)this.m_oPanel, oracleConConstraints);
        this.m_convPanel = new ConvertedModelPanel();
        GridBagConstraints convConstraints = new GridBagConstraints();
        convConstraints.fill = 1;
        convConstraints.anchor = 18;
        convConstraints.weighty = 1.0;
        convConstraints.weightx = 1.0;
        convConstraints.gridy = 2;
        convConstraints.gridx = 0;
        panel.add((Component)this.m_convPanel, convConstraints);
        this.m_removeLocalCheck = new JCheckBox("Remove local tables from Access Database");
        this.m_removeLocalCheck.setSelected(MigrationAddin.getMigrationConfig().getBooleanProperty("RemoveLocalTables"));
        GridBagConstraints checkConstraints = new GridBagConstraints();
        checkConstraints.fill = 1;
        checkConstraints.anchor = 18;
        checkConstraints.insets = new Insets(5, 10, 5, 5);
        checkConstraints.weighty = 1.0;
        checkConstraints.weightx = 1.0;
        checkConstraints.gridy = 3;
        checkConstraints.gridx = 0;
        panel.add((Component)this.m_removeLocalCheck, checkConstraints);
        JPanel dsnpanel = new JPanel();
        dsnpanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel();
        label.setText("Oracle DSN");
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 5, 5, 5);
        labelConstraints.weightx = 0.0;
        labelConstraints.weighty = 0.0;
        labelConstraints.anchor = 18;
        labelConstraints.gridy = 0;
        labelConstraints.gridx = 0;
        dsnpanel.add((Component)label, labelConstraints);
        GridBagConstraints dsnPanelCons2 = new GridBagConstraints();
        dsnPanelCons2.insets = new Insets(5, 5, 5, 5);
        dsnPanelCons2.weightx = 1.0;
        dsnPanelCons2.anchor = 18;
        dsnPanelCons2.weighty = 1.0;
        dsnPanelCons2.fill = 2;
        dsnPanelCons2.gridy = 0;
        dsnPanelCons2.gridx = 1;
        this.dsnField = new JTextField();
        this.dsnField.setText("");
        dsnpanel.add((Component)this.dsnField, dsnPanelCons2);
        GridBagConstraints dsnConstraints = new GridBagConstraints();
        dsnConstraints.fill = 1;
        dsnConstraints.anchor = 18;
        dsnConstraints.weighty = 1.0;
        dsnConstraints.weightx = 1.0;
        dsnConstraints.gridy = 4;
        dsnConstraints.gridx = 0;
        panel.add((Component)dsnpanel, dsnConstraints);
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)MigrationAddinArb.getString((int)20), (int)6);
        this.m_dlg.setTitle("Modify Access DB: Create Link Tables");
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_changemdb_html");
        JButton okButton = new JButton("OK");
        this.m_dlg.addCustomButton((Component)okButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String oName = AccessChangeMdbDialog.this.getConnName(AccessChangeMdbDialog.this.m_oPanel);
                String tpName = AccessChangeMdbDialog.this.getConnName(AccessChangeMdbDialog.this.m_tpPanel);
                MdConnection mdConnection = ((ConvertedModelPanel)AccessChangeMdbDialog.this.m_convPanel).getConvertedConnection();
                MSAccessPostMigration engine = new MSAccessPostMigration(oName, tpName, AccessChangeMdbDialog.this.m_removeLocalCheck.isSelected(), mdConnection, AccessChangeMdbDialog.this.dsnField.getText());
                engine.doPostMigration();
            }
        });
        this.m_dlg.setSize(400, 220);
        this.m_dlg.setResizable(false);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
    }

    private String getConnName(JPanel panel) {
        return ((ConnectionPanel)panel).getSelectedConName();
    }

    public void setVisible(boolean flag) {
        this.m_dlg.setVisible(flag);
    }
}

