/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.workbench.plugin.MSAccessController;
import oracle.dbtools.util.Resource;

public class AccessExecutor
extends Thread {
    private String m_mdeFile = null;
    private boolean m_standalone;
    private String m_mdbFile;
    private String m_msaccessExe;
    private String m_password;
    private boolean m_includeSchemaInformation;
    private boolean m_includeApplicationInformation;
    private boolean m_includeData;
    private String m_tempDir;
    private String m_fileToMonitor;

    public AccessExecutor(String theFile) {
        this.m_mdeFile = theFile;
        this.m_standalone = true;
    }

    public AccessExecutor(String accessExe, String mdeFile, String mdbFile, String password, boolean includeSchema, boolean includeApplication, boolean includeData) {
        this.m_msaccessExe = accessExe;
        this.m_mdeFile = mdeFile;
        this.m_standalone = false;
        this.m_mdbFile = mdbFile;
        this.m_password = password;
        this.m_includeApplicationInformation = includeApplication;
        this.m_includeSchemaInformation = includeSchema;
        this.m_includeData = includeData;
        this.m_tempDir = Resource.raptorUserTmp.getAbsolutePath();
        if (!this.m_tempDir.endsWith("/") && !this.m_tempDir.endsWith("\\")) {
            this.m_tempDir = this.m_tempDir + System.getProperty("file.separator");
        }
        this.storeFileToMonitor();
    }

    public void run() {
        try {
            String[] cmdArray;
            String helpDownload = MSAccessController.writeFile("omwb", true);
            String written = MSAccessController.writeFile(this.m_mdeFile, false);
            for (String s : cmdArray = this.generateCommandArray(written)) {
                System.out.print(s + " ");
            }
            System.out.println();
            Process p = Runtime.getRuntime().exec(cmdArray, null, new File(written.substring(0, written.lastIndexOf(92))));
            EatMe err = new EatMe(p.getErrorStream());
            err.start();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (input.readLine() != null) {
            }
            input.close();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private String[] generateCommandArray(String fullMdeFileName) {
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<String> accessCMDLine = new ArrayList<String>();
        if (this.m_standalone) {
            commands.add("cmd.exe");
            commands.add("/C");
            commands.add("start");
            commands.add(fullMdeFileName.substring(fullMdeFileName.lastIndexOf(92) + 1));
        } else {
            commands.add(this.m_msaccessExe);
            commands.add(fullMdeFileName);
            commands.add("/cmd");
        }
        if (!this.m_standalone) {
            accessCMDLine.add("/n=" + this.m_mdbFile);
            accessCMDLine.add("/o=" + this.m_tempDir);
            if (this.m_password == null) {
                accessCMDLine.add("/p=");
            } else {
                accessCMDLine.add("/p=" + this.m_password);
            }
            accessCMDLine.add("/d=" + AccessExecutor.booleanToHilaryVal(this.m_includeSchemaInformation));
            accessCMDLine.add("/a=" + AccessExecutor.booleanToHilaryVal(this.m_includeApplicationInformation));
            accessCMDLine.add("/t=" + AccessExecutor.booleanToHilaryVal(this.m_includeData));
            accessCMDLine.add("/x");
        }
        if (accessCMDLine.size() > 0) {
            StringBuffer sBuf = new StringBuffer();
            for (String s : accessCMDLine) {
                sBuf.append(s);
                sBuf.append(' ');
            }
            commands.add(sBuf.toString());
        }
        return commands.toArray(new String[commands.size()]);
    }

    public String getMonitorFile() {
        return this.m_fileToMonitor;
    }

    private void storeFileToMonitor() {
        String[] parts = this.m_mdbFile.split("\\\\");
        String sFileName = parts[parts.length - 1];
        parts = sFileName.split("\\.");
        this.m_fileToMonitor = this.m_tempDir + parts[0] + ".XML";
    }

    private static String booleanToHilaryVal(boolean b) {
        return b ? "0" : "1";
    }

    static final class EatMe
    extends Thread {
        InputStream m_theInputStream = null;

        public EatMe(InputStream ip) {
            this.m_theInputStream = new BufferedInputStream(ip);
        }

        public void run() {
            try {
                while (this.m_theInputStream.read() != -1) {
                }
                this.m_theInputStream.close();
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }
}

