/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.utils.Connections;

public class ConnectionPanel
extends JPanel {
    private static final long serialVersionUID = 4165381162747429352L;
    private static final int INSET = 5;
    private JComboBox m_comboBox;

    public ConnectionPanel(String title, boolean oracle) {
        this.setLayout(new GridBagLayout());
        JLabel accessConnectionLabel = new JLabel();
        accessConnectionLabel.setText(title);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 5, 5, 5);
        labelConstraints.weightx = 0.0;
        labelConstraints.weighty = 0.0;
        labelConstraints.anchor = 18;
        labelConstraints.gridy = 0;
        labelConstraints.gridx = 0;
        this.add((Component)accessConnectionLabel, labelConstraints);
        String[] conns = null;
        conns = oracle ? this.getOracleCons() : this.getNonOracleConNames();
        this.m_comboBox = new JComboBox<String>(conns);
        if (conns.length > 0) {
            this.m_comboBox.setSelectedIndex(0);
        }
        GridBagConstraints comboConstraints = new GridBagConstraints();
        comboConstraints.insets = new Insets(5, 5, 5, 5);
        comboConstraints.weightx = 1.0;
        comboConstraints.anchor = 18;
        comboConstraints.weighty = 1.0;
        comboConstraints.fill = 2;
        comboConstraints.gridy = 0;
        comboConstraints.gridx = 1;
        this.add((Component)this.m_comboBox, comboConstraints);
    }

    private String[] getOracleCons() {
        Connections inst = Connections.getInstance();
        ArrayList<String> names = new ArrayList<String>();
        String[] connNames = inst.getConnNames();
        for (int i = 0; i < connNames.length; ++i) {
            String connName = connNames[i];
            if (!inst.isOracle(connName)) continue;
            names.add(connName);
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getNonOracleConNames() {
        Connections inst = Connections.getInstance();
        ArrayList<String> names = new ArrayList<String>();
        String[] connNames = inst.getConnNames();
        for (int i = 0; i < connNames.length; ++i) {
            String connName = connNames[i];
            Properties cd = inst.getConnectionInfo(connName);
            if (!cd.getProperty("RaptorConnectionType").equals("ACCESS")) continue;
            names.add(connName);
        }
        return names.toArray(new String[names.size()]);
    }

    protected String getSelectedConName() {
        if (this.m_comboBox.getSelectedItem() != null) {
            return this.m_comboBox.getSelectedItem().toString();
        }
        return "";
    }
}

