/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.ui.AbstractCommonMigrationProgressRunnable;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MSAccessPlugin;
import oracle.dbtools.migration.workbench.plugin.MSAccessXMLExporterFileParser;

public class MSAccessCapture
extends AbstractCommonMigrationProgressRunnable
implements CaptureEventListener {
    private CaptureContext _context;
    private MigrationStorer m_storer;
    private String m_mdbfile;
    private MSAccessXMLExporterFileParser m_parser;

    public MSAccessCapture(String filePath, MigrationStorer storer) {
        this.setTitle(MigrationAddinArb.getString((int)158));
        this.setMessage(MigrationAddinArb.getString((int)159));
        this._context = new CaptureContext();
        this._context.getAudience().addListener((CaptureEventListener)this);
        this.m_parser = new MSAccessXMLExporterFileParser(filePath, storer, this._context);
        this.m_storer = storer;
        this.m_mdbfile = filePath;
    }

    protected Object doWork() throws Exception {
        MdConnection capturedConnection;
        try {
            capturedConnection = this.storeConnection();
        }
        catch (PersistenceException pex) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, pex.getLocalizedMessage());
            return Boolean.FALSE;
        }
        if (this.m_parser.loadFile()) {
            CapturedDatabases.getInstance().addMdConnection(capturedConnection);
            int uaVal = this.m_parser.getUAValue();
            MigrationAddin.getMigrationConfig().updateUACode(uaVal);
            this.updateStatistics(capturedConnection);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void updateStatistics(MdConnection capturedConnection) throws PersistenceException {
        PersistenceUtility util = this.m_storer.getPersistenceUtility();
        util.updateConnectionStatistics(capturedConnection);
    }

    public void raiseEvent(CaptureEvent event) {
        String progressLabel = MigrationAddinArb.getString((int)84) + " " + event.getEventSource();
        switch (event.getEventId()) {
            case 1: {
                progressLabel = MigrationAddinArb.getString((int)81) + " " + event.getEventSource();
                this.updateProgress(1, event, progressLabel);
                break;
            }
            case 2: {
                progressLabel = event.getEventSource() + " " + MigrationAddinArb.getString((int)80);
                this.updateProgress(2, event, progressLabel);
                break;
            }
            case 3: {
                progressLabel = MigrationAddinArb.getString((int)84) + " " + event.getEventSource();
                this.updateProgress(3, event, progressLabel);
                break;
            }
            case 4: {
                progressLabel = MigrationAddinArb.getString((int)85) + " " + event.getEventSource();
                this.updateProgress(4, event, progressLabel);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                progressLabel = MigrationAddinArb.getString((int)86);
                this.updateProgress(6, event, progressLabel);
                break;
            }
            case 7: {
                progressLabel = MigrationAddinArb.getString((int)88);
                this.updateProgress(7, event, progressLabel);
                break;
            }
        }
    }

    public void setTableCellRenderer() {
    }

    public void setToolTip() {
    }

    public String[] getColumnNames() {
        return new String[]{MigrationAddinArb.getString((int)154), MigrationAddinArb.getString((int)160)};
    }

    public String getEventString(Object event) {
        if (event != null && event instanceof CaptureEvent) {
            CaptureEvent eve = (CaptureEvent)event;
            String objType = null;
            if (eve.getEventId() == 3) {
                for (int i = 0; i < CaptureEvent.CAPTURE_OBJECTS.length; ++i) {
                    if (!eve.getEventSourceType().equalsIgnoreCase(CaptureEvent.CAPTURE_OBJECTS[i])) continue;
                    objType = CaptureEvent.CAPTURE_OBJECTS[i];
                }
            }
            return objType;
        }
        return null;
    }

    private MdConnection storeConnection() throws PersistenceException {
        MdProject proj = new MdProject("Dummy Access Project");
        proj = (MdProject)this.m_storer.storeObject((PersistableObject)proj);
        this._context.setContextVariable("PROJECTID", (Object)proj.getKey());
        MdConnection capturedConnection = new MdConnection(proj.getKey());
        capturedConnection.setDburl("dummy");
        capturedConnection.setUsername("dummy");
        capturedConnection.setPassword("dummy");
        CaptureEvent event = new CaptureEvent(3, MSAccessMigrationAddinArb.getString(1), capturedConnection.getDburl());
        capturedConnection.setName(MSAccessPlugin.getModelNameFromMDBFileName(this.m_mdbfile));
        capturedConnection = (MdConnection)this.m_storer.storeObject((PersistableObject)capturedConnection);
        capturedConnection.addProperty("PLUGIN_ID", MSAccessPlugin.class.getName(), capturedConnection.getKey());
        capturedConnection = (MdConnection)this.m_storer.storeObject((PersistableObject)capturedConnection);
        this._context.setContextVariable("CONNECTIONID", (Object)capturedConnection.getKey());
        event.setEventId(4);
        this._context.getAudience().fireListeners(event);
        return capturedConnection;
    }
}

