/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.MSAccessCapture;
import oracle.dbtools.migration.workbench.plugin.MSAccessCaptureSelectionPanel;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MSAccessPlugin;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;

public class MSAccessCaptureDialog {
    private JEWTDialog _jewtDialog;
    private static final long serialVersionUID = 5025669709731183466L;
    private MSAccessCaptureSelectionPanel _panel = new MSAccessCaptureSelectionPanel();
    private JButton m_okButton;
    private String _errMsg;

    public MSAccessCaptureDialog() {
        this._jewtDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._panel, null, (String)MSAccessMigrationAddinArb.getString(8), (int)2);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "f1_accessCapture_html");
        this.m_okButton = new JButton(MSAccessMigrationAddinArb.getString(12));
        this._jewtDialog.addCustomButton((Component)this.m_okButton);
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String fileName = MSAccessCaptureDialog.this._panel.getFileName();
                    if (fileName != null) {
                        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
                        if (persistenceManager == null) {
                            MSAccessCaptureDialog.this._jewtDialog.closeDialog(true);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString((int)219), (String)MigrationAddinArb.getString((int)218), (String)"help_must_connect_before_capture");
                            return;
                        }
                        if (!MSAccessCaptureDialog.this.validateXML(fileName)) {
                            MSAccessCaptureDialog.this._jewtDialog.closeDialog(true);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MSAccessCaptureDialog.this._errMsg, (String)MigrationAddinArb.getString((int)218), null);
                        } else {
                            MSAccessCapture capture = new MSAccessCapture(fileName, (MigrationStorer)new BasicMigrationStorer(MigrationAddin.getPersistenceManager()));
                            MSAccessCaptureDialog.this._jewtDialog.closeDialog(true);
                            capture.start(true);
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ex.getStackTrace()[0].toString(), ex);
                }
            }
        });
        this._jewtDialog.setSize(500, 200);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._jewtDialog);
    }

    public void setVisible(boolean visible) {
        this._jewtDialog.setVisible(visible);
    }

    private boolean validateXML(String fileName) {
        if (!fileName.endsWith("xml")) {
            this._errMsg = MSAccessMigrationAddinArb.getString(6);
            return false;
        }
        DOMParser parser = new DOMParser();
        try {
            InputStream dtdStream = MSAccessPlugin.class.getResourceAsStream("schema.dtd");
            parser.parseDTD(dtdStream, "DATABASES");
            DTD exdtd = parser.getDoctype();
            parser.setValidationMode(2);
            parser.showWarnings(true);
            parser.setDoctype(exdtd);
            FileInputStream in = new FileInputStream(new File(fileName));
            parser.parse((InputStream)in);
        }
        catch (Exception e) {
            this._errMsg = MSAccessMigrationAddinArb.getString(7);
            return false;
        }
        return true;
    }
}

