/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.AbstractConverter;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertResultImpl;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;

public class MSAccessConverter
extends AbstractConverter {
    public ITranslator getPlaformTranslator() {
        return ParserFactory.getParser((String)"oracle.dbtools.migration.parser.msaccess.MSAccessParserMain");
    }

    public String getDefaultValueMappingXML() {
        return "MSAccessDefaultValuesMappingRules.xml";
    }

    public ConvertResult convertObject(PersistableObject schemaObj, String matchingKey, PersistenceManager pman) throws ConvertException {
        ConvertResultImpl res = null;
        if (matchingKey.equals("ACCESS_HAS_DEFAULT")) {
            String defaultValue;
            MdColumn col = (MdColumn)schemaObj;
            if (col.getColumnType().equals("VARCHAR2") || col.getColumnType().equals("BLOB")) {
                String defaultValue2 = col.getDefaultValue();
                if (defaultValue2.indexOf("'") == -1) {
                    col.setDefaultValue("'" + defaultValue2 + "'");
                }
                if (defaultValue2.startsWith("=")) {
                    col.setDefaultValue("");
                    Logger logger = Logger.getLogger("oracle.dbtools.migration");
                    logger.severe(MigrationAddinArb.getString((int)302) + " " + "Default value:" + " " + defaultValue2 + " of the Column" + col.getObjectName());
                }
            } else if (col.getColumnType().equals("DATE") && (defaultValue = col.getDefaultValue()) != null && !defaultValue.trim().equals("") && defaultValue.indexOf("#") != -1) {
                defaultValue = defaultValue.replaceAll("#", "");
                defaultValue = defaultValue.replaceAll("=", "");
                defaultValue = "'" + defaultValue.trim() + "'";
                String dateformat = MigrationAddin.getMigrationConfig().getDateOfflineDateMask();
                defaultValue = "TO_DATE(" + defaultValue + ",'" + dateformat + "')";
                col.setDefaultValue(defaultValue);
            }
            res = new ConvertResultImpl(schemaObj);
        }
        return res;
    }

    public String[] getPropertyKeyList() {
        return new String[]{"ACCESS_HAS_DEFAULT"};
    }
}

