/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.sql.Connection;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationMenuManager;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.MSAccessController;
import oracle.dbtools.migration.workbench.plugin.MSAccessConverter;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MSAccessQuoter;
import oracle.dbtools.migration.workbench.plugin.access.MSAccessThirdPartyProvider;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public class MSAccessPlugin
extends AbstractMigrationPlugin {
    public static final String MY_PLATFORM = "ACCESS";
    public static final String MDE_ACCESS_97 = "omwb97";
    public static final String MDE_ACCESS_2000 = "omwb2000";
    public static final String MDE_ACCESS_2002 = "omwb2002";
    public static final String MDE_ACCESS_2003 = "omwb2003";
    public static final String REMOVE_LOCAL_TABLES = "RemoveLocalTables";
    protected Converter m_converter;

    public String getVersionNumber() {
        return "5.0";
    }

    public String getPluginName() {
        return MY_PLATFORM;
    }

    public String getPlatformName() {
        return "MSAccess";
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new MSAccessConverter();
        }
        return this.m_converter;
    }

    public ThirdPartyDbProvider getProvider(String url, Properties info) throws MigrationPluginException {
        return null;
    }

    public ThirdPartyDbProvider getProvider(String url, String user, String password) throws MigrationPluginException {
        return null;
    }

    public ThirdPartyDbProvider getProvider(String url) throws MigrationPluginException {
        return null;
    }

    public String getPublishedVersion() {
        return null;
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String platform, int major, int minor, String productversion) {
        if (platform.equals(MY_PLATFORM)) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    public ThirdPartyDbProvider getProvider(Connection conn) throws MigrationPluginException {
        return new MSAccessThirdPartyProvider(conn);
    }

    public void initialize() {
        super.initialize();
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent e) {
            }

            public void mainWindowClosing(IdeEvent e) {
            }

            public void mainWindowOpened(IdeEvent e) {
                MSAccessPlugin.this.addToMigrationMenu();
            }
        });
    }

    protected String getSupportedMapsXMLFileName() {
        return "MSAccessSupportedDataTypesMap.xml";
    }

    private void addToMigrationMenu() {
        MSAccessController controller = new MSAccessController();
        MigrationMenuManager manager = MigrationAddin.getMigrationMenuManager();
        JMenuItem accessMenuItem = this.createMigrationMenuItem(controller, "ACTION_CAPTURE_ACCESS", MSAccessMigrationAddinArb.getString(18), MigrationAddinArb.getMnemonic((int)18));
        manager.addMenuItem(accessMenuItem, true, 3);
        JMenu subMenu = this.createAccessSubMenu();
        if (subMenu != null) {
            manager.addMenuItem((JMenuItem)subMenu, false, 2);
        }
        JMenuItem accessMDBChangeItem = this.createMigrationMenuItem(controller, "ACTION_CHANGE_MDB", MSAccessMigrationAddinArb.getString(19), 109);
    }

    private JMenu createAccessSubMenu() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return null;
        }
        MSAccessController controller = new MSAccessController();
        JMenu jmenu = new JMenu(StringUtils.stripMnemonic((String)MSAccessMigrationAddinArb.getString(13)));
        jmenu.setMnemonic('x');
        JMenuItem menuItem97 = this.createMigrationMenuItem(controller, "ACTION_RUN_ACCESS_97", MSAccessMigrationAddinArb.getString(14), 109);
        JMenuItem menuItem2000 = this.createMigrationMenuItem(controller, "ACTION_RUN_ACCESS_2000", MSAccessMigrationAddinArb.getString(15), 109);
        JMenuItem menuItem2002 = this.createMigrationMenuItem(controller, "ACTION_RUN_ACCESS_2002", MSAccessMigrationAddinArb.getString(16), 109);
        JMenuItem menuItem2003 = this.createMigrationMenuItem(controller, "ACTION_RUN_ACCESS_2003", MSAccessMigrationAddinArb.getString(17), 109);
        jmenu.add(menuItem97);
        jmenu.add(menuItem2000);
        jmenu.add(menuItem2002);
        jmenu.add(menuItem2003);
        return jmenu;
    }

    private JMenuItem createMigrationMenuItem(Controller controller, String commandName, String menuLabel, int mnemonic) {
        int aid = Ide.findOrCreateCmdID((String)commandName);
        IdeAction firstAction = IdeAction.get((int)aid, null, (String)StringUtils.stripMnemonic((String)menuLabel), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)menuLabel)), (ResourceBundle)MigrationAddinArb.getInstance(), null, null, (boolean)true);
        firstAction.addController(controller);
        JMenuItem ret = new JMenuItem((Action)firstAction);
        return ret;
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.access");
    }

    public Quoter getQuoter() {
        return new MSAccessQuoter();
    }

    public boolean doIReturnUnloadScripts() {
        return false;
    }

    public boolean getDataExportCommmand(String srcTable, MdColumn[] srcTableCols, Offline3rdPartyPrintStream printStream) {
        return true;
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/access/images/access.gif";
    }

    public String getDatafileExtension() {
        return "dat";
    }

    public String maybeUnqualifyTable(String qualifiedTable) {
        if (qualifiedTable != null && qualifiedTable.startsWith("[") && qualifiedTable.endsWith("]") && qualifiedTable.length() > 2) {
            return qualifiedTable.substring(1, qualifiedTable.length() - 1);
        }
        return qualifiedTable;
    }

    public String formatSQLLoaderColumn(MdColumn column, MdColumn tgtColumn) {
        String format = "";
        String columnName = tgtColumn.getColumnName();
        String dataType = column.getColumnType();
        String tgtDataType = tgtColumn.getColumnType();
        Integer tgtPrecision = tgtColumn.getPrecision();
        int columnLength = 0;
        columnLength = tgtPrecision == null ? 0 : tgtPrecision;
        if (tgtDataType.equalsIgnoreCase("CHAR") || tgtDataType.equalsIgnoreCase("NCHAR") || tgtDataType.equalsIgnoreCase("VARCHAR2") || tgtDataType.equalsIgnoreCase("NVARCHAR2") || tgtDataType.equalsIgnoreCase("CLOB") || tgtDataType.equalsIgnoreCase("NCLOB")) {
            if (columnLength >= 255) {
                format = "CHAR(" + columnLength + ")";
            }
            if (tgtDataType.equalsIgnoreCase("CLOB") || tgtDataType.equalsIgnoreCase("NCLOB")) {
                format = format + "CHAR(2000000)";
            }
        } else if (tgtDataType.equalsIgnoreCase("TIMESTAMP")) {
            format = "\"TO_TIMESTAMP(:" + columnName + ", '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
        } else if (dataType.equalsIgnoreCase("TIME")) {
            format = "\"TO_DATE(:" + columnName + ",  'HH24:mi:ss')\"";
        } else if (tgtDataType.equalsIgnoreCase("DATE")) {
            format = "\"TO_DATE(:" + columnName + ",  '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
        } else if (dataType.equalsIgnoreCase("CURRENCY")) {
            format = "\"TRANSLATE (substr(:" + columnName + ",2),'1,','1')\"";
        } else if (tgtDataType.equalsIgnoreCase("BLOB")) {
            format = "CHAR(10000000)";
        }
        return format;
    }

    public static String getMDEFileForVersion(int version) {
        switch (version) {
            case 8: {
                return MDE_ACCESS_97;
            }
            case 9: {
                return MDE_ACCESS_2000;
            }
            case 10: {
                return MDE_ACCESS_2002;
            }
        }
        return MDE_ACCESS_2003;
    }

    public static String getModelNameFromMDBFileName(String mdbFileName) {
        String fileName = new File(mdbFileName).getName();
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        return name.concat(" (Access)");
    }
}

