/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.workbench.plugin.common.InvalidDatabaseException;
import oracle.dbtools.migration.workbench.plugin.common.LinkTableDescriptor;
import oracle.dbtools.migration.workbench.plugin.common.MSAccessUtils;
import oracle.dbtools.migration.workbench.plugin.common.UnableToModifyAccessDatabaseException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoDatabase;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoWorkspace;

public class MSAccessPostMigration {
    private String m_oracleConn;
    private String m_accessConn;
    private boolean m_removeSrcTables;
    private DBObjectId m_convertedModelId;
    private JDaoWorkspace m_daoWorkspace;
    private String oracleDSN = "";

    public MSAccessPostMigration(String oracleConn, String accessConn, boolean removeSrcTables, MdConnection convertModelId, String DSN) {
        this.m_oracleConn = oracleConn;
        this.m_accessConn = accessConn;
        this.m_removeSrcTables = removeSrcTables;
        this.m_convertedModelId = convertModelId.getKey();
        this.oracleDSN = DSN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPostMigration() {
        if (!MSAccessUtils.confirmDaoVersion(this.m_accessConn)) {
            return false;
        }
        try {
            this.m_daoWorkspace = MSAccessUtils.getDAOWorkspace(this.m_accessConn);
            String DSN = MSAccessUtils.getOdbcFromConnection(this.m_accessConn);
            String dbPathName = MSAccessUtils.getPathAndFileName(DSN);
            if (!MSAccessUtils.ensureValidDatabase(dbPathName, false, false)) {
                boolean bl = false;
                return bl;
            }
            JDaoDatabase db = new JDaoDatabase();
            db.open(dbPathName, true, false);
            ArrayList<LinkTableDescriptor> tables = MSAccessUtils.getTablesInfo(this.m_convertedModelId);
            for (LinkTableDescriptor table : tables) {
                MSAccessUtils.createTableAttachment(db, DSN, table, this.m_oracleConn, true, true);
                MSAccessUtils.createMappingQuery(db, table);
            }
        }
        catch (JDaoException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (InvalidDatabaseException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (UnableToModifyAccessDatabaseException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            this.m_daoWorkspace.deinit();
            this.m_daoWorkspace = null;
        }
        return true;
    }
}

