/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdGroupMember;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MSAccessXMLExporterFileParser {
    private static final String VERSION_2000 = "MS Access 2000";
    private static final String VERSION_1997 = "MS Access 97";
    private static final String VERSION_2002 = "MS Access 2002";
    private static final String VERSION_2003 = "MS Access 2003";
    public static final String MY_LANGUAGE_ID = "MSAccessSQL";
    private String _filePath;
    private XMLDocument _xmlDocument;
    private Node _rootNode;
    private CaptureContext _context;
    private int m_uaMask;
    private MigrationStorer m_storer;
    private Hashtable<AccessId, DBObjectId> m_IdCache;
    private HashMap<String, Integer> m_schemaNameCount;

    public MSAccessXMLExporterFileParser(String filePath, MigrationStorer storer, CaptureContext context) {
        this._filePath = filePath;
        this._context = context;
        this.m_storer = storer;
        this.m_IdCache = new Hashtable();
        this.m_schemaNameCount = new HashMap();
    }

    public boolean loadFile() {
        CaptureEvent captureEvent = new CaptureEvent(6, "", MigrationAddinArb.getString((int)86));
        this._context.getAudience().fireListeners(captureEvent);
        if (this.loadXML()) {
            captureEvent.setEventId(7);
            this._context.getAudience().fireListeners(captureEvent);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadXML() {
        FileInputStream in = null;
        try {
            CaptureEvent event = new CaptureEvent(3, MSAccessMigrationAddinArb.getString(0), this._filePath);
            this._context.getAudience().fireListeners(event);
            in = new FileInputStream(new File(this._filePath));
            DOMParser parser = new DOMParser();
            parser.setPreserveWhitespace(false);
            parser.parse((InputStream)in);
            this._xmlDocument = parser.getDocument();
            this._rootNode = this._xmlDocument.getElementsByTagName("DATABASES").item(0);
            event.setEventId(4);
            this._context.getAudience().fireListeners(event);
            this.capture();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void capture() {
        try {
            DBObjectId capturedConnectionId = (DBObjectId)this._context.getContextVariable("CONNECTIONID");
            MdCatalog migrcatalog = new MdCatalog(capturedConnectionId);
            CaptureEvent catEvent = new CaptureEvent(3, MigrationAddinArb.getString((int)142), "");
            migrcatalog.setDummyFlag("Y");
            this._context.getAudience().fireListeners(catEvent);
            migrcatalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)migrcatalog);
            catEvent.setEventId(4);
            this._context.getAudience().fireListeners(catEvent);
            this._context.setContextVariable("CATALOGID", (Object)migrcatalog.getKey());
            NodeList nodes = this._rootNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                this.captureDatabase(node, this._context);
            }
            this.getStorer().commit();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public int getUAValue() {
        return this.m_uaMask;
    }

    private void captureDatabase(Node node, CaptureContext context) {
        if (node.getNodeName().equals("DATABASE")) {
            this.captureSchema(context, node);
            Node tablesNode = XMLHelper.getChildNode((Node)node, (String)"TABLES");
            this.captureTable(context, XMLHelper.getChildNodes((Node)tablesNode, (String)"TABLE"));
            Node usersNode = XMLHelper.getChildNode((Node)node, (String)"USERS");
            this.captureUsers(context, XMLHelper.getChildNodes((Node)usersNode, (String)"USER"));
            Node groupsNode = XMLHelper.getChildNode((Node)node, (String)"GROUPS");
            this.captureGroups(context, XMLHelper.getChildNodes((Node)groupsNode, (String)"GROUP"));
            Node queriesNode = XMLHelper.getChildNode((Node)node, (String)"QUERIES");
            this.captureQueries(context, XMLHelper.getChildNodes((Node)queriesNode, (String)"QUERY"));
            Node modulesNode = XMLHelper.getChildNode((Node)node, (String)"MODULES");
            this.captureModules(context, XMLHelper.getChildNodes((Node)modulesNode, (String)"MODULE"));
            Node relationsNode = XMLHelper.getChildNode((Node)node, (String)"RELATIONS");
            this.captureRelations(context, XMLHelper.getChildNodes((Node)relationsNode, (String)"RELATION"));
        }
    }

    private void captureSchema(CaptureContext context, Node node) {
        try {
            String schemaName = XMLHelper.getNodeValue((Node)node, (String)"DBNAME");
            String dbUser = XMLHelper.getNodeValue((Node)node, (String)"DBUSER");
            String dbPassword = XMLHelper.getNodeValue((Node)node, (String)"DBPASSWORD");
            String accessVer = XMLHelper.getNodeValue((Node)node, (String)"ACCESSVERSION");
            this.m_uaMask = MSAccessXMLExporterFileParser.toUAValue(accessVer);
            CaptureAudience audience = context.getAudience();
            DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            boolean isSchemaNameExists = false;
            if (this.m_schemaNameCount.containsKey(schemaName)) {
                Integer count = this.m_schemaNameCount.get(schemaName);
                this.m_schemaNameCount.put(schemaName, count + 1);
                isSchemaNameExists = true;
            } else {
                this.m_schemaNameCount.put(schemaName, 0);
            }
            MdSchema schema = new MdSchema(catalogId);
            if (isSchemaNameExists) {
                Integer currentCount = this.m_schemaNameCount.get(schemaName);
                schema.setName(schemaName + "_" + currentCount.toString());
            } else {
                schema.setName(schemaName);
            }
            AdditionalProperty userProp = new AdditionalProperty(MSAccessMigrationAddinArb.getString(2), dbUser);
            schema.addProperty(userProp, connectionId);
            AdditionalProperty passwordProp = new AdditionalProperty(MSAccessMigrationAddinArb.getString(3), dbPassword);
            schema.addProperty(passwordProp, connectionId);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)141), schema.getName());
            audience.fireListeners(event);
            schema = (MdSchema)this.getStorer().storeObject((PersistableObject)schema);
            event.setEventId(4);
            audience.fireListeners(event);
            context.setContextVariable("SCHEMAID", (Object)schema.getKey());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureTable(CaptureContext context, XMLNode[] nodes) {
        CaptureAudience audience = context.getAudience();
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        try {
            for (int i = 0; i < nodes.length; ++i) {
                String tableName = XMLHelper.getNodeValue((Node)nodes[i], (String)"TBLNAME");
                String tableId = XMLHelper.getNodeValue((Node)nodes[i], (String)"TBLID");
                String comments = XMLHelper.getNodeValue((Node)nodes[i], (String)"DESCRIPTION");
                DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
                MdTable table = new MdTable(schemaId, tableName, "[" + tableName + "]");
                table.addProperty(new AdditionalProperty(MSAccessMigrationAddinArb.getString(4), tableId), connectionId);
                if (comments != null && comments.length() > 0) {
                    table.setComments(comments);
                }
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)138), table.getTableName());
                audience.fireListeners(event);
                table = (MdTable)this.getStorer().storeObject((PersistableObject)table);
                this.m_IdCache.put(new AccessId(tableId, "MD_TABLES"), table.getKey());
                event.setEventId(4);
                audience.fireListeners(event);
                this.captureTableDetails(context, table, (Node)nodes[i]);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureTableDetails(CaptureContext context, MdTable table, Node node) {
        Node columnNode = XMLHelper.getChildNode((Node)node, (String)"COLUMNS");
        XMLNode[] listofColumnNodes = XMLHelper.getChildNodes((Node)columnNode, (String)"COLUMN");
        this.captureColumnDetails(context, table, (Node[])listofColumnNodes);
        Node indexNode = XMLHelper.getChildNode((Node)node, (String)"INDEXES");
        XMLNode[] listofIndexNodes = XMLHelper.getChildNodes((Node)indexNode, (String)"INDEX");
        this.captureIndexDetails(context, table, (Node[])listofIndexNodes);
    }

    private void captureColumnDetails(CaptureContext context, MdTable table, Node[] listofColumnNodes) {
        CaptureAudience audience = context.getAudience();
        try {
            for (int i = 0; i < listofColumnNodes.length; ++i) {
                MdColumn column;
                Node node = listofColumnNodes[i];
                String columnName = XMLHelper.getNodeValue((Node)node, (String)"COLNAME");
                String columnType = XMLHelper.getNodeValue((Node)node, (String)"COLTYPEDESC");
                String isNullString = XMLHelper.getNodeValue((Node)node, (String)"COLREQUIRED");
                String autoIncrement = XMLHelper.getNodeValue((Node)node, (String)"COLAUTOINCR");
                String columnId = XMLHelper.getNodeValue((Node)node, (String)"COLID");
                String nextCount = XMLHelper.getNodeValue((Node)node, (String)"NEXTCOUNTERVALUE");
                String colTextSize = XMLHelper.getNodeValue((Node)node, (String)"COLTEXTSIZE");
                String defaultValue = XMLHelper.getNodeValue((Node)node, (String)"DEFAULTVALUE");
                String columnComments = XMLHelper.getNodeValue((Node)node, (String)"COLUMNDESCRIPTION");
                DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                if (autoIncrement.equals("1")) {
                    long seed = Long.parseLong(nextCount);
                    column = new MdIdentityColumn(table.getKey(), columnName, Integer.valueOf(i + 1), seed, 1L, connectionId);
                    column.setNullable("N");
                } else {
                    column = new MdColumn(table.getKey(), columnName, Integer.valueOf(i + 1));
                    if (isNullString.equals("1")) {
                        column.setNullable("Y");
                    } else {
                        column.setNullable("N");
                    }
                }
                column.setColumnType(columnType);
                if (columnType.equals("Text")) {
                    column.setPrecision(Integer.valueOf(colTextSize));
                }
                if (defaultValue != null && defaultValue.length() > 0) {
                    column.setDefaultValue(defaultValue);
                    column.addProperty(new AdditionalProperty("ACCESS_HAS_DEFAULT", "Y"), connectionId);
                }
                if (columnComments != null && columnComments.length() > 0) {
                    column.setComments(columnComments);
                }
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)134), column.getColumnName());
                audience.fireListeners(event);
                column = (MdColumn)this.getStorer().storeObject((PersistableObject)column);
                this.m_IdCache.put(new AccessId(columnId, "MD_COLUMNS"), column.getKey());
                event.setEventId(4);
                audience.fireListeners(event);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureIndexDetails(CaptureContext context, MdTable table, Node[] listofIndexNodes) {
        CaptureAudience audience = context.getAudience();
        try {
            for (int i = 0; i < listofIndexNodes.length; ++i) {
                CaptureEvent event;
                Node node = listofIndexNodes[i];
                String indexName = XMLHelper.getNodeValue((Node)node, (String)"INDNAME");
                String isPrimary = XMLHelper.getNodeValue((Node)node, (String)"ISPRIMARY");
                if (isPrimary.equals("1")) {
                    MdConstraint constraint = new MdConstraint(table.getKey(), MY_LANGUAGE_ID);
                    constraint.setName(indexName);
                    constraint.setConstraintType("PK");
                    event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                    this.createIndexDetails(context, constraint, node);
                    continue;
                }
                MdIndexe index = new MdIndexe(table.getKey());
                index.setIndexName(indexName);
                index.setIndexType("NON_UNIQUE");
                event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), index.getIndexName());
                audience.fireListeners(event);
                index = (MdIndexe)this.getStorer().storeObject((PersistableObject)index);
                event.setEventId(4);
                audience.fireListeners(event);
                this.createNonUniqueIndexDetails(context, index, node);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void createNonUniqueIndexDetails(CaptureContext context, MdIndexe index, Node node) {
        try {
            Node indexColumnNode = XMLHelper.getChildNode((Node)node, (String)"INDEX_COLUMNS");
            XMLNode[] listofIndexColumnNodes = XMLHelper.getChildNodes((Node)indexColumnNode, (String)"INDEX_COLUMN");
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            for (int i = 0; i < listofIndexColumnNodes.length; ++i) {
                MdColumn pkcol;
                XMLNode columnNode = listofIndexColumnNodes[i];
                String indexColName = XMLHelper.getNodeValue((Node)columnNode, (String)"COLNAME");
                DBObjectId colId = util.getIdForColumn(index.getTableId(), indexColName);
                MdIndexDetail indexDetail = new MdIndexDetail(index.getKey(), colId, Integer.valueOf(i + 1));
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)143), index.getIndexName());
                context.getAudience().fireListeners(event);
                indexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)indexDetail);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                if (!index.getIndexType().equals("PRIMARY") || !(pkcol = (MdColumn)util.loadPersistableObject(colId, "MD_COLUMNS")).getNullable().equals("Y")) continue;
                pkcol.setNullable("N");
                pkcol = (MdColumn)this.getStorer().storeObject((PersistableObject)pkcol);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void createIndexDetails(CaptureContext context, MdConstraint index, Node node) {
        try {
            Node indexColumnNode = XMLHelper.getChildNode((Node)node, (String)"INDEX_COLUMNS");
            XMLNode[] listofIndexColumnNodes = XMLHelper.getChildNodes((Node)indexColumnNode, (String)"INDEX_COLUMN");
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            for (int i = 0; i < listofIndexColumnNodes.length; ++i) {
                XMLNode columnNode = listofIndexColumnNodes[i];
                String indexColName = XMLHelper.getNodeValue((Node)columnNode, (String)"COLNAME");
                DBObjectId colId = util.getIdForColumn(index.getTableId(), indexColName);
                MdConstraintDetail constraintDetail = new MdConstraintDetail(index.getKey(), Integer.valueOf(i + 1));
                constraintDetail.setColumnId(colId);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), index.getName());
                context.getAudience().fireListeners(event);
                constraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintDetail);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureUsers(CaptureContext context, XMLNode[] nodes) {
        CaptureAudience audience = context.getAudience();
        try {
            for (int i = 0; i < nodes.length; ++i) {
                String userName = XMLHelper.getNodeValue((Node)nodes[i], (String)"USERNAME");
                DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
                MdUser user = new MdUser(schemaId, userName);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)144), user.getUsername());
                audience.fireListeners(event);
                user = (MdUser)this.getStorer().storeObject((PersistableObject)user);
                event.setEventId(4);
                audience.fireListeners(event);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureGroups(CaptureContext context, XMLNode[] nodes) {
        CaptureAudience audience = context.getAudience();
        try {
            for (int i = 0; i < nodes.length; ++i) {
                String groupName = XMLHelper.getNodeValue((Node)nodes[i], (String)"GRPNAME");
                DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
                MdGroup group = new MdGroup(schemaId);
                group.setGroupName(groupName);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)145), group.getGroupName());
                audience.fireListeners(event);
                group = (MdGroup)this.getStorer().storeObject((PersistableObject)group);
                event.setEventId(4);
                audience.fireListeners(event);
                this.captureGroupDetails(context, group, nodes[i]);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureGroupDetails(CaptureContext context, MdGroup group, XMLNode node) {
        try {
            CaptureAudience audience = context.getAudience();
            DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
            XMLNode[] groupUsersNodes = XMLHelper.getChildNodes((Node)node, (String)"GROUPUSERS");
            for (int i = 0; i < groupUsersNodes.length; ++i) {
                XMLNode userNode = groupUsersNodes[i];
                String groupUserName = XMLHelper.getNodeValue((Node)userNode, (String)"GROUPUSER");
                MdGroupMember groupMember = new MdGroupMember(group.getKey());
                PersistenceUtility util = this.getStorer().getPersistenceUtility();
                DBObjectId groupMemberId = util.getIdForUser(schemaId, groupUserName);
                groupMember.setUserId(groupMemberId);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)146), groupUserName);
                audience.fireListeners(event);
                groupMember = (MdGroupMember)this.getStorer().storeObject((PersistableObject)groupMember);
                event.setEventId(4);
                audience.fireListeners(event);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureQueries(CaptureContext context, XMLNode[] nodes) {
        CaptureAudience audience = context.getAudience();
        try {
            for (int i = 0; i < nodes.length; ++i) {
                String viewName = XMLHelper.getNodeValue((Node)nodes[i], (String)"QRYNAME");
                String viewCreatedOn = XMLHelper.getNodeValue((Node)nodes[i], (String)"DATECREATED");
                String viewLastUpdatedOn = XMLHelper.getNodeValue((Node)nodes[i], (String)"LASTUPDATED");
                String viewNativeSQL = XMLHelper.getNodeValue((Node)nodes[i], (String)"QRYSQL");
                DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
                MdView view = new MdView(schemaId, MY_LANGUAGE_ID);
                view.setViewName(viewName);
                view.setCreatedOn(new Date(new Long(viewCreatedOn)));
                view.setLastUpdatedOn(new Date(new Long(viewLastUpdatedOn)));
                view.setNativeSql(viewNativeSQL);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)137), view.getViewName());
                audience.fireListeners(event);
                view = (MdView)this.getStorer().storeObject((PersistableObject)view);
                event.setEventId(4);
                audience.fireListeners(event);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureModules(CaptureContext context, XMLNode[] nodes) {
        CaptureAudience audience = context.getAudience();
        try {
            for (int i = 0; i < nodes.length; ++i) {
                String moduleName = XMLHelper.getNodeValue((Node)nodes[i], (String)"MODULENAME");
                XMLNode[] linesNos = XMLHelper.getChildNodes((Node)nodes[i], (String)"LINES");
                StringBuffer linesofCode = new StringBuffer();
                for (int j = 0; j < linesNos.length; ++j) {
                    linesofCode.append(linesNos[j].getTextContent());
                    linesofCode.append('\n');
                }
                DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
                MdStoredProgram storedProgram = new MdStoredProgram(schemaId, MY_LANGUAGE_ID);
                storedProgram.setName(moduleName);
                storedProgram.setNativeSql(linesofCode.toString());
                storedProgram.setProgramtype("PROCEDURE");
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)136), storedProgram.getName());
                audience.fireListeners(event);
                storedProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)storedProgram);
                event.setEventId(4);
                audience.fireListeners(event);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureRelations(CaptureContext context, XMLNode[] nodes) {
        try {
            for (int i = 0; i < nodes.length; ++i) {
                String relationName = XMLHelper.getNodeValue((Node)nodes[i], (String)"RELNAME");
                String parentTableId = XMLHelper.getNodeValue((Node)nodes[i], (String)"PARENTTBLID");
                String childTableId = XMLHelper.getNodeValue((Node)nodes[i], (String)"CHILDTBLID");
                String isDeleteCascade = XMLHelper.getNodeValue((Node)nodes[i], (String)"ISDELETECASCADE");
                String isEnforced = XMLHelper.getNodeValue((Node)nodes[i], (String)"ISENFORCED");
                DBObjectId refTableId = this.getId(parentTableId, "MD_TABLES");
                DBObjectId tableId = this.getId(childTableId, "MD_TABLES");
                MdConstraint constraint = new MdConstraint(tableId, MY_LANGUAGE_ID);
                constraint.setName(relationName);
                constraint.setReftableId(refTableId);
                constraint.setConstraintType("FOREIGN KEY");
                if (isEnforced.equals("1") && isDeleteCascade.equals("1")) {
                    constraint.setDeleteClause("CASCADE");
                }
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                context.getAudience().fireListeners(event);
                constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                Node relationColumnsNode = XMLHelper.getChildNode((Node)nodes[i], (String)"RELATION_COLUMNS");
                this.createRelationDetails(context, XMLHelper.getChildNodes((Node)relationColumnsNode, (String)"RELATION_COLUMN"), constraint);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void createRelationDetails(CaptureContext context, XMLNode[] nodes, MdConstraint constraint) {
        int constraintOrder = 1;
        try {
            for (int i = 0; i < nodes.length; ++i) {
                String relationParentColumnId = XMLHelper.getNodeValue((Node)nodes[i], (String)"PARENTCOLID");
                String relationChildColumnId = XMLHelper.getNodeValue((Node)nodes[i], (String)"CHILDCOLID");
                DBObjectId parentColumnId = this.getId(relationParentColumnId, "MD_COLUMNS");
                DBObjectId childColumnId = this.getId(relationChildColumnId, "MD_COLUMNS");
                constraintOrder = this.createConstraintDetails(constraint.getKey(), parentColumnId, "Y", constraintOrder, context);
                constraintOrder = this.createConstraintDetails(constraint.getKey(), childColumnId, "N", constraintOrder, context);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private int createConstraintDetails(DBObjectId migCon, DBObjectId colId, String flagIndicator, int constraintOrder, CaptureContext context) throws PersistenceException, SQLException {
        int order = constraintOrder;
        MdConstraintDetail detail = new MdConstraintDetail(migCon, Integer.valueOf(order++));
        detail.setColumnId(colId);
        detail.setRefFlag(flagIndicator);
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), "");
        context.getAudience().fireListeners(event);
        detail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)detail);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
        return order;
    }

    private DBObjectId getId(String accessId, String refType) {
        AccessId lookup = new AccessId(accessId, refType);
        return this.m_IdCache.get(lookup);
    }

    public void setTableCellRenderer() {
    }

    private static int toUAValue(String accessVersion) {
        if (accessVersion == null) {
            return 4096;
        }
        if (accessVersion.equals(VERSION_1997)) {
            return 256;
        }
        if (accessVersion.equals(VERSION_2000)) {
            return 512;
        }
        if (accessVersion.equals(VERSION_2002)) {
            return 1024;
        }
        if (accessVersion.equals(VERSION_2003)) {
            return 2048;
        }
        return 4096;
    }

    protected MigrationStorer getStorer() {
        return this.m_storer;
    }

    private static class AccessId {
        private String m_id;
        private String m_type;

        public AccessId(String id, String type) {
            this.setId(id);
            this.setType(type);
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
            result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccessId other = (AccessId)obj;
            if (this.m_id == null ? other.m_id != null : !this.m_id.equals(other.m_id)) {
                return false;
            }
            return !(this.m_type == null ? other.m_type != null : !this.m_type.equals(other.m_type));
        }

        public String getId() {
            return this.m_id;
        }

        public String getType() {
            return this.m_type;
        }

        protected void setId(String id) {
            this.m_id = id;
        }

        protected void setType(String type) {
            this.m_type = type;
        }
    }
}

