/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.access;

import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryKey;

public class MSAccessInstallLocator {
    private static final String ACCESS_97_REGISTRY = "SOFTWARE\\Microsoft\\Office\\8.0\\Access\\Options";
    private static final String ACCESS_97_INSTALL_LOCATION = "SOFTWARE\\Microsoft\\Office\\8.0\\";
    private static final String ACCESS_97_LOCATION_SEARCH_KEY = "BinDirPath";
    private static final String OFFICE_REGISTRY_KEY_LOCATION = "SOFTWARE\\Microsoft\\Office\\{0}.0\\Access\\InstallRoot";
    private static final String BINARY_LOCATION_SEARCH_KEY = "Path";
    private static final int MIN_SUPPORTED_ACCESS_VERSION = 8;
    private static final int MAX_SUPPORTED_ACCESS_VERSION = 11;
    private int m_minToFind;
    private int m_maxToFind;
    private ArrayList<AccessInstallInfo> m_installed;

    public MSAccessInstallLocator(int min, int max) {
        if (min < 8) {
            throw new IllegalArgumentException("min cannot be less than 8");
        }
        this.m_maxToFind = max;
        this.m_minToFind = min;
        this.m_installed = new ArrayList();
        this.doSearch();
    }

    public MSAccessInstallLocator() {
        this(8, 11);
    }

    private void doSearch() {
        for (int i = this.m_minToFind; i <= this.m_maxToFind; ++i) {
            if (i == 8) {
                this.checkForAccess97();
                continue;
            }
            String searchKey = MessageFormat.format(OFFICE_REGISTRY_KEY_LOCATION, i);
            try {
                RegistryKey rk = NativeHandler.getRegistry().getLocalMachineKey().openKey(searchKey, 131097L);
                String s = rk.getStringValue(BINARY_LOCATION_SEARCH_KEY);
                if (s != null) {
                    AccessInstallInfo installInfo = new AccessInstallInfo(i, s);
                    this.m_installed.add(installInfo);
                }
                rk.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkForAccess97() {
        String searchKey = ACCESS_97_REGISTRY;
        try {
            RegistryKey rk = NativeHandler.getRegistry().getLocalMachineKey().openKey(searchKey, 131097L);
            if (rk != null) {
                rk.close();
                searchKey = ACCESS_97_INSTALL_LOCATION;
                rk = NativeHandler.getRegistry().getLocalMachineKey().openKey(searchKey, 131097L);
                if (rk != null) {
                    String s = rk.getStringValue(ACCESS_97_LOCATION_SEARCH_KEY);
                    if (s != null) {
                        AccessInstallInfo info = new AccessInstallInfo(8, s);
                        this.m_installed.add(info);
                    }
                    rk.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AccessInstallInfo[] getInstalledVersions() {
        if (this.m_installed == null || this.m_installed.size() == 0) {
            return null;
        }
        AccessInstallInfo[] ret = new AccessInstallInfo[this.m_installed.size()];
        int index = this.m_installed.size() - 1;
        for (int i = 0; i < this.m_installed.size(); ++i) {
            ret[index--] = new AccessInstallInfo(this.m_installed.get(i));
        }
        return ret;
    }

    public static class AccessInstallInfo {
        private int m_version;
        private String m_installLocation;

        public AccessInstallInfo(int version, String installDir) {
            this.m_version = version;
            this.m_installLocation = installDir;
        }

        public AccessInstallInfo(AccessInstallInfo copy) {
            this(copy.getVersion(), copy.getInstallLocation());
        }

        public int getVersion() {
            return this.m_version;
        }

        public String getInstallLocation() {
            return this.m_installLocation;
        }

        public String toString() {
            return this.m_version + " installed at " + this.m_installLocation;
        }
    }
}

