/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.access;

import java.io.File;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.AccessExecutor;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MSAccessPlugin;
import oracle.dbtools.migration.workbench.plugin.MSAccessXMLExporterFileParser;
import oracle.dbtools.migration.workbench.plugin.access.MSAccessInstallLocator;

public class MSAccessOnlineCapturer
extends AbstractOnlineCapturer {
    private static final String ACCESS_EXE_NAME = "MSACCESS.EXE";
    private String m_mdbFile;
    private boolean m_alreadyCaptured;
    private File m_movedFile = null;
    private String m_originalName;

    public MSAccessOnlineCapturer(MigrationStorer storer, Connection sourceConnection, String mdbFile) {
        super(storer, sourceConnection);
        this.m_mdbFile = mdbFile;
        this.m_alreadyCaptured = false;
    }

    public CaptureQueries getCaptureQueries() {
        return new CaptureQueries(){

            public String getQueryForType(String type, MigrationObjectFilter filter) {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        if (this.m_alreadyCaptured) {
            return;
        }
        String xmlFile = this.executeAccessExporter(context);
        if (xmlFile == null) {
            if (this.m_movedFile != null) {
                MSAccessOnlineCapturer.moveBack(this.m_movedFile, this.m_originalName);
            }
            return;
        }
        MSAccessXMLExporterFileParser parser = new MSAccessXMLExporterFileParser(xmlFile, this.getStorer(), context);
        try {
            if (!parser.loadFile()) {
                throw new CaptureException((Throwable)new IllegalStateException("Failed to parse XML"));
            }
        }
        finally {
            if (this.m_movedFile != null) {
                MSAccessOnlineCapturer.moveBack(this.m_movedFile, this.m_originalName);
            }
        }
        this.m_alreadyCaptured = true;
    }

    private static void moveBack(File fileToMove, String originalName) {
        File orig = new File(originalName);
        String msg = MSAccessMigrationAddinArb.format(25, new Object[]{fileToMove.getAbsoluteFile(), originalName});
        Logger.getLogger("oracle.dbtools.migration").log(Level.FINE, msg);
        fileToMove.renameTo(orig);
    }

    public String getModelName() throws CaptureException {
        return MSAccessPlugin.getModelNameFromMDBFileName(this.m_mdbFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeAccessExporter(CaptureContext context) throws CaptureException {
        String mdeFile;
        MSAccessInstallLocator locator = new MSAccessInstallLocator();
        MSAccessInstallLocator.AccessInstallInfo[] installed = locator.getInstalledVersions();
        if (installed == null || installed.length == 0) {
            throw new CaptureException((Throwable)new IllegalStateException(MSAccessMigrationAddinArb.getString(23)));
        }
        String msAccessExe = installed[0].getInstallLocation() + ACCESS_EXE_NAME;
        AccessExecutor executor = new AccessExecutor(msAccessExe, mdeFile = MSAccessPlugin.getMDEFileForVersion(installed[0].getVersion()), this.m_mdbFile, null, true, false, false);
        String fileNameToFind = executor.getMonitorFile();
        File fSearch = new File(fileNameToFind);
        if (fSearch.exists()) {
            this.temporarilyMoveFile(fSearch);
        }
        CaptureEvent event = new CaptureEvent(6, "MDBFILE", this.m_mdbFile);
        context.getAudience().fireListeners(event);
        executor.start();
        event = new CaptureEvent(8, "Awaiting " + fileNameToFind, null);
        context.getAudience().fireListeners(event);
        while (true) {
            if (fSearch.exists()) {
                event.setEventSubject((Object)"Exported complete");
                context.getAudience().fireListeners(event);
                return fileNameToFind;
            }
            if (context.shouldCancel()) {
                return null;
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException iex) {
                if (context.shouldCancel()) return null;
                continue;
            }
            break;
        }
    }

    private void temporarilyMoveFile(File ftoMove) {
        File targ = ftoMove;
        while (targ.exists()) {
            int randomext = (int)(Math.random() * 10000.0);
            String tempFileName = ftoMove.getAbsolutePath() + "." + randomext;
            targ = new File(tempFileName);
        }
        this.m_originalName = ftoMove.getAbsolutePath();
        String msg = MSAccessMigrationAddinArb.format(24, new Object[]{this.m_originalName, targ.getAbsoluteFile()});
        Logger.getLogger("oracle.dbtools.migration").log(Level.FINE, msg);
        ftoMove.renameTo(targ);
        this.m_movedFile = targ;
    }
}

