/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.access;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.access.MSAccessOnlineCapturer;

public class MSAccessThirdPartyProvider
extends ThirdPartyDbProvider {
    private static final String SIG_DBQ = "DBQ=";

    public MSAccessThirdPartyProvider(Connection conn) {
        super(conn);
    }

    public OnlineCapturer getCapturer(MigrationStorer storer) {
        String mdbFile = MSAccessThirdPartyProvider.getMDBFileFromConnection(this.getConnection());
        MSAccessOnlineCapturer capturer = new MSAccessOnlineCapturer(storer, this.getConnection(), mdbFile);
        return capturer;
    }

    public String getConnectionLabel() {
        return MSAccessThirdPartyProvider.getMDBFileFromConnection(this.getConnection());
    }

    public static String getMDBFileFromConnection(Connection conn) {
        if (!conn.getClass().getName().equals("sun.jdbc.odbc.JdbcOdbcConnection")) {
            return null;
        }
        String url = null;
        try {
            Method m = conn.getClass().getMethod("getURL", null);
            Object ret = m.invoke((Object)conn, null);
            url = ret.toString();
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (InvocationTargetException e) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (SecurityException e) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (NoSuchMethodException e) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        String[] parts = url.split(";");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].startsWith(SIG_DBQ)) continue;
            String mdbFile = parts[i].substring(SIG_DBQ.length());
            return mdbFile.replace('/', '\\');
        }
        return null;
    }
}

