/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.common;

import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.plugin.common.InvalidDatabaseException;
import oracle.dbtools.migration.workbench.plugin.common.LinkTableDescriptor;
import oracle.dbtools.migration.workbench.plugin.common.MsAccessRegistry;
import oracle.dbtools.migration.workbench.plugin.common.NotOfficialJetDataTypeException;
import oracle.dbtools.migration.workbench.plugin.common.PHKey;
import oracle.dbtools.migration.workbench.plugin.common.ReplicaDatabaseException;
import oracle.dbtools.migration.workbench.plugin.common.SecuredDatabaseException;
import oracle.dbtools.migration.workbench.plugin.common.UnableToModifyAccessDatabaseException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoDatabase;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoField;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoQueryDef;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoTableDef;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoWorkspace;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.db.DBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MSAccessUtils {
    private static final float ERROR = -999.0f;
    private static final int REPLICATION_ID = 15;
    public static final int NO_DELETE_LOCAL = 1;
    public static final int RELATIONS_ALREADY_DELETED = 2;
    public static final int REL_DELETED_N_DONT_DELETE_LOCAL = 3;
    private static final String QUERY_LOAD_CONV_TABLES = "SELECT DERIVED_TYPE, DERIVED_ID, SRC_ID FROM MD_DERIVATIVES WHERE (DERIVED_TYPE = 'MD_TABLES' OR DERIVED_TYPE = 'MD_COLUMNS') AND DERIVED_TYPE = SRC_TYPE AND DERIVED_CONNECTION_ID_FK = ?";

    private MSAccessUtils() {
    }

    public static boolean confirmDaoVersion(String accessConn) {
        float version = MSAccessUtils.getVersion(accessConn);
        if ((double)version >= 4.0) {
            try {
                return MSAccessUtils.isDao36installed();
            }
            catch (Exception e) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Cannot determine if DAO 3.6 is installed for database " + accessConn), (String)"Error retrieving DAO version", (String)"f1_accessDAOerror_html");
                return false;
            }
        }
        try {
            return MSAccessUtils.isDao36installed();
        }
        catch (Exception e) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Cannot determine if DAO 3.6 is installed for database " + accessConn), (String)"Error retrieving DAO version", (String)"f1_accessDAOerror_html");
            return false;
        }
    }

    private static float getVersion(String accessConn) {
        Connections conns = Connections.getInstance();
        Connection conn = null;
        DatabaseMetaData mData = null;
        if (conns.isOracle(accessConn)) {
            return -999.0f;
        }
        Properties cInfo = conns.getConnectionInfo(accessConn);
        String connType = cInfo.getProperty("ConnectionType");
        if (!connType.equalsIgnoreCase("ACCESS")) {
            return -999.0f;
        }
        try {
            conn = conns.getConnection(accessConn);
        }
        catch (DBException e) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Cannot get a connection to the Access Database " + accessConn), (String)"Error Connecting to Access", (String)"f1_accessconnectionerror_html");
            return -999.0f;
        }
        try {
            mData = conn.getMetaData();
            String version = mData.getDatabaseProductVersion();
            float vsn = Float.parseFloat(version);
            return vsn;
        }
        catch (SQLException e) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Cannot get the version of the Access Database " + accessConn), (String)"Error retrieving version", (String)"f1_accessversionerror_html");
            return -999.0f;
        }
    }

    public static boolean isDao35installed() throws Exception {
        boolean bIsInstalled = false;
        String subKey = "CLSID\\{00000010-0000-0010-8000-00AA006D2EA4}";
        bIsInstalled = MSAccessUtils.isDaoVersionInstalled(subKey);
        return bIsInstalled;
    }

    public static boolean isDao36installed() throws Exception {
        boolean bIsInstalled = false;
        String subKey = "CLSID\\{00000100-0000-0010-8000-00AA006D2EA4}";
        bIsInstalled = MSAccessUtils.isDaoVersionInstalled(subKey);
        return bIsInstalled;
    }

    private static boolean isDaoVersionInstalled(String subKey) throws Exception {
        boolean bIsInstalled = false;
        MsAccessRegistry registry = new MsAccessRegistry();
        PHKey phkResult = new PHKey();
        long status = registry.regOpenKeyEx(Integer.MIN_VALUE, subKey, 0L, 131097, phkResult);
        bIsInstalled = status == 0L;
        status = registry.regCloseKey(phkResult);
        return bIsInstalled;
    }

    public static JDaoWorkspace getDAOWorkspace(String accessConn) throws JDaoException {
        float version = MSAccessUtils.getVersion(accessConn);
        if ((double)version < 4.0) {
            return new JDaoWorkspace(false);
        }
        return new JDaoWorkspace(true);
    }

    public static String getOdbcFromConnection(String accessConn) {
        String DSN = "";
        try {
            Connection conn = Connections.getInstance().getConnection(accessConn);
            String odbcString = conn.getMetaData().getURL();
            conn.close();
            DSN = odbcString.substring(10);
        }
        catch (DBException e) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (SQLException e) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return DSN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureValidDatabase(String dbName, boolean readOnly, boolean isAttachedDb) throws InvalidDatabaseException, UnsupportedEncodingException {
        JDaoDatabase db = null;
        try {
            db = new JDaoDatabase();
            db.open(dbName, true, readOnly);
            int tblCount = db.getTableCount();
            JDaoTableDef td = null;
            for (int i = 0; i < tblCount; ++i) {
                byte[] tblNameBytes = db.getTableName(i).getBytes("UTF-8");
                String tblName = new String(tblNameBytes, "UTF-8");
                td = new JDaoTableDef(db);
                td.open(tblName);
                String tableType = td.getTableTypeStr();
                if (tableType.equals("User Table")) {
                    try {
                        td.getIndexCount();
                    }
                    catch (JDaoException e) {
                        td.close();
                        td.deinit();
                        td = null;
                        throw new SecuredDatabaseException(e.getMessage() + "\n" + dbName + " is a secured database");
                    }
                    int fldCount = td.getFieldCount();
                    for (int j = 0; j < fldCount; ++j) {
                        String fldName = td.getFieldName(j);
                        short typeID = td.getFieldType(j);
                        String strType = JDaoField.strFieldType(typeID);
                        if (!JDaoField.isOfficialJetDataType(typeID)) {
                            throw new NotOfficialJetDataTypeException("Unoffical Datatype" + strType + "\n\nTable: " + tblName + ", Field: " + fldName);
                        }
                        if (!fldName.equalsIgnoreCase("s_GUID") && !fldName.equalsIgnoreCase("s_Lineage") && !fldName.equalsIgnoreCase("s_Generation") && typeID != 15) continue;
                        td.close();
                        td.deinit();
                        td = null;
                        throw new ReplicaDatabaseException(dbName + "is a replicated database." + "\n\nTable: " + tblName + ", Field: " + fldName);
                    }
                }
                td.close();
                td.deinit();
                td = null;
            }
        }
        catch (JDaoException e) {
            if (!isAttachedDb) {
                throw new InvalidDatabaseException(e.getMessage());
            }
            throw new InvalidDatabaseException("Attached Database: " + e.getMessage());
        }
        catch (NotOfficialJetDataTypeException e) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            boolean bl = false;
            return bl;
        }
        catch (ReplicaDatabaseException e) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            boolean bl = false;
            return bl;
        }
        catch (SecuredDatabaseException e) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                db.close();
                db.deinit();
                db = null;
            }
            catch (JDaoException e) {
                Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                return false;
            }
        }
        return true;
    }

    public static int createTableAttachment(JDaoDatabase db, String odbcConnect, LinkTableDescriptor tblInfo, String oracleConn, boolean removeLocalTables, boolean relationsAlreadyDeleted) throws UnableToModifyAccessDatabaseException {
        boolean lrelationsAlreadyDeleted = relationsAlreadyDeleted;
        boolean lremoveLocalTables = removeLocalTables;
        int returnCode = 0;
        try {
            String srcTableName = tblInfo.getSourceTable().getObjectName();
            String oraTableName = tblInfo.getTargetTableName();
            String localTableName = srcTableName + "_L";
            String attachedTableName = srcTableName + "_R";
            JDaoTableDef td2 = new JDaoTableDef(db);
            td2.create(attachedTableName);
            String oraDbUser = MSAccessUtils.getUserFromConnection(oracleConn);
            String qualifiedTableName = oraDbUser + "." + oraTableName;
            td2.setSourceTableName(qualifiedTableName.toUpperCase());
            td2.setConnect(odbcConnect);
            td2.append();
            td2.close();
            td2.deinit();
            td2 = null;
            if (removeLocalTables) {
                if (!relationsAlreadyDeleted) {
                    if (!MSAccessUtils.deleteAllRelations(db)) {
                        lremoveLocalTables = false;
                    }
                    lrelationsAlreadyDeleted = true;
                }
                MSAccessUtils.deleteLocalTable(db, srcTableName);
            } else {
                JDaoTableDef td = new JDaoTableDef(db);
                td.open(srcTableName);
                boolean success = MSAccessUtils.renameLocalTable(td, localTableName);
                td.close();
                td.deinit();
                td = null;
                if (!lremoveLocalTables) {
                    ++returnCode;
                }
                if (lrelationsAlreadyDeleted) {
                    returnCode += 2;
                }
            }
        }
        catch (JDaoException e1) {
            throw new UnableToModifyAccessDatabaseException(e1.getMessage());
        }
        return returnCode;
    }

    private static String getUserFromConnection(String oracleConn) {
        Properties cd = Connections.getInstance().getConnectionInfo(oracleConn);
        return cd.getProperty("USERNAME");
    }

    private static boolean deleteAllRelations(JDaoDatabase db) {
        try {
            int relcount = db.getRelationCount();
            ArrayList<String> relnames = new ArrayList<String>();
            for (int i = 0; i < relcount; ++i) {
                relnames.add(db.getRelationName(i));
            }
            for (String relname : relnames) {
                db.deleteRelation(relname);
            }
            return true;
        }
        catch (JDaoException e) {
            return false;
        }
    }

    private static boolean deleteLocalTable(JDaoDatabase db, String srcTableName) {
        try {
            db.deleteTable(srcTableName);
            return true;
        }
        catch (JDaoException e) {
            return false;
        }
    }

    private static boolean renameLocalTable(JDaoTableDef td, String srcTableName) {
        try {
            td.setName(srcTableName);
            return true;
        }
        catch (JDaoException e) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return false;
        }
    }

    public static void createMappingQuery(JDaoDatabase db, LinkTableDescriptor tblInfo) throws UnableToModifyAccessDatabaseException {
        try {
            String srcTableName = tblInfo.getSourceTableName();
            JDaoQueryDef qry = new JDaoQueryDef(db);
            qry.create(srcTableName);
            String attachedTableName = srcTableName + "_R";
            LinkedHashMap<MdColumn, MdColumn> cols = tblInfo.getColumns();
            MdColumn[] oracleCols = cols.keySet().toArray(new MdColumn[cols.size()]);
            MdColumn[] accessColumns = cols.values().toArray(new MdColumn[cols.size()]);
            String sql = " SELECT ";
            int i = 0;
            int numColumns = cols.size();
            for (int j = 0; j < cols.size(); ++j) {
                String srcColName = accessColumns[j].getColumnName();
                String oraColName = oracleCols[j].getColumnName();
                sql = ++i < numColumns - 1 ? sql + "[" + attachedTableName + "].[" + oraColName + "] AS [" + srcColName + "]," : sql + "[" + attachedTableName + "].[" + oraColName + "] AS [" + srcColName + "] FROM [" + attachedTableName + "]";
            }
            qry.setSQL(sql);
            qry.append();
            qry.close();
            qry.deinit();
            qry = null;
            Logger.getLogger("oracle.dbtools.migration").info("Link table for " + srcTableName + "created");
        }
        catch (JDaoException e) {
            throw new UnableToModifyAccessDatabaseException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<LinkTableDescriptor> getTablesInfo(DBObjectId modelId) {
        ArrayList<LinkTableDescriptor> tables = new ArrayList<LinkTableDescriptor>();
        MdSchema sourceSchema = null;
        MdSchema targetSchema = null;
        MdTable sourceTable = null;
        MdTable targetTable = null;
        CloseableResultSet crs = null;
        LinkTableDescriptor ltd = null;
        try {
            PersistenceManager pman = MigrationAddin.getPersistenceManager();
            PreparedStatement stmt = pman.getPreparedStatement(QUERY_LOAD_CONV_TABLES);
            stmt.setLong(1, modelId.getId());
            ResultSet rs = stmt.executeQuery();
            LinkedHashMap<MdColumn, MdColumn> columnNameMap = null;
            crs = new CloseableResultSet(null, rs);
            while (rs.next()) {
                String type = rs.getString(1);
                Long derivedId = rs.getLong(2);
                Long srcId = rs.getLong(3);
                if (type.equals("MD_TABLES")) {
                    if (ltd != null) {
                        if (columnNameMap == null || columnNameMap.size() == 0) {
                            throw new IllegalStateException("derived records not found");
                        }
                        ltd.setColumnMap(columnNameMap);
                        tables.add(ltd);
                    }
                    ltd = new LinkTableDescriptor();
                    columnNameMap = new LinkedHashMap<MdColumn, MdColumn>();
                    try {
                        sourceTable = MdTable.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)new DBObjectId(srcId.longValue()));
                        sourceSchema = MdSchema.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)sourceTable.getSchemaId());
                        targetTable = MdTable.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)new DBObjectId(derivedId.longValue()));
                        targetSchema = MdSchema.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)targetTable.getSchemaId());
                        if (sourceTable == null || sourceSchema == null || targetTable == null || targetTable == null) {
                            throw new IllegalStateException("derived records not found");
                        }
                        ltd = new LinkTableDescriptor(sourceSchema, sourceTable, targetSchema, targetTable);
                    }
                    catch (NoSuchObjectException nsoe) {
                        Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, nsoe.getLocalizedMessage());
                    }
                    catch (PersistenceException e) {
                        Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                    continue;
                }
                if (!type.equals("MD_COLUMNS")) continue;
                try {
                    columnNameMap.put(MdColumn.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)new DBObjectId(derivedId.longValue())), MdColumn.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)new DBObjectId(srcId.longValue())));
                }
                catch (NoSuchObjectException e) {
                    Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, e.getLocalizedMessage());
                }
                catch (PersistenceException e) {
                    Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        catch (SQLException e) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
        if (ltd != null) {
            tables.add(ltd);
        }
        return tables;
    }

    public static String getPathAndFileName(String DSN) {
        StringTokenizer st = new StringTokenizer(DSN, ";");
        st.nextToken();
        String filename = st.nextToken().substring(4);
        return filename;
    }
}

