/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.common;

import oracle.dbtools.migration.workbench.plugin.common.NumericAttrib;
import oracle.dbtools.migration.workbench.plugin.common.PHKey;
import oracle.dbtools.migration.workbench.plugin.common.TextAttrib;

public class MsAccessRegistry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_PERFORMANCE_DATA = -2147483644;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int HKEY_DYN_DATA = -2147483642;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_NOTIFY = 16;
    public static final int KEY_CREATE_LINK = 32;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_EXECUTE = 131097;
    public static final int KEY_READ = 131097;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static int REG_MULTI_SZ = 7;
    public static int REG_RESOURCE_LIST = 8;
    public static int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    public static final int REG_OPTION_NON_VOLATILE = 0;
    public static final int REG_OPTION_VOLATILE = 1;
    public static final int REG_OPTION_BACKUP_RESTORE = 4;
    public static final int ERROR_SUCCESS = 0;

    public MsAccessRegistry() throws Exception {
        try {
            System.loadLibrary("registry");
            System.loadLibrary("mfcdao");
        }
        catch (Error e) {
            throw new Exception(e.getMessage());
        }
    }

    private native String _getWindowsDirectory();

    private native String _getWindowsSystemDirectory();

    private native long _regOpenKeyEx(int var1, String var2, long var3, int var5, PHKey var6);

    private native long _regCloseKey(int var1);

    private native long _regDeleteKey(int var1, String var2);

    private native long _regDeleteValue(int var1, String var2);

    private native long _regSetValueEx(int var1, String var2, int var3, int var4, String var5, int var6);

    private native long _regSetValueEx(int var1, String var2, int var3, int var4, int var5);

    private native long _regSetValueEx(int var1, String var2, int var3, int var4, byte var5);

    private native long _regCreateKeyEx(int var1, String var2, int var3, String var4, int var5, int var6, String var7, PHKey var8, NumericAttrib var9);

    private native long _regEnumValue(int var1, int var2, TextAttrib var3, NumericAttrib var4, NumericAttrib var5, NumericAttrib var6, TextAttrib var7, NumericAttrib var8);

    private native long _regEnumKeyEx(int var1, int var2, TextAttrib var3, NumericAttrib var4, NumericAttrib var5, TextAttrib var6, NumericAttrib var7, NumericAttrib var8);

    private native boolean _jni_dao35_installed();

    private native boolean m_MigrationDao36_installed();

    public long regOpenKeyEx(int hKey, String subKey, long options, int samDesired, PHKey phkResult) {
        long status = this._regOpenKeyEx(hKey, subKey, options, samDesired, phkResult);
        return status;
    }

    public long regCloseKey(PHKey hkey) {
        int key = hkey.get();
        long status = this._regCloseKey(key);
        return status;
    }

    public long regDeleteKey(PHKey hkey, String subKey) {
        int key = hkey.get();
        long status = this._regDeleteKey(key, subKey);
        return status;
    }

    public long regDeleteValue(PHKey hkey, String valueName) {
        int key = hkey.get();
        long status = this._regDeleteValue(key, valueName);
        return status;
    }

    public long regEnumValue(PHKey hKey, int index, TextAttrib valueName, NumericAttrib cValueName, NumericAttrib reserved, NumericAttrib type, TextAttrib valueData, NumericAttrib cValueData) {
        int key = hKey.get();
        long status = this._regEnumValue(key, index, valueName, cValueName, reserved, type, valueData, cValueData);
        return status;
    }

    public long regEnumKeyEx(PHKey hKey, int index, TextAttrib keyName, NumericAttrib cKeyName, NumericAttrib reserved, TextAttrib className, NumericAttrib cClassName, NumericAttrib lastTimeWrite) {
        int key = hKey.get();
        long status = this._regEnumKeyEx(key, index, keyName, cKeyName, reserved, className, cClassName, lastTimeWrite);
        return status;
    }

    public long regSetValueEx(PHKey hKey, String valueName, int reserved, int type, String valueData, int dataBufferSize) {
        int key = hKey.get();
        long status = this._regSetValueEx(key, valueName, reserved, type, valueData, dataBufferSize);
        return status;
    }

    public long regSetTextValueEx(PHKey hKey, String valueName, int reserved, String valueData, int dataBufferSize) {
        int key = hKey.get();
        long status = this._regSetValueEx(key, valueName, reserved, 1, valueData, dataBufferSize);
        return status;
    }

    public long regSetNumericValueEx(PHKey hKey, String valueName, int reserved, int valueData) {
        int key = hKey.get();
        long status = this._regSetValueEx(key, valueName, reserved, 4, valueData);
        return status;
    }

    public long regSetBinaryValueEx(PHKey hKey, String valueName, int reserved, byte valueData) {
        int key = hKey.get();
        long status = this._regSetValueEx(key, valueName, reserved, 3, valueData);
        return status;
    }

    public long regCreateKeyEx(int hKey, String subKey, int reserved, String className, int options, int samDesired, String securityAttributes, PHKey phkResult, NumericAttrib disposition) {
        long status = this._regCreateKeyEx(hKey, subKey, reserved, className, options, samDesired, securityAttributes, phkResult, disposition);
        return status;
    }

    public boolean isDao35Installed() {
        boolean status = false;
        status = this._jni_dao35_installed();
        return status;
    }

    public String getWindowsDirectory() {
        String dir = this._getWindowsDirectory();
        return dir;
    }

    public String getWindowsSystemDirectory() {
        String dir = this._getWindowsSystemDirectory();
        return dir;
    }

    public boolean isDao36Installed() {
        boolean status = false;
        status = this.m_MigrationDao36_installed();
        return status;
    }
}

