/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import oracle.ojc.compiler.AnnotationElementValue;
import oracle.ojc.compiler.ArrayElementValue;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionElementValue;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodScope;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;

class Annotation {
    Annotation next;
    int pos;
    TypeSymbol annotationType;
    ArrayList elementValuePairs;
    private short typeIndex;
    boolean defaultValue;
    private Set suppressedWarningSet;
    private static Map supportedWarningTable;
    private static Identifier allIdentifier;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    static void initializeStatics() {
        supportedWarningTable = new Hashtable();
        Identifier ident = Identifier.getIdentifier("deprecation");
        supportedWarningTable.put(new Integer(Message.warningIsDeprecated.getNumber()), ident);
        supportedWarningTable.put(new Integer(Message.warningOverridesDeprecated.getNumber()), ident);
        ident = Identifier.getIdentifier("unchecked");
        supportedWarningTable.put(new Integer(Message.warningUncheckedConversion.getNumber()), ident);
        ident = Identifier.getIdentifier("cast");
        supportedWarningTable.put(new Integer(Message.warningUnnecessaryCast.getNumber()), ident);
        ident = Identifier.getIdentifier("empty");
        supportedWarningTable.put(new Integer(Message.warningEmptyStatement.getNumber()), ident);
        supportedWarningTable.put(new Integer(Message.warningSwitchWithoutCase.getNumber()), ident);
        supportedWarningTable.put(new Integer(Message.warningEmptyCatchStatement.getNumber()), ident);
        ident = Identifier.getIdentifier("fallthrough");
        supportedWarningTable.put(new Integer(Message.warningFallThrough.getNumber()), ident);
        ident = Identifier.getIdentifier("unread");
        Identifier otherIdent = Identifier.getIdentifier("unused");
        Identifier[] idents = new Identifier[]{ident, otherIdent};
        supportedWarningTable.put(new Integer(Message.warningVarAssignmentNeverRead.getNumber()), idents);
        supportedWarningTable.put(new Integer(Message.warningParameterNeverRead.getNumber()), idents);
        supportedWarningTable.put(new Integer(Message.warningVariableNeverRead.getNumber()), idents);
        supportedWarningTable.put(new Integer(Message.warningCatchVarNeverRead.getNumber()), idents);
        supportedWarningTable.put(new Integer(Message.warningMethodNeverCalled.getNumber()), idents);
        ident = Identifier.getIdentifier("finally");
        supportedWarningTable.put(new Integer(Message.warningUnterminatedFinally.getNumber()), ident);
        ident = Identifier.getIdentifier("serial");
        supportedWarningTable.put(new Integer(Message.warningNoSerialVersionUID.getNumber()), ident);
        ident = Identifier.getIdentifier("keyword");
        supportedWarningTable.put(new Integer(Message.warningKeywordShouldNotBeUsed.getNumber()), ident);
        ident = Identifier.getIdentifier("static");
        supportedWarningTable.put(new Integer(Message.warningStaticAccessWithObject.getNumber()), ident);
        ident = Identifier.getIdentifier("malformed");
        supportedWarningTable.put(new Integer(Message.warningMalformedInput.getNumber()), ident);
        allIdentifier = Identifier.getIdentifier("all");
    }

    static void releaseStatics() {
        supportedWarningTable = null;
        allIdentifier = null;
    }

    Annotation(TypeSymbol annotationType, int pos, boolean defaultValue) {
        this.annotationType = annotationType;
        this.pos = pos;
        this.defaultValue = defaultValue;
        this.elementValuePairs = new ArrayList();
    }

    void addExpressionElementValuePair(Identifier elementName, Expression expr, int pos) {
        this.elementValuePairs.add(new ExpressionElementValue(elementName, expr, pos, this.defaultValue, false));
    }

    void addAnnotationElementValuePair(Identifier elementName, Annotation annotation, int pos) {
        this.elementValuePairs.add(new AnnotationElementValue(elementName, annotation, pos, this.defaultValue, false));
    }

    void addArrayElementValuePair(Identifier elementName, ArrayList arrayElements, int pos) {
        this.elementValuePairs.add(new ArrayElementValue(elementName, arrayElements, pos, this.defaultValue, false));
    }

    static boolean isSuppressedWarning(Parser parser, Symbol symbol, int messageNumber) {
        Symbol containingScope;
        if (parser.options.sourceJDKVersion < 150) {
            return false;
        }
        Integer messageNumberInteger = new Integer(messageNumber);
        if (symbol != null && Annotation.suppressesWarning(parser, symbol, messageNumberInteger)) {
            return true;
        }
        if (parser.currentFieldSymbol != null) {
            containingScope = parser.currentFieldSymbol;
        } else if (parser.currentMethodSymbol != null) {
            containingScope = parser.currentMethodSymbol;
        } else if (parser.currentClassSymbol != null) {
            containingScope = parser.currentClassSymbol;
        } else {
            return false;
        }
        if (Annotation.suppressesWarning(parser, containingScope, messageNumberInteger)) {
            return true;
        }
        Scope scope = containingScope.scope;
        while (scope != null) {
            if (scope.kind == 2) {
                ClassScope classScope = (ClassScope)scope;
                if (Annotation.suppressesWarning(parser, classScope.classSymbol, messageNumberInteger)) {
                    return true;
                }
            } else {
                if (scope.kind != 3) break;
                MethodScope methodScope = (MethodScope)scope;
                if (Annotation.suppressesWarning(parser, methodScope.methodSymbol, messageNumberInteger)) {
                    return true;
                }
            }
            scope = scope.getOuterScope();
        }
        return false;
    }

    private static boolean suppressesWarning(Parser parser, Symbol symbol, Integer messageNumber) {
        if (symbol == null) {
            return false;
        }
        if ((symbol.symbolFlags & 1) != 0) {
            return true;
        }
        Annotation annotation = symbol.getAnnotations();
        while (annotation != null) {
            if (annotation.annotationType == parser.javaLangSuppressWarningsSymbol) {
                if (annotation.suppressedWarningSet != null && annotation.suppressedWarningSet.contains(messageNumber)) {
                    return true;
                }
                if (annotation.elementValuePairs.size() > 0) {
                    ElementValue elementValue = (ElementValue)annotation.elementValuePairs.get(0);
                    if (elementValue instanceof ExpressionElementValue) {
                        if (Annotation.suppressesWarning(annotation, symbol, (ExpressionElementValue)elementValue, messageNumber)) {
                            return true;
                        }
                    } else if (elementValue instanceof ArrayElementValue) {
                        ArrayElementValue elementValues = (ArrayElementValue)elementValue;
                        int x = 0;
                        while (x < elementValues.arrayElements.size()) {
                            if (Annotation.suppressesWarning(annotation, symbol, (ExpressionElementValue)elementValues.arrayElements.get(x), messageNumber)) {
                                return true;
                            }
                            ++x;
                        }
                    }
                }
            }
            annotation = annotation.next;
        }
        return false;
    }

    private static boolean suppressesWarning(Annotation annotation, Symbol symbol, ExpressionElementValue elementValue, Integer messageNumber) {
        Expression expression = elementValue.expr;
        if (expression instanceof StringConstantExpression) {
            boolean suppress = false;
            if (Identifier.compare(Annotation.allIdentifier.name, ((StringConstantExpression)expression).sval)) {
                symbol.symbolFlags = (byte)(symbol.symbolFlags | 1);
                suppress = true;
            } else {
                Object object = supportedWarningTable.get(messageNumber);
                if (object != null) {
                    if (object instanceof Identifier) {
                        suppress = Identifier.compare(((Identifier)object).name, ((StringConstantExpression)expression).sval);
                    } else {
                        Identifier[] idents = (Identifier[])object;
                        int x = 0;
                        while (x < idents.length) {
                            if (Identifier.compare(idents[x].name, ((StringConstantExpression)expression).sval)) {
                                suppress = true;
                                break;
                            }
                            ++x;
                        }
                    }
                }
            }
            if (suppress) {
                if (annotation.suppressedWarningSet == null) {
                    annotation.suppressedWarningSet = new HashSet();
                }
                annotation.suppressedWarningSet.add(messageNumber);
                return true;
            }
        }
        return false;
    }

    private byte stringToTarget(String str) {
        if (str.equals("TYPE")) {
            return 1;
        }
        if (str.equals("FIELD")) {
            return 2;
        }
        if (str.equals("METHOD")) {
            return 4;
        }
        if (str.equals("PARAMETER")) {
            return 8;
        }
        if (str.equals("CONSTRUCTOR")) {
            return 16;
        }
        if (str.equals("LOCAL_VARIABLE")) {
            return 32;
        }
        if (str.equals("ANNOTATION_TYPE")) {
            return 64;
        }
        return -128;
    }

    void resolveAnnotationType(Parser parser, Symbol symbol) {
        Annotation annot = this;
        while (annot != null) {
            annot.annotationType = annot.annotationType.resolveType(parser, this.pos, false, true, false);
            if (!annot.annotationType.isAnnotation()) {
                parser.error(Message.errorAnnotationExpected, this.pos, annot.annotationType.isErroneous());
                annot.annotationType = ParameterizedClassSymbol.errorClass;
            } else {
                String str;
                ExpressionElementValue eev;
                RawClassSymbol.AnnotationClassData acd;
                RawClassSymbol classSymbol;
                RawClassSymbol annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                annot.annotationType = annotationType;
                if ((annotationType.flags & 0x2000) == 0) {
                    if (!annotationType.isAccessible(parser.currentClassSymbol)) {
                        parser.error(Message.errorAccessError, annot.pos, false, annotationType.errorName());
                        annotationType.flags = (short)(annotationType.flags | 0x10);
                    }
                } else if (annotationType == parser.javaLangDeprecatedSymbol) {
                    symbol.deprecate();
                } else if (annotationType == parser.javaLangOverrideSymbol) {
                    if (symbol instanceof MethodSymbol) {
                        ((MethodSymbol)symbol).flags = (short)(((MethodSymbol)symbol).flags | 0x80);
                    }
                } else if (annotationType == parser.javaLangAnnotationTargetSymbol) {
                    if (symbol instanceof RawClassSymbol && (classSymbol = (RawClassSymbol)symbol).isAnnotation()) {
                        acd = (RawClassSymbol.AnnotationClassData)classSymbol.cd;
                        acd.target = 0;
                        int count = annot.elementValuePairs.size();
                        int i = 0;
                        while (i < count) {
                            try {
                                Object o = annot.elementValuePairs.get(i);
                                if (o instanceof ExpressionElementValue) {
                                    eev = (ExpressionElementValue)o;
                                    str = ((FieldExpression)eev.expr).field.identifier.toString();
                                    acd.target = (byte)(acd.target | this.stringToTarget(str));
                                } else {
                                    ArrayElementValue aev = (ArrayElementValue)o;
                                    ArrayList al = aev.arrayElements;
                                    int size = al.size();
                                    int j = 0;
                                    while (j < size) {
                                        eev = (ExpressionElementValue)al.get(j);
                                        str = ((FieldExpression)eev.expr).field.identifier.toString();
                                        acd.target = (byte)(acd.target | this.stringToTarget(str));
                                        ++j;
                                    }
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }
                } else if (annotationType == parser.javaLangAnnotationRetentionSymbol && symbol instanceof RawClassSymbol && (classSymbol = (RawClassSymbol)symbol).isAnnotation()) {
                    acd = (RawClassSymbol.AnnotationClassData)classSymbol.cd;
                    try {
                        eev = (ExpressionElementValue)annot.elementValuePairs.get(0);
                        str = ((FieldExpression)eev.expr).field.identifier.toString();
                        if (str.equals("SOURCE")) {
                            acd.retention = 0;
                        }
                        if (str.equals("CLASS")) {
                            acd.retention = 1;
                        }
                        acd.retention = (byte)2;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            annot = annot.next;
        }
    }

    void resolveAndCheck(Parser parser, Symbol symbol) {
        RawClassSymbol annotationType;
        Annotation annot = this;
        while (annot != null) {
            TypeSymbol typeSymbol;
            annot.annotationType = typeSymbol = annot.annotationType.resolveType(parser, annot.pos, false, true, false);
            if (!typeSymbol.isErroneous()) {
                annotationType = null;
                if (!annot.defaultValue) {
                    annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                    if ((annotationType.flags & 0x1000) != 0) {
                        parser.error(Message.errorDuplicateAnnotation, annot.pos, annotationType.isErroneous(), annotationType.errorName());
                        annotationType.flags = (short)(annotationType.flags | 0x10);
                    } else {
                        annotationType.flags = (short)(annotationType.flags | 0x1000);
                    }
                }
            }
            annot = annot.next;
        }
        annot = this;
        while (annot != null) {
            if (!annot.annotationType.isErroneous() && !annot.defaultValue) {
                annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                annotationType.flags = (short)(annotationType.flags & 0xFFFFEFFF);
            }
            annot = annot.next;
        }
        annot = this;
        while (annot != null) {
            if (!annot.annotationType.isErroneous()) {
                MethodSymbol methodSymbol;
                annotationType = null;
                if (!annot.defaultValue) {
                    annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                }
                int count = annot.elementValuePairs.size();
                int i = 0;
                while (i < count) {
                    ElementValue ev = (ElementValue)annot.elementValuePairs.get(i);
                    ev = ev.resolveAndCheck(parser, annot);
                    annot.elementValuePairs.set(i, ev);
                    if (annotationType != null && (methodSymbol = (MethodSymbol)annotationType.classScope.lookupSpecificSymbolInScope(ev.elementName, 8, true)) != null) {
                        methodSymbol.flags = (short)(methodSymbol.flags | 0x10);
                    }
                    ++i;
                }
                if (annotationType != null && annotationType.isAnnotation()) {
                    if (annotationType.isDeprecated() && !annotationType.isErroneous()) {
                        parser.warning(annotationType, Message.warningIsDeprecated, annot.pos, annotationType.errorName());
                    }
                    methodSymbol = annotationType.cd.methodList;
                    while (methodSymbol != null) {
                        if ((methodSymbol.flags & 0x71) == 0) {
                            parser.error(Message.errorMissingValue, annot.pos, false, methodSymbol.identifier.toString());
                        }
                        methodSymbol.flags = (short)(methodSymbol.flags & 0xFFFFFFEF);
                        methodSymbol = methodSymbol.nextInClass;
                    }
                }
                if (!annot.defaultValue && symbol != null) {
                    annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                    if ((symbol.getAnnotationTarget() & annotationType.cd.getAnnotationTarget()) == 0 && symbol.identifier != Identifier.packageInfoIdentifier) {
                        parser.error(Message.errorAnnotationIllegalTarget, annot.pos, annotationType.isErroneous(), annotationType.errorName(), symbol.kindName());
                    }
                }
            }
            annot = annot.next;
        }
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = Annotation.class$("oracle.ojc.compiler.Annotation");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void generateConstantPoolEntries(ClassFileWriter cfw, ConstantPool cp) {
        Annotation annot = this;
        while (annot != null) {
            if (!annot.annotationType.isErroneous()) {
                RawClassSymbol annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                if (!($a || annotationType != null && annotationType.cd instanceof RawClassSymbol.AnnotationClassData)) {
                    throw new AssertionError();
                }
                byte retention = annotationType.cd.getAnnotationRetention();
                if (annot.defaultValue || retention > 0) {
                    if (annot.defaultValue) {
                        if (cfw.annotationDefaultAttrIndex == 0) {
                            cfw.annotationDefaultAttrIndex = cp.enterConstantPoolUtf8(Identifier.annotationDefaultAttribute.name);
                        }
                    } else {
                        if (retention == 1) {
                            if (cfw.runtimeInvisibleAnnotationAttrIndex == 0) {
                                cfw.runtimeInvisibleAnnotationAttrIndex = cp.enterConstantPoolUtf8(Identifier.runtimeInvisibleAnnotationAttribute.name);
                            }
                        } else if (cfw.runtimeVisibleAnnotationAttrIndex == 0) {
                            cfw.runtimeVisibleAnnotationAttrIndex = cp.enterConstantPoolUtf8(Identifier.runtimeVisibleAnnotationAttribute.name);
                        }
                        annot.typeIndex = cp.enterConstantPoolUtf8(annot.annotationType.getSignature());
                    }
                    int count = annot.elementValuePairs.size();
                    int i = 0;
                    while (i < count) {
                        ElementValue ev = (ElementValue)annot.elementValuePairs.get(i);
                        ev.generateConstantPoolEntries(cfw, cp);
                        ++i;
                    }
                }
            }
            annot = annot.next;
        }
    }

    static void generateConstantPoolEntries(MethodSymbol methodSymbol, ClassFileWriter cfw, ConstantPool cp) {
        int argCount = methodSymbol.actualArgCount;
        int i = 0;
        while (i < argCount) {
            MethodVariableSymbol varSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
            if (varSymbol != null) {
                Annotation annot = varSymbol.annotation;
                while (annot != null) {
                    if (!annot.annotationType.isErroneous()) {
                        RawClassSymbol annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                        byte retention = annotationType.cd.getAnnotationRetention();
                        if (retention > 0) {
                            if (retention == 1) {
                                if (cfw.runtimeInvisibleParameterAnnotationAttrIndex == 0) {
                                    cfw.runtimeInvisibleParameterAnnotationAttrIndex = cp.enterConstantPoolUtf8(Identifier.runtimeInvisibleParameterAnnotationAttribute.name);
                                }
                            } else if (cfw.runtimeVisibleParameterAnnotationAttrIndex == 0) {
                                cfw.runtimeVisibleParameterAnnotationAttrIndex = cp.enterConstantPoolUtf8(Identifier.runtimeVisibleParameterAnnotationAttribute.name);
                            }
                            annot.typeIndex = cp.enterConstantPoolUtf8(annot.annotationType.getSignature());
                            int count = annot.elementValuePairs.size();
                            int j = 0;
                            while (j < count) {
                                ElementValue ev = (ElementValue)annot.elementValuePairs.get(j);
                                ev.generateConstantPoolEntries(cfw, cp);
                                ++j;
                            }
                        }
                    }
                    annot = annot.next;
                }
            }
            ++i;
        }
    }

    int getAttibuteCount() {
        boolean defaultFound = false;
        boolean visibleFound = false;
        boolean invisibleFound = false;
        Annotation annot = this;
        while (annot != null) {
            if (!annot.annotationType.isErroneous()) {
                RawClassSymbol annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                byte retention = annotationType.cd.getAnnotationRetention();
                if (annot.defaultValue || retention > 0) {
                    if (annot.defaultValue) {
                        defaultFound = true;
                    } else if (retention == 1) {
                        invisibleFound = true;
                    } else {
                        visibleFound = true;
                    }
                }
            }
            annot = annot.next;
        }
        int attrCount = 0;
        if (defaultFound) {
            ++attrCount;
        }
        if (invisibleFound) {
            ++attrCount;
        }
        if (visibleFound) {
            ++attrCount;
        }
        return attrCount;
    }

    static int getAttibuteCount(MethodSymbol methodSymbol) {
        boolean visibleFound = false;
        boolean invisibleFound = false;
        int argCount = methodSymbol.actualArgCount;
        int i = 0;
        while (i < argCount) {
            MethodVariableSymbol varSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
            if (varSymbol != null) {
                Annotation annot = varSymbol.annotation;
                while (annot != null) {
                    if (!annot.annotationType.isErroneous()) {
                        RawClassSymbol annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                        byte retention = annotationType.cd.getAnnotationRetention();
                        if (retention > 0) {
                            if (retention == 1) {
                                invisibleFound = true;
                            } else {
                                visibleFound = true;
                            }
                        }
                    }
                    annot = annot.next;
                }
            }
            ++i;
        }
        int attrCount = 0;
        if (invisibleFound) {
            ++attrCount;
        }
        if (visibleFound) {
            ++attrCount;
        }
        return attrCount;
    }

    int getAttributeLength() {
        int count = this.elementValuePairs.size();
        int size = 4;
        while (--count >= 0) {
            ElementValue ev = (ElementValue)this.elementValuePairs.get(count);
            size += ev.getAttributeLength();
        }
        return size;
    }

    void writeAnnotation(ClassFileWriter cfw) throws IOException {
        int count = this.elementValuePairs.size();
        int wbIdx = cfw.ensureWriteBufferCapacity(4);
        byte[] wb = cfw.writeBuffer;
        wb[wbIdx + 3] = (byte)count;
        wb[wbIdx + 2] = (byte)(count >> 8);
        wb[wbIdx + 1] = (byte)this.typeIndex;
        wb[wbIdx] = (byte)(this.typeIndex >> 8);
        cfw.writeBufferIndex = wbIdx + 4;
        int i = 0;
        while (i < count) {
            ElementValue ev = (ElementValue)this.elementValuePairs.get(i);
            ev.write(cfw);
            ++i;
        }
    }

    void write(ClassFileWriter cfw) throws IOException {
        byte[] wb;
        int wbIdx;
        short attrIndex;
        byte retention;
        RawClassSymbol annotationType;
        ElementValue ev = null;
        int annotInvisibleCount = 0;
        int annotVisibleCount = 0;
        int attrInvisibleLen = 2;
        int attrVisibleLen = 2;
        Annotation annot = this;
        while (annot != null) {
            if (!annot.annotationType.isErroneous()) {
                annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                retention = annotationType.cd.getAnnotationRetention();
                if (annot.defaultValue) {
                    if (!$a && annot.elementValuePairs.size() != 1) {
                        throw new AssertionError();
                    }
                    if (!$a && ev != null) {
                        throw new AssertionError();
                    }
                    ev = (ElementValue)annot.elementValuePairs.get(0);
                } else {
                    switch (retention) {
                        default: {
                            if (!$a) {
                                throw new AssertionError();
                            }
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            attrInvisibleLen += annot.getAttributeLength();
                            annotInvisibleCount = (short)(annotInvisibleCount + 1);
                            break;
                        }
                        case 2: {
                            attrVisibleLen += annot.getAttributeLength();
                            annotVisibleCount = (short)(annotVisibleCount + 1);
                            break;
                        }
                    }
                }
            }
            annot = annot.next;
        }
        if (annotInvisibleCount > 0) {
            attrIndex = cfw.runtimeInvisibleAnnotationAttrIndex;
            wbIdx = cfw.ensureWriteBufferCapacity(8);
            wb = cfw.writeBuffer;
            wb[wbIdx + 7] = (byte)annotInvisibleCount;
            wb[wbIdx + 6] = (byte)(annotInvisibleCount >> 8);
            wb[wbIdx + 5] = (byte)attrInvisibleLen;
            wb[wbIdx + 4] = (byte)(attrInvisibleLen >> 8);
            wb[wbIdx + 3] = (byte)(attrInvisibleLen >> 16);
            wb[wbIdx + 2] = (byte)(attrInvisibleLen >> 24);
            wb[wbIdx + 1] = (byte)attrIndex;
            wb[wbIdx] = (byte)(attrIndex >> 8);
            cfw.writeBufferIndex = wbIdx + 8;
            annot = this;
            while (annot != null) {
                if (!annot.annotationType.isErroneous() && !annot.defaultValue) {
                    annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                    retention = annotationType.cd.getAnnotationRetention();
                    if (retention == 1) {
                        annot.writeAnnotation(cfw);
                    }
                }
                annot = annot.next;
            }
        }
        if (annotVisibleCount > 0) {
            attrIndex = cfw.runtimeVisibleAnnotationAttrIndex;
            wbIdx = cfw.ensureWriteBufferCapacity(8);
            wb = cfw.writeBuffer;
            wb[wbIdx + 7] = (byte)annotVisibleCount;
            wb[wbIdx + 6] = (byte)(annotVisibleCount >> 8);
            wb[wbIdx + 5] = (byte)attrVisibleLen;
            wb[wbIdx + 4] = (byte)(attrVisibleLen >> 8);
            wb[wbIdx + 3] = (byte)(attrVisibleLen >> 16);
            wb[wbIdx + 2] = (byte)(attrVisibleLen >> 24);
            wb[wbIdx + 1] = (byte)attrIndex;
            wb[wbIdx] = (byte)(attrIndex >> 8);
            cfw.writeBufferIndex = wbIdx + 8;
            annot = this;
            while (annot != null) {
                if (!annot.annotationType.isErroneous() && !annot.defaultValue) {
                    annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                    retention = annotationType.cd.getAnnotationRetention();
                    if (retention == 2) {
                        annot.writeAnnotation(cfw);
                    }
                }
                annot = annot.next;
            }
        }
        if (ev != null) {
            int attrLen = ev.getAttributeLength();
            attrIndex = cfw.annotationDefaultAttrIndex;
            wbIdx = cfw.ensureWriteBufferCapacity(6);
            wb = cfw.writeBuffer;
            wb[wbIdx + 5] = (byte)attrLen;
            wb[wbIdx + 4] = (byte)(attrLen >> 8);
            wb[wbIdx + 3] = (byte)(attrLen >> 16);
            wb[wbIdx + 2] = (byte)(attrLen >> 24);
            wb[wbIdx + 1] = (byte)attrIndex;
            wb[wbIdx] = (byte)(attrIndex >> 8);
            cfw.writeBufferIndex = wbIdx + 6;
            ev.write(cfw);
        }
    }

    static void write(MethodSymbol methodSymbol, ClassFileWriter cfw) throws IOException {
        int annotCount;
        byte[] wb;
        int wbIdx;
        short attrIndex;
        byte retention;
        RawClassSymbol annotationType;
        Annotation annot;
        MethodVariableSymbol varSymbol;
        int attrInvisibleLen = 0;
        int attrVisibleLen = 0;
        int argCount = methodSymbol.actualArgCount;
        int argsToGenerate = 0;
        int i = 0;
        while (i < argCount) {
            varSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
            if (varSymbol != null) {
                ++argsToGenerate;
                annot = varSymbol.annotation;
                while (annot != null) {
                    if (!annot.annotationType.isErroneous()) {
                        annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                        retention = annotationType.cd.getAnnotationRetention();
                        switch (retention) {
                            default: {
                                if (!$a) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                            case 0: {
                                break;
                            }
                            case 1: {
                                attrInvisibleLen += annot.getAttributeLength();
                                break;
                            }
                            case 2: {
                                attrVisibleLen += annot.getAttributeLength();
                                break;
                            }
                        }
                    }
                    annot = annot.next;
                }
            }
            ++i;
        }
        if (attrInvisibleLen > 0) {
            attrIndex = cfw.runtimeInvisibleParameterAnnotationAttrIndex;
            wbIdx = cfw.ensureWriteBufferCapacity(7);
            wb = cfw.writeBuffer;
            wb[wbIdx + 6] = (byte)methodSymbol.argCount;
            wb[wbIdx + 5] = (byte)(attrInvisibleLen += argsToGenerate * 2 + 1);
            wb[wbIdx + 4] = (byte)(attrInvisibleLen >> 8);
            wb[wbIdx + 3] = (byte)(attrInvisibleLen >> 16);
            wb[wbIdx + 2] = (byte)(attrInvisibleLen >> 24);
            wb[wbIdx + 1] = (byte)attrIndex;
            wb[wbIdx] = (byte)(attrIndex >> 8);
            cfw.writeBufferIndex = wbIdx + 7;
            int i2 = 0;
            while (i2 < argCount) {
                varSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i2);
                if (varSymbol != null) {
                    annotCount = 0;
                    annot = varSymbol.annotation;
                    while (annot != null) {
                        if (!annot.annotationType.isErroneous() && !annot.defaultValue) {
                            annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                            retention = annotationType.cd.getAnnotationRetention();
                            if (retention == 1) {
                                annotCount = (short)(annotCount + 1);
                            }
                        }
                        annot = annot.next;
                    }
                    wbIdx = cfw.ensureWriteBufferCapacity(2);
                    wb = cfw.writeBuffer;
                    wb[wbIdx + 1] = (byte)annotCount;
                    wb[wbIdx] = (byte)(annotCount >> 8);
                    cfw.writeBufferIndex = wbIdx + 2;
                    if (annotCount > 0) {
                        annot = varSymbol.annotation;
                        while (annot != null) {
                            if (!annot.annotationType.isErroneous() && !annot.defaultValue) {
                                annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                                retention = annotationType.cd.getAnnotationRetention();
                                if (retention == 1) {
                                    annot.writeAnnotation(cfw);
                                }
                            }
                            annot = annot.next;
                        }
                    }
                }
                ++i2;
            }
        }
        if (attrVisibleLen > 0) {
            attrIndex = cfw.runtimeVisibleParameterAnnotationAttrIndex;
            wbIdx = cfw.ensureWriteBufferCapacity(7);
            wb = cfw.writeBuffer;
            wb[wbIdx + 6] = (byte)methodSymbol.argCount;
            wb[wbIdx + 5] = (byte)(attrVisibleLen += argsToGenerate * 2 + 1);
            wb[wbIdx + 4] = (byte)(attrVisibleLen >> 8);
            wb[wbIdx + 3] = (byte)(attrVisibleLen >> 16);
            wb[wbIdx + 2] = (byte)(attrVisibleLen >> 24);
            wb[wbIdx + 1] = (byte)attrIndex;
            wb[wbIdx] = (byte)(attrIndex >> 8);
            cfw.writeBufferIndex = wbIdx + 7;
            int i3 = 0;
            while (i3 < argCount) {
                varSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i3);
                if (varSymbol != null) {
                    annotCount = 0;
                    annot = varSymbol.annotation;
                    while (annot != null) {
                        if (!annot.annotationType.isErroneous() && !annot.defaultValue) {
                            annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                            retention = annotationType.cd.getAnnotationRetention();
                            if (retention == 2) {
                                annotCount = (short)(annotCount + 1);
                            }
                        }
                        annot = annot.next;
                    }
                    wbIdx = cfw.ensureWriteBufferCapacity(2);
                    wb = cfw.writeBuffer;
                    wb[wbIdx + 1] = (byte)annotCount;
                    wb[wbIdx] = (byte)(annotCount >> 8);
                    cfw.writeBufferIndex = wbIdx + 2;
                    if (annotCount > 0) {
                        annot = varSymbol.annotation;
                        while (annot != null) {
                            if (!annot.annotationType.isErroneous() && !annot.defaultValue) {
                                annotationType = ((ClassSymbol)annot.annotationType).getClassSymbol();
                                retention = annotationType.cd.getAnnotationRetention();
                                if (retention == 2) {
                                    annot.writeAnnotation(cfw);
                                }
                            }
                            annot = annot.next;
                        }
                    }
                }
                ++i3;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

