/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class ArrayInitializerExpression
extends Expression {
    Expression arrayExpr;
    ExpressionList initializers;

    ArrayInitializerExpression(Expression arrayExpr, ExpressionList initializers, int pos) {
        super((byte)50, pos);
        this.arrayExpr = arrayExpr;
        this.initializers = initializers;
    }

    /*
     * Enabled aggressive block sorting
     */
    Expression resolveAndCheck(Parser parser) {
        this.arrayExpr = this.arrayExpr.resolveAndCheck(parser);
        TypeSymbol typeSymbol = this.arrayExpr.getType();
        if (typeSymbol.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
        TypeSymbol elemType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
        ExpressionList el = this.initializers;
        while (el != null) {
            block18: {
                if (el.expr.takeAssignmentContext()) {
                    parser.assignmentContext = elemType;
                }
                Expression expr = el.expr.resolveAndCheck(parser);
                TypeSymbol exprType = expr.getType();
                if (!elemType.isErroneous() && !exprType.isErroneous()) {
                    if ((elemType.typeClass & 0xFFFFFFC0) != 0) {
                        if ((exprType.typeClass & 0xFFFFFFC0) == 0) {
                            if (parser.options.sourceJDKVersion >= 150 && exprType.isPrimitiveType() && BoxingExpression.getPrimitiveType(parser, elemType) != null) {
                                el.expr = expr.promoteType(parser, elemType);
                                break block18;
                            } else {
                                Error error = parser.error(Message.errorIncompatibleTypes, expr.pos, false, exprType.errorName(), elemType.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                        ReferenceTypeSymbol eRefSymbol = (ReferenceTypeSymbol)exprType;
                        ReferenceTypeSymbol rRefSymbol = (ReferenceTypeSymbol)elemType;
                        if (!eRefSymbol.isAssignmentCompatible(parser, rRefSymbol)) {
                            Error error = parser.error(Message.errorIncompatibleTypes, expr.pos, false, exprType.errorName(), elemType.errorName());
                            return new ErrorExpression(error);
                        }
                        elemType.checkForUncheckedConversion(parser, expr.pos, exprType, false);
                        el.expr = expr.promoteType(parser, elemType);
                    } else if ((elemType.typeClass & 2) != 0) {
                        if ((exprType.typeClass & 2) == 0) {
                            if (parser.options.sourceJDKVersion >= 150 && exprType.isReferenceType() && BoxingExpression.getPrimitiveType(parser, exprType) != null) {
                                el.expr = expr.promoteType(parser, elemType);
                            } else {
                                Error error = parser.error(Message.errorIncompatibleTypes, expr.pos, false, exprType.errorName(), elemType.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                    } else {
                        if ((exprType.typeClass & 0xFFFFFFC2) != 0) {
                            if (parser.options.sourceJDKVersion >= 150 && exprType.isReferenceType() && BoxingExpression.getPrimitiveType(parser, exprType) != null) {
                                el.expr = expr.promoteType(parser, elemType);
                            } else {
                                Error error = parser.error(Message.errorIncompatibleTypes, expr.pos, false, exprType.errorName(), elemType.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                        el.expr = expr.promoteType(parser, elemType);
                    }
                }
            }
            el = el.next;
        }
        this.setType(this.arrayExpr.getType());
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.arrayExpr.generateByteCode(byteCodeGenerator);
        TypeSymbol typeSymbol = this.arrayExpr.getType();
        ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
        TypeSymbol exprType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
        int index = 0;
        ExpressionList el = this.initializers;
        while (el != null) {
            byteCodeGenerator.generate_8((byte)89);
            byteCodeGenerator.incOpStackHeight(1);
            IntConstantExpression.generateByteCodeIntConstant(byteCodeGenerator, index);
            Expression expr = el.expr;
            expr.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.generate_8(ArrayExpression.astore_opcode[exprType.typeKind]);
            byteCodeGenerator.decOpStackHeight((exprType.typeClass & 0x28) != 0 ? 4 : 3);
            ++index;
            el = el.next;
        }
    }
}

