/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;

final class ArraySymbol
extends ReferenceTypeSymbol {
    TypeSymbol baseType;
    int dimension;
    char[] signature;
    char[] genericSignature;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    private ArraySymbol(int pos, TypeSymbol baseType, int dimension) {
        super(pos, baseType.identifier, (byte)11, baseType.access, null);
        this.baseType = baseType;
        this.dimension = dimension;
    }

    boolean isErroneous() {
        return this.baseType.isErroneous();
    }

    String errorName() {
        if (this.isErroneous()) {
            return "";
        }
        return Message.arrayString + " " + this.toString();
    }

    char[] getSignature() {
        if (this.signature == null) {
            this.signature = this.getSignature(false);
        }
        return this.signature;
    }

    char[] getGenericSignature() {
        if (this.genericSignature == null) {
            this.genericSignature = this.getSignature(true);
        }
        return this.genericSignature;
    }

    protected void toString(StringBuffer sb) {
        this.baseType.toString(sb);
        int dim = this.dimension;
        int i = 0;
        while (i < dim) {
            sb.append("[]");
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        this.toString(sb);
        return sb.toString();
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol recursionCheck) {
        if (typeSymbol instanceof ArraySymbol) {
            ArraySymbol arr = (ArraySymbol)typeSymbol;
            if (arr.dimension != this.dimension) {
                return false;
            }
            return this.baseType.equalTo(arr.baseType, recursionCheck);
        }
        return false;
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy) {
        return ArraySymbol.getArrayType(this.baseType.resolveType(parser, pos, mustBePublic, checkActualTypeParameters, lazy), this.dimension);
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy, boolean checkAccess) {
        return ArraySymbol.getArrayType(this.baseType.resolveType(parser, pos, mustBePublic, checkActualTypeParameters, lazy, checkAccess), this.dimension);
    }

    boolean isUnresolvedType() {
        return this.baseType.isUnresolvedType();
    }

    boolean isArrayType() {
        return true;
    }

    boolean isReifiable() {
        return this.baseType.isReifiable();
    }

    boolean involvesGenerics() {
        return this.baseType.involvesGenerics();
    }

    void checkDeprecated(Parser parser, int pos) {
        this.baseType.checkDeprecated(parser, pos);
    }

    boolean involvesTypeParameter() {
        return this.baseType.involvesTypeParameter();
    }

    boolean containsTypeParameterDefinedBy(Symbol definedBySymbol) {
        return this.baseType.containsTypeParameterDefinedBy(definedBySymbol);
    }

    boolean containsTypeParameter(TypeParameterSymbol tps) {
        return this.baseType.containsTypeParameter(tps);
    }

    void getTypeParameterSymbol(ArrayList al) {
        this.baseType.getTypeParameterSymbol(al);
    }

    void changeScope(Scope scope) {
        this.baseType.changeScope(scope);
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList tpl) {
        this.baseType.replaceUnresolvedTypeParameters(tpl);
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList tpl) {
        TypeSymbol newBaseType = this.baseType.replaceTypeParameters(tpl);
        if (newBaseType != this.baseType) {
            return ArraySymbol.getArrayType(newBaseType, this.dimension);
        }
        return this;
    }

    TypeSymbol applyTypeVariables(TypeParameterList tpl, TypeVariableList tvl, boolean topLevel) {
        TypeSymbol newBaseType = this.baseType.applyTypeVariables(tpl, tvl, true);
        if (newBaseType != this.baseType) {
            return ArraySymbol.getArrayType(newBaseType, this.dimension);
        }
        return this;
    }

    TypeSymbol eraseType() {
        TypeSymbol newBaseType = this.baseType.eraseType();
        if (newBaseType != this.baseType) {
            return ArraySymbol.getArrayType(newBaseType, this.dimension);
        }
        return this;
    }

    boolean isAccessible(ClassSymbol fromClass) {
        return this.baseType.isAccessible(fromClass);
    }

    private char[] getSignature(boolean isGeneric) {
        char[] baseTypeName = isGeneric ? this.baseType.getGenericSignature() : this.baseType.getSignature();
        int dim = this.dimension;
        int size = dim + baseTypeName.length;
        char[] arraySignature = new char[size];
        System.arraycopy(baseTypeName, 0, arraySignature, dim, baseTypeName.length);
        while (--dim >= 0) {
            arraySignature[dim] = 91;
        }
        return arraySignature;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = ArraySymbol.class$("oracle.ojc.compiler.ArraySymbol");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    static TypeSymbol getArrayType(TypeSymbol baseType, int dimension) {
        TypeSymbol arrayType;
        if (!$a && dimension < 0) {
            throw new AssertionError();
        }
        if (baseType.isArrayType()) {
            ArraySymbol arraySymbol = (ArraySymbol)baseType;
            dimension += arraySymbol.dimension;
            baseType = arraySymbol.baseType;
        }
        TypeSymbol[] arrayTypes = baseType.arrayTypes;
        if (baseType.arrayTypes == null) {
            arrayTypes = new TypeSymbol[dimension < 10 ? 10 : dimension + 1];
            arrayTypes[0] = baseType;
            if (dimension == 0) {
                arrayType = baseType;
            } else {
                arrayTypes[dimension] = arrayType = new ArraySymbol(baseType.pos, baseType, dimension);
            }
            baseType.arrayTypes = arrayTypes;
        } else if (arrayTypes.length <= dimension) {
            arrayTypes = new TypeSymbol[dimension + 5];
            System.arraycopy(baseType.arrayTypes, 0, arrayTypes, 0, baseType.arrayTypes.length);
            arrayTypes[dimension] = arrayType = new ArraySymbol(baseType.pos, baseType, dimension);
        } else if (arrayTypes[dimension] == null) {
            arrayTypes[dimension] = arrayType = new ArraySymbol(baseType.pos, baseType, dimension);
        } else {
            arrayType = arrayTypes[dimension];
        }
        return arrayType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

