/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class AssignmentBitOperationExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    AssignmentBitOperationExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos, leftOperand, rightOperand);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol commonType;
        Expression leftOp = this.leftOperand;
        byte kind = leftOp.kind;
        if (kind != 1 && kind != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, leftOp.pos, kind == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        leftOp = leftOp.resolveAndCheckReadBeforeWrite(parser);
        kind = leftOp.kind;
        if (kind != 1 && kind != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, kind == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        Expression rightOp = this.rightOperand;
        rightOp = rightOp.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        TypeSymbol rightOpType = rightOp.getType();
        if ((leftOpType.typeKind != 2 || rightOpType.typeKind != 2) && (commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType)).isErroneous() && (parser.options.sourceJDKVersion < 150 || leftOpType != TypeSymbol.booleanSymbol && !leftOpType.equalTo(parser.javaLangBooleanSymbol) || rightOpType != TypeSymbol.booleanSymbol && !rightOpType.equalTo(parser.javaLangBooleanSymbol))) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, rightOpType.isErroneous() | leftOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
            return new ErrorExpression(error);
        }
        this.setType(leftOpType);
        this.leftOperand = leftOp;
        this.rightOperand = rightOp;
        return this;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = AssignmentBitOperationExpression.class$("oracle.ojc.compiler.AssignmentBitOperationExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator, byte intOpcode, byte longOpcode) {
        TypeSymbol commonType;
        Expression leftOp = this.leftOperand;
        leftOp.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
        TypeSymbol leftOpType = leftOp.getType();
        TypeSymbol primitiveType = null;
        if (leftOpType.isReferenceType()) {
            primitiveType = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, leftOpType);
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, leftOpType, primitiveType);
            leftOpType = primitiveType;
        }
        Expression rightOp = this.rightOperand;
        TypeSymbol rightOpType = rightOp.getType();
        if ((leftOpType.typeClass & 2) != 0) {
            rightOp.generateByteCode(byteCodeGenerator);
            if (rightOpType.isReferenceType()) {
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, rightOpType, TypeSymbol.booleanSymbol);
            }
            byteCodeGenerator.generate_8(intOpcode);
            byteCodeGenerator.decOpStackHeight(1);
            commonType = TypeSymbol.booleanSymbol;
            int commonTypeClass = 2;
        } else {
            commonType = TypeSymbol.binaryNumericPromotion(byteCodeGenerator.parser, leftOpType, rightOpType);
            byte commonTypeClass = commonType.typeClass;
            byteCodeGenerator.generateWideningPrimitiveConversion(leftOpType.typeClass, commonTypeClass);
            rightOp.generateByteCode(byteCodeGenerator);
            if (rightOpType.isReferenceType()) {
                TypeSymbol typeSymbol = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, rightOpType);
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, rightOpType, typeSymbol);
                rightOpType = typeSymbol;
            }
            byteCodeGenerator.generateWideningPrimitiveConversion(rightOpType.typeClass, commonTypeClass);
            switch (commonTypeClass) {
                default: {
                    if (!$a) {
                        throw new AssertionError();
                    }
                }
                case 4: {
                    byteCodeGenerator.generate_8(intOpcode);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 8: {
                    byteCodeGenerator.generate_8(longOpcode);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
            }
            byteCodeGenerator.generateNarrowingPrimitiveConversion(commonTypeClass, leftOpType.typeKind);
        }
        if (primitiveType != null) {
            AutoBoxingExpression.generateByteCode(byteCodeGenerator, commonType, leftOp.getType());
        }
        this.generateByteCodeForAssignmentExpression(byteCodeGenerator, leftOp);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

