/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class AssignmentShiftOperationExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    AssignmentShiftOperationExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos, leftOperand, rightOperand);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol primitiveType;
        Expression leftOp = this.leftOperand;
        byte kind = leftOp.kind;
        if (kind != 1 && kind != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, leftOp.pos, kind == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        leftOp = leftOp.resolveAndCheckReadBeforeWrite(parser);
        kind = leftOp.kind;
        if (kind != 1 && kind != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, kind == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        Expression rightOp = this.rightOperand;
        rightOp = rightOp.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        if (!((leftOpType.typeClass & 0xC) != 0 || parser.options.sourceJDKVersion >= 150 && leftOpType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, leftOpType)) != null && (primitiveType.typeClass & 0xC) != 0)) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, leftOpType.isErroneous(), this.toString(), leftOpType.errorName());
            return new ErrorExpression(error);
        }
        this.setType(leftOpType);
        TypeSymbol rightOpType = rightOp.getType();
        if ((rightOpType.typeClass & 0xC) == 0) {
            if (parser.options.sourceJDKVersion < 150 || !rightOpType.isReferenceType() || (primitiveType = BoxingExpression.getPrimitiveType(parser, rightOpType)) == null || (primitiveType.typeClass & 0xC) == 0) {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, rightOpType.isErroneous(), this.toString(), rightOpType.errorName());
                return new ErrorExpression(error);
            }
        } else if (rightOpType != TypeSymbol.intSymbol) {
            CastExpression expr = new CastExpression(this.pos, rightOp, TypeSymbol.intSymbol);
            if (rightOp.kind == 2) {
                this.rightOperand = ((Expression)expr).resolveAndCheck(parser);
            } else {
                expr.setType(TypeSymbol.intSymbol);
                this.rightOperand = expr;
            }
        } else {
            this.rightOperand = rightOp;
        }
        return this;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = AssignmentShiftOperationExpression.class$("oracle.ojc.compiler.AssignmentShiftOperationExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator, byte intOpcode, byte longOpcode) {
        Expression leftOp = this.leftOperand;
        leftOp.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
        TypeSymbol leftOpType = leftOp.getType();
        TypeSymbol primitiveType = null;
        if (leftOpType.isReferenceType()) {
            primitiveType = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, leftOpType);
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, leftOpType, primitiveType);
            leftOpType = primitiveType;
        }
        Expression rightOp = this.rightOperand;
        rightOp.generateByteCode(byteCodeGenerator);
        TypeSymbol rightOpType = rightOp.getType();
        if (rightOpType.isReferenceType()) {
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, rightOpType, leftOpType);
            TypeSymbol typeSymbol = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, rightOpType);
            byteCodeGenerator.generateNarrowingPrimitiveConversion(typeSymbol.typeClass, (byte)6);
        }
        switch (leftOpType.typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8(intOpcode);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8(longOpcode);
                break;
            }
        }
        byteCodeGenerator.generateNarrowingPrimitiveConversion(leftOpType.typeClass, leftOpType.typeKind);
        byteCodeGenerator.decOpStackHeight(1);
        if (primitiveType != null) {
            AutoBoxingExpression.generateByteCode(byteCodeGenerator, primitiveType, leftOp.getType());
        }
        this.generateByteCodeForAssignmentExpression(byteCodeGenerator, leftOp);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

