/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BitExpression;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;

final class BitOrExpression
extends BitExpression {
    BitOrExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)19, pos, leftOperand, rightOperand);
    }

    Expression foldExpression() {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        if (leftOp.kind == 2 && rightOp.kind == 2) {
            switch (leftOp.getType().typeClass) {
                case 2: {
                    return new BooleanConstantExpression(this.pos, ((BooleanConstantExpression)leftOp).bval | ((BooleanConstantExpression)rightOp).bval);
                }
                case 4: {
                    return new IntConstantExpression(this.pos, this.getType(), ((ConstantExpression)leftOp).getIntConstValue() | ((ConstantExpression)rightOp).getIntConstValue());
                }
                case 8: {
                    return new LongConstantExpression(this.pos, ((LongConstantExpression)leftOp).lval | ((LongConstantExpression)rightOp).lval);
                }
            }
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.generateByteCode(byteCodeGenerator, (byte)-128, (byte)-127);
    }

    public String toString() {
        return "|";
    }
}

