/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LabeledStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SynchronizedStatement;
import oracle.ojc.compiler.TryStatement;

final class BreakStatement
extends Statement {
    LabelSymbol labelSymbol;
    LabelSymbol breakSymbol;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    BreakStatement(StatementList parent, int pos, LabelSymbol labelSymbol) {
        super(parent, pos, (byte)9);
        this.labelSymbol = labelSymbol;
    }

    void resolveAndCheck(Parser parser) {
        this.parent.updateDefUseSetsAfterBreak(parser, this.labelSymbol);
        if (this.labelSymbol != null) {
            LabeledStatement labeledStatement = this.labelSymbol.labeledStatement;
            if (labeledStatement != null) {
                this.breakSymbol = labeledStatement.breakLabelSymbol;
                if (this.breakSymbol == null) {
                    this.breakSymbol = new LabelSymbol(0, null);
                    this.breakSymbol.label = new Label();
                    labeledStatement.breakLabelSymbol = this.breakSymbol;
                }
            }
        } else {
            SwitchLoopList switchLoop = parser.innerSwitchLoop;
            if (switchLoop == null) {
                parser.error(Message.errorBreakOutside, this.pos, false);
            } else {
                this.breakSymbol = switchLoop.getBreakSymbol();
            }
        }
        if (this.next != null && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = BreakStatement.class$("oracle.ojc.compiler.BreakStatement");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Statement stmt;
        if (this.labelSymbol != null) {
            stmt = this.labelSymbol.labeledStatement;
        } else {
            SwitchLoopList sll = byteCodeGenerator.parser.innerSwitchLoop;
            if (!$a && sll == null) {
                throw new AssertionError();
            }
            stmt = sll.loopStmt != null ? sll.loopStmt : sll.switchStmt;
        }
        if (stmt != null) {
            StatementList statementList = this.parent;
            while (true) {
                if (!$a && statementList.parent == null) {
                    throw new AssertionError();
                }
                if (statementList.parent == stmt) break;
                switch (statementList.parent.kind) {
                    case 17: {
                        TryStatement tryStmt = (TryStatement)statementList.parent;
                        if (tryStmt.finallyBody == null || tryStmt.finallyBody == statementList) break;
                        if (byteCodeGenerator.parser.options.targetJDKVersion < 150) {
                            if (tryStmt.finallyLabel == null) {
                                tryStmt.finallyLabel = new Label();
                            }
                            byteCodeGenerator.generateBranch_jsr(tryStmt.finallyLabel);
                            break;
                        }
                        tryStmt.finallyBody.generateByteCode(byteCodeGenerator);
                        break;
                    }
                    case 15: {
                        SynchronizedStatement syncStmt = (SynchronizedStatement)statementList.parent;
                        byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, syncStmt.localVar);
                        byteCodeGenerator.generate_8((byte)-61);
                        byteCodeGenerator.decOpStackHeight(1);
                        break;
                    }
                }
                statementList = statementList.parent.parent;
            }
        }
        byteCodeGenerator.generateBranch_goto(this.breakSymbol.label);
    }

    boolean isLoopExitStatement() {
        return true;
    }

    boolean canReachNextStatement(boolean strict) {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

