/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.Hashtable;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.CodeGenerator;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.EnumMapClassSymbol;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Fixup;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;

final class ByteCodeGenerator
extends CodeGenerator {
    static final byte opc_nop = 0;
    static final byte opc_aconst_null = 1;
    static final byte opc_iconst_m1 = 2;
    static final byte opc_iconst_0 = 3;
    static final byte opc_iconst_1 = 4;
    static final byte opc_iconst_2 = 5;
    static final byte opc_iconst_3 = 6;
    static final byte opc_iconst_4 = 7;
    static final byte opc_iconst_5 = 8;
    static final byte opc_lconst_0 = 9;
    static final byte opc_lconst_1 = 10;
    static final byte opc_fconst_0 = 11;
    static final byte opc_fconst_1 = 12;
    static final byte opc_fconst_2 = 13;
    static final byte opc_dconst_0 = 14;
    static final byte opc_dconst_1 = 15;
    static final byte opc_bipush = 16;
    static final byte opc_sipush = 17;
    static final byte opc_ldc = 18;
    static final byte opc_ldc_w = 19;
    static final byte opc_ldc2_w = 20;
    static final byte opc_iload = 21;
    static final byte opc_lload = 22;
    static final byte opc_fload = 23;
    static final byte opc_dload = 24;
    static final byte opc_aload = 25;
    static final byte opc_iload_0 = 26;
    static final byte opc_iload_1 = 27;
    static final byte opc_iload_2 = 28;
    static final byte opc_iload_3 = 29;
    static final byte opc_lload_0 = 30;
    static final byte opc_lload_1 = 31;
    static final byte opc_lload_2 = 32;
    static final byte opc_lload_3 = 33;
    static final byte opc_fload_0 = 34;
    static final byte opc_fload_1 = 35;
    static final byte opc_fload_2 = 36;
    static final byte opc_fload_3 = 37;
    static final byte opc_dload_0 = 38;
    static final byte opc_dload_1 = 39;
    static final byte opc_dload_2 = 40;
    static final byte opc_dload_3 = 41;
    static final byte opc_aload_0 = 42;
    static final byte opc_aload_1 = 43;
    static final byte opc_aload_2 = 44;
    static final byte opc_aload_3 = 45;
    static final byte opc_iaload = 46;
    static final byte opc_laload = 47;
    static final byte opc_faload = 48;
    static final byte opc_daload = 49;
    static final byte opc_aaload = 50;
    static final byte opc_baload = 51;
    static final byte opc_caload = 52;
    static final byte opc_saload = 53;
    static final byte opc_istore = 54;
    static final byte opc_lstore = 55;
    static final byte opc_fstore = 56;
    static final byte opc_dstore = 57;
    static final byte opc_astore = 58;
    static final byte opc_istore_0 = 59;
    static final byte opc_istore_1 = 60;
    static final byte opc_istore_2 = 61;
    static final byte opc_istore_3 = 62;
    static final byte opc_lstore_0 = 63;
    static final byte opc_lstore_1 = 64;
    static final byte opc_lstore_2 = 65;
    static final byte opc_lstore_3 = 66;
    static final byte opc_fstore_0 = 67;
    static final byte opc_fstore_1 = 68;
    static final byte opc_fstore_2 = 69;
    static final byte opc_fstore_3 = 70;
    static final byte opc_dstore_0 = 71;
    static final byte opc_dstore_1 = 72;
    static final byte opc_dstore_2 = 73;
    static final byte opc_dstore_3 = 74;
    static final byte opc_astore_0 = 75;
    static final byte opc_astore_1 = 76;
    static final byte opc_astore_2 = 77;
    static final byte opc_astore_3 = 78;
    static final byte opc_iastore = 79;
    static final byte opc_lastore = 80;
    static final byte opc_fastore = 81;
    static final byte opc_dastore = 82;
    static final byte opc_aastore = 83;
    static final byte opc_bastore = 84;
    static final byte opc_castore = 85;
    static final byte opc_sastore = 86;
    static final byte opc_pop = 87;
    static final byte opc_pop2 = 88;
    static final byte opc_dup = 89;
    static final byte opc_dup_x1 = 90;
    static final byte opc_dup_x2 = 91;
    static final byte opc_dup2 = 92;
    static final byte opc_dup2_x1 = 93;
    static final byte opc_dup2_x2 = 94;
    static final byte opc_swap = 95;
    static final byte opc_iadd = 96;
    static final byte opc_ladd = 97;
    static final byte opc_fadd = 98;
    static final byte opc_dadd = 99;
    static final byte opc_isub = 100;
    static final byte opc_lsub = 101;
    static final byte opc_fsub = 102;
    static final byte opc_dsub = 103;
    static final byte opc_imul = 104;
    static final byte opc_lmul = 105;
    static final byte opc_fmul = 106;
    static final byte opc_dmul = 107;
    static final byte opc_idiv = 108;
    static final byte opc_ldiv = 109;
    static final byte opc_fdiv = 110;
    static final byte opc_ddiv = 111;
    static final byte opc_irem = 112;
    static final byte opc_lrem = 113;
    static final byte opc_frem = 114;
    static final byte opc_drem = 115;
    static final byte opc_ineg = 116;
    static final byte opc_lneg = 117;
    static final byte opc_fneg = 118;
    static final byte opc_dneg = 119;
    static final byte opc_ishl = 120;
    static final byte opc_lshl = 121;
    static final byte opc_ishr = 122;
    static final byte opc_lshr = 123;
    static final byte opc_iushr = 124;
    static final byte opc_lushr = 125;
    static final byte opc_iand = 126;
    static final byte opc_land = 127;
    static final byte opc_ior = -128;
    static final byte opc_lor = -127;
    static final byte opc_ixor = -126;
    static final byte opc_lxor = -125;
    static final byte opc_iinc = -124;
    static final byte opc_i2l = -123;
    static final byte opc_i2f = -122;
    static final byte opc_i2d = -121;
    static final byte opc_l2i = -120;
    static final byte opc_l2f = -119;
    static final byte opc_l2d = -118;
    static final byte opc_f2i = -117;
    static final byte opc_f2l = -116;
    static final byte opc_f2d = -115;
    static final byte opc_d2i = -114;
    static final byte opc_d2l = -113;
    static final byte opc_d2f = -112;
    static final byte opc_i2b = -111;
    static final byte opc_i2c = -110;
    static final byte opc_i2s = -109;
    static final byte opc_lcmp = -108;
    static final byte opc_fcmpl = -107;
    static final byte opc_fcmpg = -106;
    static final byte opc_dcmpl = -105;
    static final byte opc_dcmpg = -104;
    static final byte opc_ifeq = -103;
    static final byte opc_ifne = -102;
    static final byte opc_iflt = -101;
    static final byte opc_ifge = -100;
    static final byte opc_ifgt = -99;
    static final byte opc_ifle = -98;
    static final byte opc_if_icmpeq = -97;
    static final byte opc_if_icmpne = -96;
    static final byte opc_if_icmplt = -95;
    static final byte opc_if_icmpge = -94;
    static final byte opc_if_icmpgt = -93;
    static final byte opc_if_icmple = -92;
    static final byte opc_if_acmpeq = -91;
    static final byte opc_if_acmpne = -90;
    static final byte opc_goto = -89;
    static final byte opc_jsr = -88;
    static final byte opc_ret = -87;
    static final byte opc_tableswitch = -86;
    static final byte opc_lookupswitch = -85;
    static final byte opc_ireturn = -84;
    static final byte opc_lreturn = -83;
    static final byte opc_freturn = -82;
    static final byte opc_dreturn = -81;
    static final byte opc_areturn = -80;
    static final byte opc_return = -79;
    static final byte opc_getstatic = -78;
    static final byte opc_putstatic = -77;
    static final byte opc_getfield = -76;
    static final byte opc_putfield = -75;
    static final byte opc_invokevirtual = -74;
    static final byte opc_invokespecial = -73;
    static final byte opc_invokestatic = -72;
    static final byte opc_invokeinterface = -71;
    static final byte opc_new = -69;
    static final byte opc_newarray = -68;
    static final byte opc_anewarray = -67;
    static final byte opc_arraylength = -66;
    static final byte opc_athrow = -65;
    static final byte opc_checkcast = -64;
    static final byte opc_instanceof = -63;
    static final byte opc_monitorenter = -62;
    static final byte opc_monitorexit = -61;
    static final byte opc_wide = -60;
    static final byte opc_multianewarray = -59;
    static final byte opc_ifnull = -58;
    static final byte opc_ifnonnull = -57;
    static final byte opc_goto_w = -56;
    static final byte opc_jsr_w = -55;
    static final int INITIAL_CODE_BUFFER_SIZE = 4096;
    private static final byte[] short_load_opcode;
    private static final byte[] load_opcode;
    private static final byte[] short_store_opcode;
    private static final byte[] store_opcode;
    Parser parser;
    ConstantPool constantPool;
    MethodSymbol methodSymbol;
    private byte[] codeBuffer;
    private int codeBufferStartOffset;
    private int codeBufferIndex;
    private int prevLineOffset;
    private int prevLine;
    int lineNumberTableIndex;
    byte[] lineNumberTable;
    private int opStackHeight;
    private int maxOpStackHeight;
    Fixup fixupList;
    boolean wideFlag;
    boolean doingStringConcatonation;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = ByteCodeGenerator.class$("oracle.ojc.compiler.ByteCodeGenerator");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
        short_load_opcode = new byte[12];
        ByteCodeGenerator.short_load_opcode[10] = 42;
        ByteCodeGenerator.short_load_opcode[11] = 42;
        ByteCodeGenerator.short_load_opcode[2] = 26;
        ByteCodeGenerator.short_load_opcode[3] = 26;
        ByteCodeGenerator.short_load_opcode[4] = 26;
        ByteCodeGenerator.short_load_opcode[5] = 26;
        ByteCodeGenerator.short_load_opcode[6] = 26;
        ByteCodeGenerator.short_load_opcode[7] = 30;
        ByteCodeGenerator.short_load_opcode[8] = 34;
        ByteCodeGenerator.short_load_opcode[9] = 38;
        load_opcode = new byte[12];
        ByteCodeGenerator.load_opcode[10] = 25;
        ByteCodeGenerator.load_opcode[11] = 25;
        ByteCodeGenerator.load_opcode[2] = 21;
        ByteCodeGenerator.load_opcode[3] = 21;
        ByteCodeGenerator.load_opcode[4] = 21;
        ByteCodeGenerator.load_opcode[5] = 21;
        ByteCodeGenerator.load_opcode[6] = 21;
        ByteCodeGenerator.load_opcode[7] = 22;
        ByteCodeGenerator.load_opcode[8] = 23;
        ByteCodeGenerator.load_opcode[9] = 24;
        short_store_opcode = new byte[12];
        ByteCodeGenerator.short_store_opcode[10] = 75;
        ByteCodeGenerator.short_store_opcode[11] = 75;
        ByteCodeGenerator.short_store_opcode[2] = 59;
        ByteCodeGenerator.short_store_opcode[3] = 59;
        ByteCodeGenerator.short_store_opcode[4] = 59;
        ByteCodeGenerator.short_store_opcode[5] = 59;
        ByteCodeGenerator.short_store_opcode[6] = 59;
        ByteCodeGenerator.short_store_opcode[7] = 63;
        ByteCodeGenerator.short_store_opcode[8] = 67;
        ByteCodeGenerator.short_store_opcode[9] = 71;
        store_opcode = new byte[12];
        ByteCodeGenerator.store_opcode[10] = 58;
        ByteCodeGenerator.store_opcode[11] = 58;
        ByteCodeGenerator.store_opcode[2] = 54;
        ByteCodeGenerator.store_opcode[3] = 54;
        ByteCodeGenerator.store_opcode[4] = 54;
        ByteCodeGenerator.store_opcode[5] = 54;
        ByteCodeGenerator.store_opcode[6] = 54;
        ByteCodeGenerator.store_opcode[7] = 55;
        ByteCodeGenerator.store_opcode[8] = 56;
        ByteCodeGenerator.store_opcode[9] = 57;
    }

    ByteCodeGenerator(Parser parser, MethodSymbol methodSymbol) {
        this.parser = parser;
        this.constantPool = methodSymbol.definingClass.cd.ccd.constantPool;
        this.methodSymbol = methodSymbol;
        this.lineNumberTableIndex = 0;
        int estimatedLineCount = methodSymbol.cmd.estimatedLineCount;
        if (estimatedLineCount > 0) {
            this.lineNumberTable = new byte[estimatedLineCount * 4];
        }
        this.prevLineOffset = -1;
        this.codeBuffer = new byte[4096];
    }

    byte[] flushCodeBuffer(boolean enlargeCodeBuffer) {
        MethodSymbol methodSymbol = this.methodSymbol;
        int startOffset = this.codeBufferStartOffset;
        int index = this.codeBufferIndex;
        int methodCodeBufferSize = startOffset + index;
        byte[] methodCodeBuffer = new byte[methodCodeBufferSize];
        if (startOffset != 0) {
            System.arraycopy(methodSymbol.cmd.codeBuffer, 0, methodCodeBuffer, 0, startOffset);
        }
        try {
            System.arraycopy(this.codeBuffer, 0, methodCodeBuffer, startOffset, index);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.out.println("---------------------------------------------------------------------------");
            System.out.println("Unexpected ArrayIndexOutOfBoundsException in CodeGenerator.flushCodeBuffer:");
            System.out.println("CodeBuffer.length: " + this.codeBuffer.length);
            System.out.println("MethodCodeBuffer.length: " + methodCodeBuffer.length);
            System.out.println("StartOffset: " + startOffset);
            System.out.println("Index: " + index);
            System.out.println("Wide Flag: " + (this.wideFlag ? "true" : "false"));
            System.out.println("MethodSymbol: " + methodSymbol.errorName());
            System.out.println("---------------------------------------------------------------------------");
            throw ex;
        }
        methodSymbol.cmd.codeBuffer = methodCodeBuffer;
        this.codeBufferStartOffset = startOffset + index;
        this.codeBufferIndex = 0;
        if (this.codeBufferStartOffset >= 65534) {
            this.parser.error(Message.errorCodeSegmentTooLarge, methodSymbol.pos, false, methodSymbol.errorName());
            this.codeBuffer = new byte[this.codeBuffer.length * 2];
        } else if (enlargeCodeBuffer && this.codeBuffer.length < 32768) {
            this.codeBuffer = new byte[this.codeBuffer.length * 2];
        }
        return this.codeBuffer;
    }

    private void generateGotoFixup(boolean wideFlag, Label label) {
        this.generateFixup(wideFlag, label);
        this.fixupList.flags = (byte)(this.fixupList.flags | 2);
    }

    private void generateFixup(boolean wideFlag, Label label) {
        int index = this.codeBufferIndex;
        Fixup fixup = new Fixup(wideFlag, label, this.codeBufferStartOffset + index);
        if ((index += wideFlag ? 4 : 2) > this.codeBuffer.length) {
            this.flushCodeBuffer(true);
            index = wideFlag ? 4 : 2;
        }
        this.codeBufferIndex = index;
        fixup.next = this.fixupList;
        this.fixupList = fixup;
    }

    void setOpStackHeight(int height) {
        this.opStackHeight = height;
        if (this.opStackHeight > this.maxOpStackHeight) {
            this.maxOpStackHeight = this.opStackHeight;
        }
    }

    int getOpStackHeight() {
        return this.opStackHeight;
    }

    void incOpStackHeight(int by) {
        this.opStackHeight += by;
        if (this.opStackHeight > this.maxOpStackHeight) {
            this.maxOpStackHeight = this.opStackHeight;
        }
    }

    void decOpStackHeight(int by) {
        this.opStackHeight -= by;
        if (!$a && this.opStackHeight < 0) {
            throw new AssertionError();
        }
    }

    void generateTableFixup(short tableBaseAddress, Label label) {
        int index = this.codeBufferIndex;
        int offset = this.codeBufferStartOffset + index;
        Fixup fixup = new Fixup(true, label, offset);
        fixup.baseAdjustment = (short)(offset - tableBaseAddress);
        if ((index += 4) > this.codeBuffer.length) {
            this.flushCodeBuffer(true);
            index = 4;
        }
        this.codeBufferIndex = index;
        fixup.next = this.fixupList;
        this.fixupList = fixup;
    }

    void setLabel(Label label) {
        label.offset = this.codeBufferStartOffset + this.codeBufferIndex;
    }

    void generate_8(byte b) {
        int index = this.codeBufferIndex;
        if (index >= this.codeBuffer.length) {
            this.flushCodeBuffer(true);
            index = 0;
        }
        this.codeBuffer[index] = b;
        this.codeBufferIndex = index + 1;
    }

    void generate_8_8(byte b1, byte b2) {
        int index = this.codeBufferIndex;
        if (index >= this.codeBuffer.length - 1) {
            this.flushCodeBuffer(true);
            index = 0;
        }
        byte[] buffer = this.codeBuffer;
        buffer[index + 1] = b2;
        buffer[index] = b1;
        this.codeBufferIndex = index + 2;
    }

    void generate_8_8_8(byte b1, byte b2, byte b3) {
        int index = this.codeBufferIndex;
        if (index >= this.codeBuffer.length - 2) {
            this.flushCodeBuffer(true);
            index = 0;
        }
        byte[] buffer = this.codeBuffer;
        buffer[index + 2] = b3;
        buffer[index + 1] = b2;
        buffer[index] = b1;
        this.codeBufferIndex = index + 3;
    }

    void generate_8_16(byte b, short w) {
        int index = this.codeBufferIndex;
        if (index >= this.codeBuffer.length - 2) {
            this.flushCodeBuffer(true);
            index = 0;
        }
        byte[] buffer = this.codeBuffer;
        buffer[index + 2] = (byte)w;
        buffer[index + 1] = (byte)(w >> 8);
        buffer[index] = b;
        this.codeBufferIndex = index + 3;
    }

    void generate_8_8_16(byte b1, byte b2, short w) {
        int index = this.codeBufferIndex;
        if (index >= this.codeBuffer.length - 3) {
            this.flushCodeBuffer(true);
            index = 0;
        }
        byte[] buffer = this.codeBuffer;
        buffer[index + 3] = (byte)w;
        buffer[index + 2] = (byte)(w >> 8);
        buffer[index + 1] = b2;
        buffer[index] = b1;
        this.codeBufferIndex = index + 4;
    }

    void generate_16_16(short w1, short w2) {
        int index = this.codeBufferIndex;
        if (index >= this.codeBuffer.length - 3) {
            this.flushCodeBuffer(true);
            index = 0;
        }
        byte[] buffer = this.codeBuffer;
        buffer[index + 3] = (byte)w2;
        buffer[index + 2] = (byte)(w2 >> 8);
        buffer[index + 1] = (byte)w1;
        buffer[index] = (byte)(w1 >> 8);
        this.codeBufferIndex = index + 4;
    }

    void generate_8_16_8(byte b1, short w, byte b2) {
        int index = this.codeBufferIndex;
        if (index >= this.codeBuffer.length - 3) {
            this.flushCodeBuffer(true);
            index = 0;
        }
        byte[] buffer = this.codeBuffer;
        buffer[index + 3] = b2;
        buffer[index + 2] = (byte)w;
        buffer[index + 1] = (byte)(w >> 8);
        buffer[index] = b1;
        this.codeBufferIndex = index + 4;
    }

    void generate_32(int i) {
        int index = this.codeBufferIndex;
        if (index >= this.codeBuffer.length - 3) {
            this.flushCodeBuffer(true);
            index = 0;
        }
        byte[] buffer = this.codeBuffer;
        buffer[index + 3] = (byte)i;
        buffer[index + 2] = (byte)(i >> 8);
        buffer[index + 1] = (byte)(i >> 16);
        buffer[index] = (byte)(i >> 24);
        this.codeBufferIndex = index + 4;
    }

    void generateIntConst(int ival) {
        switch (ival) {
            default: {
                if (-128 <= ival && ival <= 127) {
                    this.generate_8_8((byte)16, (byte)ival);
                    break;
                }
                if (Short.MIN_VALUE <= ival && ival <= Short.MAX_VALUE) {
                    this.generate_8_16((byte)17, (short)ival);
                    break;
                }
                short index = this.constantPool.enterConstantPoolInteger(ival);
                if ((index & 0xFF00) != 0) {
                    this.generate_8_16((byte)19, index);
                    break;
                }
                this.generate_8_8((byte)18, (byte)index);
                break;
            }
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.generate_8((byte)(3 + ival));
                break;
            }
        }
    }

    void generateStringConst(char[] sval) {
        short index = this.constantPool.enterConstantPoolString(sval);
        if ((index & 0xFF00) != 0) {
            this.generate_8_16((byte)19, index);
        } else {
            this.generate_8_8((byte)18, (byte)index);
        }
    }

    void generateWideningPrimitiveConversion(byte fromTypeClass, byte toTypeClass) {
        block0 : switch (fromTypeClass) {
            default: {
                break;
            }
            case 4: {
                switch (toTypeClass) {
                    case 8: {
                        this.generate_8((byte)-123);
                        this.incOpStackHeight(1);
                        break block0;
                    }
                    case 16: {
                        this.generate_8((byte)-122);
                        break block0;
                    }
                    case 32: {
                        this.generate_8((byte)-121);
                        this.incOpStackHeight(1);
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (toTypeClass) {
                    case 16: {
                        this.generate_8((byte)-119);
                        this.decOpStackHeight(1);
                        break block0;
                    }
                    case 32: {
                        this.generate_8((byte)-118);
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                if (toTypeClass != 32) break;
                this.generate_8((byte)-115);
                this.incOpStackHeight(1);
                break;
            }
        }
    }

    void generateNarrowingPrimitiveConversion(byte fromTypeClass, byte toTypeKind) {
        block0 : switch (fromTypeClass) {
            default: {
                break;
            }
            case 32: {
                switch (toTypeKind) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.generate_8((byte)-114);
                        this.decOpStackHeight(1);
                        break block0;
                    }
                    case 7: {
                        this.generate_8((byte)-113);
                        break block0;
                    }
                    case 8: {
                        this.generate_8((byte)-112);
                        this.decOpStackHeight(1);
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                switch (toTypeKind) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.generate_8((byte)-117);
                        break block0;
                    }
                    case 7: {
                        this.generate_8((byte)-116);
                        this.incOpStackHeight(1);
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (toTypeKind) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.generate_8((byte)-120);
                        this.decOpStackHeight(1);
                        break block0;
                    }
                }
                break;
            }
        }
        if (toTypeKind == 3) {
            this.generate_8((byte)-111);
        } else if (toTypeKind == 5) {
            this.generate_8((byte)-109);
        } else if (toTypeKind == 4) {
            this.generate_8((byte)-110);
        }
    }

    void loadLocalVariable(TypeSymbol type, short varStackIndex) {
        byte typeKind = type.typeKind;
        if (varStackIndex <= 3) {
            this.generate_8((byte)(short_load_opcode[typeKind] + varStackIndex));
        } else if (varStackIndex < 256) {
            this.generate_8_8(load_opcode[typeKind], (byte)varStackIndex);
        } else {
            this.generate_8_8_16((byte)-60, load_opcode[typeKind], varStackIndex);
        }
        this.incOpStackHeight((type.typeClass & 0x28) != 0 ? 2 : 1);
    }

    void storeLocalVariable(TypeSymbol type, short varStackIndex) {
        byte typeKind = type.typeKind;
        if (varStackIndex <= 3) {
            this.generate_8((byte)(short_store_opcode[typeKind] + varStackIndex));
        } else if (varStackIndex < 256) {
            this.generate_8_8(store_opcode[typeKind], (byte)varStackIndex);
        } else {
            this.generate_8_8_16((byte)-60, store_opcode[typeKind], varStackIndex);
        }
        this.decOpStackHeight((type.typeClass & 0x28) != 0 ? 2 : 1);
    }

    void generateBranch_ifeq(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-102, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-103);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifne(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-103, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-102);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_iflt(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-100, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-101);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifge(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-101, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-100);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifgt(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-98, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-99);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifle(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-99, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-98);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmpeq(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-96, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-97);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmpne(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-97, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-96);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmplt(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-94, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-95);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmpge(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-95, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-94);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmpgt(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-92, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-93);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmple(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-93, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-92);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_acmpeq(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-90, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-91);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_acmpne(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-91, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-90);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifnonnull(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-58, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-57);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifnull(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-57, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-58);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_goto(Label label) {
        this.generate_8(this.wideFlag ? (byte)-56 : -89);
        this.generateGotoFixup(this.wideFlag, label);
    }

    void generateBranch_jsr(Label label) {
        this.generate_8(this.wideFlag ? (byte)-55 : -88);
        this.generateFixup(this.wideFlag, label);
    }

    RawClassSymbol generateOuterClassFieldAccessor(RawClassSymbol outerClass, RawClassSymbol innerClass, boolean ignoreSuperClasses) {
        RawClassSymbol classSymbol;
        short index;
        FieldSymbol dollarThisSymbol = this.parser.getThisDollarSymbol(innerClass);
        if (this.parser.currentMethodSymbol.isConstructor()) {
            InnerClassSymbol innerClassSymbol = (InnerClassSymbol)innerClass;
            InnerClassSymbol.HiddenArgumentList hal = innerClassSymbol.hiddenArgumentList;
            while (hal != null) {
                if (hal.fieldSymbol == dollarThisSymbol) {
                    this.loadLocalVariable(hal.type, hal.stackVarIndex);
                    break;
                }
                hal = hal.next;
            }
        } else {
            index = this.constantPool.enterConstantPoolFieldRef(innerClass.getInternalName(), dollarThisSymbol.identifier.name, ((Symbol)dollarThisSymbol).getSignature());
            this.generate_8_16((byte)-76, index);
        }
        while (outerClass != (classSymbol = innerClass.getOuterClass()) && !(outerClass.isInterface() ? classSymbol.implementsInterface(outerClass) : !ignoreSuperClasses && outerClass.isSuperclass(classSymbol))) {
            innerClass = classSymbol;
            dollarThisSymbol = this.parser.getThisDollarSymbol(innerClass);
            index = this.constantPool.enterConstantPoolFieldRef(innerClass.getInternalName(), dollarThisSymbol.identifier.name, ((Symbol)dollarThisSymbol).getSignature());
            this.generate_8_16((byte)-76, index);
        }
        return classSymbol;
    }

    MethodSymbol generateReadAccessor(FieldSymbol fieldSymbol) {
        int offset;
        byte[] methodBuffer;
        Identifier accessorName;
        MethodSymbol methodSymbol;
        String dollarSign;
        String dollarName = dollarSign = Identifier.dollarString;
        RawClassSymbol classSymbol = fieldSymbol.definingClass;
        RawClassSymbol fromClass = this.parser.currentClassSymbol;
        while (fromClass.isInnerClass()) {
            RawClassSymbol outerClass = fromClass.getOuterClass();
            if (classSymbol == outerClass) break;
            if (classSymbol.isSuperclass(outerClass)) {
                classSymbol = outerClass;
                break;
            }
            fromClass = outerClass;
        }
        while ((methodSymbol = (MethodSymbol)classSymbol.classScope.lookupSpecificSymbolInScope(accessorName = Identifier.getIdentifier("ra" + dollarName + fieldSymbol.identifier.toString()), 8, true)) != null) {
            if ((methodSymbol.flags & 1) != 0) {
                return methodSymbol;
            }
            dollarName = dollarName + dollarSign;
        }
        methodSymbol = new MethodSymbol(0, classSymbol, accessorName, fieldSymbol.type, 0, 8, null, true);
        methodSymbol.flags = (short)(methodSymbol.flags | 0x21);
        if (!$a && !classSymbol.isCompiled()) {
            throw new AssertionError();
        }
        classSymbol.classScope.enterSymbol(methodSymbol);
        methodSymbol.nextInClass = classSymbol.cd.methodList;
        classSymbol.cd.methodList = methodSymbol;
        if ((fieldSymbol.access & 8) != 0) {
            methodBuffer = new byte[4];
            methodBuffer[0] = -78;
            offset = 1;
        } else {
            ArgumentVariableSymbol arg = new ArgumentVariableSymbol(0, methodSymbol, null, classSymbol, 0, 0, null, 0);
            methodSymbol.cmd.localVariables.add(arg);
            methodSymbol.argumentList = new ArgumentVariableList(arg);
            methodSymbol.localVarCount = 1;
            methodSymbol.actualArgCount = 1;
            methodSymbol.argCount = 1;
            methodBuffer = new byte[5];
            methodBuffer[0] = 42;
            methodBuffer[1] = -76;
            offset = 2;
        }
        switch (fieldSymbol.type.typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 2: 
            case 4: {
                methodBuffer[offset + 2] = -84;
                methodSymbol.cmd.maxOpStackDepth = 1;
                break;
            }
            case -128: 
            case 64: {
                methodBuffer[offset + 2] = -80;
                methodSymbol.cmd.maxOpStackDepth = 1;
                break;
            }
            case 8: {
                methodBuffer[offset + 2] = -83;
                methodSymbol.cmd.maxOpStackDepth = 2;
                break;
            }
            case 16: {
                methodBuffer[offset + 2] = -82;
                methodSymbol.cmd.maxOpStackDepth = 1;
                break;
            }
            case 32: {
                methodBuffer[offset + 2] = -81;
                methodSymbol.cmd.maxOpStackDepth = 2;
                break;
            }
        }
        if (classSymbol.cd.ccd.constantPool == null) {
            classSymbol.cd.ccd.constantPool = new ConstantPool(this.parser);
        }
        short index = classSymbol.cd.ccd.constantPool.enterConstantPoolFieldRef(classSymbol.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
        methodBuffer[offset + 1] = (byte)index;
        methodBuffer[offset] = (byte)(index >> 8);
        methodSymbol.cmd.codeBuffer = methodBuffer;
        return methodSymbol;
    }

    MethodSymbol generateWriteAccessor(FieldSymbol fieldSymbol) {
        byte[] methodBuffer;
        Identifier accessorName;
        MethodSymbol methodSymbol;
        String dollarSign;
        String dollarName = dollarSign = Identifier.dollarString;
        RawClassSymbol classSymbol = fieldSymbol.definingClass;
        RawClassSymbol fromClass = this.parser.currentClassSymbol;
        while (fromClass.isInnerClass()) {
            RawClassSymbol outerClass = fromClass.getOuterClass();
            if (classSymbol == outerClass) break;
            if (classSymbol.isSuperclass(outerClass)) {
                classSymbol = outerClass;
                break;
            }
            fromClass = outerClass;
        }
        while ((methodSymbol = (MethodSymbol)classSymbol.classScope.lookupSpecificSymbolInScope(accessorName = Identifier.getIdentifier("wa" + dollarName + fieldSymbol.identifier.toString()), 8, true)) != null) {
            if ((methodSymbol.flags & 1) != 0) {
                return methodSymbol;
            }
            dollarName = dollarName + dollarSign;
        }
        methodSymbol = new MethodSymbol(0, classSymbol, accessorName, TypeSymbol.voidSymbol, 0, 8, null, true);
        methodSymbol.flags = (short)(methodSymbol.flags | 0x21);
        if (!$a && !classSymbol.isCompiled()) {
            throw new AssertionError();
        }
        classSymbol.classScope.enterSymbol(methodSymbol);
        methodSymbol.nextInClass = classSymbol.cd.methodList;
        classSymbol.cd.methodList = methodSymbol;
        if (classSymbol.cd.ccd.constantPool == null) {
            classSymbol.cd.ccd.constantPool = new ConstantPool(this.parser);
        }
        short index = classSymbol.cd.ccd.constantPool.enterConstantPoolFieldRef(classSymbol.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
        int argCount = 0;
        if ((fieldSymbol.access & 8) != 0) {
            byte loadOpcode;
            switch (fieldSymbol.type.typeClass) {
                default: {
                    if (!$a) {
                        throw new AssertionError();
                    }
                }
                case 2: 
                case 4: {
                    loadOpcode = 26;
                    methodSymbol.cmd.maxOpStackDepth = 1;
                    break;
                }
                case -128: 
                case 64: {
                    loadOpcode = 42;
                    methodSymbol.cmd.maxOpStackDepth = 1;
                    break;
                }
                case 8: {
                    loadOpcode = 30;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
                case 16: {
                    loadOpcode = 34;
                    methodSymbol.cmd.maxOpStackDepth = 1;
                    break;
                }
                case 32: {
                    loadOpcode = 38;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
            }
            short s = methodSymbol.localVarCount;
            methodSymbol.localVarCount = (short)(s + 1);
            ArgumentVariableSymbol arg = new ArgumentVariableSymbol(0, methodSymbol, null, fieldSymbol.type, 0, 0, null, s);
            methodSymbol.cmd.localVariables.add(arg);
            methodSymbol.argumentList = new ArgumentVariableList(arg);
            argCount = (short)(argCount + 1);
            methodBuffer = new byte[]{loadOpcode, -77, (byte)(index >> 8), (byte)index, -79};
        } else {
            byte loadOpcode;
            switch (fieldSymbol.type.typeClass) {
                default: {
                    if (!$a) {
                        throw new AssertionError();
                    }
                }
                case 2: 
                case 4: {
                    loadOpcode = 27;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
                case -128: 
                case 64: {
                    loadOpcode = 43;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
                case 8: {
                    loadOpcode = 31;
                    methodSymbol.cmd.maxOpStackDepth = 3;
                    methodSymbol.localVarCount = (short)(methodSymbol.localVarCount + 1);
                    break;
                }
                case 16: {
                    loadOpcode = 35;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
                case 32: {
                    loadOpcode = 39;
                    methodSymbol.cmd.maxOpStackDepth = 3;
                    methodSymbol.localVarCount = (short)(methodSymbol.localVarCount + 1);
                    break;
                }
            }
            short s = methodSymbol.localVarCount;
            methodSymbol.localVarCount = (short)(s + 1);
            ArgumentVariableSymbol arg = new ArgumentVariableSymbol(0, methodSymbol, null, classSymbol, 0, 0, null, s);
            methodSymbol.cmd.localVariables.add(arg);
            methodSymbol.argumentList = new ArgumentVariableList(arg);
            argCount = (short)(argCount + 1);
            short s2 = methodSymbol.localVarCount;
            methodSymbol.localVarCount = (short)(s2 + 1);
            arg = new ArgumentVariableSymbol(0, methodSymbol, null, fieldSymbol.type, 0, 0, null, s2);
            methodSymbol.cmd.localVariables.add(arg);
            methodSymbol.argumentList.next = new ArgumentVariableList(arg);
            argCount = (short)(argCount + 1);
            methodBuffer = new byte[]{42, loadOpcode, -75, (byte)(index >> 8), (byte)index, -79};
        }
        methodSymbol.argCount = (short)argCount;
        methodSymbol.actualArgCount = methodSymbol.localVarCount;
        methodSymbol.cmd.codeBuffer = methodBuffer;
        return methodSymbol;
    }

    private int generateArgumentLoadForMethodAccessor(byte[] methodBuffer, int off, int varStackIndex, byte shortOpcode, byte opcode) {
        if (varStackIndex <= 3) {
            methodBuffer[off++] = (byte)(shortOpcode + varStackIndex);
        } else if (varStackIndex < 256) {
            methodBuffer[off++] = opcode;
            methodBuffer[off++] = (byte)varStackIndex;
        } else {
            methodBuffer[off++] = -60;
            methodBuffer[off++] = opcode;
            methodBuffer[off++] = (byte)(varStackIndex >> 8);
            methodBuffer[off++] = (byte)varStackIndex;
        }
        return off;
    }

    private MethodSymbol generateMethodAccessor(MethodSymbol methodSymbol, MethodSymbol accMethSym, byte invokeOpcode) {
        int stackDepth;
        int returnOpcode;
        RawClassSymbol classSymbol = accMethSym.definingClass;
        if (!$a && !classSymbol.isCompiled()) {
            throw new AssertionError();
        }
        if (classSymbol.cd.ccd.constantPool == null) {
            classSymbol.cd.ccd.constantPool = new ConstantPool(this.parser);
        }
        RawClassSymbol accessSymbol = invokeOpcode == -74 ? classSymbol : methodSymbol.definingClass;
        short index = classSymbol.cd.ccd.constantPool.enterConstantPoolMethodRef(accessSymbol.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
        int size = accMethSym.actualArgCount * 4 + 1 + 2 + 1;
        byte[] methodBuffer = new byte[size];
        int i = 0;
        int off = 0;
        int actualArgCount = accMethSym.actualArgCount;
        if ((accMethSym.access & 8) == 0) {
            --actualArgCount;
            off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i++, (byte)42, (byte)25);
        }
        if (methodSymbol.isConstructor() && methodSymbol.definingClass.isInnerClass()) {
            InnerClassSymbol innerClassSymbol = (InnerClassSymbol)methodSymbol.definingClass;
            InnerClassSymbol.HiddenArgumentList hal = innerClassSymbol.hiddenArgumentList;
            while (hal != null) {
                switch (hal.type.typeClass) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 2: 
                    case 4: {
                        off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)26, (byte)21);
                        break;
                    }
                    case -128: 
                    case 64: {
                        off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)42, (byte)25);
                        break;
                    }
                    case 8: {
                        off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)30, (byte)22);
                        ++i;
                        break;
                    }
                    case 16: {
                        off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)34, (byte)23);
                        break;
                    }
                    case 32: {
                        off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)38, (byte)24);
                        ++i;
                        break;
                    }
                }
                hal = hal.next;
                ++i;
            }
        }
        ArgumentVariableList sl = accMethSym.argumentList;
        while (i < actualArgCount) {
            ArgumentVariableSymbol arg = sl.argSymbol;
            accMethSym.cmd.localVariables.add(arg);
            switch (arg.type.typeClass) {
                default: {
                    if (!$a) {
                        throw new AssertionError();
                    }
                }
                case 2: 
                case 4: {
                    off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)26, (byte)21);
                    break;
                }
                case -128: 
                case 64: {
                    off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)42, (byte)25);
                    break;
                }
                case 8: {
                    off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)30, (byte)22);
                    ++i;
                    break;
                }
                case 16: {
                    off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)34, (byte)23);
                    break;
                }
                case 32: {
                    off = this.generateArgumentLoadForMethodAccessor(methodBuffer, off, i, (byte)38, (byte)24);
                    ++i;
                    break;
                }
            }
            sl = sl.next;
            ++i;
        }
        methodBuffer[off++] = invokeOpcode;
        methodBuffer[off++] = (byte)(index >> 8);
        methodBuffer[off++] = (byte)index;
        switch (accMethSym.resultType.typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 1: {
                returnOpcode = -79;
                stackDepth = 0;
                break;
            }
            case 2: 
            case 4: {
                returnOpcode = -84;
                stackDepth = 1;
                break;
            }
            case -128: 
            case 64: {
                returnOpcode = -80;
                stackDepth = 1;
                break;
            }
            case 8: {
                returnOpcode = -83;
                stackDepth = 2;
                break;
            }
            case 16: {
                returnOpcode = -82;
                stackDepth = 1;
                break;
            }
            case 32: {
                returnOpcode = -81;
                stackDepth = 2;
                break;
            }
        }
        methodBuffer[off++] = returnOpcode;
        if (accMethSym.cmd.maxOpStackDepth < stackDepth) {
            accMethSym.cmd.maxOpStackDepth = stackDepth;
        }
        accMethSym.cmd.codeBuffer = new byte[off];
        System.arraycopy(methodBuffer, 0, accMethSym.cmd.codeBuffer, 0, off);
        return accMethSym;
    }

    MethodSymbol generateMethodAccessor(MethodSymbol methodSymbol, byte invocationMode) {
        MethodSymbol accMethSym;
        Identifier accessorName;
        String dollarName;
        byte invokeOpcode;
        RawClassSymbol classSymbol = methodSymbol.definingClass;
        RawClassSymbol fromClass = this.parser.currentClassSymbol;
        while (fromClass.isInnerClass()) {
            RawClassSymbol outerClass = fromClass.getOuterClass();
            if (classSymbol == outerClass) break;
            if (classSymbol.isSuperclass(outerClass)) {
                classSymbol = outerClass;
                break;
            }
            fromClass = outerClass;
        }
        switch (invocationMode) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 1: {
                invokeOpcode = -73;
                dollarName = "s";
                break;
            }
            case 3: {
                invokeOpcode = -74;
                dollarName = "v";
                break;
            }
            case 4: {
                invokeOpcode = -72;
                dollarName = "S";
                break;
            }
        }
        ArgumentVariableList sl = methodSymbol.argumentList;
        if ((methodSymbol.access & 8) == 0) {
            ArgumentVariableSymbol arg = new ArgumentVariableSymbol(0, methodSymbol, null, classSymbol, 0, 0, null, 0);
            sl = new ArgumentVariableList(arg);
            sl.next = methodSymbol.argumentList;
        }
        String dollarSign = Identifier.dollarString;
        block6: while (true) {
            dollarName = dollarName + dollarSign;
            accessorName = Identifier.getIdentifier("ma" + dollarName + methodSymbol.identifier.toString());
            MethodSymbol methSym = accMethSym = (MethodSymbol)classSymbol.classScope.lookupSpecificSymbolInScope(accessorName, 8, true);
            while (methSym != null) {
                if (methSym.actualArgCount == methodSymbol.actualArgCount && (methSym.argumentList == null || methSym.argumentList.equals(sl))) {
                    if ((methSym.flags & 1) == 0) continue block6;
                    return methSym;
                }
                methSym = methSym.nextWithSameName;
            }
            break;
        }
        MethodSymbol newAccMethSym = new MethodSymbol(0, classSymbol, accessorName, methodSymbol.resultType, 0, 8, null, true);
        newAccMethSym.flags = (short)(newAccMethSym.flags | 0x21);
        newAccMethSym.argumentList = sl;
        newAccMethSym.localVarCount = newAccMethSym.actualArgCount = methodSymbol.actualArgCount;
        newAccMethSym.cmd.maxOpStackDepth = newAccMethSym.actualArgCount;
        newAccMethSym.argCount = methodSymbol.argCount;
        if ((methodSymbol.access & 8) == 0) {
            newAccMethSym.argCount = (short)(newAccMethSym.argCount + 1);
        }
        newAccMethSym.nextInClass = classSymbol.cd.methodList;
        classSymbol.cd.methodList = newAccMethSym;
        if (accMethSym == null) {
            classSymbol.classScope.enterSymbol(newAccMethSym);
        } else {
            newAccMethSym.nextWithSameName = accMethSym.nextWithSameName;
            accMethSym.nextWithSameName = newAccMethSym;
        }
        return this.generateMethodAccessor(methodSymbol, newAccMethSym, invokeOpcode);
    }

    MethodSymbol generateConstructorAccessor(MethodSymbol methodSymbol, RawClassSymbol fromClassSymbol) {
        RawClassSymbol dummyClass;
        RawClassSymbol classSymbol = methodSymbol.definingClass;
        MethodSymbol accMethSym = (MethodSymbol)classSymbol.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
        ArgumentVariableList sl1 = methodSymbol.argumentList;
        ArgumentVariableList sl2 = null;
        ArgumentVariableList argList = null;
        while (sl1 != null) {
            ArgumentVariableList sl = new ArgumentVariableList(sl1.argSymbol);
            if (argList == null) {
                sl2 = argList = sl;
            } else {
                sl2.next = sl;
            }
            sl1 = sl1.next;
            sl2 = sl;
        }
        if (fromClassSymbol.isAnonymousInnerClass()) {
            dummyClass = fromClassSymbol;
        } else {
            dummyClass = null;
            TypeSymbolList tsl = classSymbol.cd.innerClassList;
            while (tsl != null) {
                if (tsl.typeSymbol.isAnonymousInnerClass()) {
                    dummyClass = (RawClassSymbol)tsl.typeSymbol;
                    break;
                }
                tsl = tsl.next;
            }
            if (dummyClass == null) {
                dummyClass = AnonymousClassSymbol.createDummyClass(this.parser, classSymbol);
            }
        }
        ArgumentVariableSymbol arg = new ArgumentVariableSymbol(0, methodSymbol, null, dummyClass, 0, 0, null, methodSymbol.actualArgCount);
        if (argList == null) {
            argList = new ArgumentVariableList(arg);
        } else {
            sl2.next = new ArgumentVariableList(arg);
        }
        MethodSymbol methSym = accMethSym;
        while (methSym != null) {
            if (methSym.actualArgCount == methodSymbol.actualArgCount + 1 && (methSym.argumentList == null || methSym.argumentList.equals(argList))) {
                return methSym;
            }
            methSym = methSym.nextWithSameName;
        }
        MethodSymbol newAccMethSym = new MethodSymbol(0, classSymbol, Identifier.initializerIdentifier, methodSymbol.resultType, 0, 0, null, true);
        newAccMethSym.flags = (short)(newAccMethSym.flags | 0x21);
        newAccMethSym.argumentList = argList;
        newAccMethSym.argCount = (short)(methodSymbol.argCount + 1);
        newAccMethSym.localVarCount = newAccMethSym.actualArgCount = (short)(methodSymbol.actualArgCount + 1);
        newAccMethSym.cmd.maxOpStackDepth = newAccMethSym.actualArgCount;
        newAccMethSym.nextInClass = classSymbol.cd.methodList;
        classSymbol.cd.methodList = newAccMethSym;
        if (accMethSym == null) {
            classSymbol.classScope.enterSymbol(newAccMethSym);
        } else {
            newAccMethSym.nextWithSameName = accMethSym.nextWithSameName;
            accMethSym.nextWithSameName = newAccMethSym;
        }
        return this.generateMethodAccessor(methodSymbol, newAccMethSym, (byte)-73);
    }

    short generateGetPC() {
        return (short)(this.codeBufferStartOffset + this.codeBufferIndex);
    }

    void generateLineNumber(int line) {
        if (line != 0 && line != this.prevLine) {
            this.prevLine = line;
            int offset = this.codeBufferStartOffset + this.codeBufferIndex;
            if (offset == this.prevLineOffset) {
                int count = this.lineNumberTableIndex - 4;
                this.lineNumberTable[count + 3] = (byte)line;
                this.lineNumberTable[count + 2] = (byte)(line >> 8);
            } else {
                this.prevLineOffset = offset;
                int count = this.lineNumberTableIndex;
                this.lineNumberTableIndex += 4;
                if (this.lineNumberTable == null || count >= this.lineNumberTable.length) {
                    byte[] tmp = new byte[count + 256];
                    if (count > 0) {
                        System.arraycopy(this.lineNumberTable, 0, tmp, 0, this.lineNumberTable.length);
                    }
                    this.lineNumberTable = tmp;
                }
                this.lineNumberTable[count + 3] = (byte)line;
                this.lineNumberTable[count + 2] = (byte)(line >> 8);
                this.lineNumberTable[count + 1] = (byte)offset;
                this.lineNumberTable[count] = (byte)(offset >> 8);
            }
        }
    }

    void generateExceptionHandler(short startPC, short endPC, short handlerPC, short catchType) {
        if (!$a && startPC == endPC) {
            throw new AssertionError();
        }
        short idx = this.methodSymbol.cmd.exceptionTableLen;
        byte[] et = this.methodSymbol.cmd.exceptionTable;
        if (et == null) {
            this.methodSymbol.cmd.exceptionTable = et = new byte[40];
        } else if (idx + 8 < et.length) {
            byte[] newet = new byte[et.length + 40];
            System.arraycopy(et, 0, newet, 0, et.length);
            this.methodSymbol.cmd.exceptionTable = et = newet;
        }
        et[idx + 7] = (byte)catchType;
        et[idx + 6] = (byte)(catchType >> 8);
        et[idx + 5] = (byte)handlerPC;
        et[idx + 4] = (byte)(handlerPC >> 8);
        et[idx + 3] = (byte)endPC;
        et[idx + 2] = (byte)(endPC >> 8);
        et[idx + 1] = (byte)startPC;
        et[idx] = (byte)(startPC >> 8);
        this.methodSymbol.cmd.exceptionTableLen = (short)(idx + 8);
    }

    private void generateLocalVariableTable(MethodSymbol methodSymbol) {
        MethodVariableSymbol localVar;
        int cnt = 0;
        int typeCnt = 0;
        int i = methodSymbol.localVarCount;
        while (--i >= 0) {
            localVar = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
            if (localVar == null || localVar.identifier == null || localVar.startPC == -1) continue;
            ++cnt;
            if (!localVar.type.involvesGenerics()) continue;
            ++typeCnt;
        }
        ArgumentVariableSymbol thisLocalVar = null;
        if ((methodSymbol.access & 8) == 0) {
            ++cnt;
            if (methodSymbol.definingClass.involvesGenerics()) {
                ++typeCnt;
            }
            thisLocalVar = new ArgumentVariableSymbol(0, methodSymbol, Identifier.thisIdentifier, methodSymbol.definingClass, 0, 16, null, 0);
            thisLocalVar.endPC = (short)methodSymbol.cmd.codeBuffer.length;
        }
        methodSymbol.cmd.localVarTableLen = (short)cnt;
        byte[] localVarTable = new byte[cnt * 10];
        methodSymbol.cmd.localVarTypeTableLen = (short)typeCnt;
        byte[] localVarTypeTable = null;
        if (typeCnt > 0) {
            localVarTypeTable = new byte[typeCnt * 10];
        }
        i = 0;
        int idx = 0;
        int tidx = 0;
        while (i < methodSymbol.localVarCount) {
            localVar = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
            if (localVar == null && i == 0 && thisLocalVar != null) {
                localVar = thisLocalVar;
            }
            if (localVar != null && localVar.identifier != null && localVar.startPC != -1) {
                short nameIdx = this.constantPool.enterConstantPoolUtf8(localVar.identifier.name);
                short typeIdx = this.constantPool.enterConstantPoolUtf8(localVar.type.getSignature());
                localVarTable[idx + 9] = (byte)localVar.varStackIndex;
                localVarTable[idx + 8] = (byte)(localVar.varStackIndex >> 8);
                localVarTable[idx + 7] = (byte)typeIdx;
                localVarTable[idx + 6] = (byte)(typeIdx >> 8);
                localVarTable[idx + 5] = (byte)nameIdx;
                localVarTable[idx + 4] = (byte)(nameIdx >> 8);
                if (localVar.endPC == 0 && localVar.startPC != 0) {
                    localVar.endPC = (short)methodSymbol.cmd.codeBuffer.length;
                }
                localVarTable[idx + 3] = (byte)(localVar.endPC - localVar.startPC);
                localVarTable[idx + 2] = (byte)(localVar.endPC - localVar.startPC >> 8);
                localVarTable[idx + 1] = (byte)localVar.startPC;
                localVarTable[idx] = (byte)(localVar.startPC >> 8);
                if (localVar.type.involvesGenerics()) {
                    typeIdx = this.constantPool.enterConstantPoolUtf8(localVar.type.getGenericSignature());
                    localVarTypeTable[tidx + 9] = localVarTable[idx + 9];
                    localVarTypeTable[tidx + 8] = localVarTable[idx + 8];
                    localVarTypeTable[tidx + 7] = (byte)typeIdx;
                    localVarTypeTable[tidx + 6] = (byte)(typeIdx >> 8);
                    localVarTypeTable[tidx + 5] = localVarTable[idx + 5];
                    localVarTypeTable[tidx + 4] = localVarTable[idx + 4];
                    localVarTypeTable[tidx + 3] = localVarTable[idx + 3];
                    localVarTypeTable[tidx + 2] = localVarTable[idx + 2];
                    localVarTypeTable[tidx + 1] = localVarTable[idx + 1];
                    localVarTypeTable[tidx] = localVarTable[idx];
                    tidx += 10;
                }
                idx += 10;
            }
            ++i;
        }
        methodSymbol.cmd.localVarTable = localVarTable;
        methodSymbol.cmd.localVarTypeTable = localVarTypeTable;
    }

    void generateClassDollarMethod() {
        this.generate_8((byte)42);
        short startPC = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
        short index = this.constantPool.enterConstantPoolMethodRef(Identifier.javaLangClassInternal.name, Identifier.forNameIdentifier.name, Identifier.javaLangClassMethodStringSignature.name);
        this.generate_8_16_8((byte)-72, index, (byte)-80);
        short handlerPC = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
        index = this.constantPool.enterConstantPoolClass(Identifier.javaLangNoClassDefFoundErrorInternal.name);
        this.generate_8_16_8((byte)-69, index, (byte)90);
        this.generate_8((byte)95);
        index = this.constantPool.enterConstantPoolMethodRef(Identifier.javaLangClassNotFoundExceptionInternal.name, Identifier.getMessageIdentifier.name, Identifier.javaLangStringMethodSignature.name);
        this.generate_8_16((byte)-74, index);
        index = this.constantPool.enterConstantPoolMethodRef(Identifier.javaLangNoClassDefFoundErrorInternal.name, Identifier.initializerIdentifier.name, Identifier.voidMethodStringSignature.name);
        this.generate_8_16_8((byte)-73, index, (byte)-65);
        index = this.constantPool.enterConstantPoolClass(Identifier.javaLangClassNotFoundExceptionInternal.name);
        this.generateExceptionHandler(startPC, (short)(startPC + 3), handlerPC, index);
        this.maxOpStackHeight = 3;
    }

    void generateEnumValuesMethod() {
        char[] arrayInternalName = ArraySymbol.getArrayType(this.methodSymbol.definingClass, 1).getSignature();
        short index = this.constantPool.enterConstantPoolFieldRef(this.methodSymbol.definingClass.getInternalName(), Identifier.enumValuesInternal.name, arrayInternalName);
        this.generate_8_16((byte)-78, index);
        index = this.constantPool.enterConstantPoolMethodRef(arrayInternalName, Identifier.cloneIdentifier.name, Identifier.javaLangObjectMethodSignature.name);
        this.generate_8_16((byte)-74, index);
        index = this.constantPool.enterConstantPoolClass(arrayInternalName);
        this.generate_8_16_8((byte)-64, index, (byte)-80);
        this.maxOpStackHeight = 1;
    }

    void generateEnumValueOfMethod() {
        RawClassSymbol classSymbol = this.methodSymbol.definingClass;
        String className = new String(((ClassSymbol)classSymbol).getInternalName());
        short index = this.constantPool.enterConstantPoolClass(className.toCharArray());
        if ((index & 0xFF00) != 0) {
            this.generate_8_16_8((byte)19, index, (byte)42);
        } else {
            this.generate_8_8_8((byte)18, (byte)index, (byte)42);
        }
        index = this.constantPool.enterConstantPoolMethodRef(this.parser.javaLangEnumSymbol.getInternalName(), Identifier.valueOfIdentifier.name, Identifier.javaLangEnumMethodClassStringSignature.name);
        this.generate_8_16((byte)-72, index);
        index = this.constantPool.enterConstantPoolClass(((ClassSymbol)classSymbol).getInternalName());
        this.generate_8_16_8((byte)-64, index, (byte)-80);
        this.maxOpStackHeight = 2;
        this.methodSymbol.localVarCount = 1;
    }

    void generateBridgeMethod(MethodSymbol methSymbol) {
        byte returnOpcode;
        short index;
        this.generate_8((byte)42);
        ArgumentVariableList methArgList = methSymbol.argumentList;
        ArgumentVariableList bridgeArgList = this.methodSymbol.argumentList;
        while (bridgeArgList != null) {
            this.loadLocalVariable(methArgList.argSymbol.type, methArgList.argSymbol.varStackIndex);
            if (methArgList.argSymbol.type != bridgeArgList.argSymbol.type) {
                char[] typeName = methArgList.argSymbol.type.isArrayType() ? ((ArraySymbol)methArgList.argSymbol.type).getSignature() : ((ClassSymbol)methArgList.argSymbol.type).getInternalName();
                index = this.constantPool.enterConstantPoolClass(typeName);
                this.generate_8_16((byte)-64, index);
            }
            bridgeArgList = bridgeArgList.next;
            methArgList = methArgList.next;
        }
        switch (methSymbol.resultType.typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 1: {
                returnOpcode = -79;
                break;
            }
            case 2: 
            case 4: {
                returnOpcode = -84;
                break;
            }
            case -128: 
            case 64: {
                returnOpcode = -80;
                break;
            }
            case 8: {
                returnOpcode = -83;
                break;
            }
            case 16: {
                returnOpcode = -82;
                break;
            }
            case 32: {
                returnOpcode = -81;
                break;
            }
        }
        index = this.constantPool.enterConstantPoolMethodRef(methSymbol.definingClass.getInternalName(), methSymbol.identifier.name, methSymbol.getSignature());
        this.generate_8_16_8((byte)-74, index, returnOpcode);
        this.methodSymbol.localVarCount = this.methodSymbol.actualArgCount;
        this.maxOpStackHeight = this.methodSymbol.localVarCount;
    }

    void generateClassInitalizerPrologue() {
        RawClassSymbol classSymbol = this.parser.currentClassSymbol;
        char[] classSignature = classSymbol.getInternalName();
        if (classSymbol instanceof EnumMapClassSymbol) {
            EnumMapClassSymbol enumMapClassSymbol = (EnumMapClassSymbol)classSymbol;
            short indexClass = this.constantPool.enterConstantPoolClass(Identifier.javaLangNoSuchFieldErrorInternal.name);
            EnumMapClassSymbol.EnumDescriptor el = enumMapClassSymbol.enumList;
            while (el != null) {
                String signature = "()" + new String(ArraySymbol.getArrayType(el.enumClassSymbol, 1).getSignature());
                short index = this.constantPool.enterConstantPoolMethodRef(el.enumClassSymbol.getInternalName(), Identifier.valuesIdentifier.name, signature.toCharArray());
                this.generate_8_16_8((byte)-72, index, (byte)-66);
                this.generate_8_8((byte)-68, (byte)10);
                int cnt = el.enumConstList.size();
                if (cnt > 0) {
                    this.generate_8((byte)89);
                }
                short indexMap = this.constantPool.enterConstantPoolFieldRef(classSignature, el.enumMapField.identifier.name, Identifier.intArraySignature.name);
                this.generate_8_16((byte)-77, indexMap);
                int i = 0;
                while (i < cnt) {
                    if (i > 0) {
                        this.generate_8_16((byte)-78, indexMap);
                    }
                    short startPC = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
                    FieldSymbol field = (FieldSymbol)el.enumConstList.get(i);
                    index = this.constantPool.enterConstantPoolFieldRef(el.enumClassSymbol.getInternalName(), field.identifier.name, el.enumClassSymbol.getSignature());
                    this.generate_8_16((byte)-78, index);
                    short endPC = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
                    index = this.constantPool.enterConstantPoolMethodRef(el.enumClassSymbol.getInternalName(), Identifier.ordinalIdentifier.name, Identifier.intMethodSignature.name);
                    this.generate_8_16((byte)-74, index);
                    this.generateIntConst(i + 1);
                    this.generate_8((byte)79);
                    Label contLabel = new Label();
                    this.generate_8((byte)-89);
                    this.generateFixup(false, contLabel);
                    short handlerPC = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
                    this.generateExceptionHandler(startPC, endPC, handlerPC, indexClass);
                    this.generate_8((byte)87);
                    this.setLabel(contLabel);
                    ++i;
                }
                el = el.next;
            }
            this.generate_8((byte)-79);
            this.maxOpStackHeight = 4;
        } else {
            short index;
            short indexClass;
            if ((classSymbol.flags & 1) != 0) {
                if (this.parser.options.targetJDKVersion < 150) {
                    indexClass = this.constantPool.enterConstantPoolFieldRef(classSignature, Identifier.classObjectInternal.name, Identifier.javaLangClassSignature.name);
                    this.generate_8_16_8((byte)-78, indexClass, (byte)89);
                    String className = new String(classSymbol.getInternalName());
                    className = className.replace('/', '.');
                    index = this.constantPool.enterConstantPoolString(className.toCharArray());
                    if ((index & 0xFF00) != 0) {
                        this.generate_8_16_8((byte)-57, (short)14, (byte)87);
                        this.generate_8_16((byte)19, index);
                    } else {
                        this.generate_8_16_8((byte)-57, (short)13, (byte)87);
                        this.generate_8_8((byte)18, (byte)index);
                    }
                    MethodSymbol classLoaderMethod = classSymbol.cd.ccd.classLoaderMethod;
                    index = this.constantPool.enterConstantPoolMethodRef(classLoaderMethod.definingClass.getInternalName(), classLoaderMethod.identifier.name, classLoaderMethod.getSignature());
                    this.generate_8_16_8((byte)-72, index, (byte)89);
                    this.generate_8_16((byte)-77, indexClass);
                } else {
                    index = this.constantPool.enterConstantPoolClass(classSignature);
                    if ((index & 0xFF00) != 0) {
                        this.generate_8_16((byte)19, index);
                    } else {
                        this.generate_8_8((byte)18, (byte)index);
                    }
                }
                index = this.constantPool.enterConstantPoolMethodRef(Identifier.javaLangClassInternal.name, Identifier.desiredAssertionStatusIdentifier.name, Identifier.booleanMethodSignature.name);
                this.generate_8_16((byte)-74, index);
                this.generate_8_8((byte)4, (byte)-126);
                index = this.constantPool.enterConstantPoolFieldRef(classSignature, Identifier.assertionsDisabledInternal.name, Identifier.booleanSignature.name);
                this.generate_8_16((byte)-77, index);
                this.maxOpStackHeight = 2;
            }
            if (classSymbol.isEnum()) {
                int cnt = 0;
                FieldSymbol field = classSymbol.cd.fieldList;
                while (field != null) {
                    if ((field.access & 0x4000) != 0) {
                        if (field.initializer == null) {
                            if (!$a && !this.parser.errorFound) {
                                throw new AssertionError();
                            }
                            cnt = 0;
                            break;
                        }
                        ++cnt;
                    }
                    field = field.nextInClass;
                }
                if (cnt > 0) {
                    this.generateIntConst(cnt);
                    indexClass = this.constantPool.enterConstantPoolClass(classSignature);
                    this.generate_8_16_8((byte)-67, indexClass, (byte)89);
                    this.incOpStackHeight(2);
                    field = classSymbol.cd.fieldList;
                    while (true) {
                        if ((field.access & 0x4000) != 0) {
                            field.initializer.generateByteCode(this);
                            index = this.constantPool.enterConstantPoolFieldRef(classSignature, field.identifier.name, classSymbol.getSignature());
                            this.generate_8((byte)89);
                            this.incOpStackHeight(1);
                            this.generate_8_16((byte)-77, index);
                            this.decOpStackHeight(1);
                            this.generateIntConst(--cnt);
                            this.incOpStackHeight(1);
                            this.generate_8_8((byte)95, (byte)83);
                            this.decOpStackHeight(3);
                            if (cnt == 0) break;
                            this.generate_8((byte)89);
                            this.incOpStackHeight(1);
                        }
                        field = field.nextInClass;
                    }
                    index = this.constantPool.enterConstantPoolFieldRef(classSignature, Identifier.enumValuesInternal.name, ArraySymbol.getArrayType(classSymbol, 1).getSignature());
                    this.generate_8_16((byte)-77, index);
                    this.decOpStackHeight(1);
                    if (!$a && this.opStackHeight != 0) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    boolean finish() {
        this.flushCodeBuffer(false);
        byte[] methodCodebuffer = this.methodSymbol.cmd.codeBuffer;
        Hashtable<Integer, Fixup> fixupMap = new Hashtable<Integer, Fixup>();
        Fixup fixup = this.fixupList;
        while (fixup != null) {
            if ((fixup.flags & 2) != 0) {
                fixupMap.put(new Integer(fixup.offset - fixup.baseAdjustment), fixup);
            }
            fixup = fixup.next;
        }
        Hashtable<Fixup, Fixup> previousFixups = new Hashtable<Fixup, Fixup>();
        fixup = this.fixupList;
        while (fixup != null) {
            Fixup otherFixup;
            previousFixups.clear();
            while ((otherFixup = (Fixup)fixupMap.get(new Integer(fixup.label.offset))) != null && previousFixups.get(otherFixup) == null && (otherFixup.flags & 1) == (fixup.flags & 1)) {
                previousFixups.put(otherFixup, otherFixup);
                fixup.label.offset = otherFixup.label.offset;
            }
            fixup = fixup.next;
        }
        fixupMap.clear();
        previousFixups.clear();
        fixup = this.fixupList;
        while (fixup != null) {
            int off = fixup.offset;
            int targetOff = fixup.label.offset - (off - fixup.baseAdjustment);
            if ((fixup.flags & 1) != 0) {
                methodCodebuffer[off + 3] = (byte)targetOff;
                methodCodebuffer[off + 2] = (byte)(targetOff >> 8);
                methodCodebuffer[off + 1] = (byte)(targetOff >> 16);
                methodCodebuffer[off] = (byte)(targetOff >> 24);
            } else {
                if (targetOff < Short.MIN_VALUE || Short.MAX_VALUE < targetOff) {
                    this.lineNumberTableIndex = 0;
                    this.maxOpStackHeight = 0;
                    this.opStackHeight = 0;
                    this.codeBufferStartOffset = 0;
                    this.codeBufferIndex = 0;
                    this.prevLineOffset = -1;
                    this.fixupList = null;
                    this.methodSymbol.cmd.exceptionTable = null;
                    this.methodSymbol.cmd.exceptionTableLen = 0;
                    this.doingStringConcatonation = false;
                    this.wideFlag = true;
                    return false;
                }
                methodCodebuffer[off + 1] = (byte)targetOff;
                methodCodebuffer[off] = (byte)(targetOff >> 8);
            }
            fixup = fixup.next;
        }
        if (!(!this.parser.options.localVariables || this.methodSymbol.isSynthetic() || this.methodSymbol.isGenerated() || this.methodSymbol.isDefaultConstructor() || this.methodSymbol.isBridgeMethod())) {
            this.generateLocalVariableTable(this.methodSymbol);
        }
        this.methodSymbol.cmd.maxOpStackDepth = this.maxOpStackHeight;
        if (this.lineNumberTableIndex != 0) {
            if (this.lineNumberTableIndex < this.lineNumberTable.length) {
                this.methodSymbol.cmd.lineNumberTable = new byte[this.lineNumberTableIndex];
                System.arraycopy(this.lineNumberTable, 0, this.methodSymbol.cmd.lineNumberTable, 0, this.lineNumberTableIndex);
            } else {
                this.methodSymbol.cmd.lineNumberTable = this.lineNumberTable;
            }
            this.lineNumberTable = null;
            this.lineNumberTableIndex = 0;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

