/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class CastExpression
extends UnaryExpression {
    TypeSymbol castType;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    CastExpression(int pos, Expression operand, TypeSymbol castType) {
        super((byte)46, pos, operand);
        this.castType = castType;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = CastExpression.class$("oracle.ojc.compiler.CastExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    static Expression castNumericConstant(Expression constExpr, TypeSymbol toType, boolean clone) {
        if (!$a && constExpr.kind != 2) {
            throw new AssertionError();
        }
        TypeSymbol fromType = constExpr.getType();
        if (!($a || toType.isNumericType() && fromType.isNumericType())) {
            throw new AssertionError();
        }
        byte toTypeKind = toType.typeKind;
        byte fromTypeKind = fromType.typeKind;
        switch (fromTypeKind) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 4: {
                CharConstantExpression ccExpr = (CharConstantExpression)constExpr;
                char cval = ccExpr.cval;
                switch (toTypeKind) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.byteSymbol, (byte)cval);
                    }
                    case 4: {
                        if (clone) {
                            return new CharConstantExpression(constExpr.pos, cval);
                        }
                        return ccExpr;
                    }
                    case 5: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.shortSymbol, (short)cval);
                    }
                    case 6: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.intSymbol, cval);
                    }
                    case 7: {
                        return new LongConstantExpression(constExpr.pos, (long)cval);
                    }
                    case 8: {
                        return new FloatConstantExpression(constExpr.pos, (float)cval);
                    }
                    case 9: 
                }
                return new DoubleConstantExpression(constExpr.pos, (double)cval);
            }
            case 3: 
            case 5: 
            case 6: {
                IntConstantExpression icExpr = (IntConstantExpression)constExpr;
                int ival = icExpr.ival;
                switch (toTypeKind) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        if (clone) {
                            return new IntConstantExpression(constExpr.pos, TypeSymbol.byteSymbol, ival);
                        }
                        icExpr.ival = (byte)ival;
                        icExpr.setType(TypeSymbol.byteSymbol);
                        return icExpr;
                    }
                    case 4: {
                        return new CharConstantExpression(constExpr.pos, (char)ival);
                    }
                    case 5: {
                        if (clone) {
                            return new IntConstantExpression(constExpr.pos, TypeSymbol.shortSymbol, ival);
                        }
                        icExpr.ival = (short)ival;
                        icExpr.setType(TypeSymbol.shortSymbol);
                        return icExpr;
                    }
                    case 6: {
                        if (clone) {
                            return new IntConstantExpression(constExpr.pos, TypeSymbol.intSymbol, ival);
                        }
                        icExpr.setType(TypeSymbol.intSymbol);
                        return icExpr;
                    }
                    case 7: {
                        return new LongConstantExpression(constExpr.pos, (long)ival);
                    }
                    case 8: {
                        return new FloatConstantExpression(constExpr.pos, (float)ival);
                    }
                    case 9: 
                }
                return new DoubleConstantExpression(constExpr.pos, (double)ival);
            }
            case 7: {
                LongConstantExpression lcExpr = (LongConstantExpression)constExpr;
                long lval = lcExpr.lval;
                switch (toTypeKind) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.byteSymbol, (byte)lval);
                    }
                    case 4: {
                        return new CharConstantExpression(constExpr.pos, (char)lval);
                    }
                    case 5: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.shortSymbol, (short)lval);
                    }
                    case 6: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.intSymbol, (int)lval);
                    }
                    case 7: {
                        if (clone) {
                            return new LongConstantExpression(constExpr.pos, lval);
                        }
                        return lcExpr;
                    }
                    case 8: {
                        return new FloatConstantExpression(constExpr.pos, lval);
                    }
                    case 9: 
                }
                return new DoubleConstantExpression(constExpr.pos, lval);
            }
            case 8: {
                FloatConstantExpression fcExpr = (FloatConstantExpression)constExpr;
                float fval = fcExpr.fval;
                switch (toTypeKind) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.byteSymbol, (byte)fval);
                    }
                    case 4: {
                        return new CharConstantExpression(constExpr.pos, (char)fval);
                    }
                    case 5: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.shortSymbol, (short)fval);
                    }
                    case 6: {
                        return new IntConstantExpression(constExpr.pos, TypeSymbol.intSymbol, (int)fval);
                    }
                    case 7: {
                        return new LongConstantExpression(constExpr.pos, (long)fval);
                    }
                    case 8: {
                        if (clone) {
                            return new FloatConstantExpression(constExpr.pos, fval);
                        }
                        return fcExpr;
                    }
                    case 9: 
                }
                return new DoubleConstantExpression(constExpr.pos, fval);
            }
            case 9: 
        }
        DoubleConstantExpression dcExpr = (DoubleConstantExpression)constExpr;
        double dval = dcExpr.dval;
        switch (toTypeKind) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 3: {
                return new IntConstantExpression(constExpr.pos, TypeSymbol.byteSymbol, (byte)dval);
            }
            case 4: {
                return new CharConstantExpression(constExpr.pos, (char)dval);
            }
            case 5: {
                return new IntConstantExpression(constExpr.pos, TypeSymbol.shortSymbol, (short)dval);
            }
            case 6: {
                return new IntConstantExpression(constExpr.pos, TypeSymbol.intSymbol, (int)dval);
            }
            case 7: {
                return new LongConstantExpression(constExpr.pos, (long)dval);
            }
            case 8: {
                return new FloatConstantExpression(constExpr.pos, (float)dval);
            }
            case 9: 
        }
        if (clone) {
            return new DoubleConstantExpression(constExpr.pos, dval);
        }
        return dcExpr;
    }

    Expression foldExpression() {
        TypeSymbol toType = this.getType();
        if (toType.isNumericType()) {
            Expression op = this.operand;
            if (op.kind == 2) {
                return CastExpression.castNumericConstant(op, toType, false);
            }
        }
        return this;
    }

    Expression constantFolding(Parser parser) {
        this.operand = this.operand.constantFolding(parser);
        return this.foldExpression();
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol fromType;
        Expression op = this.operand.resolveAndCheck(parser);
        if (op instanceof ErrorExpression) {
            return op;
        }
        TypeSymbol toType = this.castType.resolveType(parser, this.pos, false, true, false);
        if (toType.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        if (parser.currentClassSymbol != null) {
            parser.currentClassSymbol.addNameReference(parser, toType, toType.pos);
        }
        if ((fromType = op.getType()).isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        if (fromType == toType) {
            parser.warning(fromType, Message.warningUnnecessaryCast, this.pos, fromType.errorName(), toType.errorName());
            return op;
        }
        toType.checkDeprecated(parser, this.pos);
        byte toTypeKind = toType.typeKind;
        switch (toTypeKind) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 10: 
            case 11: {
                if (fromType.isPrimitiveType()) {
                    TypeSymbol primitiveType;
                    if (parser.options.sourceJDKVersion >= 150 && (primitiveType = BoxingExpression.getPrimitiveType(parser, toType)) != null && (primitiveType.typeKind == fromType.typeKind || toType.equalTo(parser.javaLangNumberSymbol) || toType.equalTo(parser.javaLangComparableSymbol) || toType.equalTo(parser.javaIoSerializableSymbol) || toType.equalTo(parser.javaLangObjectSymbol))) {
                        return new AutoBoxingExpression(op, toType);
                    }
                    Error error = parser.error(Message.errorCannotCast, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (!toType.isTypeParameter() && toType.equalTo(parser.javaLangObjectSymbol)) {
                    parser.warning(toType, Message.warningUnnecessaryCast, this.pos, fromType.errorName(), toType.errorName());
                    break;
                }
                ReferenceTypeSymbol fromRefSymbol = (ReferenceTypeSymbol)fromType;
                ReferenceTypeSymbol toRefSymbol = (ReferenceTypeSymbol)toType;
                if (!fromRefSymbol.isCastCompatible(parser, toRefSymbol)) {
                    Error error = parser.error(Message.errorCannotCast, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                toType.checkForUncheckedConversion(parser, this.pos, fromType, true);
                break;
            }
            case 2: {
                TypeSymbol primitiveType;
                if (parser.options.sourceJDKVersion >= 150 && fromType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, fromType)) != null && primitiveType.typeKind == 2) {
                    return new AutoUnboxingExpression(op, primitiveType);
                }
                Error error = parser.error(Message.errorCannotCast, this.pos, false, fromType.errorName(), toType.errorName());
                return new ErrorExpression(error);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (!fromType.isNumericType()) {
                    TypeSymbol primitiveType;
                    if (parser.options.sourceJDKVersion >= 150 && fromType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, fromType)) != null && primitiveType.isNumericType()) {
                        if ((op = op.promoteType(parser, toType)).getType() != toType) break;
                        return op;
                    }
                    Error error = parser.error(Message.errorCannotCast, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (op.kind != 2) break;
                return CastExpression.castNumericConstant(op, toType, false);
            }
        }
        this.setType(toType);
        this.operand = op;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression op = this.operand;
        op.generateByteCode(byteCodeGenerator);
        TypeSymbol toType = this.getType();
        byte toTypeKind = toType.typeKind;
        TypeSymbol fromType = op.getType();
        byte fromTypeKind = fromType.typeKind;
        block0 : switch (toTypeKind) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 10: 
            case 11: {
                if (toType == ReferenceTypeSymbol.nullTypeSymbol) break;
                if (toType.isClass()) {
                    RawClassSymbol toClass = ((ClassSymbol)toType).getClassSymbol();
                    byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(byteCodeGenerator.parser.currentClassSymbol, toClass);
                }
                short index = byteCodeGenerator.constantPool.enterConstantPoolClass(toType.getInternalName());
                byteCodeGenerator.generate_8_16((byte)-64, index);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (fromTypeKind) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        byteCodeGenerator.generate_8((byte)-120);
                        byteCodeGenerator.decOpStackHeight(1);
                        break;
                    }
                    case 8: {
                        byteCodeGenerator.generate_8((byte)-117);
                        break;
                    }
                    case 9: {
                        byteCodeGenerator.generate_8((byte)-114);
                        byteCodeGenerator.decOpStackHeight(1);
                        break;
                    }
                }
                if (toTypeKind == 3) {
                    byteCodeGenerator.generate_8((byte)-111);
                    break;
                }
                if (toTypeKind == 5) {
                    byteCodeGenerator.generate_8((byte)-109);
                    break;
                }
                if (toTypeKind != 4) break;
                byteCodeGenerator.generate_8((byte)-110);
                break;
            }
            case 7: {
                switch (fromTypeKind) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        byteCodeGenerator.generate_8((byte)-123);
                        byteCodeGenerator.incOpStackHeight(1);
                        break block0;
                    }
                    case 8: {
                        byteCodeGenerator.generate_8((byte)-116);
                        byteCodeGenerator.incOpStackHeight(1);
                        break block0;
                    }
                    case 9: 
                }
                byteCodeGenerator.generate_8((byte)-113);
                break;
            }
            case 8: {
                switch (fromTypeKind) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        byteCodeGenerator.generate_8((byte)-122);
                        break block0;
                    }
                    case 7: {
                        byteCodeGenerator.generate_8((byte)-119);
                        byteCodeGenerator.decOpStackHeight(1);
                        break block0;
                    }
                    case 9: 
                }
                byteCodeGenerator.generate_8((byte)-112);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 9: {
                switch (fromTypeKind) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        byteCodeGenerator.generate_8((byte)-121);
                        byteCodeGenerator.incOpStackHeight(1);
                        break block0;
                    }
                    case 7: {
                        byteCodeGenerator.generate_8((byte)-118);
                        break block0;
                    }
                    case 8: 
                }
                byteCodeGenerator.generate_8((byte)-115);
                byteCodeGenerator.incOpStackHeight(1);
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

