/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ojc.compiler.DepClassFileInfo;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.DepMemberInfo;
import oracle.ojc.compiler.DepSourceFileInfo;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.storage.FileStorage;

public class CdiDump {
    public static void main(String[] argv) {
        String inputFile = null;
        boolean checkSourceFileTimeStamps = false;
        int x = 0;
        while (x < argv.length) {
            String arg = argv[x];
            if (arg.startsWith("-")) {
                if ("-check".equals(arg)) {
                    checkSourceFileTimeStamps = true;
                } else {
                    CdiDump.usage("error: invalid options", System.out);
                }
            } else {
                if (inputFile != null) {
                    CdiDump.usage("error: only one input file allowed", System.out);
                }
                inputFile = arg;
            }
            ++x;
        }
        if (inputFile == null) {
            CdiDump.usage("error: no input file specified", System.out);
        }
        if (inputFile.endsWith("zyxr") || inputFile.endsWith("zyxm") || inputFile.endsWith("zyxr.cdi") || inputFile.endsWith("zyxm.cdi")) {
            System.out.println("Cannot dump this file, use main cdi file: " + inputFile);
            System.exit(0);
        }
        if (!CdiDump.dumpCdiFile(inputFile, checkSourceFileTimeStamps, System.out, System.err)) {
            System.exit(1);
        }
        System.exit(0);
    }

    public static boolean dumpCdiFile(String inputFile, boolean checkSourceFileTimeStamps, PrintStream outStream, PrintStream errStream) {
        DepInfo depInfo = new DepInfo();
        try {
            depInfo.dontCheckEmbeddedFileName = true;
            depInfo.read(new FileStorage(new File(inputFile)));
        }
        catch (IOException e) {
            depInfo.clear();
            outStream.println("i/o error reading: " + inputFile + " (" + e.getMessage() + ")");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            depInfo.clear();
            outStream.println("fatal error reading: " + inputFile + " (" + e.getMessage() + ")");
            boolean bl = false;
            return bl;
        }
        CdiDump.dumpLine("Version: " + Integer.toHexString(depInfo.getMagicHeader()), outStream);
        Hashtable<Integer, DepClassFileInfo> indexedClasses = new Hashtable<Integer, DepClassFileInfo>();
        ArrayList<DepClassFileInfo> depClassFileInfoList = new ArrayList<DepClassFileInfo>();
        Enumeration cfiEnum = depInfo.classes.elements();
        while (cfiEnum.hasMoreElements()) {
            DepClassFileInfo cfi = (DepClassFileInfo)cfiEnum.nextElement();
            depClassFileInfoList.add(cfi);
            indexedClasses.put(new Integer(cfi.index), cfi);
            if (cfi.sfi == null) continue;
            int j = 0;
            while (j < cfi.depClasses.size()) {
                DepClassFileInfo depCls = (DepClassFileInfo)cfi.depClasses.get(j);
                if (depCls.sfi != null && depCls.sfi != cfi.sfi) {
                    depCls.sfi.usedBy.add(cfi.sfi);
                }
                ++j;
            }
        }
        1 classSorter = new 1();
        Collections.sort(depClassFileInfoList, classSorter);
        ArrayList depSourceFileInfoList = new ArrayList();
        depSourceFileInfoList.addAll(depInfo.sources.values());
        2 sourceSorter = new 2();
        Collections.sort(depSourceFileInfoList, sourceSorter);
        CdiDump.dumpLine(depInfo.sources.size() + "sources read", outStream);
        CdiDump.dumpLine(depInfo.classes.size() + "classes read", outStream);
        int mismatch = 0;
        Iterator sourceIter = depSourceFileInfoList.iterator();
        while (sourceIter.hasNext()) {
            DepSourceFileInfo sfi = (DepSourceFileInfo)sourceIter.next();
            if (checkSourceFileTimeStamps) {
                File f = new File(sfi.fullName);
                if (f.exists()) {
                    if (f.lastModified() != sfi.modDate) {
                        long diff = Math.abs(f.lastModified() - sfi.modDate);
                        errStream.println("error: timestamp mismatch: diff: " + diff + " : " + f.getPath() + " file: " + new Date(f.lastModified()) + " cdi: " + new Date(sfi.modDate));
                        ++mismatch;
                    } else {
                        errStream.println("ok: no timestamp mismatch: " + f.getPath());
                    }
                } else {
                    errStream.println("error: unable to find " + f.getPath());
                }
            }
            CdiDump.dump(outStream);
            CdiDump.dumpLine("Source: " + sfi.fullName + " (" + new Date(sfi.modDate).toString() + ")", outStream);
            CdiDump.dumpLine("\tDependents: (cnt = " + sfi.classFiles.size() + ")", outStream);
            Collections.sort(sfi.classFiles, classSorter);
            int i = 0;
            while (i < sfi.classFiles.size()) {
                DepClassFileInfo cfi = (DepClassFileInfo)sfi.classFiles.get(i);
                CdiDump.dumpLine("\t\t" + cfi.getClassName() + " (" + new Date(cfi.modDate).toString() + ")", outStream);
                ++i;
            }
            CdiDump.dumpLine("\tUsedBy: (cnt = " + sfi.usedBy.size() + ")", outStream);
            ArrayList usedByList = new ArrayList();
            usedByList.addAll(sfi.usedBy);
            Collections.sort(usedByList, sourceSorter);
            Iterator iter = usedByList.iterator();
            while (iter.hasNext()) {
                DepSourceFileInfo elem = (DepSourceFileInfo)iter.next();
                CdiDump.dumpLine("\t\t" + elem.fullName, outStream);
            }
        }
        if (depClassFileInfoList.size() > 0) {
            CdiDump.dump(outStream);
            CdiDump.dumpLine("Class list:", outStream);
            Iterator classIter = depClassFileInfoList.iterator();
            while (classIter.hasNext()) {
                DepClassFileInfo cfi = (DepClassFileInfo)classIter.next();
                CdiDump.dumpLine("\t" + cfi.getClassName(), outStream);
                if (depInfo.getMagicHeader() == 305419897 || depInfo.getMagicHeader() < 0x11100103) continue;
                if (cfi.superClass != null) {
                    CdiDump.dumpLine("\t  Super class: " + cfi.superClass.getClassName(), outStream);
                }
                if (cfi.implementedInterfaces == null || cfi.implementedInterfaces.size() <= 0) continue;
                Iterator interfaceIter = cfi.implementedInterfaces.iterator();
                while (interfaceIter.hasNext()) {
                    DepClassFileInfo oneInterface = (DepClassFileInfo)interfaceIter.next();
                    CdiDump.dumpLine("\t  Interface: " + oneInterface.getClassName(), outStream);
                }
            }
            CdiDump.dump(outStream);
            CdiDump.dumpLine("Symbol references:", outStream);
            StringBuffer buf = new StringBuffer();
            classIter = depClassFileInfoList.iterator();
            while (classIter.hasNext()) {
                DepClassFileInfo cfi = (DepClassFileInfo)classIter.next();
                if (depInfo.getMagicHeader() != 305419897 && depInfo.getMagicHeader() >= 0x11100102) {
                    if (cfi.nameRefs == null) continue;
                    Set nameRefSet = cfi.nameRefs;
                    ArrayList nameRefList = new ArrayList(nameRefSet);
                    CdiDump.dump("Symbols for class: ", outStream);
                    CdiDump.dumpLine(cfi.getClassName(), outStream);
                    3 referenceSorter = new 3();
                    Collections.sort(nameRefList, referenceSorter);
                    Iterator iter = nameRefList.iterator();
                    int lastMember = -1;
                    while (iter.hasNext()) {
                        int[] entry = (int[])iter.next();
                        if (lastMember != entry[0]) {
                            CdiDump.dumpLine(buf.toString(), outStream);
                            buf.setLength(0);
                            buf.append("  ");
                            int lookupIndex = entry[0] & 0xFFFFFF;
                            if ((entry[0] & 0x10000000) != 0) {
                                DepClassFileInfo typeCfi = (DepClassFileInfo)indexedClasses.get(new Integer(lookupIndex));
                                buf.append(typeCfi.getClassName());
                            } else {
                                DepMemberInfo dmi = depInfo.getDepMemberInfo(lookupIndex);
                                buf.append(dmi.getFullName(depInfo));
                            }
                            buf.append(':');
                            CdiDump.dumpLine(buf.toString(), outStream);
                            buf.setLength(0);
                            lastMember = entry[0];
                        }
                        buf.append('(');
                        buf.append(Scanner.positionToLine(entry[1]));
                        buf.append(',');
                        buf.append(Scanner.positionToColumn(entry[1]));
                        buf.append(")  ");
                    }
                    CdiDump.dumpLine(buf.toString(), outStream);
                    buf.setLength(0);
                    continue;
                }
                Map referenceTable = cfi.nameReferencesTable;
                if (referenceTable == null) continue;
                CdiDump.dump("Symbols for class: ", outStream);
                CdiDump.dumpLine(cfi.getClassName(), outStream);
                Iterator iter = referenceTable.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    CdiDump.dump("  ", outStream);
                    CdiDump.dumpLine((String)entry.getKey(), outStream);
                    int[] referenceArray = (int[])entry.getValue();
                    int count = 0;
                    buf.setLength(0);
                    CdiDump.dump("    ", outStream);
                    int x = 1;
                    while (x < referenceArray[0]) {
                        if (count > 4) {
                            CdiDump.dumpLine(buf.toString(), outStream);
                            CdiDump.dump("    ", outStream);
                            buf.setLength(0);
                            count = 0;
                        } else if (count > 0) {
                            buf.append(", ");
                        }
                        buf.append('(');
                        buf.append(Scanner.positionToLine(referenceArray[x]));
                        buf.append(',');
                        buf.append(Scanner.positionToColumn(referenceArray[x]));
                        buf.append(')');
                        ++x;
                    }
                    if (buf.length() <= 0) continue;
                    CdiDump.dumpLine(buf.toString(), outStream);
                }
            }
        }
        if (checkSourceFileTimeStamps && mismatch > 0) {
            errStream.println("Source files checked: " + mismatch + " mismatch out of " + depInfo.sources.size());
        }
        depInfo.clear();
        return true;
    }

    private static void usage(String err, PrintStream errStream) {
        if (err != null) {
            errStream.println(err + "\n");
        }
        errStream.println("usage: dumpDepInfo [-check] <depfile>");
        System.exit(1);
    }

    private static void dumpLine(String msg, PrintStream outStream) {
        outStream.println(msg);
    }

    private static void dump(String msg, PrintStream outStream) {
        outStream.print(msg);
    }

    private static void dump(PrintStream outStream) {
        outStream.println();
    }

    static final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            DepClassFileInfo cfi1 = (DepClassFileInfo)o1;
            DepClassFileInfo cfi2 = (DepClassFileInfo)o2;
            return cfi1.getClassName().compareTo(cfi2.getClassName());
        }
    }

    static final class 2
    implements Comparator {
        public int compare(Object o1, Object o2) {
            DepSourceFileInfo sfi1 = (DepSourceFileInfo)o1;
            DepSourceFileInfo sfi2 = (DepSourceFileInfo)o2;
            return sfi1.fullName.compareTo(sfi2.fullName);
        }
    }

    static final class 3
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int[] one = (int[])o1;
            int[] two = (int[])o2;
            int result = one[0] - two[0];
            if (result == 0) {
                return one[1] - two[1];
            }
            return result;
        }
    }
}

