/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.DepSourceFileInfo;
import oracle.ojc.storage.FileStorage;

public final class CdiRebase {
    public static void main(String[] args) {
        try {
            int argc = args.length;
            if (argc < 3) {
                System.out.println("usage: cdirebase old_root new_root {cdifile|cdidir}+");
                System.out.println();
                System.out.println("  ex1: cdirebase C:\\ade\\olderview C:\\ade\\newview C:\\ade\\newview\\classes\\X.cdi");
                System.out.println();
                System.out.println("  ex2: cdirebase C:\\ade\\olderview C:\\ade\\newview C:\\ade\\newview\\classes");
                System.out.println();
                System.out.println("       will convert all .cdi file in the specified directory");
                return;
            }
            String oldbase = "auto".equals(args[0]) ? null : DepInfo.fixKey(args[0]);
            String newbase = DepInfo.fixKey(args[1]);
            ArrayList<File> cdifiles = new ArrayList<File>();
            int i = 2;
            while (i < argc) {
                File cdifile = new File(args[i]);
                if (cdifile.isDirectory()) {
                    File[] files = cdifile.listFiles();
                    int j = 0;
                    while (j < files.length) {
                        if (files[j].getName().endsWith(".cdi")) {
                            cdifiles.add(files[j]);
                        }
                        ++j;
                    }
                } else {
                    cdifiles.add(cdifile);
                }
                ++i;
            }
            CdiRebase.rebaseCdiFiles(cdifiles, System.out, args[1], oldbase, newbase, System.getenv("CHECKTIMESTAMPS") != null);
        }
        catch (Exception t) {
            t.printStackTrace();
            System.out.println("Fatal error rebasing CDI");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean rebaseCdiFiles(ArrayList cdifiles, PrintStream outStream, String rawNewBase, String oldbase, String newbase, boolean updateSourceFileStamps) {
        DepInfo depInfo = new DepInfo();
        depInfo.rebaseCdi = true;
        depInfo.dontCheckEmbeddedFileName = true;
        Iterator cdiIter = cdifiles.iterator();
        while (cdiIter.hasNext()) {
            Object var29_23;
            File f = (File)cdiIter.next();
            try {
                try {
                    block21: {
                        block20: {
                            String cdiFileName = f.getPath();
                            if (cdiFileName.endsWith("zyxr") || cdiFileName.endsWith("zyxm") || cdiFileName.endsWith("zyxr.cdi")) break block20;
                            if (!cdiFileName.endsWith("zyxm.cdi")) break block21;
                        }
                        var29_23 = null;
                        depInfo.clear();
                        continue;
                    }
                    int keyCount = 0;
                    int keySkipped = 0;
                    FileStorage store = new FileStorage(f);
                    depInfo.read(store);
                    Enumeration en = depInfo.sources.keys();
                    while (true) {
                        String key;
                        if (!en.hasMoreElements()) {
                            depInfo.writeRebasedCdi(store, depInfo.getEncoding());
                            outStream.println(store.getPath() + " updated, " + keyCount + " elements updated, " + keySkipped + " elements skipped");
                            break;
                        }
                        String transKey = key = (String)en.nextElement();
                        char oldFileSep = File.separatorChar;
                        if (transKey.substring(0, 3).indexOf(File.separatorChar) < 0) {
                            oldFileSep = '\\' == File.separatorChar ? (char)'/' : '\\';
                            transKey = transKey.replace(oldFileSep, File.separatorChar);
                        }
                        if (oldbase != null && !key.startsWith(oldbase)) {
                            oldbase = null;
                        }
                        if (oldbase == null) {
                            int n = transKey.length();
                            int nextSep = -1;
                            while (++nextSep >= 0 && nextSep < n && (nextSep = transKey.indexOf(File.separatorChar, nextSep)) >= 0) {
                                String newPath = newbase + transKey.substring(nextSep);
                                if (!new File(newPath).exists()) continue;
                                oldbase = key.substring(0, nextSep);
                                break;
                            }
                        }
                        if (oldbase != null && key.startsWith(oldbase)) {
                            long lastModified;
                            DepSourceFileInfo sf = (DepSourceFileInfo)depInfo.sources.get(key);
                            String fullNameTail = sf.fullName.substring(oldbase.length());
                            if (key != transKey) {
                                fullNameTail = fullNameTail.replace(oldFileSep, File.separatorChar);
                            }
                            sf.fullName = rawNewBase + fullNameTail;
                            if (!updateSourceFileStamps || (lastModified = new File(sf.fullName).lastModified()) == (long)-1 || lastModified == sf.modDate) continue;
                            sf.modDate = lastModified;
                            ++keyCount;
                            continue;
                        }
                        ++keySkipped;
                        outStream.println(key + " ignored");
                    }
                }
                catch (IOException e) {
                    outStream.println("error reading: " + f.getPath() + " (" + e.getMessage() + ")");
                    boolean bl = false;
                    var29_23 = null;
                    depInfo.clear();
                    return bl;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    outStream.println("Fatal error rebasing CDI: " + f.getPath());
                    boolean bl = false;
                    var29_23 = null;
                    depInfo.clear();
                    return bl;
                }
            }
            catch (Throwable throwable) {
                var29_23 = null;
                depInfo.clear();
                throw throwable;
            }
            var29_23 = null;
            depInfo.clear();
        }
        return true;
    }
}

