/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class CharConstantExpression
extends ConstantExpression {
    char cval;

    CharConstantExpression(int pos, char cval) {
        super(pos, TypeSymbol.charSymbol);
        this.cval = cval;
    }

    Expression copyConstantExpression(int newPos) {
        return new CharConstantExpression(newPos, this.cval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.generateIntConst(this.cval);
        byteCodeGenerator.incOpStackHeight(1);
    }

    int getIntConstValue() {
        return this.cval;
    }
}

