/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.LogProxy;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.OJCDEBUG;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.Warning;
import oracle.ojc.compiler.WrappedStorage;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public final class Compiler {
    static byte[] loadBuffer;
    private Parser parser;
    private boolean foundDeployables;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    Compiler(Options options) {
        this.parser = new Parser(options);
        this.foundDeployables = false;
    }

    static void notImplemented() {
        Thread.dumpStack();
        System.exit(-1);
    }

    static int loadFile(Parser parser, Storage sourceFile) {
        int size;
        try {
            sourceFile.open();
            size = sourceFile.size();
            byte[] buffer = loadBuffer;
            if (buffer == null || buffer.length < size) {
                buffer = loadBuffer = new byte[size + 1024];
            }
            sourceFile.read(buffer);
            sourceFile.close();
        }
        catch (Exception e) {
            Error error = new Error(null, Error.errorCannotReadSource, 0, sourceFile.getPath());
            parser.error(error);
            if (loadBuffer == null) {
                loadBuffer = new byte[0];
            }
            int n = 0;
            return n;
        }
        return size;
    }

    private static void copyFile(Storage sourceFile, Storage targetDir, Log2 log) {
        try {
            sourceFile.open();
            byte[] buffer = sourceFile.read();
            sourceFile.close();
            Storage targetFile = targetDir.create(sourceFile.getName());
            targetFile.write(buffer, 0, buffer.length);
            targetFile.close();
            if (System.getProperty("resetClassTimestampToSource") != null && targetFile instanceof FileStorage) {
                ((FileStorage)targetFile).setLastModified(sourceFile.modDate());
            }
        }
        catch (Exception e) {
            Error error = new Error(null, Error.errorCannotCopy, 0, sourceFile.getPath(), targetDir.getPath());
            log.printError(error.message.getMessage());
        }
    }

    private static String changeForwardSlashesToBackwardSlashes(String str) {
        if (str != null && File.separator.charAt(0) == '\\') {
            str = str.replace('/', '\\');
        }
        return str;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] expandFile(String[] argv, int curIndex, Log2 log) {
        try {
            fileName = argv[curIndex].substring(1);
            if (!new File(fileName).exists()) {
                error = new Error(null, Error.errorCannotReadSource, 0, fileName);
                log.printError(error.message.getMessage());
                var18_5 = null;
                return var18_5;
            }
            f = new FileInputStream(fileName);
            fileSize = f.available();
            buf = new byte[fileSize];
            f.read(buf, 0, fileSize);
            f.close();
            firstChar = false;
            inString = false;
            argCnt = 0;
            i = 0;
            while (i < fileSize) {
                block17: {
                    block20: {
                        block18: {
                            block19: {
                                if (buf[i] != 96) break block18;
                                if (i + 1 >= fileSize || buf[i + 1] != 10) break block19;
                                buf[i++] = 1;
                                buf[i] = 1;
                                break block17;
                            }
                            if (i + 2 >= fileSize || buf[i + 1] != 13 || buf[i + 2] != 10) break block18;
                            buf[i++] = 1;
                            buf[i++] = 1;
                            buf[i] = 1;
                            break block17;
                        }
                        if (inString || !Character.isWhitespace((char)buf[i])) break block20;
                        buf[i] = 0;
                        firstChar = false;
                        break block17;
                    }
                    if (firstChar) ** GOTO lbl48
                    if (buf[i] == 35) {
                        while (i < fileSize) {
                            b = buf[i];
                            buf[i] = 0;
                            if (b != 10) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else {
                        firstChar = true;
                        ++argCnt;
lbl48:
                        // 2 sources

                        if (buf[i] == 34) {
                            buf[i] = 0;
                            inString ^= true;
                        }
                    }
                }
                ++i;
            }
            if (argCnt == 0) {
                var19_14 = argv;
                return var19_14;
            }
            newArgv = new String[argCnt + argv.length - 1];
            if (curIndex > 0) {
                System.arraycopy(argv, 0, newArgv, 0, curIndex);
            }
            if (curIndex + 1 < argv.length) {
                System.arraycopy(argv, curIndex + 1, newArgv, curIndex + argCnt, argv.length - (curIndex + 1));
            }
            i = 0;
            while (i < fileSize) {
                if (buf[i] != 0) {
                    len = 0;
                    j = i;
                    while (j < fileSize && buf[j] != 0) {
                        if (buf[j++] == 1) continue;
                        ++len;
                    }
                    tmpbuf = new byte[len];
                    len = 0;
                    while (i < fileSize && buf[i] != 0) {
                        if (buf[i] != 1) {
                            tmpbuf[len++] = buf[i];
                        }
                        ++i;
                    }
                    newArgv[curIndex++] = Compiler.changeForwardSlashesToBackwardSlashes(new String(tmpbuf));
                }
                ++i;
            }
            var20_19 = newArgv;
            return var20_19;
        }
        catch (Throwable e) {
            var21_21 = argv;
            return var21_21;
        }
    }

    private static void banner(Log log) {
        log.println("Oracle Java Compiler " + 11 + "." + 1 + "." + 1);
        log.println("Copyright (c) 1997-2008 Oracle Corporation. All Rights Reserved.");
    }

    static void standardUsage(Log log) {
        Compiler.banner(log);
        log.println(Message.usageString + ": ojc <" + Message.optionsString + "> <" + Message.sourceFilesString + "> <@" + Message.argumentFilesString + ">");
        log.println(Message.standardUsageScreen);
    }

    static void nonstandardUsage(Log log) {
        Compiler.banner(log);
        log.println(Message.nonStandardUsageScreen);
    }

    static void help(Log2 log, String option) {
        if (option.startsWith("-")) {
            option = option.substring(1);
        }
        boolean loaded = false;
        try {
            int index;
            Locale locale = Locale.getDefault();
            ResourceBundle rb = ResourceBundle.getBundle("oracle.ojc.ojchelp", locale);
            loaded = true;
            String value = rb.getString(option);
            if (value.charAt(0) == '-') {
                value = rb.getString(value.substring(1));
            }
            if ((index = value.indexOf("%%")) >= 0) {
                value = value.replaceAll("%%", File.pathSeparator);
            }
            Compiler.banner(log);
            log.println(value);
        }
        catch (Exception e) {
            if (!loaded) {
                log.printError("can't load OJC resource file");
            }
            log.printError("option not found in OJC resource file");
        }
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = Compiler.class$("oracle.ojc.compiler.Compiler");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    private static boolean containsWildcardCharacters(String str) {
        if (!$a && str == null) {
            throw new AssertionError();
        }
        return str.indexOf(42) >= 0 || str.indexOf(63) >= 0;
    }

    static boolean matches(String s, int soffset, String p, int poffset) {
        if (poffset >= p.length()) {
            return soffset >= s.length();
        }
        if (p.charAt(poffset) == '*') {
            return Compiler.matches(s, soffset, p, poffset + 1) || soffset < s.length() && Compiler.matches(s, soffset + 1, p, poffset);
        }
        if (soffset >= s.length()) {
            return false;
        }
        char sc = s.charAt(soffset);
        char pc = p.charAt(poffset);
        return (pc == '?' || Character.toUpperCase(sc) == Character.toUpperCase(pc) || sc == '/' && pc == '\\' || sc == '\\' && pc == '/') && Compiler.matches(s, soffset + 1, p, poffset + 1);
    }

    private static boolean ignoreDirectory(String[] ignoreDirs, String name) {
        if (ignoreDirs != null) {
            int i = 0;
            while (i < ignoreDirs.length) {
                if (Compiler.matches(name, 0, "*" + ignoreDirs[i], 0)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static void expandSourceFiles(ArrayList sourceFiles, int curRecurseLevel, int maxRecurseLevel, String[] ignoreDirs, String str) {
        File dir;
        File file = new File(str);
        String pathName = file.getParent();
        String fileName = file.getName();
        if (pathName == null) {
            String string = pathName = str.indexOf(File.separator) == 0 ? "" : ".";
        }
        if ((dir = new File(pathName + File.separator)) == null) {
            sourceFiles.add(new SourcePackageRecord(str, false));
            return;
        }
        String[] files = dir.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                String fullName = pathName + File.separator + files[i];
                if (new File(fullName).isDirectory() && curRecurseLevel < maxRecurseLevel) {
                    if (!Compiler.ignoreDirectory(ignoreDirs, fullName)) {
                        Compiler.expandSourceFiles(sourceFiles, curRecurseLevel + 1, maxRecurseLevel, ignoreDirs, fullName + File.separator + fileName);
                    }
                } else if (Compiler.matches(files[i], 0, fileName, 0)) {
                    sourceFiles.add(new SourcePackageRecord(fullName, false));
                }
                ++i;
            }
        }
    }

    public static ArrayList parseCommandLine(Log log, String[] args, Options options) {
        LogProxy logProxy = new LogProxy(log);
        if (args.length == 0) {
            Compiler.standardUsage(log);
            return null;
        }
        Warning.defaultAllWarnings();
        ArrayList<SourcePackageRecord> sourceFiles = new ArrayList<SourcePackageRecord>();
        String[] ignoreDirs = null;
        int recurseLevel = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                ++i;
                continue;
            }
            if (args[i].startsWith("-")) {
                if (args[i].equals("-recurse")) {
                    if (i + 1 < args.length) {
                        try {
                            recurseLevel = Integer.parseInt(args[i + 1]);
                            if (recurseLevel < 0) {
                                recurseLevel = 0;
                            }
                            ++i;
                        }
                        catch (NumberFormatException e) {
                            recurseLevel = Integer.MAX_VALUE;
                        }
                    }
                    ++i;
                    continue;
                }
                if (args[i].equals("-rx")) {
                    if (i + 1 >= args.length) continue;
                    ignoreDirs = Options.stringToArray(args[++i], ",");
                    continue;
                }
                if (args[i].equals("-s")) {
                    ++i;
                    while (i < args.length && !args[i].startsWith("-")) {
                        sourceFiles.add(new SourcePackageRecord(args[i++], false));
                    }
                    continue;
                }
                if (args[i].equals("-p")) {
                    ++i;
                    while (i < args.length && !args[i].startsWith("-")) {
                        sourceFiles.add(new SourcePackageRecord(args[i++], true));
                    }
                    continue;
                }
                int result = options.parseOption(args, i);
                if (result == 0) {
                    return null;
                }
                i += result;
                continue;
            }
            if (args[i].startsWith("@")) {
                if ((args = Compiler.expandFile(args, i, logProxy)) != null) continue;
                return null;
            }
            if (Compiler.containsWildcardCharacters(args[i])) {
                Compiler.expandSourceFiles(sourceFiles, 0, recurseLevel, ignoreDirs, args[i++]);
                continue;
            }
            sourceFiles.add(new SourcePackageRecord(args[i++], false));
        }
        if (options.makeFile == null) {
            options.addNameReferences = false;
        }
        if (!options.checkSourceTargetVersions()) {
            return null;
        }
        if (sourceFiles.isEmpty() && !options.helpPrinted) {
            Compiler.standardUsage(log);
        }
        return sourceFiles;
    }

    private static void printStoragePath(Log log, Storage[] storagePath, String separator) {
        int size = storagePath.length;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                log.print(separator);
            }
            log.print(storagePath[i].getPath());
            ++i;
        }
    }

    private int deployFiles(Options options, ArrayList deployables) {
        long ms = System.currentTimeMillis();
        int deployCnt = 0;
        if (options.destinationDir != null) {
            File destFile;
            if (options.destinationFile == null) {
                destFile = new File(options.destinationDir);
                if (!destFile.exists() && !destFile.mkdirs()) {
                    this.parser.error(Message.errorUnableToCreateOutputDir, 0, false, options.destinationDir);
                }
                options.destinationFile = new DirectoryStorage(destFile);
            }
            Storage targetBaseDir = options.destinationFile;
            HashMap<File, Storage> storageCache = new HashMap<File, Storage>();
            int i = 0;
            while (i < deployables.size()) {
                DeployRecord dr = (DeployRecord)deployables.get(i);
                int j = 0;
                while (j < options.deployExtensions.length) {
                    if (dr.file.getName().endsWith(options.deployExtensions[j])) {
                        Storage targetFile;
                        this.foundDeployables = true;
                        String packageDir = dr.packageName.replace('.', File.separatorChar);
                        packageDir = targetBaseDir.getPath() + File.separator + packageDir;
                        destFile = new File(packageDir);
                        Storage targetDir = (Storage)storageCache.get(destFile);
                        if (targetDir == null) {
                            if (!destFile.exists() && !destFile.mkdirs()) {
                                options.getLog().printError("unable to create output directory " + packageDir);
                                options.errorFound = true;
                            }
                            targetDir = new DirectoryStorage(destFile);
                            storageCache.put(destFile, targetDir);
                        }
                        if (!options.rebuild && (targetFile = targetDir.open(dr.file.getName())) != null && dr.file.modDate() <= targetFile.modDate()) break;
                        if (options.verbose || options.noquiet) {
                            options.getLog().println("[" + Message.deployingString + " " + dr.file.getName() + " " + Message.toString + " " + targetDir + "]");
                        }
                        Compiler.copyFile(dr.file, targetDir, options.getLog());
                        ++deployCnt;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (deployCnt > 0 && (options.verbose || options.elapsedTime)) {
                options.getLog().println("[" + Message.deploymentTimeString + " " + (System.currentTimeMillis() - ms) + "ms]");
            }
        }
        return deployCnt;
    }

    private static String internalError(Log2 log, Throwable e, ArrayList sourceFiles, Options options, Parser parser) {
        Error error = new Error(null, Error.errorInternalError, 0);
        log.printError(error.message.getMessage());
        if (options != null) {
            options.errorFound = true;
        }
        try {
            String fileName = "ojcInternalError.log";
            String tmpDirName = System.getProperty("java.io.tmpdir");
            if (tmpDirName != null) {
                if (!tmpDirName.endsWith(options.fileSeparator)) {
                    tmpDirName = tmpDirName + options.fileSeparator;
                }
                fileName = tmpDirName + fileName;
            }
            File f = new File(fileName);
            FileOutputStream fileOut = new FileOutputStream(f);
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bytesOut);
            out.println("OJC internal error log:");
            out.print("----------------------------------------------------");
            out.println("----------------------------");
            out.println("Compiler version: " + 11 + "." + 1 + "." + 1);
            out.println("Build number:     " + 4935);
            out.println("Source files:");
            if (sourceFiles == null || sourceFiles.size() == 0) {
                out.println("\t" + (sourceFiles == null ? "<null>!" : "None!"));
            } else {
                int size = sourceFiles.size();
                int i = 0;
                while (i < size) {
                    Storage storage = (Storage)sourceFiles.get(i);
                    out.println("\t" + storage.getPath());
                    ++i;
                }
            }
            out.println();
            out.println("Options:");
            if (options == null) {
                out.println("<null>");
            } else {
                options.print(out);
            }
            out.println();
            out.println("Parser:");
            if (parser == null) {
                out.println("<null>");
            } else {
                parser.print(out);
            }
            out.println();
            bytesOut.flush();
            String detailsWithoutStacktrace = bytesOut.toString();
            e.printStackTrace(out);
            out.close();
            fileOut.write(bytesOut.toByteArray());
            fileOut.flush();
            fileOut.close();
            log.println(Message.substitePercentArgument(Message.internalErrorLogString, f.getPath(), 1));
            String string = detailsWithoutStacktrace;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Unknown compiler state";
        }
    }

    private static void outOfMemoryError(Log2 log) {
        Error error = new Error(null, Error.errorOutOfMemoryError, 0);
        log.printError(error.message.getMessage());
    }

    public static int main_throws_exceptions(ArrayList sourceFiles, Options options) throws Exception {
        Message.initializeMessages(options.getLog());
        options.sourceTargetJDKDefault = false;
        if (sourceFiles.size() > 0) {
            return Compiler.main_internal(sourceFiles, options, options.getLog());
        }
        return 0;
    }

    public static int main(ArrayList sourceFiles, Options options) {
        try {
            int n = Compiler.main_throws_exceptions(sourceFiles, options);
            return n;
        }
        catch (Exception e) {
            int n = 2;
            return n;
        }
    }

    public static int main(String[] args, Log log) {
        return Compiler.main(args, log, null);
    }

    public static int main(String[] args, Log log, IdeEnv ideEnv) {
        try {
            Message.initializeMessages(log);
            Options options = new Options(log);
            options.ideEnv = ideEnv;
            ArrayList sourceFiles = Compiler.parseCommandLine(options.getLog(), args, options);
            if (sourceFiles == null) {
                int n = 1;
                return n;
            }
            if (sourceFiles.size() > 0) {
                int n = Compiler.main_internal(sourceFiles, options, options.getLog());
                return n;
            }
        }
        catch (Exception e) {
            int n = 2;
            return n;
        }
        return 0;
    }

    public static int main(String[] args, List storages, Log log) {
        try {
            ArrayList sourceFiles;
            Message.initializeMessages(log);
            Options options = new Options(log);
            options.helpPrinted = true;
            if (args != null && args.length > 0) {
                sourceFiles = Compiler.parseCommandLine(options.getLog(), args, options);
                if (sourceFiles == null) {
                    int n = 1;
                    return n;
                }
            } else {
                sourceFiles = new ArrayList();
            }
            if (storages != null) {
                sourceFiles.addAll(storages);
            }
            if (sourceFiles.size() > 0) {
                int n = Compiler.main_internal(sourceFiles, options, options.getLog());
                return n;
            }
            Compiler.standardUsage(log);
        }
        catch (Exception e) {
            int n = 2;
            return n;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int main_internal(ArrayList sourceFiles, Options options, Log2 log) throws Exception {
        int compileResult;
        Exception finalException;
        block78: {
            Parser parser;
            block77: {
                int n;
                block76: {
                    int n2;
                    block75: {
                        int n3;
                        finalException = null;
                        parser = null;
                        ArrayList compilables = null;
                        compileResult = 0;
                        try {
                            block74: {
                                try {
                                    boolean noCompilables;
                                    Identifier.initializeIdentifiers(options.targetJDKVersion);
                                    Symbol.initializeSymbols();
                                    Expression.initializeExpressions();
                                    Annotation.initializeStatics();
                                    int messageNumber = Message.warningDirectoryDoesntExist.getNumber();
                                    boolean warnNonExistingPath = (messageNumber < Warning.warnings.size() && !Warning.warnings.get(messageNumber)) ^ true;
                                    boolean warnEndorsedDir = true;
                                    if (options.endorseddirsStr == null) {
                                        options.endorseddirsStr = System.getProperty("java.endorsed.dirs");
                                        warnEndorsedDir = false;
                                    }
                                    if (options.bootClasspathStr == null) {
                                        options.bootClasspathStr = System.getProperty("sun.boot.class.path");
                                        if (options.bootClasspathStr == null) {
                                            options.bootClasspathStr = System.getProperty("java.class.path");
                                        }
                                        if (options.bootClasspathStr == null && warnNonExistingPath) {
                                            options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, false, false);
                                        }
                                    } else if (warnNonExistingPath) {
                                        options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, true, false);
                                    }
                                    if (options.prependBootClasspathStr != null) {
                                        if (warnNonExistingPath) {
                                            options.makeClassPath(options.prependBootClasspathStr, Message.bootclasspathString, true, false);
                                        }
                                        options.bootClasspathStr = options.bootClasspathStr == null ? options.prependBootClasspathStr : options.prependBootClasspathStr + options.bootClasspathStr;
                                    }
                                    if (options.appendBootClasspathStr != null) {
                                        if (warnNonExistingPath) {
                                            options.makeClassPath(options.appendBootClasspathStr, Message.bootclasspathString, true, false);
                                        }
                                        options.bootClasspathStr = options.bootClasspathStr == null ? options.appendBootClasspathStr : options.bootClasspathStr + options.appendBootClasspathStr;
                                    }
                                    boolean warnExtDir = true;
                                    if (options.extdirsStr == null) {
                                        options.extdirsStr = System.getProperty("java.ext.dirs");
                                        warnExtDir = false;
                                    }
                                    if (options.classpathStr == null && options.classpathStorage == null) {
                                        options.classpathStr = System.getProperty("env.class.path");
                                    }
                                    boolean warnSourcepath = true;
                                    if (options.sourcepathStr == null && options.sourcepathStorage == null) {
                                        options.sourcepathStr = System.getProperty("env.source.path");
                                        if (options.sourcepathStr == null && options.classpathStr != null) {
                                            options.sourcepathStr = options.classpathStr;
                                            warnSourcepath = false;
                                        }
                                    }
                                    if (options.endorseddirsStr != null) {
                                        options.endorseddirs = options.makeClassPath(options.endorseddirsStr, Message.endorsedDirectoryListString, warnEndorsedDir, true);
                                    }
                                    if (options.bootClasspathStr != null) {
                                        options.bootClasspath = options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, false, false);
                                    }
                                    if (options.extdirsStr != null) {
                                        options.extdirs = options.makeClassPath(options.extdirsStr, Message.extensionDirectoryListString, warnExtDir, true);
                                    }
                                    if (options.classpathStr != null) {
                                        options.classpath = options.makeClassPath(options.classpathStr, Message.classpathString, true, false);
                                    } else if (options.classpathStorage != null) {
                                        options.classpath = options.classpathStorage;
                                    }
                                    options.classpath = Compiler.makeWrappedPath(options.classpath);
                                    if (options.sourcepathStr != null) {
                                        options.sourcepath = options.makeClassPath(options.sourcepathStr, Message.sourcepathString, warnSourcepath, false);
                                    } else if (options.sourcepathStorage != null) {
                                        options.sourcepath = options.sourcepathStorage;
                                    }
                                    if (options.verbosepath) {
                                        log.print("[endorsed dirs: ");
                                        if (options.endorseddirs != null) {
                                            Compiler.printStoragePath(log, options.endorseddirs, options.pathSeparator);
                                        }
                                        log.println(" ]");
                                        log.print("[boot classpath: ");
                                        if (options.bootClasspath != null) {
                                            Compiler.printStoragePath(log, options.bootClasspath, options.pathSeparator);
                                        }
                                        log.println(" ]");
                                        log.print("[ext dirs: ");
                                        if (options.extdirs != null) {
                                            Compiler.printStoragePath(log, options.extdirs, options.pathSeparator);
                                        }
                                        log.println(" ]");
                                        log.print("[classpath: ");
                                        if (options.classpath != null) {
                                            Compiler.printStoragePath(log, options.classpath, options.pathSeparator);
                                        }
                                        log.println(" ]");
                                        log.print("[sourcepath: ");
                                        if (options.sourcepath != null) {
                                            Compiler.printStoragePath(log, options.sourcepath, "");
                                        }
                                        log.println(" ]");
                                    }
                                    if (options.verbose) {
                                        log.println("[encoding: " + options.encoding + "]");
                                    }
                                    Compiler compiler = new Compiler(options);
                                    parser = compiler.parser;
                                    if (parser.errorFound || options.errorFound) {
                                        n3 = 1;
                                        Object var50_14 = null;
                                        break block74;
                                    }
                                    RawClassSymbol.javaLangObjectSymbol = parser.javaLangObjectSymbol;
                                    ArrayList<DeployRecord> deployables = new ArrayList<DeployRecord>();
                                    compilables = new ArrayList();
                                    int i = 0;
                                    while (true) {
                                        if (i >= sourceFiles.size()) {
                                            boolean bl = noCompilables = compilables.size() == 0;
                                        }
                                        Object obj = sourceFiles.get(i);
                                        if (obj instanceof Storage) {
                                            compilables.add(obj);
                                        } else {
                                            Storage sourceFile;
                                            SourcePackageRecord spr = (SourcePackageRecord)obj;
                                            if (spr.isPackage) {
                                                ArrayList sourceFilesInPackage = options.findSourcesInPackage(parser, spr.source);
                                                if (sourceFilesInPackage != null) {
                                                    int j = 0;
                                                    while (j < sourceFilesInPackage.size()) {
                                                        sourceFile = (Storage)sourceFilesInPackage.get(j);
                                                        if (sourceFile.getName().endsWith(".java")) {
                                                            compilables.add(sourceFile);
                                                        } else {
                                                            deployables.add(new DeployRecord(spr.source, sourceFile));
                                                        }
                                                        ++j;
                                                    }
                                                }
                                            } else {
                                                sourceFile = new FileStorage(new File(spr.source));
                                                if (spr.source.endsWith(".java")) {
                                                    compilables.add(sourceFile);
                                                } else {
                                                    String packageName;
                                                    int index = spr.source.lastIndexOf(File.separatorChar);
                                                    if (index < 0) {
                                                        packageName = "";
                                                    } else {
                                                        packageName = spr.source.substring(0, index);
                                                        packageName = packageName.replace(File.separatorChar, '.');
                                                    }
                                                    deployables.add(new DeployRecord(packageName, sourceFile));
                                                }
                                            }
                                        }
                                        ++i;
                                    }
                                    if (options.makeFile != null) {
                                        compilables = parser.depInfo.analyzeSources(compilables, options);
                                        parser.depInfo.startWritingNameRefFile(options.makeFile);
                                    }
                                    compilables = Compiler.trimDuplicates(compilables);
                                    long startTime = System.currentTimeMillis();
                                    parser.parse(compilables);
                                    long endTime = System.currentTimeMillis();
                                    int deployCnt = 0;
                                    if ((!parser.errorFound || options.generateClassesDespiteErrors) && deployables.size() > 0 && options.deployExtensions != null && options.destinationDir != null) {
                                        deployCnt = compiler.deployFiles(options, deployables);
                                    }
                                    int n4 = compileResult = parser.errorFound ? 1 : 0;
                                    if (parser.sourceFileList.size() == 0 && deployCnt == 0 && !options.verbose) {
                                        if (noCompilables && !compiler.foundDeployables) {
                                            Compiler.standardUsage(log);
                                            n2 = 1;
                                            break block75;
                                        }
                                        n = compileResult;
                                        break block76;
                                    }
                                    parser.printMessages(log);
                                    Compiler.checkUnusedZipFiles(parser, options.classpath);
                                    if (options.verbose || options.elapsedTime) {
                                        String lineString = parser.sourceLineCount == 1 ? Message.lineString : Message.linesString;
                                        String sfileString = parser.sourceFileList.size() == 1 ? Message.fileString : Message.filesString;
                                        String cfileString = parser.classFileCount == 1 ? Message.classString : Message.classesString;
                                        String dfileString = deployCnt == 1 ? Message.fileString : Message.filesString;
                                        log.print("[" + parser.sourceLineCount + " " + lineString + " " + Message.compiledString + " " + Message.inString + " " + (endTime - startTime) + "ms " + Message.fromString + " " + parser.sourceFileList.size() + " " + sfileString + ", " + Message.generatingString + " " + parser.classFileCount + " " + cfileString);
                                        if (deployCnt > 0) {
                                            log.print(", " + Message.deployingString + " " + deployCnt + " " + dfileString);
                                        }
                                        log.println("]");
                                    }
                                    break block77;
                                }
                                catch (OutOfMemoryError e) {
                                    Compiler.outOfMemoryError(options.getLog());
                                    int n5 = 4;
                                    Object var50_18 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    return n5;
                                }
                                catch (RuntimeException e) {
                                    String msg = e.getMessage();
                                    if (msg != null && msg.equals("user aborted")) {
                                        int n6 = 3;
                                        Object var50_19 = null;
                                        options.releaseJars();
                                        Options.releaseStatics();
                                        Identifier.releaseIdentifiers();
                                        Symbol.releaseSymbols();
                                        Expression.releaseExpressions();
                                        Annotation.releaseStatics();
                                        OJCDEBUG.releaseStatics();
                                        if (parser != null) {
                                            parser.depInfo.clear();
                                            parser.depInfo = null;
                                        }
                                        return n6;
                                    }
                                    e.printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), e, compilables, options, parser);
                                    finalException = new Exception(message, e);
                                    Object var50_20 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block78;
                                }
                                catch (AssertionError e) {
                                    ((Throwable)((Object)e)).printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), (Throwable)((Object)e), compilables, options, parser);
                                    finalException = new Exception(message, (Throwable)((Object)e));
                                    Object var50_21 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block78;
                                }
                                catch (StackOverflowError e) {
                                    e.printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), e, compilables, options, parser);
                                    finalException = new Exception(message, e);
                                    Object var50_22 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block78;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), e, compilables, options, parser);
                                    finalException = new Exception(message, e);
                                    Object var50_23 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block78;
                                }
                                catch (java.lang.Error e) {
                                    e.printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), e, compilables, options, parser);
                                    finalException = new Exception(message, e);
                                    Object var50_24 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block78;
                                }
                            }
                            options.releaseJars();
                        }
                        catch (Throwable throwable) {
                            Object var50_25 = null;
                            options.releaseJars();
                            Options.releaseStatics();
                            Identifier.releaseIdentifiers();
                            Symbol.releaseSymbols();
                            Expression.releaseExpressions();
                            Annotation.releaseStatics();
                            OJCDEBUG.releaseStatics();
                            if (parser != null) {
                                parser.depInfo.clear();
                                parser.depInfo = null;
                            }
                            throw throwable;
                        }
                        Options.releaseStatics();
                        Identifier.releaseIdentifiers();
                        Symbol.releaseSymbols();
                        Expression.releaseExpressions();
                        Annotation.releaseStatics();
                        OJCDEBUG.releaseStatics();
                        if (parser != null) {
                            parser.depInfo.clear();
                            parser.depInfo = null;
                        }
                        return n3;
                    }
                    Object var50_15 = null;
                    options.releaseJars();
                    Options.releaseStatics();
                    Identifier.releaseIdentifiers();
                    Symbol.releaseSymbols();
                    Expression.releaseExpressions();
                    Annotation.releaseStatics();
                    OJCDEBUG.releaseStatics();
                    if (parser != null) {
                        parser.depInfo.clear();
                        parser.depInfo = null;
                    }
                    return n2;
                }
                Object var50_16 = null;
                options.releaseJars();
                Options.releaseStatics();
                Identifier.releaseIdentifiers();
                Symbol.releaseSymbols();
                Expression.releaseExpressions();
                Annotation.releaseStatics();
                OJCDEBUG.releaseStatics();
                if (parser != null) {
                    parser.depInfo.clear();
                    parser.depInfo = null;
                }
                return n;
            }
            Object var50_17 = null;
            options.releaseJars();
            Options.releaseStatics();
            Identifier.releaseIdentifiers();
            Symbol.releaseSymbols();
            Expression.releaseExpressions();
            Annotation.releaseStatics();
            OJCDEBUG.releaseStatics();
            if (parser != null) {
                parser.depInfo.clear();
                parser.depInfo = null;
            }
        }
        if (finalException != null) {
            throw finalException;
        }
        return compileResult;
    }

    private static Storage[] makeWrappedPath(Storage[] pathEntries) {
        if (Warning.warnings.get(Warning.warningZipFileNotUsed.getNumber()) && pathEntries != null) {
            HashMap<Storage, Storage> pathEntryMap = new HashMap<Storage, Storage>();
            Storage[] newEntries = new Storage[pathEntries.length];
            int x = 0;
            while (x < pathEntries.length) {
                String pathName = pathEntries[x].getName();
                if (pathName != null && (pathName.endsWith(".jar") || pathName.endsWith(".zip"))) {
                    if (pathName.equals("rt.jar") || pathName.equals("jsse.jar") || pathName.equals("jce.jar") || pathName.equals("charsets.jar")) {
                        String fullName = pathEntries[x].getPath();
                        if (fullName != null) {
                            if ((fullName = fullName.replace('\\', '/')).endsWith("jre/lib/rt.jar") || fullName.endsWith("jre/lib/jsse.jar") || fullName.endsWith("jre/lib/jce.jar") || fullName.endsWith("jre/lib/charsets.jar")) {
                                newEntries[x] = pathEntries[x];
                            } else {
                                newEntries[x] = new WrappedStorage(pathEntries[x]);
                                pathEntryMap.put(pathEntries[x], newEntries[x]);
                            }
                        }
                    } else {
                        newEntries[x] = new WrappedStorage(pathEntries[x]);
                        pathEntryMap.put(pathEntries[x], newEntries[x]);
                    }
                } else {
                    newEntries[x] = pathEntries[x];
                }
                ++x;
            }
            int x2 = 0;
            while (x2 < newEntries.length) {
                WrappedStorage enclosingWrappedStorage;
                Storage enclosingStorage;
                if (newEntries[x2] instanceof WrappedStorage && (enclosingStorage = (Storage)newEntries[x2].getProperty("enclosing_storage")) != null && (enclosingWrappedStorage = (WrappedStorage)pathEntryMap.get(enclosingStorage)) != null) {
                    WrappedStorage newWrappedStorage = (WrappedStorage)newEntries[x2];
                    newWrappedStorage.setParent(enclosingWrappedStorage);
                }
                ++x2;
            }
            pathEntryMap.clear();
            return newEntries;
        }
        return pathEntries;
    }

    private static void checkUnusedZipFiles(Parser parser, Storage[] pathEntries) {
        if (Warning.warnings.get(Warning.warningZipFileNotUsed.getNumber()) && pathEntries != null) {
            int x = 0;
            while (x < pathEntries.length) {
                WrappedStorage wrappedStorage;
                if (pathEntries[x] instanceof WrappedStorage && pathEntries[x].getProperty("enclosing_storage") == null && !(wrappedStorage = (WrappedStorage)pathEntries[x]).hasBeenUsedForIO()) {
                    Warning warning = new Warning(null, Message.warningZipFileNotUsed, 0, wrappedStorage.getPath());
                    parser.warning(warning);
                }
                ++x;
            }
        }
    }

    private static ArrayList trimDuplicates(ArrayList compilables) {
        HashSet<String> pathNames = new HashSet<String>(compilables.size());
        int i = compilables.size() - 1;
        while (i >= 0) {
            Storage storage = (Storage)compilables.get(i);
            String pathName = storage.getPath();
            if (pathNames.contains(pathName)) {
                compilables.remove(i);
            } else {
                pathNames.add(pathName);
            }
            --i;
        }
        return compilables;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SourcePackageRecord {
        boolean isPackage;
        String source;

        SourcePackageRecord(String source, boolean isPackage) {
            this.source = source;
            this.isPackage = isPackage;
        }
    }

    static class DeployRecord {
        String packageName;
        Storage file;

        DeployRecord(String packageName, Storage file) {
            this.packageName = packageName;
            this.file = file;
        }
    }
}

