/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPoolClass;
import oracle.ojc.compiler.ConstantPoolDouble;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.ConstantPoolFieldRef;
import oracle.ojc.compiler.ConstantPoolFloat;
import oracle.ojc.compiler.ConstantPoolInteger;
import oracle.ojc.compiler.ConstantPoolInterfaceMethodRef;
import oracle.ojc.compiler.ConstantPoolLong;
import oracle.ojc.compiler.ConstantPoolMethodRef;
import oracle.ojc.compiler.ConstantPoolNameAndType;
import oracle.ojc.compiler.ConstantPoolString;
import oracle.ojc.compiler.ConstantPoolUtf8;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbolList;

final class ConstantPool {
    static final byte CONSTANT_Utf8 = 1;
    static final byte CONSTANT_Integer = 3;
    static final byte CONSTANT_Float = 4;
    static final byte CONSTANT_Long = 5;
    static final byte CONSTANT_Double = 6;
    static final byte CONSTANT_Class = 7;
    static final byte CONSTANT_String = 8;
    static final byte CONSTANT_Fieldref = 9;
    static final byte CONSTANT_Methodref = 10;
    static final byte CONSTANT_InterfaceMethodref = 11;
    static final byte CONSTANT_NameAndType = 12;
    private static final int CONSTANTPOOL_INTEGER_HASHTABLESIZE = 128;
    private static final int CONSTANTPOOL_LONG_HASHTABLESIZE = 32;
    private static final int CONSTANTPOOL_FLOAT_HASHTABLESIZE = 32;
    private static final int CONSTANTPOOL_DOUBLE_HASHTABLESIZE = 32;
    private static final int CONSTANTPOOL_STRING_HASHTABLESIZE = 64;
    private static final int CONSTANTPOOL_FIELDREF_HASHTABLESIZE = 256;
    private static final int CONSTANTPOOL_INTERFACEMETHODREF_HASHTABLESIZE = 64;
    private static final int CONSTANTPOOL_METHODREF_HASHTABLESIZE = 256;
    private static final int CONSTANTPOOL_CLASS_HASHTABLESIZE = 128;
    private static final int CONSTANTPOOL_NAMEANDTYPE_HASHTABLESIZE = 256;
    private static final int CONSTANTPOOL_UTF8_HASHTABLESIZE = 256;
    ConstantPoolClass[] constantPoolClassHashTable;
    int constantPoolClassHashTableCount;
    private ConstantPoolFieldRef[] constantPoolFieldRefHashTable;
    private int constantPoolFieldRefHashTableCount;
    private ConstantPoolMethodRef[] constantPoolMethodRefHashTable;
    private int constantPoolMethodRefHashTableCount;
    private ConstantPoolInterfaceMethodRef[] constantPoolInterfaceMethodRefHashTable;
    private int constantPoolInterfaceMethodRefHashTableCount;
    private ConstantPoolNameAndType[] constantPoolNameAndTypeHashTable;
    private int constantPoolNameAndTypeHashTableCount;
    private ConstantPoolString[] constantPoolStringHashTable;
    private int constantPoolStringHashTableCount;
    private ConstantPoolUtf8[] constantPoolUtf8HashTable;
    private int constantPoolUtf8HashTableCount;
    private ConstantPoolInteger[] constantPoolIntegerHashTable;
    private int constantPoolIntegerHashTableCount;
    private ConstantPoolLong[] constantPoolLongHashTable;
    private int constantPoolLongHashTableCount;
    private ConstantPoolFloat[] constantPoolFloatHashTable;
    private int constantPoolFloatHashTableCount;
    private ConstantPoolDouble[] constantPoolDoubleHashTable;
    private int constantPoolDoubleHashTableCount;
    private int constantPoolIndex;
    private ArrayList constantPoolVector;
    Parser parser;
    TypeSymbolList outOfPackageInnerClassList;

    ConstantPool(Parser parser) {
        this.parser = parser;
        this.constantPoolClassHashTable = new ConstantPoolClass[128];
        this.constantPoolFieldRefHashTable = new ConstantPoolFieldRef[256];
        this.constantPoolMethodRefHashTable = new ConstantPoolMethodRef[256];
        this.constantPoolInterfaceMethodRefHashTable = new ConstantPoolInterfaceMethodRef[64];
        this.constantPoolNameAndTypeHashTable = new ConstantPoolNameAndType[256];
        this.constantPoolStringHashTable = new ConstantPoolString[64];
        this.constantPoolUtf8HashTable = new ConstantPoolUtf8[256];
        this.constantPoolIntegerHashTable = new ConstantPoolInteger[128];
        this.constantPoolLongHashTable = new ConstantPoolLong[32];
        this.constantPoolFloatHashTable = new ConstantPoolFloat[32];
        this.constantPoolDoubleHashTable = new ConstantPoolDouble[32];
        this.constantPoolVector = new ArrayList();
        this.constantPoolVector.add(null);
        this.constantPoolIndex = 1;
    }

    private int rehashConstantPoolClass() {
        int cnt = this.constantPoolClassHashTableCount;
        ConstantPoolClass[] oldTable = this.constantPoolClassHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolClass[] newTable = new ConstantPoolClass[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolClass cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolClass ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolClassHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolClass(char[] className) {
        int count = this.constantPoolClassHashTableCount;
        int length = this.constantPoolClassHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolClass();
        }
        int hash = Identifier.hashCode(className) & length - 1;
        ConstantPoolClass cpe = this.constantPoolClassHashTable[hash];
        while (cpe != null) {
            if (Identifier.compare(className, cpe.className)) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolClass(this, className);
        cpe.nextHashed = this.constantPoolClassHashTable[hash];
        this.constantPoolClassHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolClassHashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolMethodRef() {
        int cnt = this.constantPoolMethodRefHashTableCount;
        ConstantPoolMethodRef[] oldTable = this.constantPoolMethodRefHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolMethodRef[] newTable = new ConstantPoolMethodRef[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolMethodRef cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolMethodRef ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolMethodRefHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolMethodRef(char[] className, char[] name, char[] signature) {
        int count = this.constantPoolMethodRefHashTableCount;
        int length = this.constantPoolMethodRefHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolMethodRef();
        }
        int hash = Identifier.hashCode(className) + Identifier.hashCode(name) + Identifier.hashCode(signature) & length - 1;
        ConstantPoolMethodRef cpe = this.constantPoolMethodRefHashTable[hash];
        while (cpe != null) {
            if (Identifier.compare(className, cpe.className) && Identifier.compare(name, cpe.name) && Identifier.compare(signature, cpe.signature)) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolMethodRef(this, className, name, signature);
        cpe.nextHashed = this.constantPoolMethodRefHashTable[hash];
        this.constantPoolMethodRefHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolMethodRefHashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolInterfaceMethodRef() {
        int cnt = this.constantPoolInterfaceMethodRefHashTableCount;
        ConstantPoolInterfaceMethodRef[] oldTable = this.constantPoolInterfaceMethodRefHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolInterfaceMethodRef[] newTable = new ConstantPoolInterfaceMethodRef[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolInterfaceMethodRef cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolInterfaceMethodRef ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolInterfaceMethodRefHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolInterfaceMethodRef(char[] className, char[] name, char[] signature) {
        int count = this.constantPoolInterfaceMethodRefHashTableCount;
        int length = this.constantPoolInterfaceMethodRefHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolInterfaceMethodRef();
        }
        int hash = Identifier.hashCode(className) + Identifier.hashCode(name) + Identifier.hashCode(signature) & length - 1;
        ConstantPoolInterfaceMethodRef cpe = this.constantPoolInterfaceMethodRefHashTable[hash];
        while (cpe != null) {
            if (Identifier.compare(className, cpe.className) && Identifier.compare(name, cpe.name) && Identifier.compare(signature, cpe.signature)) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolInterfaceMethodRef(this, className, name, signature);
        cpe.nextHashed = this.constantPoolInterfaceMethodRefHashTable[hash];
        this.constantPoolInterfaceMethodRefHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolInterfaceMethodRefHashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolFieldRef() {
        int cnt = this.constantPoolFieldRefHashTableCount;
        ConstantPoolFieldRef[] oldTable = this.constantPoolFieldRefHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolFieldRef[] newTable = new ConstantPoolFieldRef[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolFieldRef cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolFieldRef ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolFieldRefHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolFieldRef(char[] className, char[] name, char[] signature) {
        int count = this.constantPoolFieldRefHashTableCount;
        int length = this.constantPoolFieldRefHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolFieldRef();
        }
        int hash = Identifier.hashCode(className) + Identifier.hashCode(name) + Identifier.hashCode(signature) & length - 1;
        ConstantPoolFieldRef cpe = this.constantPoolFieldRefHashTable[hash];
        while (cpe != null) {
            if (Identifier.compare(className, cpe.className) && Identifier.compare(name, cpe.name) && Identifier.compare(signature, cpe.signature)) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolFieldRef(this, className, name, signature);
        cpe.nextHashed = this.constantPoolFieldRefHashTable[hash];
        this.constantPoolFieldRefHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolFieldRefHashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolNameAndType() {
        int cnt = this.constantPoolNameAndTypeHashTableCount;
        ConstantPoolNameAndType[] oldTable = this.constantPoolNameAndTypeHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolNameAndType[] newTable = new ConstantPoolNameAndType[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolNameAndType cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolNameAndType ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolNameAndTypeHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolNameAndType(char[] name, char[] signature) {
        int count = this.constantPoolNameAndTypeHashTableCount;
        int length = this.constantPoolNameAndTypeHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolNameAndType();
        }
        int hash = Identifier.hashCode(name) + Identifier.hashCode(signature) & length - 1;
        ConstantPoolNameAndType cpe = this.constantPoolNameAndTypeHashTable[hash];
        while (cpe != null) {
            if (Identifier.compare(name, cpe.name) && Identifier.compare(signature, cpe.type)) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolNameAndType(this, name, signature);
        cpe.nextHashed = this.constantPoolNameAndTypeHashTable[hash];
        this.constantPoolNameAndTypeHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolNameAndTypeHashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolUtf8() {
        int cnt = this.constantPoolUtf8HashTableCount;
        ConstantPoolUtf8[] oldTable = this.constantPoolUtf8HashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolUtf8[] newTable = new ConstantPoolUtf8[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolUtf8 cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolUtf8 ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolUtf8HashTable = newTable;
        return newLength;
    }

    short enterConstantPoolUtf8(char[] string) {
        int count = this.constantPoolUtf8HashTableCount;
        int length = this.constantPoolUtf8HashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolUtf8();
        }
        int hash = Identifier.hashCode(string) & length - 1;
        ConstantPoolUtf8 cpe = this.constantPoolUtf8HashTable[hash];
        while (cpe != null) {
            if (Identifier.compare(string, cpe.string)) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolUtf8(string);
        cpe.nextHashed = this.constantPoolUtf8HashTable[hash];
        this.constantPoolUtf8HashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolUtf8HashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolString() {
        int cnt = this.constantPoolStringHashTableCount;
        ConstantPoolString[] oldTable = this.constantPoolStringHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolString[] newTable = new ConstantPoolString[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolString cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolString ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolStringHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolString(char[] str) {
        int count = this.constantPoolStringHashTableCount;
        int length = this.constantPoolStringHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolString();
        }
        int hash = Identifier.hashCode(str) & length - 1;
        ConstantPoolString cpe = this.constantPoolStringHashTable[hash];
        while (cpe != null) {
            if (Identifier.compare(str, cpe.string)) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolString(this, str);
        cpe.nextHashed = this.constantPoolStringHashTable[hash];
        this.constantPoolStringHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolStringHashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolInteger() {
        int cnt = this.constantPoolIntegerHashTableCount;
        ConstantPoolInteger[] oldTable = this.constantPoolIntegerHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolInteger[] newTable = new ConstantPoolInteger[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolInteger cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolInteger ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolIntegerHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolInteger(int ival) {
        int count = this.constantPoolIntegerHashTableCount;
        int length = this.constantPoolIntegerHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolInteger();
        }
        int hash = ConstantPoolInteger.hashCode(ival) & length - 1;
        ConstantPoolInteger cpe = this.constantPoolIntegerHashTable[hash];
        while (cpe != null) {
            if (cpe.ival == ival) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolInteger(ival);
        cpe.nextHashed = this.constantPoolIntegerHashTable[hash];
        this.constantPoolIntegerHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolIntegerHashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolLong() {
        int cnt = this.constantPoolLongHashTableCount;
        ConstantPoolLong[] oldTable = this.constantPoolLongHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolLong[] newTable = new ConstantPoolLong[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolLong cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolLong ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolLongHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolLong(long lval) {
        int count = this.constantPoolLongHashTableCount;
        int length = this.constantPoolLongHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolLong();
        }
        int hash = ConstantPoolLong.hashCode(lval) & length - 1;
        ConstantPoolLong cpe = this.constantPoolLongHashTable[hash];
        while (cpe != null) {
            if (cpe.lval == lval) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolLong(lval);
        cpe.nextHashed = this.constantPoolLongHashTable[hash];
        this.constantPoolLongHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        this.constantPoolVector.add(null);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65535) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolLongHashTableCount = count + 1;
        this.constantPoolIndex = index + 2;
        return (short)index;
    }

    private int rehashConstantPoolFloat() {
        int cnt = this.constantPoolFloatHashTableCount;
        ConstantPoolFloat[] oldTable = this.constantPoolFloatHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolFloat[] newTable = new ConstantPoolFloat[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolFloat cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolFloat ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolFloatHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolFloat(float fval) {
        int count = this.constantPoolFloatHashTableCount;
        int length = this.constantPoolFloatHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolFloat();
        }
        int bits = Float.floatToIntBits(fval);
        int hash = ConstantPoolFloat.hashCode(bits) & length - 1;
        ConstantPoolFloat cpe = this.constantPoolFloatHashTable[hash];
        while (cpe != null) {
            if (cpe.bits == bits) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolFloat(bits);
        cpe.nextHashed = this.constantPoolFloatHashTable[hash];
        this.constantPoolFloatHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolFloatHashTableCount = count + 1;
        this.constantPoolIndex = index + 1;
        return (short)index;
    }

    private int rehashConstantPoolDouble() {
        int cnt = this.constantPoolDoubleHashTableCount;
        ConstantPoolDouble[] oldTable = this.constantPoolDoubleHashTable;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ConstantPoolDouble[] newTable = new ConstantPoolDouble[newLength];
        int i = 0;
        while (i < oldLength) {
            ConstantPoolDouble cpe = oldTable[i];
            if (cpe != null) {
                ConstantPoolDouble ncpe;
                do {
                    --cnt;
                    ncpe = cpe.nextHashed;
                    int hash = cpe.hashCode() & newLength - 1;
                    cpe.nextHashed = newTable[hash];
                    newTable[hash] = cpe;
                } while ((cpe = ncpe) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        this.constantPoolDoubleHashTable = newTable;
        return newLength;
    }

    short enterConstantPoolDouble(double dval) {
        int count = this.constantPoolDoubleHashTableCount;
        int length = this.constantPoolDoubleHashTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehashConstantPoolDouble();
        }
        long bits = Double.doubleToLongBits(dval);
        int hash = ConstantPoolDouble.hashCode(bits) & length - 1;
        ConstantPoolDouble cpe = this.constantPoolDoubleHashTable[hash];
        while (cpe != null) {
            if (cpe.bits == bits) {
                return cpe.index;
            }
            cpe = cpe.nextHashed;
        }
        cpe = new ConstantPoolDouble(bits);
        cpe.nextHashed = this.constantPoolDoubleHashTable[hash];
        this.constantPoolDoubleHashTable[hash] = cpe;
        this.constantPoolVector.add(cpe);
        this.constantPoolVector.add(null);
        int index = this.constantPoolIndex;
        cpe.index = (short)index;
        if (index >= 65535) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolDoubleHashTableCount = count + 1;
        this.constantPoolIndex = index + 2;
        return (short)index;
    }

    void writeConstantPool(ClassFileWriter cfw) throws IOException {
        int wbIdx = cfw.ensureWriteBufferCapacity(2);
        byte[] wb = cfw.writeBuffer;
        int cpIdx = this.constantPoolIndex;
        wb[wbIdx + 1] = (byte)cpIdx;
        wb[wbIdx] = (byte)(cpIdx >> 8);
        cfw.writeBufferIndex = wbIdx + 2;
        ConstantPoolEntry[] cpeArray = this.constantPoolVector.toArray(new ConstantPoolEntry[cpIdx]);
        int i = 1;
        while (i < cpIdx) {
            ConstantPoolEntry cpe = cpeArray[i];
            i += cpe.write(cfw);
            ++i;
        }
    }

    void checkForOutOfPackageInnerClass(RawClassSymbol classSymbol, RawClassSymbol innerClass) {
        if (innerClass.isInnerClass() && innerClass.getPackageScope() != classSymbol.getPackageScope()) {
            TypeSymbolList tsl = this.outOfPackageInnerClassList;
            while (tsl != null) {
                if (innerClass.equalTo(tsl.typeSymbol)) {
                    return;
                }
                tsl = tsl.next;
            }
            tsl = new TypeSymbolList(innerClass);
            tsl.next = this.outOfPackageInnerClassList;
            this.outOfPackageInnerClassList = tsl;
        }
    }
}

