/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPoolEntry;

final class ConstantPoolDouble
extends ConstantPoolEntry {
    ConstantPoolDouble nextHashed;
    long bits;

    ConstantPoolDouble(long bits) {
        super((byte)6);
        this.bits = bits;
    }

    int write(ClassFileWriter cfw) throws IOException {
        int wbIdx = cfw.ensureWriteBufferCapacity(9);
        byte[] wb = cfw.writeBuffer;
        wb[wbIdx + 8] = (byte)this.bits;
        wb[wbIdx + 7] = (byte)(this.bits >> 8);
        wb[wbIdx + 6] = (byte)(this.bits >> 16);
        wb[wbIdx + 5] = (byte)(this.bits >> 24);
        wb[wbIdx + 4] = (byte)(this.bits >> 32);
        wb[wbIdx + 3] = (byte)(this.bits >> 40);
        wb[wbIdx + 2] = (byte)(this.bits >> 48);
        wb[wbIdx + 1] = (byte)(this.bits >> 56);
        wb[wbIdx] = 6;
        cfw.writeBufferIndex = wbIdx + 9;
        return 1;
    }

    static int hashCode(long bits) {
        return (int)bits + (int)(bits >> 32);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ConstantPoolDouble.hashCode(this.bits);
        }
        return this.hash;
    }
}

