/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;

final class DoStatement
extends LoopStatement {
    Expression condition;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    DoStatement(StatementList parent, int pos, int bodyPos, Expression condition, StatementList bodyStatements) {
        super(parent, pos, bodyPos, (byte)13, bodyStatements);
        this.condition = condition;
    }

    void resolveAndCheck(Parser parser) {
        SwitchLoopList outerSwitchLoop = parser.innerSwitchLoop;
        this.loopRec = new SwitchLoopList(outerSwitchLoop, null, this, parser.defSet, parser.posSet, parser.useSet);
        try {
            parser.innerSwitchLoop = this.loopRec;
            StatementList bodyStatements = this.bodyStatements;
            if (bodyStatements != null) {
                bodyStatements.resolveAndCheck(parser);
            }
            if (this.continueDefSet != null) {
                parser.defSet.and(this.continueDefSet);
            }
            Expression expr = this.condition.resolveAndCheck(parser);
            boolean forEver = false;
            Expression checkedExpr = this.checkForBooleanExpression(parser, expr);
            if (checkedExpr == expr) {
                if (expr.isConstantBooleanExpression()) {
                    forEver = expr.getConstantBooleanExpressionValue();
                }
            } else {
                expr = checkedExpr;
            }
            this.condition = expr;
            if (bodyStatements != null) {
                if (forEver && this.loopRec.breakSymbol == null && this.next != null && this.next.isCodeStatement()) {
                    parser.error(Message.errorUnreachableStatement, this.next.pos, false);
                }
            } else if (forEver && this.next != null && this.next.isCodeStatement()) {
                parser.error(Message.errorUnreachableStatement, this.next.pos, false);
            }
            this.loopRec.insertLabels();
            if (expr.isLogicalExpression()) {
                parser.defSet = expr.getLogicalExpressionFalseDefSet();
            }
            if (this.resultDefSet != null) {
                if (forEver) {
                    parser.defSet = this.resultDefSet;
                } else {
                    parser.defSet.and(this.resultDefSet);
                }
            }
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            this.checkPosibleReinitializations(parser);
            Object var8_7 = null;
            parser.innerSwitchLoop = outerSwitchLoop;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            parser.innerSwitchLoop = outerSwitchLoop;
            throw throwable;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    boolean isBogusLoop() {
        return this.condition.isConstantBooleanExpression() && !this.condition.getConstantBooleanExpressionValue();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Label bodyLabel = new Label();
        byteCodeGenerator.setLabel(bodyLabel);
        SwitchLoopList outerSwitchLoop = byteCodeGenerator.parser.innerSwitchLoop;
        byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
        StatementList bodyStatements = this.bodyStatements;
        if (bodyStatements != null) {
            bodyStatements.generateByteCode(byteCodeGenerator);
        }
        byteCodeGenerator.parser.innerSwitchLoop = outerSwitchLoop;
        Expression expr = this.condition;
        if (expr.isConstantBooleanExpression()) {
            if (expr.kind != 2) {
                expr.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (expr.getConstantBooleanExpressionValue()) {
                byteCodeGenerator.generateBranch_goto(bodyLabel);
            }
        } else {
            expr.generateByteCodeBranch(byteCodeGenerator, bodyLabel, false);
        }
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = DoStatement.class$("oracle.ojc.compiler.DoStatement");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    boolean canReachNextStatement(boolean strict) {
        boolean forEver = false;
        Expression expr = this.condition;
        if (expr.isConstantBooleanExpression()) {
            forEver = expr.getConstantBooleanExpressionValue();
        }
        if (!$a && this.loopRec == null) {
            throw new AssertionError();
        }
        if (this.loopRec.breakSymbol != null) {
            forEver = false;
        }
        return forEver ^ true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

