/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class DoubleConstantExpression
extends ConstantExpression {
    double dval;

    DoubleConstantExpression(int pos, double dval) {
        super(pos, TypeSymbol.doubleSymbol);
        this.dval = dval;
    }

    Expression copyConstantExpression(int newPos) {
        return new DoubleConstantExpression(newPos, this.dval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        long bits = Double.doubleToLongBits(this.dval);
        if (bits == 0L) {
            byteCodeGenerator.generate_8((byte)14);
        } else if (bits == 0x3FF0000000000000L) {
            byteCodeGenerator.generate_8((byte)15);
        } else {
            short index = byteCodeGenerator.constantPool.enterConstantPoolDouble(this.dval);
            byteCodeGenerator.generate_8_16((byte)20, index);
        }
        byteCodeGenerator.incOpStackHeight(2);
    }
}

